/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.relocated.com.google.common.collect.ImmutableMap;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.MutableDiagnosticsWithSuppression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.SlicedMapImpl;
import org.jetbrains.kotlin.util.slicedMap.TrackingSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class BindingTraceContext
implements BindingTrace {
    private final MutableSlicedMap map;
    private final MutableDiagnosticsWithSuppression mutableDiagnostics;
    private final BindingContext bindingContext;

    public BindingTraceContext() {
        this(SlicedMapImpl.create());
    }

    private BindingTraceContext(@NotNull MutableSlicedMap map2) {
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/resolve/BindingTraceContext", "<init>"));
        }
        this.bindingContext = new BindingContext(){

            @Override
            @NotNull
            public Diagnostics getDiagnostics() {
                MutableDiagnosticsWithSuppression mutableDiagnosticsWithSuppression = BindingTraceContext.this.mutableDiagnostics;
                if (mutableDiagnosticsWithSuppression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingTraceContext$1", "getDiagnostics"));
                }
                return mutableDiagnosticsWithSuppression;
            }

            @Override
            public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
                return BindingTraceContext.this.get(slice, key);
            }

            @Override
            @NotNull
            public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
                Collection<K> collection = BindingTraceContext.this.getKeys(slice);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingTraceContext$1", "getKeys"));
                }
                return collection;
            }

            @Override
            @NotNull
            public <K, V> ImmutableMap<K, V> getSliceContents(@NotNull ReadOnlySlice<K, V> slice) {
                if (slice == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slice", "org/jetbrains/kotlin/resolve/BindingTraceContext$1", "getSliceContents"));
                }
                ImmutableMap<K, V> immutableMap = BindingTraceContext.this.map.getSliceContents(slice);
                if (immutableMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingTraceContext$1", "getSliceContents"));
                }
                return immutableMap;
            }

            @Override
            @Nullable
            public KotlinType getType(@NotNull KtExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/BindingTraceContext$1", "getType"));
                }
                return BindingTraceContext.this.getType(expression);
            }

            @Override
            public void addOwnDataTo(@NotNull BindingTrace trace, boolean commitDiagnostics) {
                if (trace == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BindingTraceContext$1", "addOwnDataTo"));
                }
                BindingContextUtils.addOwnDataTo(trace, null, commitDiagnostics, BindingTraceContext.this.map, BindingTraceContext.this.mutableDiagnostics);
            }
        };
        this.map = map2;
        this.mutableDiagnostics = new MutableDiagnosticsWithSuppression(this.bindingContext, Diagnostics.Companion.getEMPTY());
    }

    public static BindingTraceContext createTraceableBindingTrace() {
        return new BindingTraceContext(new TrackingSlicedMap(true));
    }

    @Override
    public void report(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/resolve/BindingTraceContext", "report"));
        }
        this.mutableDiagnostics.report(diagnostic);
    }

    public void clearDiagnostics() {
        this.mutableDiagnostics.clear();
    }

    @Override
    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext2 = this.bindingContext;
        if (bindingContext2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingTraceContext", "getBindingContext"));
        }
        return bindingContext2;
    }

    @Override
    public <K, V> void record(WritableSlice<K, V> slice, K key, V value2) {
        this.map.put(slice, key, value2);
    }

    @Override
    public <K> void record(WritableSlice<K, Boolean> slice, K key) {
        this.record(slice, key, true);
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        return this.map.get(slice, key);
    }

    @Override
    @NotNull
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        Collection<K> collection = this.map.getKeys(slice);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingTraceContext", "getKeys"));
        }
        return collection;
    }

    @Override
    @Nullable
    public KotlinType getType(@NotNull KtExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/BindingTraceContext", "getType"));
        }
        KotlinTypeInfo typeInfo = this.get(BindingContext.EXPRESSION_TYPE_INFO, expression);
        return typeInfo != null ? typeInfo.getType() : null;
    }

    @Override
    public void recordType(@NotNull KtExpression expression, @Nullable KotlinType type2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/BindingTraceContext", "recordType"));
        }
        KotlinTypeInfo typeInfo = this.get(BindingContext.EXPRESSION_TYPE_INFO, expression);
        typeInfo = typeInfo != null ? typeInfo.replaceType(type2) : TypeInfoFactoryKt.createTypeInfo(type2);
        this.record(BindingContext.EXPRESSION_TYPE_INFO, expression, typeInfo);
    }
}

