/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.EqualityPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Maps;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Sets;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorEquivalenceForOverrides;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.dataClassUtils.DataClassUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.IndexedParametersSubstitution;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.utils.HashSetUtil;

public class OverrideResolver {
    @NotNull
    private final BindingTrace trace;

    public OverrideResolver(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/OverrideResolver", "<init>"));
        }
        this.trace = trace;
    }

    public void check(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/OverrideResolver", "check"));
        }
        this.checkVisibility(c);
        this.checkOverrides(c);
        this.checkParameterOverridesForAllClasses(c);
    }

    public static void generateOverridesInAClass(@NotNull ClassDescriptor classDescriptor, @NotNull Collection<CallableMemberDescriptor> membersFromCurrent, @NotNull OverridingUtil.DescriptorSink sink) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "generateOverridesInAClass"));
        }
        if (membersFromCurrent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersFromCurrent", "org/jetbrains/kotlin/resolve/OverrideResolver", "generateOverridesInAClass"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/kotlin/resolve/OverrideResolver", "generateOverridesInAClass"));
        }
        List<CallableMemberDescriptor> membersFromSupertypes = OverrideResolver.getCallableMembersFromSupertypes(classDescriptor);
        MultiMap<Name, CallableMemberDescriptor> membersFromCurrentByName = OverrideResolver.groupDescriptorsByName(membersFromCurrent);
        MultiMap<Name, CallableMemberDescriptor> membersFromSupertypesByName = OverrideResolver.groupDescriptorsByName(membersFromSupertypes);
        LinkedHashSet<Name> memberNames = new LinkedHashSet<Name>();
        memberNames.addAll(membersFromSupertypesByName.keySet());
        memberNames.addAll(membersFromCurrentByName.keySet());
        for (Name memberName : memberNames) {
            Collection<CallableMemberDescriptor> fromSupertypes = membersFromSupertypesByName.get(memberName);
            Collection<CallableMemberDescriptor> fromCurrent = membersFromCurrentByName.get(memberName);
            OverridingUtil.generateOverridesInFunctionGroup(memberName, fromSupertypes, fromCurrent, classDescriptor, sink);
        }
    }

    public static void resolveUnknownVisibilities(@NotNull Collection<? extends CallableMemberDescriptor> descriptors, @NotNull BindingTrace trace) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/resolve/OverrideResolver", "resolveUnknownVisibilities"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/OverrideResolver", "resolveUnknownVisibilities"));
        }
        for (CallableMemberDescriptor callableMemberDescriptor : descriptors) {
            OverridingUtil.resolveUnknownVisibilityForMember(callableMemberDescriptor, OverrideResolver.createCannotInferVisibilityReporter(trace));
        }
    }

    @NotNull
    public static Function1<CallableMemberDescriptor, Unit> createCannotInferVisibilityReporter(final @NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/OverrideResolver", "createCannotInferVisibilityReporter"));
        }
        Function1<CallableMemberDescriptor, Unit> function1 = new Function1<CallableMemberDescriptor, Unit>(){

            @Override
            public Unit invoke(@NotNull CallableMemberDescriptor descriptor2) {
                if (descriptor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/OverrideResolver$1", "invoke"));
                }
                MemberDescriptor reportOn = descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE || descriptor2.getKind() == CallableMemberDescriptor.Kind.DELEGATION ? DescriptorUtils.getParentOfType(descriptor2, ClassDescriptor.class) : (descriptor2 instanceof PropertyAccessorDescriptor && ((PropertyAccessorDescriptor)descriptor2).isDefault() ? ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty() : descriptor2);
                PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(reportOn);
                if (element instanceof KtDeclaration) {
                    trace.report(Errors.CANNOT_INFER_VISIBILITY.on((KtDeclaration)element, descriptor2));
                }
                return Unit.INSTANCE$;
            }
        };
        if (function1 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "createCannotInferVisibilityReporter"));
        }
        return function1;
    }

    @NotNull
    public static <D extends CallableDescriptor> Set<D> filterOutOverridden(@NotNull Set<D> candidateSet) {
        if (candidateSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateSet", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOutOverridden"));
        }
        Set<D> set = OverrideResolver.filterOverrides(candidateSet, Function.ID, Filtering.RETAIN_OVERRIDING);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOutOverridden"));
        }
        return set;
    }

    @NotNull
    public static <D> Set<D> filterOutOverriding(@NotNull Set<D> candidateSet) {
        if (candidateSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateSet", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOutOverriding"));
        }
        Set<D> set = OverrideResolver.filterOverrides(candidateSet, Function.ID, Filtering.RETAIN_OVERRIDDEN);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOutOverriding"));
        }
        return set;
    }

    @NotNull
    public static <D> Set<D> filterOutOverridden(@NotNull Set<D> candidateSet, @NotNull Function<? super D, ? extends CallableDescriptor> transform) {
        if (candidateSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateSet", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOutOverridden"));
        }
        if (transform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transform", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOutOverridden"));
        }
        Set<? super D> set = OverrideResolver.filterOverrides(candidateSet, transform, Filtering.RETAIN_OVERRIDING);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOutOverridden"));
        }
        return set;
    }

    @NotNull
    private static <D> Set<D> filterOverrides(@NotNull Set<D> candidateSet, final @NotNull Function<? super D, ? extends CallableDescriptor> transform, @NotNull Filtering filtering) {
        if (candidateSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateSet", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOverrides"));
        }
        if (transform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transform", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOverrides"));
        }
        if (filtering == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filtering", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOverrides"));
        }
        if (candidateSet.size() <= 1) {
            Set<D> set = candidateSet;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOverrides"));
            }
            return set;
        }
        Set<D> noDuplicates = HashSetUtil.linkedHashSet(candidateSet, new EqualityPolicy<D>(){

            @Override
            public int getHashCode(D d) {
                return DescriptorUtils.getFqName(((CallableDescriptor)transform.fun(d)).getContainingDeclaration()).hashCode();
            }

            @Override
            public boolean isEqual(D d1, D d2) {
                CallableDescriptor f = (CallableDescriptor)transform.fun(d1);
                CallableDescriptor g = (CallableDescriptor)transform.fun(d2);
                return DescriptorEquivalenceForOverrides.INSTANCE$.areEquivalent(f.getOriginal(), g.getOriginal());
            }
        });
        LinkedHashSet<D> candidates = Sets.newLinkedHashSet();
        block0: for (D meD : noDuplicates) {
            CallableDescriptor other;
            CallableDescriptor me = transform.fun(meD);
            for (Object otherD : noDuplicates) {
                other = transform.fun(otherD);
                if (me == other) continue;
                if (filtering == Filtering.RETAIN_OVERRIDING) {
                    if (!OverrideResolver.overrides(other, me)) continue;
                    continue block0;
                }
                if (filtering == Filtering.RETAIN_OVERRIDDEN) {
                    if (!OverrideResolver.overrides(me, other)) continue;
                    continue block0;
                }
                throw new AssertionError((Object)("Unexpected Filtering object: " + (Object)((Object)filtering)));
            }
            for (Object otherD : candidates) {
                other = transform.fun(otherD);
                if (me.getOriginal() != other.getOriginal() || OverridingUtil.DEFAULT.isOverridableBy(other, me).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE || OverridingUtil.DEFAULT.isOverridableBy(me, other).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) continue;
                continue block0;
            }
            candidates.add(meD);
        }
        assert (!candidates.isEmpty()) : "All candidates filtered out from " + candidateSet;
        LinkedHashSet<D> linkedHashSet = candidates;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterOverrides"));
        }
        return linkedHashSet;
    }

    public static <D extends CallableDescriptor> boolean overrides(@NotNull D f, @NotNull D g) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/resolve/OverrideResolver", "overrides"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "org/jetbrains/kotlin/resolve/OverrideResolver", "overrides"));
        }
        if (!f.equals(g) && DescriptorEquivalenceForOverrides.INSTANCE$.areEquivalent(f.getOriginal(), g.getOriginal())) {
            return true;
        }
        CallableDescriptor originalG = g.getOriginal();
        for (D overriddenFunction : DescriptorUtils.getAllOverriddenDescriptors(f)) {
            if (!DescriptorEquivalenceForOverrides.INSTANCE$.areEquivalent(originalG, overriddenFunction.getOriginal())) continue;
            return true;
        }
        return false;
    }

    private static <T extends DeclarationDescriptor> MultiMap<Name, T> groupDescriptorsByName(Collection<T> properties2) {
        LinkedMultiMap<Name, DeclarationDescriptor> r = new LinkedMultiMap<Name, DeclarationDescriptor>();
        for (DeclarationDescriptor property : properties2) {
            r.putValue(property.getName(), property);
        }
        return r;
    }

    private static List<CallableMemberDescriptor> getCallableMembersFromSupertypes(ClassDescriptor classDescriptor) {
        LinkedHashSet<CallableMemberDescriptor> r = Sets.newLinkedHashSet();
        for (KotlinType supertype : classDescriptor.getTypeConstructor().getSupertypes()) {
            r.addAll(OverrideResolver.getCallableMembersFromType(supertype));
        }
        return new ArrayList<CallableMemberDescriptor>(r);
    }

    private static List<CallableMemberDescriptor> getCallableMembersFromType(KotlinType type2) {
        ArrayList<CallableMemberDescriptor> r = Lists.newArrayList();
        for (DeclarationDescriptor decl : DescriptorUtils.getAllDescriptors(type2.getMemberScope())) {
            if (!(decl instanceof PropertyDescriptor) && !(decl instanceof SimpleFunctionDescriptor)) continue;
            r.add((CallableMemberDescriptor)decl);
        }
        return r;
    }

    private void checkOverrides(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkOverrides"));
        }
        for (Map.Entry<KtClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            this.checkOverridesInAClass(entry.getValue(), entry.getKey());
        }
    }

    private void checkOverridesInAClass(@NotNull ClassDescriptorWithResolutionScopes classDescriptor, @NotNull KtClassOrObject klass) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkOverridesInAClass"));
        }
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkOverridesInAClass"));
        }
        for (CallableMemberDescriptor member : classDescriptor.getDeclaredCallableMembers()) {
            this.checkOverrideForMember(member);
        }
        LinkedHashSet<CallableMemberDescriptor> abstractNoImpl = Sets.newLinkedHashSet();
        LinkedHashSet<CallableMemberDescriptor> manyImpl = Sets.newLinkedHashSet();
        LinkedHashSet<CallableMemberDescriptor> abstractInBaseClassNoImpl = Sets.newLinkedHashSet();
        LinkedHashSet<CallableMemberDescriptor> conflictingInterfaceOverrides = Sets.newLinkedHashSet();
        OverrideResolver.collectMissingImplementations(classDescriptor, abstractNoImpl, manyImpl, abstractInBaseClassNoImpl, conflictingInterfaceOverrides);
        if (!DescriptorUtils.classCanHaveAbstractMembers(classDescriptor)) {
            if (!abstractInBaseClassNoImpl.isEmpty()) {
                this.trace.report(Errors.ABSTRACT_CLASS_MEMBER_NOT_IMPLEMENTED.on(klass, klass, (CallableMemberDescriptor)abstractInBaseClassNoImpl.iterator().next()));
            } else if (!abstractNoImpl.isEmpty()) {
                this.trace.report(Errors.ABSTRACT_MEMBER_NOT_IMPLEMENTED.on(klass, klass, (CallableMemberDescriptor)abstractNoImpl.iterator().next()));
            }
        }
        if (!conflictingInterfaceOverrides.isEmpty()) {
            this.trace.report(Errors.MANY_INTERFACES_MEMBER_NOT_IMPLEMENTED.on(klass, klass, (CallableMemberDescriptor)conflictingInterfaceOverrides.iterator().next()));
        } else if (!manyImpl.isEmpty()) {
            this.trace.report(Errors.MANY_IMPL_MEMBER_NOT_IMPLEMENTED.on(klass, klass, (CallableMemberDescriptor)manyImpl.iterator().next()));
        }
    }

    @NotNull
    public static Set<CallableMemberDescriptor> getMissingImplementations(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "getMissingImplementations"));
        }
        LinkedHashSet<CallableMemberDescriptor> shouldImplement = new LinkedHashSet<CallableMemberDescriptor>();
        HashSet<CallableMemberDescriptor> dontCare = new HashSet<CallableMemberDescriptor>();
        OverrideResolver.collectMissingImplementations(classDescriptor, shouldImplement, shouldImplement, dontCare, dontCare);
        LinkedHashSet<CallableMemberDescriptor> linkedHashSet = shouldImplement;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "getMissingImplementations"));
        }
        return linkedHashSet;
    }

    private static void collectMissingImplementations(@NotNull ClassDescriptor classDescriptor, @NotNull Set<CallableMemberDescriptor> abstractNoImpl, @NotNull Set<CallableMemberDescriptor> manyImpl, @NotNull Set<CallableMemberDescriptor> abstractInBaseClassNoImpl, @NotNull Set<CallableMemberDescriptor> conflictingInterfaceOverrides) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (abstractNoImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abstractNoImpl", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (manyImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manyImpl", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (abstractInBaseClassNoImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abstractInBaseClassNoImpl", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (conflictingInterfaceOverrides == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflictingInterfaceOverrides", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        for (DeclarationDescriptor member : DescriptorUtils.getAllDescriptors(classDescriptor.getDefaultType().getMemberScope())) {
            if (!(member instanceof CallableMemberDescriptor)) continue;
            OverrideResolver.collectMissingImplementations((CallableMemberDescriptor)member, abstractNoImpl, manyImpl, abstractInBaseClassNoImpl, conflictingInterfaceOverrides);
        }
    }

    private static void collectMissingImplementations(@NotNull CallableMemberDescriptor descriptor2, @NotNull Set<CallableMemberDescriptor> abstractNoImpl, @NotNull Set<CallableMemberDescriptor> manyImpl, @NotNull Set<CallableMemberDescriptor> abstractInBaseClassNoImpl, @NotNull Set<CallableMemberDescriptor> conflictingInterfaceOverrides) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (abstractNoImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abstractNoImpl", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (manyImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manyImpl", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (abstractInBaseClassNoImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abstractInBaseClassNoImpl", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (conflictingInterfaceOverrides == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflictingInterfaceOverrides", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (descriptor2.getKind().isReal()) {
            return;
        }
        if (descriptor2.getVisibility() == Visibilities.INVISIBLE_FAKE) {
            return;
        }
        Collection<? extends CallableMemberDescriptor> directOverridden = descriptor2.getOverriddenDescriptors();
        if (directOverridden.size() == 0) {
            throw new IllegalStateException("A 'fake override' " + descriptor2.getName().asString() + " must override something");
        }
        Map<CallableMemberDescriptor, Set<CallableMemberDescriptor>> overriddenDeclarationsByDirectParent = OverrideResolver.collectOverriddenDeclarations(directOverridden);
        List<CallableMemberDescriptor> allOverriddenDeclarations = ContainerUtil.flatten(overriddenDeclarationsByDirectParent.values());
        Set<CallableMemberDescriptor> allFilteredOverriddenDeclarations = OverrideResolver.filterOutOverridden(Sets.newLinkedHashSet(allOverriddenDeclarations));
        Set<CallableMemberDescriptor> relevantDirectlyOverridden = OverrideResolver.getRelevantDirectlyOverridden(overriddenDeclarationsByDirectParent, allFilteredOverriddenDeclarations);
        OverrideResolver.collectJava8MissingOverrides(relevantDirectlyOverridden, abstractInBaseClassNoImpl, conflictingInterfaceOverrides);
        List<CallableMemberDescriptor> implementations = OverrideResolver.collectImplementations(relevantDirectlyOverridden);
        if (implementations.size() == 1 && OverrideResolver.isReturnTypeOkForOverride(descriptor2, implementations.get(0))) {
            return;
        }
        ArrayList<CallableMemberDescriptor> abstractOverridden = new ArrayList<CallableMemberDescriptor>(allFilteredOverriddenDeclarations.size());
        ArrayList<CallableMemberDescriptor> concreteOverridden = new ArrayList<CallableMemberDescriptor>(allFilteredOverriddenDeclarations.size());
        OverrideResolver.filterNotSynthesizedDescriptorsByModality(allFilteredOverriddenDeclarations, abstractOverridden, concreteOverridden);
        if (implementations.isEmpty()) {
            abstractNoImpl.addAll(abstractOverridden);
        } else if (implementations.size() > 1) {
            manyImpl.addAll(concreteOverridden);
        } else {
            abstractNoImpl.addAll(OverrideResolver.collectAbstractMethodsWithMoreSpecificReturnType(abstractOverridden, implementations.get(0)));
        }
    }

    private static void collectJava8MissingOverrides(Set<CallableMemberDescriptor> relevantDirectlyOverridden, @NotNull Set<CallableMemberDescriptor> abstractInBaseClassNoImpl, @NotNull Set<CallableMemberDescriptor> conflictingInterfaceOverrides) {
        if (abstractInBaseClassNoImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abstractInBaseClassNoImpl", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectJava8MissingOverrides"));
        }
        if (conflictingInterfaceOverrides == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflictingInterfaceOverrides", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectJava8MissingOverrides"));
        }
        boolean overridesClassMember = false;
        boolean overridesNonAbstractInterfaceMember = false;
        CallableMemberDescriptor overridesAbstractInBaseClass = null;
        SmartList<CallableMemberDescriptor> overriddenInterfaceMembers = new SmartList<CallableMemberDescriptor>();
        for (CallableMemberDescriptor overridden : relevantDirectlyOverridden) {
            DeclarationDescriptor containingDeclaration = overridden.getContainingDeclaration();
            if (!(containingDeclaration instanceof ClassDescriptor)) continue;
            ClassDescriptor baseClassOrInterface = (ClassDescriptor)containingDeclaration;
            if (baseClassOrInterface.getKind() == ClassKind.CLASS) {
                overridesClassMember = true;
                if (overridden.getModality() != Modality.ABSTRACT) continue;
                overridesAbstractInBaseClass = overridden;
                continue;
            }
            if (baseClassOrInterface.getKind() != ClassKind.INTERFACE) continue;
            overriddenInterfaceMembers.add(overridden);
            if (overridden.getModality() == Modality.ABSTRACT) continue;
            overridesNonAbstractInterfaceMember = true;
        }
        if (overridesAbstractInBaseClass != null) {
            abstractInBaseClassNoImpl.add(overridesAbstractInBaseClass);
        }
        if (!overridesClassMember && overridesNonAbstractInterfaceMember && overriddenInterfaceMembers.size() > 1) {
            conflictingInterfaceOverrides.addAll(overriddenInterfaceMembers);
        }
    }

    @NotNull
    private static List<CallableMemberDescriptor> collectImplementations(@NotNull Set<CallableMemberDescriptor> relevantDirectlyOverridden) {
        if (relevantDirectlyOverridden == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relevantDirectlyOverridden", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectImplementations"));
        }
        ArrayList<CallableMemberDescriptor> result2 = new ArrayList<CallableMemberDescriptor>(relevantDirectlyOverridden.size());
        for (CallableMemberDescriptor overriddenDescriptor : relevantDirectlyOverridden) {
            if (overriddenDescriptor.getModality() == Modality.ABSTRACT) continue;
            result2.add(overriddenDescriptor);
        }
        ArrayList<CallableMemberDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectImplementations"));
        }
        return arrayList;
    }

    private static void filterNotSynthesizedDescriptorsByModality(@NotNull Set<CallableMemberDescriptor> allOverriddenDeclarations, @NotNull List<CallableMemberDescriptor> abstractOverridden, @NotNull List<CallableMemberDescriptor> concreteOverridden) {
        if (allOverriddenDeclarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allOverriddenDeclarations", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterNotSynthesizedDescriptorsByModality"));
        }
        if (abstractOverridden == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abstractOverridden", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterNotSynthesizedDescriptorsByModality"));
        }
        if (concreteOverridden == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "concreteOverridden", "org/jetbrains/kotlin/resolve/OverrideResolver", "filterNotSynthesizedDescriptorsByModality"));
        }
        for (CallableMemberDescriptor overridden : allOverriddenDeclarations) {
            if (CallResolverUtilKt.isOrOverridesSynthesized(overridden)) continue;
            if (overridden.getModality() == Modality.ABSTRACT) {
                abstractOverridden.add(overridden);
                continue;
            }
            concreteOverridden.add(overridden);
        }
    }

    @NotNull
    private static List<CallableMemberDescriptor> collectAbstractMethodsWithMoreSpecificReturnType(@NotNull List<CallableMemberDescriptor> abstractOverridden, @NotNull CallableMemberDescriptor implementation) {
        if (abstractOverridden == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abstractOverridden", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectAbstractMethodsWithMoreSpecificReturnType"));
        }
        if (implementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implementation", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectAbstractMethodsWithMoreSpecificReturnType"));
        }
        ArrayList<CallableMemberDescriptor> result2 = new ArrayList<CallableMemberDescriptor>(abstractOverridden.size());
        for (CallableMemberDescriptor abstractMember : abstractOverridden) {
            if (OverrideResolver.isReturnTypeOkForOverride(abstractMember, implementation)) continue;
            result2.add(abstractMember);
        }
        assert (!result2.isEmpty()) : "Implementation (" + implementation + ") doesn't have the most specific type, " + "but none of the other overridden methods does either: " + abstractOverridden;
        ArrayList<CallableMemberDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectAbstractMethodsWithMoreSpecificReturnType"));
        }
        return arrayList;
    }

    @NotNull
    private static Set<CallableMemberDescriptor> getRelevantDirectlyOverridden(@NotNull Map<CallableMemberDescriptor, Set<CallableMemberDescriptor>> overriddenByParent, @NotNull Set<CallableMemberDescriptor> allFilteredOverriddenDeclarations) {
        if (overriddenByParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overriddenByParent", "org/jetbrains/kotlin/resolve/OverrideResolver", "getRelevantDirectlyOverridden"));
        }
        if (allFilteredOverriddenDeclarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allFilteredOverriddenDeclarations", "org/jetbrains/kotlin/resolve/OverrideResolver", "getRelevantDirectlyOverridden"));
        }
        Iterator<Map.Entry<CallableMemberDescriptor, Set<CallableMemberDescriptor>>> iterator2 = overriddenByParent.entrySet().iterator();
        while (iterator2.hasNext()) {
            if (OverrideResolver.isRelevant(iterator2.next().getValue(), overriddenByParent.values(), allFilteredOverriddenDeclarations)) continue;
            iterator2.remove();
        }
        Set<CallableMemberDescriptor> set = overriddenByParent.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "getRelevantDirectlyOverridden"));
        }
        return set;
    }

    private static boolean isRelevant(@NotNull Set<CallableMemberDescriptor> declarationSet, @NotNull Collection<Set<CallableMemberDescriptor>> allDeclarationSets, @NotNull Set<CallableMemberDescriptor> allFilteredOverriddenDeclarations) {
        if (declarationSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationSet", "org/jetbrains/kotlin/resolve/OverrideResolver", "isRelevant"));
        }
        if (allDeclarationSets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allDeclarationSets", "org/jetbrains/kotlin/resolve/OverrideResolver", "isRelevant"));
        }
        if (allFilteredOverriddenDeclarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allFilteredOverriddenDeclarations", "org/jetbrains/kotlin/resolve/OverrideResolver", "isRelevant"));
        }
        for (Set<CallableMemberDescriptor> otherSet : allDeclarationSets) {
            if (otherSet == declarationSet) continue;
            if (otherSet.containsAll(declarationSet)) {
                return false;
            }
            if (!Collections.disjoint(allFilteredOverriddenDeclarations, declarationSet)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Map<CallableMemberDescriptor, Set<CallableMemberDescriptor>> collectOverriddenDeclarations(@NotNull Collection<? extends CallableMemberDescriptor> directOverriddenDescriptors) {
        if (directOverriddenDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directOverriddenDescriptors", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectOverriddenDeclarations"));
        }
        LinkedHashMap<CallableMemberDescriptor, Set<CallableMemberDescriptor>> overriddenDeclarationsByDirectParent = Maps.newLinkedHashMap();
        for (CallableMemberDescriptor callableMemberDescriptor : directOverriddenDescriptors) {
            Set<CallableMemberDescriptor> overriddenDeclarations = OverrideResolver.getOverriddenDeclarations(callableMemberDescriptor);
            Set<CallableMemberDescriptor> filteredOverrides = OverrideResolver.filterOutOverridden(overriddenDeclarations);
            overriddenDeclarationsByDirectParent.put(callableMemberDescriptor, new LinkedHashSet<CallableMemberDescriptor>(filteredOverrides));
        }
        LinkedHashMap<CallableMemberDescriptor, Set<CallableMemberDescriptor>> linkedHashMap = overriddenDeclarationsByDirectParent;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "collectOverriddenDeclarations"));
        }
        return linkedHashMap;
    }

    @NotNull
    public static Set<CallableMemberDescriptor> getOverriddenDeclarations(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "getOverriddenDeclarations"));
        }
        LinkedHashSet<CallableMemberDescriptor> result2 = new LinkedHashSet<CallableMemberDescriptor>();
        OverrideResolver.getOverriddenDeclarations(descriptor2, result2);
        LinkedHashSet<CallableMemberDescriptor> linkedHashSet = result2;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "getOverriddenDeclarations"));
        }
        return linkedHashSet;
    }

    private static void getOverriddenDeclarations(@NotNull CallableMemberDescriptor descriptor2, @NotNull Set<CallableMemberDescriptor> result2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "getOverriddenDeclarations"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/resolve/OverrideResolver", "getOverriddenDeclarations"));
        }
        if (descriptor2.getKind().isReal()) {
            result2.add(descriptor2);
        } else {
            if (descriptor2.getOverriddenDescriptors().isEmpty()) {
                throw new IllegalStateException("No overridden descriptors found for (fake override) " + descriptor2);
            }
            for (CallableMemberDescriptor callableMemberDescriptor : descriptor2.getOverriddenDescriptors()) {
                OverrideResolver.getOverriddenDeclarations(callableMemberDescriptor, result2);
            }
        }
    }

    private void checkOverrideForMember(final @NotNull CallableMemberDescriptor declared) {
        if (declared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declared", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkOverrideForMember"));
        }
        if (declared.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            if (DataClassUtilsKt.isComponentLike(declared.getName())) {
                this.checkOverrideForComponentFunction(declared);
            }
            return;
        }
        if (declared.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            return;
        }
        final KtNamedDeclaration member = (KtNamedDeclaration)DescriptorToSourceUtils.descriptorToDeclaration(declared);
        if (member == null) {
            throw new IllegalStateException("declared descriptor is not resolved to declaration: " + declared);
        }
        KtModifierList modifierList = member.getModifierList();
        boolean hasOverrideNode = modifierList != null && modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        Collection<? extends CallableMemberDescriptor> overriddenDescriptors = declared.getOverriddenDescriptors();
        if (hasOverrideNode) {
            OverrideResolver.checkOverridesForMemberMarkedOverride(declared, true, new CheckOverrideReportStrategy(){
                private boolean finalOverriddenError = false;
                private boolean typeMismatchError = false;
                private boolean kindMismatchError = false;

                @Override
                public void overridingFinalMember(@NotNull CallableMemberDescriptor overridden) {
                    if (overridden == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/kotlin/resolve/OverrideResolver$3", "overridingFinalMember"));
                    }
                    if (!this.finalOverriddenError) {
                        this.finalOverriddenError = true;
                        OverrideResolver.this.trace.report(Errors.OVERRIDING_FINAL_MEMBER.on(member, overridden, overridden.getContainingDeclaration()));
                    }
                }

                @Override
                public void returnTypeMismatchOnOverride(@NotNull CallableMemberDescriptor overridden) {
                    if (overridden == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/kotlin/resolve/OverrideResolver$3", "returnTypeMismatchOnOverride"));
                    }
                    if (!this.typeMismatchError) {
                        this.typeMismatchError = true;
                        OverrideResolver.this.trace.report(Errors.RETURN_TYPE_MISMATCH_ON_OVERRIDE.on(member, declared, overridden));
                    }
                }

                @Override
                public void propertyTypeMismatchOnOverride(@NotNull CallableMemberDescriptor overridden) {
                    if (overridden == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/kotlin/resolve/OverrideResolver$3", "propertyTypeMismatchOnOverride"));
                    }
                    if (!this.typeMismatchError) {
                        this.typeMismatchError = true;
                        OverrideResolver.this.trace.report(Errors.PROPERTY_TYPE_MISMATCH_ON_OVERRIDE.on(member, declared, overridden));
                    }
                }

                @Override
                public void varOverriddenByVal(@NotNull CallableMemberDescriptor overridden) {
                    if (overridden == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/kotlin/resolve/OverrideResolver$3", "varOverriddenByVal"));
                    }
                    if (!this.kindMismatchError) {
                        this.kindMismatchError = true;
                        OverrideResolver.this.trace.report(Errors.VAR_OVERRIDDEN_BY_VAL.on(member, (PropertyDescriptor)declared, (PropertyDescriptor)overridden));
                    }
                }

                @Override
                public void cannotOverrideInvisibleMember(@NotNull CallableMemberDescriptor invisibleOverridden) {
                    if (invisibleOverridden == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invisibleOverridden", "org/jetbrains/kotlin/resolve/OverrideResolver$3", "cannotOverrideInvisibleMember"));
                    }
                    OverrideResolver.this.trace.report(Errors.CANNOT_OVERRIDE_INVISIBLE_MEMBER.on(member, declared, invisibleOverridden));
                }

                @Override
                public void nothingToOverride() {
                    OverrideResolver.this.trace.report(Errors.NOTHING_TO_OVERRIDE.on(member, declared));
                }
            });
        } else if (!overriddenDescriptors.isEmpty()) {
            CallableMemberDescriptor overridden = overriddenDescriptors.iterator().next();
            this.trace.report(Errors.VIRTUAL_MEMBER_HIDDEN.on(member, declared, overridden, overridden.getContainingDeclaration()));
        }
    }

    private static void checkOverridesForMemberMarkedOverride(@NotNull CallableMemberDescriptor declared, boolean checkIfOverridesNothing, @NotNull CheckOverrideReportStrategy reportError2) {
        if (declared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declared", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkOverridesForMemberMarkedOverride"));
        }
        if (reportError2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportError", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkOverridesForMemberMarkedOverride"));
        }
        Collection<? extends CallableMemberDescriptor> overriddenDescriptors = declared.getOverriddenDescriptors();
        for (CallableMemberDescriptor callableMemberDescriptor : overriddenDescriptors) {
            if (callableMemberDescriptor == null) continue;
            if (!callableMemberDescriptor.getModality().isOverridable()) {
                reportError2.overridingFinalMember(callableMemberDescriptor);
            }
            if (declared instanceof PropertyDescriptor && !OverrideResolver.isPropertyTypeOkForOverride((PropertyDescriptor)callableMemberDescriptor, (PropertyDescriptor)declared)) {
                reportError2.propertyTypeMismatchOnOverride(callableMemberDescriptor);
            } else if (!OverrideResolver.isReturnTypeOkForOverride(callableMemberDescriptor, declared)) {
                reportError2.returnTypeMismatchOnOverride(callableMemberDescriptor);
            }
            if (!OverrideResolver.checkPropertyKind(callableMemberDescriptor, true) || !OverrideResolver.checkPropertyKind(declared, false)) continue;
            reportError2.varOverriddenByVal(callableMemberDescriptor);
        }
        if (checkIfOverridesNothing && overriddenDescriptors.isEmpty()) {
            DeclarationDescriptor containingDeclaration = declared.getContainingDeclaration();
            assert (containingDeclaration instanceof ClassDescriptor) : "Overrides may only be resolved in a class, but " + declared + " comes from " + containingDeclaration;
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            CallableMemberDescriptor invisibleOverriddenDescriptor = OverrideResolver.findInvisibleOverriddenDescriptor(declared, classDescriptor);
            if (invisibleOverriddenDescriptor != null) {
                reportError2.cannotOverrideInvisibleMember(invisibleOverriddenDescriptor);
            } else {
                reportError2.nothingToOverride();
            }
        }
    }

    public static boolean isReturnTypeOkForOverride(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
        if (superDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "isReturnTypeOkForOverride"));
        }
        if (subDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "isReturnTypeOkForOverride"));
        }
        TypeSubstitutor typeSubstitutor2 = OverrideResolver.prepareTypeSubstitutor(superDescriptor, subDescriptor);
        if (typeSubstitutor2 == null) {
            return false;
        }
        KotlinType superReturnType = superDescriptor.getReturnType();
        assert (superReturnType != null);
        KotlinType subReturnType = subDescriptor.getReturnType();
        assert (subReturnType != null);
        KotlinType substitutedSuperReturnType = typeSubstitutor2.substitute(superReturnType, Variance.OUT_VARIANCE);
        assert (substitutedSuperReturnType != null);
        return KotlinTypeChecker.DEFAULT.isSubtypeOf(subReturnType, substitutedSuperReturnType);
    }

    @Nullable
    private static TypeSubstitutor prepareTypeSubstitutor(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
        if (superDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "prepareTypeSubstitutor"));
        }
        if (subDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "prepareTypeSubstitutor"));
        }
        List<TypeParameterDescriptor> superTypeParameters = superDescriptor.getTypeParameters();
        List<TypeParameterDescriptor> subTypeParameters = subDescriptor.getTypeParameters();
        if (subTypeParameters.size() != superTypeParameters.size()) {
            return null;
        }
        ArrayList<TypeProjectionImpl> arguments2 = new ArrayList<TypeProjectionImpl>(subTypeParameters.size());
        for (int i = 0; i < superTypeParameters.size(); ++i) {
            arguments2.add(new TypeProjectionImpl(subTypeParameters.get(i).getDefaultType()));
        }
        return new IndexedParametersSubstitution(superTypeParameters, arguments2).buildSubstitutor();
    }

    public static boolean isPropertyTypeOkForOverride(@NotNull PropertyDescriptor superDescriptor, @NotNull PropertyDescriptor subDescriptor) {
        if (superDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "isPropertyTypeOkForOverride"));
        }
        if (subDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "isPropertyTypeOkForOverride"));
        }
        TypeSubstitutor typeSubstitutor2 = OverrideResolver.prepareTypeSubstitutor(superDescriptor, subDescriptor);
        if (typeSubstitutor2 == null) {
            return false;
        }
        if (!superDescriptor.isVar()) {
            return true;
        }
        KotlinType substitutedSuperReturnType = typeSubstitutor2.substitute(superDescriptor.getType(), Variance.OUT_VARIANCE);
        assert (substitutedSuperReturnType != null);
        return KotlinTypeChecker.DEFAULT.equalTypes(subDescriptor.getType(), substitutedSuperReturnType);
    }

    private void checkOverrideForComponentFunction(final @NotNull CallableMemberDescriptor componentFunction) {
        if (componentFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentFunction", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkOverrideForComponentFunction"));
        }
        final PsiElement dataModifier = OverrideResolver.findDataModifierForDataClass(componentFunction.getContainingDeclaration());
        OverrideResolver.checkOverridesForMemberMarkedOverride(componentFunction, false, new CheckOverrideReportStrategy(){
            private boolean overrideConflict = false;

            @Override
            public void overridingFinalMember(@NotNull CallableMemberDescriptor overridden) {
                if (overridden == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/kotlin/resolve/OverrideResolver$4", "overridingFinalMember"));
                }
                if (!this.overrideConflict) {
                    this.overrideConflict = true;
                    OverrideResolver.this.trace.report(Errors.DATA_CLASS_OVERRIDE_CONFLICT.on(dataModifier, componentFunction, overridden.getContainingDeclaration()));
                }
            }

            @Override
            public void returnTypeMismatchOnOverride(@NotNull CallableMemberDescriptor overridden) {
                if (overridden == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/kotlin/resolve/OverrideResolver$4", "returnTypeMismatchOnOverride"));
                }
                if (!this.overrideConflict) {
                    this.overrideConflict = true;
                    OverrideResolver.this.trace.report(Errors.DATA_CLASS_OVERRIDE_CONFLICT.on(dataModifier, componentFunction, overridden.getContainingDeclaration()));
                }
            }

            @Override
            public void propertyTypeMismatchOnOverride(@NotNull CallableMemberDescriptor overridden) {
                if (overridden == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/kotlin/resolve/OverrideResolver$4", "propertyTypeMismatchOnOverride"));
                }
                throw new IllegalStateException("Component functions are not properties");
            }

            @Override
            public void varOverriddenByVal(@NotNull CallableMemberDescriptor overridden) {
                if (overridden == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/kotlin/resolve/OverrideResolver$4", "varOverriddenByVal"));
                }
                throw new IllegalStateException("Component functions are not properties");
            }

            @Override
            public void cannotOverrideInvisibleMember(@NotNull CallableMemberDescriptor invisibleOverridden) {
                if (invisibleOverridden == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invisibleOverridden", "org/jetbrains/kotlin/resolve/OverrideResolver$4", "cannotOverrideInvisibleMember"));
                }
                throw new IllegalStateException("CANNOT_OVERRIDE_INVISIBLE_MEMBER should be reported on the corresponding property");
            }

            @Override
            public void nothingToOverride() {
                throw new IllegalStateException("Component functions are OK to override nothing");
            }
        });
    }

    @NotNull
    private static PsiElement findDataModifierForDataClass(@NotNull DeclarationDescriptor dataClass) {
        PsiElement modifier;
        if (dataClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataClass", "org/jetbrains/kotlin/resolve/OverrideResolver", "findDataModifierForDataClass"));
        }
        KtClass classDeclaration = (KtClass)DescriptorToSourceUtils.getSourceFromDescriptor(dataClass);
        if (classDeclaration != null && classDeclaration.getModifierList() != null && (modifier = classDeclaration.getModifierList().getModifier(KtTokens.DATA_KEYWORD)) != null) {
            PsiElement psiElement2 = modifier;
            if (psiElement2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "findDataModifierForDataClass"));
            }
            return psiElement2;
        }
        throw new IllegalStateException("No data modifier is found for data class " + dataClass);
    }

    @Nullable
    private static CallableMemberDescriptor findInvisibleOverriddenDescriptor(@NotNull CallableMemberDescriptor declared, @NotNull ClassDescriptor declaringClass) {
        if (declared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declared", "org/jetbrains/kotlin/resolve/OverrideResolver", "findInvisibleOverriddenDescriptor"));
        }
        if (declaringClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaringClass", "org/jetbrains/kotlin/resolve/OverrideResolver", "findInvisibleOverriddenDescriptor"));
        }
        for (KotlinType supertype : declaringClass.getTypeConstructor().getSupertypes()) {
            LinkedHashSet<CallableMemberDescriptor> all = Sets.newLinkedHashSet();
            all.addAll(supertype.getMemberScope().getContributedFunctions(declared.getName(), NoLookupLocation.WHEN_CHECK_OVERRIDES));
            all.addAll(supertype.getMemberScope().getContributedVariables(declared.getName(), NoLookupLocation.WHEN_CHECK_OVERRIDES));
            for (CallableMemberDescriptor fromSuper : all) {
                if (OverridingUtil.DEFAULT.isOverridableBy(fromSuper, declared).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) continue;
                if (Visibilities.isVisible(ReceiverValue.IRRELEVANT_RECEIVER, fromSuper, declared)) {
                    throw new IllegalStateException("Descriptor " + fromSuper + " is overridable by " + declared + " and visible but does not appear in its getOverriddenDescriptors()");
                }
                return fromSuper;
            }
        }
        return null;
    }

    private void checkParameterOverridesForAllClasses(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkParameterOverridesForAllClasses"));
        }
        for (ClassDescriptorWithResolutionScopes classDescriptor : c.getDeclaredClasses().values()) {
            for (DeclarationDescriptor member : DescriptorUtils.getAllDescriptors(classDescriptor.getDefaultType().getMemberScope())) {
                if (!(member instanceof CallableMemberDescriptor)) continue;
                this.checkOverridesForParameters((CallableMemberDescriptor)member);
            }
        }
    }

    private void checkOverridesForParameters(@NotNull CallableMemberDescriptor declared) {
        KtModifierListOwner declaration;
        boolean isDeclaration;
        if (declared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declared", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkOverridesForParameters"));
        }
        boolean bl = isDeclaration = declared.getKind() == CallableMemberDescriptor.Kind.DECLARATION;
        if (isDeclaration && (declaration = (KtModifierListOwner)DescriptorToSourceUtils.descriptorToDeclaration(declared)) != null && !declaration.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return;
        }
        for (ValueParameterDescriptor parameterFromSubclass : declared.getValueParameters()) {
            boolean multipleDefaultsInSuper;
            int defaultsInSuper = 0;
            for (ValueParameterDescriptor parameterFromSuperclass : parameterFromSubclass.getOverriddenDescriptors()) {
                if (!parameterFromSuperclass.declaresDefaultValue()) continue;
                ++defaultsInSuper;
            }
            boolean bl2 = multipleDefaultsInSuper = defaultsInSuper > 1;
            if (isDeclaration) {
                this.checkNameAndDefaultForDeclaredParameter(parameterFromSubclass, multipleDefaultsInSuper);
                continue;
            }
            this.checkNameAndDefaultForFakeOverrideParameter(declared, parameterFromSubclass, multipleDefaultsInSuper);
        }
    }

    private void checkNameAndDefaultForDeclaredParameter(@NotNull ValueParameterDescriptor descriptor2, boolean multipleDefaultsInSuper) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkNameAndDefaultForDeclaredParameter"));
        }
        KtParameter parameter = (KtParameter)DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        assert (parameter != null) : "Declaration not found for parameter: " + descriptor2;
        if (descriptor2.declaresDefaultValue()) {
            this.trace.report(Errors.DEFAULT_VALUE_NOT_ALLOWED_IN_OVERRIDE.on(parameter));
        }
        if (multipleDefaultsInSuper) {
            this.trace.report(Errors.MULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES.on(parameter, descriptor2));
        }
        for (ValueParameterDescriptor parameterFromSuperclass : descriptor2.getOverriddenDescriptors()) {
            if (!OverrideResolver.shouldReportParameterNameOverrideWarning(descriptor2, parameterFromSuperclass)) continue;
            this.trace.report(Errors.PARAMETER_NAME_CHANGED_ON_OVERRIDE.on(parameter, (ClassDescriptor)parameterFromSuperclass.getContainingDeclaration().getContainingDeclaration(), parameterFromSuperclass));
        }
    }

    private void checkNameAndDefaultForFakeOverrideParameter(@NotNull CallableMemberDescriptor containingFunction, @NotNull ValueParameterDescriptor descriptor2, boolean multipleDefaultsInSuper) {
        if (containingFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFunction", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkNameAndDefaultForFakeOverrideParameter"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkNameAndDefaultForFakeOverrideParameter"));
        }
        DeclarationDescriptor containingClass = containingFunction.getContainingDeclaration();
        KtClassOrObject classElement = (KtClassOrObject)DescriptorToSourceUtils.descriptorToDeclaration(containingClass);
        assert (classElement != null) : "Declaration not found for class: " + containingClass;
        if (multipleDefaultsInSuper) {
            this.trace.report(Errors.MULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES_WHEN_NO_EXPLICIT_OVERRIDE.on(classElement, descriptor2));
        }
        for (ValueParameterDescriptor parameterFromSuperclass : descriptor2.getOverriddenDescriptors()) {
            if (!OverrideResolver.shouldReportParameterNameOverrideWarning(descriptor2, parameterFromSuperclass)) continue;
            this.trace.report(Errors.DIFFERENT_NAMES_FOR_THE_SAME_PARAMETER_IN_SUPERTYPES.on(classElement, containingFunction.getOverriddenDescriptors(), parameterFromSuperclass.getIndex() + 1));
        }
    }

    public static boolean shouldReportParameterNameOverrideWarning(@NotNull ValueParameterDescriptor parameterFromSubclass, @NotNull ValueParameterDescriptor parameterFromSuperclass) {
        if (parameterFromSubclass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterFromSubclass", "org/jetbrains/kotlin/resolve/OverrideResolver", "shouldReportParameterNameOverrideWarning"));
        }
        if (parameterFromSuperclass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterFromSuperclass", "org/jetbrains/kotlin/resolve/OverrideResolver", "shouldReportParameterNameOverrideWarning"));
        }
        return parameterFromSubclass.getContainingDeclaration().hasStableParameterNames() && parameterFromSuperclass.getContainingDeclaration().hasStableParameterNames() && !parameterFromSuperclass.getName().equals(parameterFromSubclass.getName());
    }

    private static boolean checkPropertyKind(@NotNull CallableMemberDescriptor descriptor2, boolean isVar) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkPropertyKind"));
        }
        return descriptor2 instanceof PropertyDescriptor && ((PropertyDescriptor)descriptor2).isVar() == isVar;
    }

    private void checkVisibility(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkVisibility"));
        }
        for (Map.Entry<KtCallableDeclaration, CallableMemberDescriptor> entry : c.getMembers().entrySet()) {
            this.checkVisibilityForMember(entry.getKey(), entry.getValue());
        }
    }

    private void checkVisibilityForMember(@NotNull KtDeclaration declaration, @NotNull CallableMemberDescriptor memberDescriptor) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkVisibilityForMember"));
        }
        if (memberDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "checkVisibilityForMember"));
        }
        Visibility visibility = memberDescriptor.getVisibility();
        for (CallableMemberDescriptor callableMemberDescriptor : memberDescriptor.getOverriddenDescriptors()) {
            Integer compare = Visibilities.compare(visibility, callableMemberDescriptor.getVisibility());
            if (compare == null) {
                this.trace.report(Errors.CANNOT_CHANGE_ACCESS_PRIVILEGE.on(declaration, callableMemberDescriptor.getVisibility(), callableMemberDescriptor, callableMemberDescriptor.getContainingDeclaration()));
                return;
            }
            if (compare >= 0) continue;
            this.trace.report(Errors.CANNOT_WEAKEN_ACCESS_PRIVILEGE.on(declaration, callableMemberDescriptor.getVisibility(), callableMemberDescriptor, callableMemberDescriptor.getContainingDeclaration()));
            return;
        }
    }

    @NotNull
    public static <D extends CallableMemberDescriptor> Collection<D> getDirectlyOverriddenDeclarations(@NotNull D descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "getDirectlyOverriddenDeclarations"));
        }
        LinkedHashSet<CallableMemberDescriptor> result2 = new LinkedHashSet<CallableMemberDescriptor>();
        for (CallableMemberDescriptor callableMemberDescriptor : descriptor2.getOverriddenDescriptors()) {
            CallableMemberDescriptor.Kind kind = callableMemberDescriptor.getKind();
            if (kind == CallableMemberDescriptor.Kind.DECLARATION) {
                result2.add(callableMemberDescriptor);
                continue;
            }
            if (kind == CallableMemberDescriptor.Kind.FAKE_OVERRIDE || kind == CallableMemberDescriptor.Kind.DELEGATION) {
                result2.addAll(OverrideResolver.getDirectlyOverriddenDeclarations(callableMemberDescriptor));
                continue;
            }
            if (kind != CallableMemberDescriptor.Kind.SYNTHESIZED) {
                throw new AssertionError((Object)("Unexpected callable kind " + (Object)((Object)kind)));
            }
        }
        Set set = OverrideResolver.filterOutOverridden(result2);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "getDirectlyOverriddenDeclarations"));
        }
        return set;
    }

    @NotNull
    @ReadOnly
    public static <D extends CallableMemberDescriptor> Set<D> getDeepestSuperDeclarations(@NotNull D functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/OverrideResolver", "getDeepestSuperDeclarations"));
        }
        Set<D> overriddenDeclarations = DescriptorUtils.getAllOverriddenDeclarations(functionDescriptor);
        if (overriddenDeclarations.isEmpty()) {
            Set<D> set = Collections.singleton(functionDescriptor);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "getDeepestSuperDeclarations"));
            }
            return set;
        }
        Set<D> set = OverrideResolver.filterOutOverriding(overriddenDeclarations);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/OverrideResolver", "getDeepestSuperDeclarations"));
        }
        return set;
    }

    private static interface CheckOverrideReportStrategy {
        public void overridingFinalMember(@NotNull CallableMemberDescriptor var1);

        public void returnTypeMismatchOnOverride(@NotNull CallableMemberDescriptor var1);

        public void propertyTypeMismatchOnOverride(@NotNull CallableMemberDescriptor var1);

        public void varOverriddenByVal(@NotNull CallableMemberDescriptor var1);

        public void cannotOverrideInvisibleMember(@NotNull CallableMemberDescriptor var1);

        public void nothingToOverride();
    }

    private static enum Filtering {
        RETAIN_OVERRIDING,
        RETAIN_OVERRIDDEN;

    }
}

