/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.HelpSetPath;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginBean;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginHelpSet;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.gnu.trove.THashMap;
import org.jetbrains.kotlin.relocated.org.jdom.Document;
import org.jetbrains.kotlin.relocated.org.jdom.Element;
import org.jetbrains.kotlin.relocated.org.jdom.JDOMException;

public class IdeaPluginDescriptorImpl
implements IdeaPluginDescriptor {
    public static final IdeaPluginDescriptorImpl[] EMPTY_ARRAY = new IdeaPluginDescriptorImpl[0];
    private static final Logger LOG = Logger.getInstance("#com.intellij.ide.plugins.PluginDescriptor");
    private final NullableLazyValue<String> myDescription;
    private String myName;
    private PluginId myId;
    private String myResourceBundleBaseName;
    private String myChangeNotes;
    private String myVersion;
    private String myVendor;
    private String myVendorEmail;
    private String myVendorUrl;
    private String myVendorLogoPath;
    private String myCategory;
    private String url;
    private File myPath;
    private PluginId[] myDependencies;
    private PluginId[] myOptionalDependencies;
    private Map<PluginId, String> myOptionalConfigs;
    private Map<PluginId, IdeaPluginDescriptorImpl> myOptionalDescriptors;
    @Nullable
    private List<Element> myActionsElements;
    private ComponentConfig[] myAppComponents;
    private ComponentConfig[] myProjectComponents;
    private ComponentConfig[] myModuleComponents;
    private ClassLoader myLoader;
    private HelpSetPath[] myHelpSets;
    @Nullable
    private MultiMap<String, Element> myExtensions;
    @Nullable
    private MultiMap<String, Element> myExtensionsPoints;
    private String myDescriptionChildText;
    private boolean myUseIdeaClassLoader;
    private boolean myUseCoreClassLoader;
    private boolean myAllowBundledUpdate;
    private boolean myEnabled;
    private String mySinceBuild;
    private String myUntilBuild;
    private List<String> myModules;

    public IdeaPluginDescriptorImpl(@NotNull File pluginPath) {
        if (pluginPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginPath", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "<init>"));
        }
        this.myDescription = new NullableLazyValue<String>(){

            @Override
            protected String compute() {
                return IdeaPluginDescriptorImpl.this.computeDescription();
            }
        };
        this.myDependencies = PluginId.EMPTY_ARRAY;
        this.myOptionalDependencies = PluginId.EMPTY_ARRAY;
        this.myEnabled = true;
        this.myPath = pluginPath;
    }

    @Nullable
    private static List<Element> copyElements(@Nullable Element[] elements, StringInterner interner) {
        if (elements == null || elements.length == 0) {
            return null;
        }
        SmartList<Element> result2 = new SmartList<Element>();
        for (Element extensionsRoot : elements) {
            for (Element element : extensionsRoot.getChildren()) {
                JDOMUtil.internElement(element, interner);
                result2.add(element);
            }
        }
        return result2;
    }

    private static String createDescriptionKey(PluginId id) {
        return "plugin." + id + ".description";
    }

    private static ComponentConfig[] mergeComponents(ComponentConfig[] first, ComponentConfig[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return ArrayUtil.mergeArrays(first, second);
    }

    @Override
    public File getPath() {
        return this.myPath;
    }

    public void setPath(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "setPath"));
        }
        this.myPath = path;
    }

    public void readExternal(@NotNull Document document, @NotNull URL url) throws InvalidDataException, FileNotFoundException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "readExternal"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "readExternal"));
        }
        Application application = ApplicationManager.getApplication();
        this.readExternal(document, url, application != null && application.isUnitTestMode());
    }

    public void readExternal(@NotNull Document document, @NotNull URL url, boolean ignoreMissingInclude) throws InvalidDataException, FileNotFoundException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "readExternal"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "readExternal"));
        }
        document = JDOMXIncluder.resolve(document, url.toExternalForm(), ignoreMissingInclude);
        Element rootElement = document.getRootElement();
        JDOMUtil.internElement(rootElement, new StringInterner());
        this.readExternal(document.getRootElement());
    }

    public void readExternal(@NotNull URL url) throws InvalidDataException, FileNotFoundException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "readExternal"));
        }
        try {
            Document document = JDOMUtil.loadDocument(url);
            this.readExternal(document, url);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new InvalidDataException(e);
        }
        catch (JDOMException e) {
            throw new InvalidDataException(e);
        }
    }

    protected void readExternal(@NotNull Element element) {
        List<Element> extensionPoints;
        StringInterner interner;
        List<Element> extensions;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "readExternal"));
        }
        PluginBean pluginBean = XmlSerializer.deserialize(element, PluginBean.class);
        this.url = pluginBean.url;
        this.myName = pluginBean.name;
        String idString = pluginBean.id;
        if (idString == null || idString.isEmpty()) {
            idString = this.myName;
        }
        this.myId = idString == null ? null : PluginId.getId(idString);
        String internalVersionString = pluginBean.formatVersion;
        if (internalVersionString != null) {
            try {
                Integer.parseInt(internalVersionString);
            }
            catch (NumberFormatException e) {
                LOG.error(new PluginException("Invalid value in plugin.xml format version: '" + internalVersionString + "'", e, this.myId));
            }
        }
        this.myUseIdeaClassLoader = pluginBean.useIdeaClassLoader;
        this.myAllowBundledUpdate = pluginBean.allowBundledUpdate;
        if (pluginBean.ideaVersion != null) {
            this.mySinceBuild = pluginBean.ideaVersion.sinceBuild;
            this.myUntilBuild = pluginBean.ideaVersion.untilBuild;
        }
        this.myResourceBundleBaseName = pluginBean.resourceBundle;
        this.myDescriptionChildText = pluginBean.description;
        this.myChangeNotes = pluginBean.changeNotes;
        this.myVersion = pluginBean.pluginVersion;
        if (this.myVersion == null) {
            this.myVersion = PluginManagerCore.getBuildNumber().getBaselineVersion() + ".SNAPSHOT";
        }
        this.myCategory = pluginBean.category;
        if (pluginBean.vendor != null) {
            this.myVendor = pluginBean.vendor.name;
            this.myVendorEmail = pluginBean.vendor.email;
            this.myVendorUrl = pluginBean.vendor.url;
            this.myVendorLogoPath = pluginBean.vendor.logo;
        }
        LinkedHashSet<PluginId> dependentPlugins = new LinkedHashSet<PluginId>();
        LinkedHashSet<PluginId> optionalDependentPlugins = new LinkedHashSet<PluginId>();
        if (pluginBean.dependencies != null) {
            this.myOptionalConfigs = new THashMap<PluginId, String>();
            for (PluginDependency dependency : pluginBean.dependencies) {
                String text = dependency.pluginId;
                if (StringUtil.isEmpty(text)) continue;
                PluginId id = PluginId.getId(text);
                dependentPlugins.add(id);
                if (!dependency.optional) continue;
                optionalDependentPlugins.add(id);
                if (StringUtil.isEmpty(dependency.configFile)) continue;
                this.myOptionalConfigs.put(id, dependency.configFile);
            }
        }
        this.myDependencies = dependentPlugins.isEmpty() ? PluginId.EMPTY_ARRAY : dependentPlugins.toArray(new PluginId[dependentPlugins.size()]);
        PluginId[] pluginIdArray = this.myOptionalDependencies = optionalDependentPlugins.isEmpty() ? PluginId.EMPTY_ARRAY : optionalDependentPlugins.toArray(new PluginId[optionalDependentPlugins.size()]);
        if (pluginBean.helpSets == null || pluginBean.helpSets.length == 0) {
            this.myHelpSets = HelpSetPath.EMPTY;
        } else {
            this.myHelpSets = new HelpSetPath[pluginBean.helpSets.length];
            for (PluginHelpSet pluginHelpSet : pluginBean.helpSets) {
                this.myHelpSets[i] = new HelpSetPath(pluginHelpSet.file, pluginHelpSet.path);
            }
        }
        this.myAppComponents = pluginBean.applicationComponents;
        this.myProjectComponents = pluginBean.projectComponents;
        this.myModuleComponents = pluginBean.moduleComponents;
        if (this.myAppComponents == null) {
            this.myAppComponents = ComponentConfig.EMPTY_ARRAY;
        }
        if (this.myProjectComponents == null) {
            this.myProjectComponents = ComponentConfig.EMPTY_ARRAY;
        }
        if (this.myModuleComponents == null) {
            this.myModuleComponents = ComponentConfig.EMPTY_ARRAY;
        }
        if ((extensions = IdeaPluginDescriptorImpl.copyElements(pluginBean.extensions, interner = new StringInterner())) != null) {
            this.myExtensions = MultiMap.createSmart();
            for (Element extension : extensions) {
                this.myExtensions.putValue(ExtensionsAreaImpl.extractEPName(extension), extension);
            }
        }
        if ((extensionPoints = IdeaPluginDescriptorImpl.copyElements(pluginBean.extensionPoints, interner)) != null) {
            this.myExtensionsPoints = MultiMap.createSmart();
            for (Element extensionPoint : extensionPoints) {
                this.myExtensionsPoints.putValue(StringUtil.notNullize(extensionPoint.getAttributeValue("area")), extensionPoint);
            }
        }
        this.myActionsElements = IdeaPluginDescriptorImpl.copyElements(pluginBean.actions, interner);
        if (pluginBean.modules != null && !pluginBean.modules.isEmpty()) {
            this.myModules = pluginBean.modules;
        }
    }

    public void registerExtensionPoints(@NotNull ExtensionsArea area) {
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "registerExtensionPoints"));
        }
        if (this.myExtensionsPoints != null) {
            for (Element element : this.myExtensionsPoints.get(StringUtil.notNullize(area.getAreaClass()))) {
                area.registerExtensionPoint(this, element);
            }
        }
    }

    public void registerExtensions(@NotNull ExtensionsArea area, @NotNull String epName) {
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "registerExtensions"));
        }
        if (epName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "epName", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "registerExtensions"));
        }
        if (this.myExtensions != null) {
            for (Element element : this.myExtensions.get(epName)) {
                area.registerExtension(this, element);
            }
        }
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    @NotNull
    public PluginId[] getDependentPluginIds() {
        if (this.myDependencies == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "getDependentPluginIds"));
        }
        return this.myDependencies;
    }

    @Override
    @NotNull
    public PluginId[] getOptionalDependentPluginIds() {
        if (this.myOptionalDependencies == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "getOptionalDependentPluginIds"));
        }
        return this.myOptionalDependencies;
    }

    @Override
    public String getVersion() {
        return this.myVersion;
    }

    @Override
    public String getCategory() {
        return this.myCategory;
    }

    @NotNull
    public List<File> getClassPath() {
        if (this.myPath.isDirectory()) {
            File[] files;
            ArrayList<File> result2 = new ArrayList<File>();
            File classesDir = new File(this.myPath, "classes");
            if (classesDir.exists()) {
                result2.add(classesDir);
            }
            if ((files = new File(this.myPath, "lib").listFiles()) != null && files.length > 0) {
                for (File f : files) {
                    if (f.isFile()) {
                        String name = f.getName();
                        if (!StringUtil.endsWithIgnoreCase(name, ".jar") && !StringUtil.endsWithIgnoreCase(name, ".zip")) continue;
                        result2.add(f);
                        continue;
                    }
                    result2.add(f);
                }
            }
            ArrayList<File> arrayList = result2;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "getClassPath"));
            }
            return arrayList;
        }
        List<File> list = Collections.singletonList(this.myPath);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "getClassPath"));
        }
        return list;
    }

    @NonNls
    public String toString() {
        return "PluginDescriptor[name='" + this.myName + "', classpath='" + this.myPath + "']";
    }

    public void setLoader(ClassLoader loader) {
        this.myLoader = loader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeaPluginDescriptorImpl)) {
            return false;
        }
        IdeaPluginDescriptorImpl pluginDescriptor = (IdeaPluginDescriptorImpl)o;
        return this.myName == null ? pluginDescriptor.myName == null : this.myName.equals(pluginDescriptor.myName);
    }

    public int hashCode() {
        return this.myName != null ? this.myName.hashCode() : 0;
    }

    @Override
    public PluginId getPluginId() {
        return this.myId;
    }

    @Override
    public ClassLoader getPluginClassLoader() {
        return this.myLoader != null ? this.myLoader : this.getClass().getClassLoader();
    }

    @Override
    public boolean getUseIdeaClassLoader() {
        return this.myUseIdeaClassLoader;
    }

    public boolean isUseCoreClassLoader() {
        return this.myUseCoreClassLoader;
    }

    public void setUseCoreClassLoader(boolean useCoreClassLoader) {
        this.myUseCoreClassLoader = useCoreClassLoader;
    }

    private String computeDescription() {
        ResourceBundle bundle = null;
        if (this.myResourceBundleBaseName != null) {
            try {
                bundle = AbstractBundle.getResourceBundle(this.myResourceBundleBaseName, this.getPluginClassLoader());
            }
            catch (MissingResourceException e) {
                LOG.info("Cannot find plugin " + this.myId + " resource-bundle: " + this.myResourceBundleBaseName);
            }
        }
        if (bundle == null) {
            return this.myDescriptionChildText;
        }
        return CommonBundle.messageOrDefault(bundle, IdeaPluginDescriptorImpl.createDescriptionKey(this.myId), this.myDescriptionChildText == null ? "" : this.myDescriptionChildText, new Object[0]);
    }

    public void insertDependency(@NotNull IdeaPluginDescriptor d) {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "insertDependency"));
        }
        PluginId[] deps = new PluginId[this.getDependentPluginIds().length + 1];
        deps[0] = d.getPluginId();
        System.arraycopy(this.myDependencies, 0, deps, 1, deps.length - 1);
        this.myDependencies = deps;
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @Override
    public String getSinceBuild() {
        return this.mySinceBuild;
    }

    @Override
    public String getUntilBuild() {
        return this.myUntilBuild;
    }

    Map<PluginId, String> getOptionalConfigs() {
        return this.myOptionalConfigs;
    }

    Map<PluginId, IdeaPluginDescriptorImpl> getOptionalDescriptors() {
        return this.myOptionalDescriptors;
    }

    void setOptionalDescriptors(@NotNull Map<PluginId, IdeaPluginDescriptorImpl> optionalDescriptors) {
        if (optionalDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionalDescriptors", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "setOptionalDescriptors"));
        }
        this.myOptionalDescriptors = optionalDescriptors;
    }

    void mergeOptionalConfig(IdeaPluginDescriptorImpl descriptor2) {
        if (this.myExtensions == null) {
            this.myExtensions = descriptor2.myExtensions;
        } else if (descriptor2.myExtensions != null) {
            this.myExtensions.putAllValues(descriptor2.myExtensions);
        }
        if (this.myExtensionsPoints == null) {
            this.myExtensionsPoints = descriptor2.myExtensionsPoints;
        } else if (descriptor2.myExtensionsPoints != null) {
            this.myExtensionsPoints.putAllValues(descriptor2.myExtensionsPoints);
        }
        if (this.myActionsElements == null) {
            this.myActionsElements = descriptor2.myActionsElements;
        } else if (descriptor2.myActionsElements != null) {
            this.myActionsElements.addAll(descriptor2.myActionsElements);
        }
        this.myAppComponents = IdeaPluginDescriptorImpl.mergeComponents(this.myAppComponents, descriptor2.myAppComponents);
        this.myProjectComponents = IdeaPluginDescriptorImpl.mergeComponents(this.myProjectComponents, descriptor2.myProjectComponents);
        this.myModuleComponents = IdeaPluginDescriptorImpl.mergeComponents(this.myModuleComponents, descriptor2.myModuleComponents);
    }

    @Override
    public boolean isBundled() {
        String path;
        if ("com.intellij".equals(this.myId.getIdString())) {
            return true;
        }
        try {
            path = this.getPath().getCanonicalPath();
        }
        catch (IOException e) {
            path = this.getPath().getAbsolutePath();
        }
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isInternal()) {
            if (path.startsWith(PathManager.getHomePath() + File.separator + "out" + File.separator + "classes")) {
                return true;
            }
            if (app.isUnitTestMode() && !path.startsWith(PathManager.getPluginsPath() + File.separatorChar)) {
                return true;
            }
        }
        return path.startsWith(PathManager.getPreInstalledPluginsPath());
    }

    @Nullable
    public List<String> getModules() {
        return this.myModules;
    }
}

