/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.annotations.Transient;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.org.jdom.Element;
import org.jetbrains.kotlin.relocated.org.jdom.Verifier;

public class DefaultJDOMExternalizer {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.DefaultJDOMExternalizer");

    public static void writeExternal(@NotNull Object data, @NotNull Element parentNode) throws WriteExternalException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/util/DefaultJDOMExternalizer", "writeExternal"));
        }
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/openapi/util/DefaultJDOMExternalizer", "writeExternal"));
        }
        DefaultJDOMExternalizer.writeExternal(data, parentNode, null);
    }

    public static void writeExternal(@NotNull Object data, @NotNull Element parentNode, @Nullable(value="null means all elements accepted") JDOMFilter filter) throws WriteExternalException {
        Field[] fields2;
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/util/DefaultJDOMExternalizer", "writeExternal"));
        }
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/openapi/util/DefaultJDOMExternalizer", "writeExternal"));
        }
        for (Field field : fields2 = data.getClass().getFields()) {
            Element element;
            String value;
            block24: {
                int modifiers2;
                if (field.getName().indexOf(36) >= 0 || !Modifier.isPublic(modifiers2 = field.getModifiers()) || Modifier.isStatic(modifiers2) || Modifier.isTransient(modifiers2) || field.getAnnotation(Transient.class) != null) continue;
                field.setAccessible(true);
                Class<?> type2 = field.getType();
                if (filter != null && !filter.isAccept(field) || field.getDeclaringClass().getAnnotation(Transient.class) != null) continue;
                value = null;
                try {
                    if (type2.isPrimitive()) {
                        if (type2.equals(Byte.TYPE)) {
                            value = Byte.toString(field.getByte(data));
                        } else if (type2.equals(Short.TYPE)) {
                            value = Short.toString(field.getShort(data));
                        } else if (type2.equals(Integer.TYPE)) {
                            value = Integer.toString(field.getInt(data));
                        } else if (type2.equals(Long.TYPE)) {
                            value = Long.toString(field.getLong(data));
                        } else if (type2.equals(Float.TYPE)) {
                            value = Float.toString(field.getFloat(data));
                        } else if (type2.equals(Double.TYPE)) {
                            value = Double.toString(field.getDouble(data));
                        } else if (type2.equals(Character.TYPE)) {
                            value = String.valueOf(field.getChar(data));
                        } else {
                            if (!type2.equals(Boolean.TYPE)) continue;
                            value = Boolean.toString(field.getBoolean(data));
                        }
                        break block24;
                    }
                    if (type2.equals(String.class)) {
                        value = DefaultJDOMExternalizer.filterXMLCharacters((String)field.get(data));
                        break block24;
                    }
                    if (type2.equals(Color.class)) {
                        Color color = (Color)field.get(data);
                        if (color != null) {
                            value = Integer.toString(color.getRGB() & 0xFFFFFF, 16);
                        }
                        break block24;
                    }
                    if (ReflectionUtil.isAssignable(JDOMExternalizable.class, type2)) {
                        element = new Element("option");
                        parentNode.addContent(element);
                        element.setAttribute("name", field.getName());
                        JDOMExternalizable domValue = (JDOMExternalizable)field.get(data);
                        if (domValue == null) continue;
                        Element valueElement = new Element("value");
                        element.addContent(valueElement);
                        domValue.writeExternal(valueElement);
                        continue;
                    }
                    LOG.debug("Wrong field type: " + type2);
                }
                catch (IllegalAccessException e) {}
                continue;
            }
            element = new Element("option");
            parentNode.addContent(element);
            element.setAttribute("name", field.getName());
            if (value == null) continue;
            element.setAttribute("value", value);
        }
    }

    @Nullable
    public static String filterXMLCharacters(String value) {
        if (value != null) {
            StringBuilder builder = null;
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (Verifier.isXMLCharacter(c)) {
                    if (builder == null) continue;
                    builder.append(c);
                    continue;
                }
                if (builder != null) continue;
                builder = new StringBuilder(value.length() + 5);
                builder.append(value, 0, i);
            }
            if (builder != null) {
                value = builder.toString();
            }
        }
        return value;
    }

    public static void readExternal(@NotNull Object data, Element parentNode) throws InvalidDataException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/util/DefaultJDOMExternalizer", "readExternal"));
        }
        if (parentNode == null) {
            return;
        }
        for (Element o : parentNode.getChildren("option")) {
            Element e = o;
            String fieldName = e.getAttributeValue("name");
            if (fieldName == null) {
                throw new InvalidDataException();
            }
            try {
                List<Element> children;
                Object value;
                Field field = data.getClass().getField(fieldName);
                Class<?> type2 = field.getType();
                int modifiers2 = field.getModifiers();
                if ((modifiers2 & 1) == 0 || (modifiers2 & 8) != 0) continue;
                field.setAccessible(true);
                if ((modifiers2 & 0x10) != 0) {
                    value = field.get(data);
                    if (!JDOMExternalizable.class.isInstance(value)) continue;
                    children = e.getChildren("value");
                    Iterator<Element> iterator2 = children.iterator();
                    while (iterator2.hasNext()) {
                        Element child;
                        Element valueTag = child = iterator2.next();
                        ((JDOMExternalizable)value).readExternal(valueTag);
                    }
                    continue;
                }
                value = e.getAttributeValue("value");
                if (type2.isPrimitive()) {
                    if (value == null) continue;
                    if (type2.equals(Byte.TYPE)) {
                        try {
                            field.setByte(data, Byte.parseByte((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Short.TYPE)) {
                        try {
                            field.setShort(data, Short.parseShort((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Integer.TYPE)) {
                        int i = DefaultJDOMExternalizer.toInt((String)value);
                        field.setInt(data, i);
                        continue;
                    }
                    if (type2.equals(Long.TYPE)) {
                        try {
                            field.setLong(data, Long.parseLong((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Float.TYPE)) {
                        try {
                            field.setFloat(data, Float.parseFloat((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Double.TYPE)) {
                        try {
                            field.setDouble(data, Double.parseDouble((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Character.TYPE)) {
                        if (((String)value).length() != 1) {
                            throw new InvalidDataException();
                        }
                        field.setChar(data, ((String)value).charAt(0));
                        continue;
                    }
                    if (type2.equals(Boolean.TYPE)) {
                        if (((String)value).equals("true")) {
                            field.setBoolean(data, true);
                            continue;
                        }
                        if (((String)value).equals("false")) {
                            field.setBoolean(data, false);
                            continue;
                        }
                        throw new InvalidDataException();
                    }
                    throw new InvalidDataException();
                }
                if (type2.equals(String.class)) {
                    field.set(data, value);
                    continue;
                }
                if (type2.equals(Color.class)) {
                    Color color = DefaultJDOMExternalizer.toColor((String)value);
                    field.set(data, color);
                    continue;
                }
                if (ReflectionUtil.isAssignable(JDOMExternalizable.class, type2)) {
                    children = e.getChildren("value");
                    if (children.isEmpty()) continue;
                    JDOMExternalizable object = null;
                    Iterator<Element> iterator3 = children.iterator();
                    while (iterator3.hasNext()) {
                        Element o1;
                        Element el = o1 = iterator3.next();
                        object = (JDOMExternalizable)type2.newInstance();
                        object.readExternal(el);
                    }
                    field.set(data, object);
                    continue;
                }
                throw new InvalidDataException("wrong type: " + type2);
            }
            catch (NoSuchFieldException ex) {
                LOG.debug(ex);
            }
            catch (SecurityException ex) {
                throw new InvalidDataException();
            }
            catch (IllegalAccessException ex) {
                throw new InvalidDataException(ex);
            }
            catch (InstantiationException ex) {
                throw new InvalidDataException();
            }
        }
    }

    public static int toInt(@NotNull String value) throws InvalidDataException {
        int i;
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/util/DefaultJDOMExternalizer", "toInt"));
        }
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException(value, ex);
        }
        return i;
    }

    public static Color toColor(@Nullable String value) throws InvalidDataException {
        Color color;
        if (value == null) {
            color = null;
        } else {
            try {
                int rgb = Integer.parseInt(value, 16);
                color = new Color(rgb);
            }
            catch (NumberFormatException ex) {
                LOG.debug("Wrong color value: " + value, ex);
                throw new InvalidDataException("Wrong color value: " + value, ex);
            }
        }
        return color;
    }

    public static interface JDOMFilter {
        public boolean isAccept(@NotNull Field var1);
    }
}

