/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.relocated.com.google.common.collect.ImmutableMap;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;

public class RangeCodegenUtil {
    private static final ImmutableMap<FqName, PrimitiveType> RANGE_TO_ELEMENT_TYPE;
    private static final ImmutableMap<FqName, PrimitiveType> PROGRESSION_TO_ELEMENT_TYPE;

    private static PrimitiveType[] supportedRangeTypes() {
        return new PrimitiveType[]{PrimitiveType.CHAR, PrimitiveType.INT, PrimitiveType.LONG, PrimitiveType.BYTE, PrimitiveType.SHORT};
    }

    private RangeCodegenUtil() {
    }

    public static boolean isRange(KotlinType rangeType) {
        return !rangeType.isMarkedNullable() && RangeCodegenUtil.getPrimitiveRangeElementType(rangeType) != null;
    }

    public static boolean isProgression(KotlinType rangeType) {
        return !rangeType.isMarkedNullable() && RangeCodegenUtil.getPrimitiveProgressionElementType(rangeType) != null;
    }

    @Nullable
    public static BinaryCall getRangeAsBinaryCall(@NotNull KtForExpression forExpression) {
        if (forExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forExpression", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "getRangeAsBinaryCall"));
        }
        KtExpression rangeExpression = forExpression.getLoopRange();
        assert (rangeExpression != null);
        KtExpression loopRange = KtPsiUtil.deparenthesize(rangeExpression);
        if (loopRange instanceof KtQualifiedExpression) {
            KtCallExpression callExpression;
            List<KtValueArgument> arguments2;
            KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)loopRange;
            KtExpression selector = qualifiedExpression.getSelectorExpression();
            if (selector instanceof KtCallExpression && (arguments2 = (callExpression = (KtCallExpression)selector).getValueArguments()).size() == 1) {
                return new BinaryCall(qualifiedExpression.getReceiverExpression(), callExpression.getCalleeExpression(), ((ValueArgument)arguments2.get(0)).getArgumentExpression());
            }
        } else if (loopRange instanceof KtBinaryExpression) {
            KtBinaryExpression binaryExpression = (KtBinaryExpression)loopRange;
            return new BinaryCall(binaryExpression.getLeft(), binaryExpression.getOperationReference(), binaryExpression.getRight());
        }
        return null;
    }

    @Nullable
    private static PrimitiveType getPrimitiveRangeElementType(KotlinType rangeType) {
        return RangeCodegenUtil.getPrimitiveRangeOrProgressionElementType(rangeType, RANGE_TO_ELEMENT_TYPE);
    }

    @Nullable
    private static PrimitiveType getPrimitiveProgressionElementType(KotlinType rangeType) {
        return RangeCodegenUtil.getPrimitiveRangeOrProgressionElementType(rangeType, PROGRESSION_TO_ELEMENT_TYPE);
    }

    @Nullable
    private static PrimitiveType getPrimitiveRangeOrProgressionElementType(@NotNull KotlinType rangeOrProgression, @NotNull ImmutableMap<FqName, PrimitiveType> map2) {
        if (rangeOrProgression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeOrProgression", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "getPrimitiveRangeOrProgressionElementType"));
        }
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "getPrimitiveRangeOrProgressionElementType"));
        }
        ClassifierDescriptor declarationDescriptor = rangeOrProgression.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor == null) {
            return null;
        }
        FqNameUnsafe fqName2 = DescriptorUtils.getFqName(declarationDescriptor);
        if (!fqName2.isSafe()) {
            return null;
        }
        return map2.get(fqName2.toSafe());
    }

    @Nullable
    public static PrimitiveType getPrimitiveRangeOrProgressionElementType(@NotNull FqName rangeOrProgressionName) {
        if (rangeOrProgressionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeOrProgressionName", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "getPrimitiveRangeOrProgressionElementType"));
        }
        PrimitiveType result2 = RANGE_TO_ELEMENT_TYPE.get(rangeOrProgressionName);
        return result2 != null ? result2 : PROGRESSION_TO_ELEMENT_TYPE.get(rangeOrProgressionName);
    }

    public static boolean isRangeOrProgression(@NotNull FqName className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/kotlin/codegen/RangeCodegenUtil", "isRangeOrProgression"));
        }
        return RangeCodegenUtil.getPrimitiveRangeOrProgressionElementType(className) != null;
    }

    public static boolean isOptimizableRangeTo(CallableDescriptor rangeTo) {
        return "rangeTo".equals(rangeTo.getName().asString()) && AsmUtil.isPrimitiveNumberClassDescriptor(rangeTo.getContainingDeclaration());
    }

    static {
        ImmutableMap.Builder<FqName, PrimitiveType> rangeBuilder = ImmutableMap.builder();
        ImmutableMap.Builder<FqName, PrimitiveType> progressionBuilder = ImmutableMap.builder();
        for (PrimitiveType primitiveType : RangeCodegenUtil.supportedRangeTypes()) {
            FqName rangeClassFqName = KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier(primitiveType.getTypeName() + "Range"));
            FqName progressionClassFqName = KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier(primitiveType.getTypeName() + "Progression"));
            rangeBuilder.put(rangeClassFqName, primitiveType);
            progressionBuilder.put(progressionClassFqName, primitiveType);
        }
        RANGE_TO_ELEMENT_TYPE = rangeBuilder.build();
        PROGRESSION_TO_ELEMENT_TYPE = progressionBuilder.build();
    }

    public static class BinaryCall {
        public final KtExpression left;
        public final KtExpression op;
        public final KtExpression right;

        private BinaryCall(KtExpression left, KtExpression op, KtExpression right) {
            this.left = left;
            this.op = op;
            this.right = right;
        }
    }
}

