/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.PositioningStrategy;
import org.jetbrains.kotlin.diagnostics.PositioningStrategyKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDelegationSpecifier;
import org.jetbrains.kotlin.psi.KtDelegationSpecifierList;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"1\u0004)\u0011\u0001D\u0001\u0006\u0003!\u0001Q!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011#)\u0011\u0001D\u0001\u0006\u0003\u0011\tAaY\u0001\r\u0001e\t\u0001\u0014AO\u0001C\u0005\u001eA!A)\u0004\u0003!\tQu\u0005C\u0004\u0011{iA!\u0003\u0002\n\u0003a\u0015\u0001DA\r\n\u0011}iQ!C\u0002\u0005\u0002%\t\u0001\u0004\tM #\u0005A\u0002%U\u0002\u0002\u0011\u0003J3\u0002b\"\t\u0011\u0007iA!\u0003\u0002\n\u0003a\u0015\u0001D\u0001\u000f\u0004#\u000e\tQ\u0001A\u0015\f\t\u000fC\u0001bA\u0007\u0005\u0013\tI\u0011\u0001g\u0002\u0019\u0005q\u0019\u0011kA\u0001\u0006\u0001%ZAq\u0011\u0005\t\t5!\u0011BA\u0005\u00021\u0013A\"\u0001H\u0002R\u0007\u0005)\u0001!K\u0006\u0005\b\"AQ!\u0004\u0003\n\u0005%\t\u00014\u0002\r\u00039\r\t6!A\u0003\u0001S-!9\t\u0003\u0005\u0007\u001b\u0011I!!C\u0001\u0019\fa\u0011AdA)\u0004\u0003\u0015\u0001\u0011f\u0003CD\u0011!5Q\u0002B\u0005\u0003\u0013\u0005Ar\u0001\u0007\u0002\u001d\u0007E\u001b\u0011!\u0002\u0001*\u0017\u0011\u001d\u0005\u0002c\u0004\u000e\t%\u0011\u0011\"\u0001\r\t1\ta2!U\u0002\u0002\u000b\u0001I3\u0002b\"\t\u0011#iA!\u0003\u0002\n\u0003aI\u0001D\u0001\u000f\u0004#\u000e\tQ\u0001A\u0015\f\t\u000fC\u00012C\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0006\u0019\u0005q\u0019\u0011kA\u0001\u0006\u0001%ZAq\u0011\u0005\t\u00165!\u0011BA\u0005\u00021)A\"\u0001H\u0002R\u0007\u0005)\u0001!K\u0006\u0005\b\"A1\"\u0004\u0003\n\u0005%\t\u00014\u0002\r\u00039\r\t6!A\u0003\u0001S-!9\t\u0003E\f\u001b\u0011I!!C\u0001\u0019\u0019a\u0011AdA)\u0004\u0003\u0015\u0001\u0011f\u0003CD\u0011!eQ\u0002B\u0005\u0003\u0013\u0005AZ\u0001\u0007\u0002\u001d\u0007E\u001b\u0011!\u0002\u0001*\u0017\u0011\u001d\u0005\u0002C\u0007\u000e\t%\u0011\u0011\"\u0001M\u000e1\ta2!U\u0002\u0002\u000b\u0001I3\u0002b\"\t\u00119iA!\u0003\u0002\n\u0003au\u0001D\u0001\u000f\u0004#\u000e\tQ\u0001A\u0015\f\t\u000fC\u0001bD\u0007\u0005\u0013\tI\u0011\u0001g\u0003\u0019\u0005q\u0019\u0011kA\u0001\u0006\u0001%ZAq\u0011\u0005\t 5!\u0011BA\u0005\u00021AA\"\u0001H\u0002R\u0007\u0005)\u0001!K\u0006\u0005\b\"A\t#\u0004\u0003\n\u0005%\t\u0001$\u0005\r\u00039\r\t6!A\u0003\u0001S-!9\t\u0003E\u0012\u001b\u0011I!!C\u0001\u0019%a\u0011AdA)\u0004\u0003\u0015\u0001\u0011f\u0003CD\u0011!\u0015R\u0002B\u0005\u0003\u0013\u0005A\u0002\u0002\u0007\u0002\u001d\u0007E\u001b\u0011!\u0002\u0001*\u0017\u0011\u001d\u0005\u0002C\n\u000e\t%\u0011\u0011\"\u0001M\u00141\ta2!U\u0002\u0002\u000b\u0001I3\u0002b\"\t\u0011QiA!\u0003\u0002\n\u0003a\u0015\u0001D\u0001\u000f\u0004#\u000e\tQ\u0001A\u0015\f\t\u000fC\u0001\u0012F\u0007\u0005\u0013\tI\u0011\u0001G\u000b\u0019\u0005q\u0019\u0011kA\u0001\u0006\u0001%ZAq\u0011\u0005\t,5!\u0011BA\u0005\u00021\u000bA\"\u0001H\u0002R\u0007\u0005)\u0001!K\u0006\u0005\b\"Aa#\u0004\u0003\n\u0005%\t\u0001T\u0006\r\u00039\r\t6!A\u0003\u0001S-!9\t\u0003\u0005\u0018\u001b\u0011I!!C\u0001\u0019\u0015a\u0011AdA)\u0004\u0003\u0015\u0001\u0011f\u0003CD\u0011!=R\u0002B\u0005\u0003\u0013\u0005AZ\u0001\u0007\u0002\u001d\u0007E\u001b\u0011!\u0002\u0001*\u0017\u0011\u001d\u0005\u0002\u0003\r\u000e\t%\u0011\u0011\"\u0001M\u00191\ta2!U\u0002\u0002\u000b\u0001I3\u0002b\"\t\u0011eiA!\u0003\u0002\n\u0003aE\u0002D\u0001\u000f\u0004#\u000e\tQ\u0001A\u0015\f\t\u000fC\u00012G\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0005\u0019\u0005q\u0019\u0011kA\u0001\u0006\u0001%ZAq\u0011\u0005\t55!\u0011BA\u0005\u00021%A\"\u0001H\u0002R\u0007\u0005)\u0001!K\u0006\u0005\b\"A)$\u0004\u0003\n\u0005%\t\u0001d\u0007\r\u00039\r\t6!A\u0003\u0001S-!9\t\u0003E\u001c\u001b\u0011I!!C\u0001\u0019\u0006a\u0011AdA)\u0004\u0003\u0015\u0001\u0011f\u0003CD\u0011!aR\u0002B\u0005\u0003\u0013\u0005A*\u0001\u0007\u0002\u001d\u0007E\u001b\u0011!\u0002\u0001*\u0017\u0011\u001d\u0005\u0002#\u000f\u000e\t%\u0011\u0011\"\u0001\r\u001e1\ta2!U\u0002\u0002\u000b\u0001I3\u0002b\"\t\u0011wiA!\u0003\u0002\n\u0003aq\u0002D\u0001\u000f\u0004#\u000e\tQ\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies;", "", "()V", "ABSTRACT_MODIFIER", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "ARRAY_ACCESS", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "AS_TYPE", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "CALL_ELEMENT", "Lcom/intellij/psi/PsiElement;", "CALL_EXPRESSION", "COMPANION_OBJECT", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "CUT_CHAR_QUOTES", "Lorg/jetbrains/kotlin/psi/KtElement;", "DECLARATION_NAME", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "DECLARATION_RETURN_TYPE", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "DECLARATION_SIGNATURE", "DECLARATION_SIGNATURE_OR_DEFAULT", "DECLARATION_WITH_BODY", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "DEFAULT", "DELEGATOR_SUPER_CALL", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "ELSE_ENTRY", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "FOR_REDECLARATION", "FOR_UNRESOLVED_REFERENCE", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "FUNCTION_PARAMETERS", "Lorg/jetbrains/kotlin/psi/KtFunction;", "IMPORT_ALIAS", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "LONG_LITERAL_SUFFIX", "NULLABLE_TYPE", "Lorg/jetbrains/kotlin/psi/KtNullableType;", "OVERRIDE_MODIFIER", "PARAMETER_DEFAULT_VALUE", "Lorg/jetbrains/kotlin/psi/KtParameter;", "PRIVATE_MODIFIER", "SECONDARY_CONSTRUCTOR_DELEGATION_CALL", "Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;", "TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE", "UNREACHABLE_CODE", "UNUSED_VALUE", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "USELESS_ELVIS", "VALUE_ARGUMENTS", "VAL_OR_VAR_NODE", "VARIANCE_IN_PROJECTION", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "VARIANCE_MODIFIER", "VISIBILITY_MODIFIER", "WHEN_CONDITION_IN_RANGE", "Lorg/jetbrains/kotlin/psi/KtWhenConditionInRange;", "WHEN_EXPRESSION", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "modifierSetPosition", "tokens", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "([Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "DeclarationHeader"}, moduleName="kotlin-compiler")
public final class PositioningStrategies {
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> DEFAULT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_RETURN_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> DECLARATION_NAME;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_SIGNATURE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> DECLARATION_SIGNATURE_OR_DEFAULT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> ABSTRACT_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> OVERRIDE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> PRIVATE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> VARIANCE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> FOR_REDECLARATION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtReferenceExpression> FOR_UNRESOLVED_REFERENCE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtArrayAccessExpression> ARRAY_ACCESS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> VISIBILITY_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtTypeProjection> VARIANCE_IN_PROJECTION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtParameter> PARAMETER_DEFAULT_VALUE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_ELEMENT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclarationWithBody> DECLARATION_WITH_BODY;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> VAL_OR_VAR_NODE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenEntry> ELSE_ENTRY;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenExpression> WHEN_EXPRESSION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenConditionInRange> WHEN_CONDITION_IN_RANGE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNullableType> NULLABLE_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_EXPRESSION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> VALUE_ARGUMENTS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtFunction> FUNCTION_PARAMETERS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> CUT_CHAR_QUOTES;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> LONG_LITERAL_SUFFIX;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> UNREACHABLE_CODE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpressionWithTypeRHS> AS_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtObjectDeclaration> COMPANION_OBJECT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtConstructorDelegationCall> SECONDARY_CONSTRUCTOR_DELEGATION_CALL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtEnumEntry> DELEGATOR_SUPER_CALL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpression> UNUSED_VALUE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpression> USELESS_ELVIS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtImportDirective> IMPORT_ALIAS;
    public static final PositioningStrategies INSTANCE;
    public static final PositioningStrategies INSTANCE$;

    @JvmStatic
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> modifierSetPosition(KtModifierKeywordToken ... tokens) {
        Intrinsics.checkParameterIsNotNull(tokens, "tokens");
        return new PositioningStrategy<KtModifierListOwner>(tokens){
            final /* synthetic */ KtModifierKeywordToken[] $tokens;

            @NotNull
            protected List<TextRange> mark(@NotNull KtModifierListOwner element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtModifierList $receiver = element.getModifierList();
                KtModifierList ktModifierList = $receiver;
                if (ktModifierList == null) {
                    AssertionError assertionError;
                    AssertionError assertionError2 = assertionError;
                    AssertionError assertionError3 = assertionError;
                    String string = "No modifier list, but modifier has been found by the analyzer";
                    assertionError2((Object)string);
                    throw (Throwable)((Object)assertionError3);
                }
                KtModifierList modifierList = ktModifierList;
                KtModifierKeywordToken[] ktModifierKeywordTokenArray = this.$tokens;
                for (int i = 0; i < ktModifierKeywordTokenArray.length; ++i) {
                    KtModifierKeywordToken token = ktModifierKeywordTokenArray[i];
                    PsiElement modifier = modifierList.getModifier(token);
                    if (modifier == null) continue;
                    return PositioningStrategyKt.markElement(modifier);
                }
                throw (Throwable)new IllegalStateException("None of the modifiers is found: " + CollectionsKt.listOf(Arrays.copyOf(this.$tokens, this.$tokens.length)));
            }
            {
                this.$tokens = $captured_local_variable$0;
            }
        };
    }

    static {
        new PositioningStrategies();
    }

    private PositioningStrategies() {
        INSTANCE = this;
        INSTANCE$ = this;
        DEFAULT = new PositioningStrategy<PsiElement>(){

            @NotNull
            protected List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement2 = element;
                if (psiElement2 instanceof KtObjectLiteralExpression) {
                    KtObjectDeclaration objectDeclaration = ((KtObjectLiteralExpression)element).getObjectDeclaration();
                    PsiElement objectKeyword = objectDeclaration.getObjectKeyword();
                    KtDelegationSpecifierList delegationSpecifierList = objectDeclaration.getDelegationSpecifierList();
                    if (delegationSpecifierList == null) {
                        return PositioningStrategyKt.markElement(objectKeyword);
                    }
                    return PositioningStrategyKt.markRange(objectKeyword, delegationSpecifierList);
                }
                if (psiElement2 instanceof KtObjectDeclaration) {
                    PsiElement psiElement3 = ((KtObjectDeclaration)element).getObjectKeyword();
                    PsiElement psiElement4 = ((KtObjectDeclaration)element).getNameIdentifier();
                    if (psiElement4 == null) {
                        psiElement4 = ((KtObjectDeclaration)element).getObjectKeyword();
                    }
                    return PositioningStrategyKt.markRange(psiElement3, psiElement4);
                }
                if (psiElement2 instanceof KtConstructorDelegationCall) {
                    return PositioningStrategies.SECONDARY_CONSTRUCTOR_DELEGATION_CALL.mark((KtConstructorDelegationCall)element);
                }
                return super.mark(element);
            }
        };
        DECLARATION_RETURN_TYPE = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return PositioningStrategyKt.markElement(this.getElementToMark(element));
            }

            public boolean isValid(@NotNull KtDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return !PositioningStrategyKt.hasSyntaxErrors(this.getElementToMark(element));
            }

            /*
             * WARNING - void declaration
             */
            private final PsiElement getElementToMark(KtDeclaration declaration) {
                void nameIdentifierOrPlaceholder;
                void returnTypeRef;
                KtDeclaration ktDeclaration = declaration;
                Pair<KtTypeReference, PsiElement> pair = ktDeclaration instanceof KtCallableDeclaration ? new Pair<KtTypeReference, PsiElement>(((KtCallableDeclaration)declaration).getTypeReference(), ((KtCallableDeclaration)declaration).getNameIdentifier()) : (ktDeclaration instanceof KtPropertyAccessor ? new Pair<KtTypeReference, PsiElement>(((KtPropertyAccessor)declaration).getReturnTypeReference(), ((KtPropertyAccessor)declaration).getNamePlaceholder()) : new Pair<Object, Object>(null, null));
                KtTypeReference ktTypeReference = pair.component1();
                PsiElement psiElement2 = pair.component2();
                pair = null;
                if (returnTypeRef != null) {
                    return (PsiElement)returnTypeRef;
                }
                if (nameIdentifierOrPlaceholder != null) {
                    return nameIdentifierOrPlaceholder;
                }
                return declaration;
            }
        };
        DECLARATION_NAME = new DeclarationHeader<KtNamedDeclaration>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtNamedDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement nameIdentifier = element.getNameIdentifier();
                if (nameIdentifier != null) {
                    if (element instanceof KtClassOrObject) {
                        PsiElement psiElement2;
                        PsiElement psiElement3 = ((KtClassOrObject)element).getModifierList();
                        if (psiElement3 == null || (psiElement3 = psiElement3.getModifier(KtTokens.ENUM_KEYWORD)) == null) {
                            ASTNode aSTNode = ((KtClassOrObject)element).getNode().findChildByType(TokenSet.create(KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD));
                            psiElement3 = psiElement2 = aSTNode != null ? aSTNode.getPsi() : null;
                        }
                        if (psiElement3 == null) {
                            psiElement2 = element;
                        }
                        PsiElement startElement = psiElement2;
                        return PositioningStrategyKt.markRange(startElement, nameIdentifier);
                    }
                    return PositioningStrategyKt.markElement(nameIdentifier);
                }
                if (element instanceof KtNamedFunction) {
                    return PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)((PsiElement)element));
                }
                return PositioningStrategies.DEFAULT.mark(element);
            }
        };
        DECLARATION_SIGNATURE = new DeclarationHeader<KtDeclaration>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtDeclaration ktDeclaration = element;
                if (ktDeclaration instanceof KtConstructor) {
                    PsiElement psiElement2 = ((KtConstructor)element).getConstructorKeyword();
                    if (psiElement2 == null) {
                        psiElement2 = ((KtConstructor)element).getValueParameterList();
                    }
                    if (psiElement2 == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    PsiElement begin = psiElement2;
                    KtParameterList ktParameterList = ((KtConstructor)element).getValueParameterList();
                    PsiElement psiElement3 = ktParameterList != null ? (PsiElement)ktParameterList : ((KtConstructor)element).getConstructorKeyword();
                    if (psiElement3 == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    PsiElement end = psiElement3;
                    return PositioningStrategyKt.markRange(begin, end);
                }
                if (ktDeclaration instanceof KtFunction) {
                    NavigatablePsiElement navigatablePsiElement;
                    PsiElement endOfSignatureElement;
                    PsiElement psiElement4;
                    KtTypeReference ktTypeReference = ((KtFunction)element).getTypeReference();
                    PsiElement psiElement5 = ktTypeReference != null ? (PsiElement)ktTypeReference : (PsiElement)((KtFunction)element).getValueParameterList();
                    if (psiElement5 == null) {
                        psiElement5 = psiElement4 = ((KtFunction)element).getNameIdentifier();
                    }
                    if (psiElement5 == null) {
                        psiElement4 = endOfSignatureElement = (PsiElement)element;
                    }
                    if (element instanceof KtFunctionLiteral) {
                        KtTypeReference ktTypeReference2 = ((KtFunctionLiteral)element).getReceiverTypeReference();
                        navigatablePsiElement = ktTypeReference2 != null ? (NavigatablePsiElement)ktTypeReference2 : (NavigatablePsiElement)((KtFunctionLiteral)element).getValueParameterList();
                        if (navigatablePsiElement == null) {
                            navigatablePsiElement = element;
                        }
                    } else {
                        navigatablePsiElement = element;
                    }
                    NavigatablePsiElement startElement = navigatablePsiElement;
                    return PositioningStrategyKt.markRange(startElement, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtProperty) {
                    KtTypeReference ktTypeReference = ((KtProperty)element).getTypeReference();
                    PsiElement psiElement6 = ktTypeReference != null ? (PsiElement)ktTypeReference : ((KtProperty)element).getNameIdentifier();
                    if (psiElement6 == null) {
                        psiElement6 = element;
                    }
                    PsiElement endOfSignatureElement = psiElement6;
                    return PositioningStrategyKt.markRange(element, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtPropertyAccessor) {
                    PsiElement psiElement7;
                    PsiElement psiElement8;
                    KtTypeReference ktTypeReference = ((KtPropertyAccessor)element).getReturnTypeReference();
                    if (ktTypeReference != null) {
                        psiElement8 = ktTypeReference;
                    } else {
                        ASTNode aSTNode = ((KtPropertyAccessor)element).getRightParenthesis();
                        psiElement8 = psiElement7 = aSTNode != null ? aSTNode.getPsi() : null;
                    }
                    if (psiElement8 == null) {
                        PsiElement psiElement9 = ((KtPropertyAccessor)element).getNamePlaceholder();
                        psiElement7 = psiElement9;
                        Intrinsics.checkExpressionValueIsNotNull(psiElement9, "element.getNamePlaceholder()");
                    }
                    PsiElement endOfSignatureElement = psiElement7;
                    return PositioningStrategyKt.markRange(element, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtClass) {
                    PsiElement psiElement10 = ((KtClass)element).getNameIdentifier();
                    if (psiElement10 == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    PsiElement nameAsDeclaration = psiElement10;
                    KtParameterList ktParameterList = ((KtClass)element).getPrimaryConstructorParameterList();
                    if (ktParameterList == null) {
                        PsiElement psiElement11 = nameAsDeclaration;
                        Intrinsics.checkExpressionValueIsNotNull(psiElement11, "nameAsDeclaration");
                        return PositioningStrategyKt.markElement(psiElement11);
                    }
                    KtParameterList primaryConstructorParameterList = ktParameterList;
                    PsiElement psiElement12 = nameAsDeclaration;
                    Intrinsics.checkExpressionValueIsNotNull(psiElement12, "nameAsDeclaration");
                    return PositioningStrategyKt.markRange(psiElement12, primaryConstructorParameterList);
                }
                if (ktDeclaration instanceof KtObjectDeclaration) {
                    return PositioningStrategies.DECLARATION_NAME.mark((KtNamedDeclaration)element);
                }
                return super.mark((PsiElement)element);
            }
        };
        DECLARATION_SIGNATURE_OR_DEFAULT = new PositioningStrategy<PsiElement>(){

            @NotNull
            protected List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return element instanceof KtDeclaration ? PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)element) : PositioningStrategies.DEFAULT.mark(element);
            }

            public boolean isValid(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return element instanceof KtDeclaration ? PositioningStrategies.DECLARATION_SIGNATURE.isValid((KtDeclaration)element) : PositioningStrategies.DEFAULT.isValid(element);
            }
        };
        TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtDeclaration element) {
                KtTypeParameterList jetTypeParameterList;
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof KtTypeParameterListOwner && (jetTypeParameterList = ((KtTypeParameterListOwner)element).getTypeParameterList()) != null) {
                    return PositioningStrategyKt.markElement(jetTypeParameterList);
                }
                return PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)((PsiElement)element));
            }
        };
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken, "KtTokens.ABSTRACT_KEYWORD");
        ktModifierKeywordTokenArray[0] = ktModifierKeywordToken;
        ABSTRACT_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray2 = new KtModifierKeywordToken[1];
        KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.OVERRIDE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken2, "KtTokens.OVERRIDE_KEYWORD");
        ktModifierKeywordTokenArray2[0] = ktModifierKeywordToken2;
        OVERRIDE_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray2);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray3 = new KtModifierKeywordToken[1];
        KtModifierKeywordToken ktModifierKeywordToken3 = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken3, "KtTokens.PRIVATE_KEYWORD");
        ktModifierKeywordTokenArray3[0] = ktModifierKeywordToken3;
        PRIVATE_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray3);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray4 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken4 = KtTokens.IN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken4, "KtTokens.IN_KEYWORD");
        ktModifierKeywordTokenArray4[0] = ktModifierKeywordToken4;
        KtModifierKeywordToken ktModifierKeywordToken5 = KtTokens.OUT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken5, "KtTokens.OUT_KEYWORD");
        ktModifierKeywordTokenArray4[1] = ktModifierKeywordToken5;
        VARIANCE_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray4);
        FOR_REDECLARATION = new PositioningStrategy<PsiElement>(){

            @NotNull
            protected List<TextRange> mark(@NotNull PsiElement element) {
                PsiElement nameIdentifier;
                PsiElement psiElement2;
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement3 = element;
                if (psiElement3 instanceof KtNamedDeclaration) {
                    psiElement2 = ((KtNamedDeclaration)element).getNameIdentifier();
                } else if (psiElement3 instanceof KtFile) {
                    KtPackageDirective ktPackageDirective = ((KtFile)element).getPackageDirective();
                    if (ktPackageDirective == null) {
                        Intrinsics.throwNpe();
                    }
                    psiElement2 = ktPackageDirective.getNameIdentifier();
                } else {
                    psiElement2 = nameIdentifier = (PsiElement)null;
                }
                if (nameIdentifier == null && element instanceof KtObjectDeclaration) {
                    return PositioningStrategies.DEFAULT.mark(element);
                }
                PsiElement psiElement4 = nameIdentifier;
                if (psiElement4 == null) {
                    psiElement4 = element;
                }
                return PositioningStrategyKt.markElement(psiElement4);
            }
        };
        FOR_UNRESOLVED_REFERENCE = new PositioningStrategy<KtReferenceExpression>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtReferenceExpression element) {
                List<TextRange> ranges2;
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof KtArrayAccessExpression && !(ranges2 = ((KtArrayAccessExpression)element).getBracketRanges()).isEmpty()) {
                    List<TextRange> list = ranges2;
                    Intrinsics.checkExpressionValueIsNotNull(list, "ranges");
                    return list;
                }
                return CollectionsKt.listOf(KtPsiUtilKt.getCalleeHighlightingRange(element));
            }
        };
        ARRAY_ACCESS = new PositioningStrategy<KtArrayAccessExpression>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtArrayAccessExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement2 = element.getIndicesNode();
                Intrinsics.checkExpressionValueIsNotNull(psiElement2, "element.getIndicesNode()");
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        VISIBILITY_MODIFIER = new PositioningStrategy<KtModifierListOwner>(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            protected List<TextRange> mark(@NotNull KtModifierListOwner element) {
                PsiElement psiElement2;
                PsiElement nameIdentifier;
                void destination;
                void $receiver;
                void $receiver2;
                void $receiver3;
                Intrinsics.checkParameterIsNotNull(element, "element");
                List<KtModifierKeywordToken> visibilityTokens = CollectionsKt.listOf(KtTokens.PRIVATE_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.PUBLIC_KEYWORD, KtTokens.INTERNAL_KEYWORD);
                KtModifierList modifierList = element.getModifierList();
                Iterable iterable = visibilityTokens;
                KtModifierListOwner ktModifierListOwner = $receiver3;
                Collection collection = new ArrayList<E>();
                void var7_7 = $receiver2;
                Iterator<T> iterator2 = $receiver.iterator();
                while (iterator2.hasNext()) {
                    Boolean bl;
                    T element2;
                    T element3 = element2 = iterator2.next();
                    KtModifierKeywordToken it2 = (KtModifierKeywordToken)element3;
                    PsiElement psiElement3 = modifierList;
                    if ((psiElement3 != null && (psiElement3 = ((KtModifierList)psiElement3).getModifier(it2)) != null ? psiElement3.getTextRange() : null) != null) {
                        void $receiver4;
                        TextRange textRange;
                        textRange = textRange;
                        void it3 = $receiver4;
                        bl = destination.add(it3);
                        continue;
                    }
                    bl = null;
                }
                List result2 = (List)destination;
                if (!result2.isEmpty()) {
                    return result2;
                }
                if (element instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)((Object)element)).getNameIdentifier()) != null) {
                    return PositioningStrategyKt.markElement(nameIdentifier);
                }
                ktModifierListOwner = element;
                if (ktModifierListOwner instanceof KtObjectDeclaration) {
                    psiElement2 = ((KtObjectDeclaration)element).getObjectKeyword();
                } else if (ktModifierListOwner instanceof KtPropertyAccessor) {
                    psiElement2 = ((KtPropertyAccessor)element).getNamePlaceholder();
                } else if (ktModifierListOwner instanceof KtAnonymousInitializer) {
                    psiElement2 = element;
                } else {
                    throw (Throwable)new IllegalArgumentException("Can't find text range for element '" + element.getClass().getCanonicalName() + "' with the text '" + element.getText() + "'");
                }
                PsiElement elementToMark = psiElement2;
                return PositioningStrategyKt.markElement(elementToMark);
            }
        };
        VARIANCE_IN_PROJECTION = new PositioningStrategy<KtTypeProjection>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtTypeProjection element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement2 = element.getProjectionToken();
                if (psiElement2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(psiElement2, "element.getProjectionToken()!!");
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        PARAMETER_DEFAULT_VALUE = new PositioningStrategy<KtParameter>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtParameter element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtExpression ktExpression = element.getDefaultValue();
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                ASTNode aSTNode = ktExpression.getNode();
                Intrinsics.checkExpressionValueIsNotNull(aSTNode, "element.getDefaultValue()!!.getNode()");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        CALL_ELEMENT = new PositioningStrategy<PsiElement>(){

            @NotNull
            protected List<TextRange> mark(@NotNull PsiElement element) {
                KtElement ktElement;
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement2 = element;
                if (!(psiElement2 instanceof KtCallElement)) {
                    psiElement2 = null;
                }
                return PositioningStrategyKt.markElement((ktElement = (KtCallElement)psiElement2) != null && (ktElement = ktElement.getCalleeExpression()) != null ? (PsiElement)ktElement : element);
            }
        };
        DECLARATION_WITH_BODY = new PositioningStrategy<KtDeclarationWithBody>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtDeclarationWithBody element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtExpression ktExpression = element.getBodyExpression();
                if (!(ktExpression instanceof KtBlockExpression)) {
                    ktExpression = null;
                }
                KtBlockExpression ktBlockExpression = (KtBlockExpression)ktExpression;
                TextRange lastBracketRange = ktBlockExpression != null ? ktBlockExpression.getLastBracketRange() : null;
                return lastBracketRange != null ? PositioningStrategyKt.markRange(lastBracketRange) : PositioningStrategyKt.markElement(element);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isValid(@NotNull KtDeclarationWithBody element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (!super.isValid((PsiElement)element)) return false;
                KtExpression ktExpression = element.getBodyExpression();
                if (!(ktExpression instanceof KtBlockExpression)) {
                    ktExpression = null;
                }
                KtBlockExpression ktBlockExpression = (KtBlockExpression)ktExpression;
                if (ktBlockExpression == null) return false;
                TextRange textRange = ktBlockExpression.getLastBracketRange();
                if (textRange == null) return false;
                return true;
            }
        };
        VAL_OR_VAR_NODE = new PositioningStrategy<KtNamedDeclaration>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtNamedDeclaration element) {
                List list;
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtNamedDeclaration ktNamedDeclaration = element;
                if (ktNamedDeclaration instanceof KtParameter) {
                    PsiElement psiElement2 = ((KtParameter)element).getValOrVarKeyword();
                    if (psiElement2 == null) {
                        psiElement2 = element;
                    }
                    list = PositioningStrategyKt.markElement(psiElement2);
                } else if (ktNamedDeclaration instanceof KtProperty) {
                    PsiElement psiElement3 = ((KtProperty)element).getValOrVarKeyword();
                    Intrinsics.checkExpressionValueIsNotNull(psiElement3, "element.valOrVarKeyword");
                    list = PositioningStrategyKt.markElement(psiElement3);
                } else {
                    list = (List)((Object)PreconditionsKt.error("Declaration is neither a parameter nor a property: " + PsiUtilsKt.getElementTextWithContext(element)));
                }
                return list;
            }
        };
        ELSE_ENTRY = new PositioningStrategy<KtWhenEntry>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtWhenEntry element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement2 = element.getElseKeyword();
                if (psiElement2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(psiElement2, "element.getElseKeyword()!!");
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        WHEN_EXPRESSION = new PositioningStrategy<KtWhenExpression>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtWhenExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement2 = element.getWhenKeyword();
                Intrinsics.checkExpressionValueIsNotNull(psiElement2, "element.getWhenKeyword()");
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        WHEN_CONDITION_IN_RANGE = new PositioningStrategy<KtWhenConditionInRange>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtWhenConditionInRange element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement2 = element.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull(psiElement2, "element.getOperationReference()");
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        NULLABLE_TYPE = new PositioningStrategy<KtNullableType>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtNullableType element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                ASTNode aSTNode = element.getQuestionMarkNode();
                Intrinsics.checkExpressionValueIsNotNull(aSTNode, "element.getQuestionMarkNode()");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        CALL_EXPRESSION = new PositioningStrategy<PsiElement>(){

            @NotNull
            protected List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof KtCallExpression) {
                    KtTypeArgumentList ktTypeArgumentList = ((KtCallExpression)element).getTypeArgumentList();
                    PsiElement psiElement2 = ktTypeArgumentList != null ? (PsiElement)ktTypeArgumentList : (PsiElement)((KtCallExpression)element).getCalleeExpression();
                    if (psiElement2 == null) {
                        psiElement2 = element;
                    }
                    return PositioningStrategyKt.markRange(element, psiElement2);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        VALUE_ARGUMENTS = new PositioningStrategy<KtElement>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtElement element) {
                PsiElement psiElement2;
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtElement ktElement = element;
                if (!(ktElement instanceof KtValueArgumentList)) {
                    ktElement = null;
                }
                if ((psiElement2 = (KtValueArgumentList)ktElement) == null || (psiElement2 = psiElement2.getRightParenthesis()) == null) {
                    psiElement2 = element;
                }
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        FUNCTION_PARAMETERS = new PositioningStrategy<KtFunction>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtFunction element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtParameterList valueParameterList = element.getValueParameterList();
                if (valueParameterList != null) {
                    return PositioningStrategyKt.markElement(valueParameterList);
                }
                if (element instanceof KtFunctionLiteral) {
                    ASTNode aSTNode = ((KtFunctionLiteral)element).getLBrace().getNode();
                    Intrinsics.checkExpressionValueIsNotNull(aSTNode, "element.getLBrace().getNode()");
                    return PositioningStrategyKt.markNode(aSTNode);
                }
                return PositioningStrategies.DECLARATION_SIGNATURE_OR_DEFAULT.mark(element);
            }
        };
        CUT_CHAR_QUOTES = new PositioningStrategy<KtElement>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof KtConstantExpression && Intrinsics.areEqual(((KtConstantExpression)element).getNode().getElementType(), KtNodeTypes.CHARACTER_CONSTANT)) {
                    TextRange elementTextRange = ((KtConstantExpression)element).getTextRange();
                    return CollectionsKt.listOf(TextRange.create(elementTextRange.getStartOffset() + 1, elementTextRange.getEndOffset() - 1));
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        LONG_LITERAL_SUFFIX = new PositioningStrategy<KtElement>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof KtConstantExpression && Intrinsics.areEqual(((KtConstantExpression)element).getNode().getElementType(), KtNodeTypes.INTEGER_CONSTANT)) {
                    int endOffset = PsiUtilsKt.getEndOffset(element);
                    return CollectionsKt.listOf(TextRange.create(endOffset - 1, endOffset));
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        UNREACHABLE_CODE = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> markDiagnostic(@NotNull ParametrizedDiagnostic<? extends PsiElement> diagnostic) {
                Intrinsics.checkParameterIsNotNull(diagnostic, "diagnostic");
                List list = (List)((DiagnosticWithParameters1)Errors.UNREACHABLE_CODE.cast(diagnostic)).getA();
                Intrinsics.checkExpressionValueIsNotNull(list, "Errors.UNREACHABLE_CODE.cast(diagnostic).getA()");
                return list;
            }
        };
        AS_TYPE = new PositioningStrategy<KtBinaryExpressionWithTypeRHS>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtBinaryExpressionWithTypeRHS element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement2 = element.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull(psiElement2, "element.getOperationReference()");
                return PositioningStrategyKt.markRange(psiElement2, element);
            }
        };
        COMPANION_OBJECT = new PositioningStrategy<KtObjectDeclaration>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtObjectDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element.hasModifier(KtTokens.COMPANION_KEYWORD)) {
                    KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
                    KtModifierKeywordToken ktModifierKeywordToken = KtTokens.COMPANION_KEYWORD;
                    Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken, "KtTokens.COMPANION_KEYWORD");
                    ktModifierKeywordTokenArray[0] = ktModifierKeywordToken;
                    return PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray).mark((KtModifierListOwner)((PsiElement)element));
                }
                return PositioningStrategies.DEFAULT.mark(element);
            }
        };
        SECONDARY_CONSTRUCTOR_DELEGATION_CALL = new PositioningStrategy<KtConstructorDelegationCall>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtConstructorDelegationCall element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element.isImplicit()) {
                    PsiElement $receiver = element;
                    KtSecondaryConstructor ktSecondaryConstructor = PsiTreeUtil.getParentOfType($receiver, KtSecondaryConstructor.class, true);
                    if (ktSecondaryConstructor == null) {
                        Intrinsics.throwNpe();
                    }
                    KtSecondaryConstructor constructor = ktSecondaryConstructor;
                    KtParameterList ktParameterList = constructor.getValueParameterList();
                    if (ktParameterList == null) {
                        return PositioningStrategyKt.markElement(constructor);
                    }
                    KtParameterList valueParameterList = ktParameterList;
                    PsiElement psiElement2 = constructor.getConstructorKeyword();
                    Intrinsics.checkExpressionValueIsNotNull(psiElement2, "constructor.getConstructorKeyword()");
                    PsiElement psiElement3 = valueParameterList.getLastChild();
                    Intrinsics.checkExpressionValueIsNotNull(psiElement3, "valueParameterList.getLastChild()");
                    return PositioningStrategyKt.markRange(psiElement2, psiElement3);
                }
                KtConstructorDelegationReferenceExpression ktConstructorDelegationReferenceExpression = element.getCalleeExpression();
                return PositioningStrategyKt.markElement(ktConstructorDelegationReferenceExpression != null ? (PsiElement)ktConstructorDelegationReferenceExpression : (PsiElement)element);
            }
        };
        DELEGATOR_SUPER_CALL = new PositioningStrategy<KtEnumEntry>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtEnumEntry element) {
                KtElementImplStub ktElementImplStub;
                Intrinsics.checkParameterIsNotNull(element, "element");
                List<KtDelegationSpecifier> specifiers = element.getDelegationSpecifiers();
                if (specifiers.isEmpty()) {
                    ktElementImplStub = element;
                } else {
                    KtElementImplStub ktElementImplStub2 = specifiers.get(0);
                    ktElementImplStub = ktElementImplStub2;
                    Intrinsics.checkExpressionValueIsNotNull(ktElementImplStub2, "specifiers[0]");
                }
                return PositioningStrategyKt.markElement(ktElementImplStub);
            }
        };
        UNUSED_VALUE = new PositioningStrategy<KtBinaryExpression>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtBinaryExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtExpression ktExpression = element.getLeft();
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                return CollectionsKt.listOf(new TextRange(PsiUtilsKt.getStartOffset(ktExpression), PsiUtilsKt.getEndOffset(element.getOperationReference())));
            }
        };
        USELESS_ELVIS = new PositioningStrategy<KtBinaryExpression>(){

            @NotNull
            protected List<TextRange> mark(@NotNull KtBinaryExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return CollectionsKt.listOf(new TextRange(PsiUtilsKt.getStartOffset(element.getOperationReference()), PsiUtilsKt.getEndOffset(element)));
            }
        };
        IMPORT_ALIAS = new PositioningStrategy<KtImportDirective>(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            protected List<TextRange> mark(@NotNull KtImportDirective element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                ASTNode aSTNode = element.getAliasNameNode();
                if (aSTNode != null) {
                    ASTNode it2;
                    ASTNode $receiver = aSTNode;
                    ASTNode aSTNode2 = it2 = $receiver;
                    Intrinsics.checkExpressionValueIsNotNull(aSTNode2, "it");
                    return PositioningStrategyKt.markNode(aSTNode2);
                }
                KtExpression ktExpression = element.getImportedReference();
                if (ktExpression != null) {
                    KtExpression $receiver = ktExpression;
                    KtExpression it3 = $receiver;
                    if (it3 instanceof KtQualifiedExpression) {
                        KtExpression ktExpression2 = ((KtQualifiedExpression)it3).getSelectorExpression();
                        if (ktExpression2 != null) {
                            void $receiver2;
                            KtExpression $i$a$1 = ktExpression2;
                            KtExpression it4 = (KtExpression)$receiver2;
                            PsiElement psiElement2 = it4;
                            Intrinsics.checkExpressionValueIsNotNull(psiElement2, "it");
                            return PositioningStrategyKt.markElement(psiElement2);
                        }
                    }
                    PsiElement psiElement3 = it3;
                    Intrinsics.checkExpressionValueIsNotNull(psiElement3, "it");
                    return PositioningStrategyKt.markElement(psiElement3);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001b\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u0017)\u0011\u0001B\u0001\u0005\u00131\u0001Q\u0003\u0002\u0003\u0001\u0011\u0003)\u0012\u0001G\u0001\u001a\t%\u0011\u0011\"\u0001S\u00011\u0007\t+!U\u0002\u0002\u0011\t)+\u0002B\u0006\t\u00065\t\u0001dA\r\u0004\u0011\u000fi\u0011\u0001\b\u0001R\u0007\u0005AA\u0001"}, strings={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$DeclarationHeader;", "T", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "()V", "isValid", "", "element", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)Z"}, moduleName="kotlin-compiler")
    private static class DeclarationHeader<T extends KtDeclaration>
    extends PositioningStrategy<T> {
        @Override
        public boolean isValid(@NotNull T element) {
            Intrinsics.checkParameterIsNotNull(element, "element");
            if (element instanceof KtNamedDeclaration && !(element instanceof KtObjectDeclaration) && !(element instanceof KtSecondaryConstructor) && !(element instanceof KtFunction) && ((KtNamedDeclaration)element).getNameIdentifier() == null) {
                return false;
            }
            return super.isValid((PsiElement)element);
        }
    }
}

