/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.IntProgression;
import kotlin.RangesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;
import org.jetbrains.kotlin.js.inline.util.JsExpressionVisitor;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsEmpty;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"%\u0015\u0001Q!\u0001\u0005\u0012\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001E\u0006\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\t\u0001\u0002E\u0003\u0002\t\u0005ia\u0003B\u0001\t\u00015!\u0011BA\u0005\u00021\u0005A\n!F\u0001\u0019\u0003eU\u00012A\u0007\b\u0013\tI\u0011\u0001G\u0001\n\u0005%\t\u0001T\u0001\r\u0003!\u000e\u0005AkA\u0002\u000e\u0016\u0011\t\u0001rA\u0007\u00021\u0011)B!\u0003\u0002\n\u0003a!\u0001\u0014\u0002+\u0004\u00075\u0019B!\u0001\u0005\u0006\u001b\u0011I!!C\u0001\u0019\u0003a\u0005Q#\u0001\r\u00023\u001fAY!\u0004\u0003\n\u0005%\t\u0001$\u0001M\u0001!\u000e\u0005AkA\u0002"}, strings={"match", "", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNode;", "predicate", "Lkotlin/Function1;", "", "ExpressionDecomposerKt", "toStatement", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsStatement;", "", "withParentsOfNodes", "nodes"}, moduleName="kotlin-compiler")
public final class ExpressionDecomposerKt {
    private static final Set<JsNode> match(JsNode $receiver, Function1<? super JsNode, ? extends Boolean> predicate) {
        JsExpressionVisitor visitor2 = new JsExpressionVisitor(predicate){
            @NotNull
            private final Set<JsNode> matched;
            final /* synthetic */ Function1 $predicate;

            @NotNull
            public final Set<JsNode> getMatched() {
                return this.matched;
            }

            protected <R extends JsNode> void doTraverse(@NotNull R node, @Nullable JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(node, "node");
                super.doTraverse(node, ctx);
                if (this.matched.contains(node) ^ true && ((Boolean)this.$predicate.invoke(node)).booleanValue()) {
                    this.matched.add(node);
                }
            }
            {
                this.$predicate = $captured_local_variable$0;
                this.matched = CollectionUtilsKt.IdentitySet();
            }
        };
        visitor2.accept($receiver);
        return visitor2.getMatched();
    }

    private static final Set<JsNode> withParentsOfNodes(JsNode $receiver, Set<? extends JsNode> nodes) {
        JsExpressionVisitor visitor2 = new JsExpressionVisitor(nodes){
            private final SmartList<JsNode> stack;
            @NotNull
            private final Set<JsNode> matched;
            final /* synthetic */ Set $nodes;

            @NotNull
            public final Set<JsNode> getMatched() {
                return this.matched;
            }

            protected <R extends JsNode> void doTraverse(@NotNull R node, @Nullable JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(node, "node");
                this.stack.add(node);
                super.doTraverse(node, ctx);
                if (this.$nodes.contains(node)) {
                    this.addAllUntilMatchedOrStatement((List<? extends JsNode>)this.stack);
                }
                CollectionsKt.remove(this.stack, CollectionsKt.getLastIndex((List)this.stack));
            }

            /*
             * WARNING - void declaration
             */
            public final void addAllUntilMatchedOrStatement(@NotNull List<? extends JsNode> nodesOnStack) {
                Intrinsics.checkParameterIsNotNull(nodesOnStack, "nodesOnStack");
                IntProgression intProgression = RangesKt.downTo(CollectionsKt.getLastIndex(nodesOnStack), 0);
                int n = intProgression.getFirst();
                int n2 = intProgression.getLast();
                int n3 = intProgression.getStep();
                int n4 = n;
                int n5 = n2;
                if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
                    void i;
                    JsNode currentNode;
                    while (!this.matched.contains(currentNode = nodesOnStack.get((int)i))) {
                        this.matched.add(currentNode);
                        if (currentNode instanceof JsStatement || i == n2) break;
                        n = i + n3;
                    }
                }
            }
            {
                this.$nodes = $captured_local_variable$0;
                this.stack = new SmartList<E>();
                this.matched = CollectionUtilsKt.IdentitySet();
            }
        };
        visitor2.accept($receiver);
        return visitor2.getMatched();
    }

    private static final JsStatement toStatement(List<? extends JsStatement> $receiver) {
        JsStatement jsStatement;
        Collection $receiver2 = $receiver;
        switch ($receiver2.size()) {
            case 0: {
                jsStatement = JsEmpty.INSTANCE;
                break;
            }
            case 1: {
                jsStatement = $receiver.get(0);
                break;
            }
            default: {
                jsStatement = new JsBlock($receiver);
            }
        }
        return jsStatement;
    }

    @NotNull
    public static final /* synthetic */ Set access$match(JsNode $receiver, @NotNull Function1 predicate) {
        return ExpressionDecomposerKt.match($receiver, predicate);
    }

    @NotNull
    public static final /* synthetic */ Set access$withParentsOfNodes(JsNode $receiver, @NotNull Set nodes) {
        return ExpressionDecomposerKt.withParentsOfNodes($receiver, nodes);
    }

    @NotNull
    public static final /* synthetic */ JsStatement access$toStatement(List $receiver) {
        return ExpressionDecomposerKt.toStatement($receiver);
    }
}

