/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.util.SmartList;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.IndexedValue;
import kotlin.IntRange;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.resolve.AllUnderImportsScope;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.FunctionImportedFromObject;
import org.jetbrains.kotlin.resolve.PackageFragmentWithCustomSource;
import org.jetbrains.kotlin.resolve.PropertyImportedFromObject;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.SingleImportScope;
import org.jetbrains.kotlin.resolve.calls.CallExpressionElement;
import org.jetbrains.kotlin.resolve.calls.CallExpressionUnrollerKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.PackageQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"Q\u0004)\u0011\u0001D\u0001\u0006\u0003!\u0001Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u0003!-Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\u0002E\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\t\t\u0015\tAAA\u0003\u0002\u0011=)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001\u0003\u0003\u0019\u0001I\u0012\u0001'\u0001\u001e\u0004!F\u0013&)\u0004\n\u0007!\tQ\"\u0001M\u0002#\u000e\t\u0001BA\u0013\u0010\t\u0005Aa!\u0004\u0003\n\u0005%\t\u0001d\u0002M\u00073\rAy!D\u0001\u0019\u0011e\u0019\u0001\u0012C\u0007\u00021\u001d)c\u0002B\u0001\t\u00135!\u0011BA\u0005\u00021!A\u001a\"\u0007\u0004\t\u00155!\u0011BA\u0005\u00021+A\u001a\"J\t\u0005\u0003!YQ\"\u0001\r\u00053\rA9\"D\u0001\u0019\u000fe!\u0001\u0002D\u0007\u0003\u0019\u0003Ar!G\u0002\t\u001a5\t\u0001$D\u0013\u0016\u00117i!\u0001$\u0001\u0019\u001de\u0019\u0001RD\u0007\u00021=I2\u0001c\b\u000e\u0003a\u0001\u0012d\u0001E\u0011\u001b\u0005A\u0012#\u0007\u0003\t$5\u0011A\u0012\u0001\r\u0013K\u0005\"\u0011\u0001#\n\u000e\u00051\u0005\u0001dE\r\u0004\u0011?i\u0011\u0001\u0007\t\u001a\u0007!\u0005R\"\u0001\r\u00123\rAi\"D\u0001\u0019\u001fe1\u0001rE\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0005\u0019\u0014e\u0019\u0001rB\u0007\u00021!IB\u0001c\t\u000e\u00051\u0005\u0001DE\u0013\u0018\t\u0005AA#D\u0001\u0019*e1\u0001rE\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0005\u0019\u0014e\u0019\u0001\"F\u0007\u00021WI2\u0001#\t\u000e\u0003a\t\u0012d\u0001E\r\u001b\u0005AR\"J\b\t-5\t\u0001TF\r\u0004\u0011]i\u0011\u0001'\u0003\u001a\u0007!=R\"\u0001\r\u00193\rA\t#D\u0001\u0019#\u0015\u0002\u0002\u0012G\u0007\u0003\u0019\u0003A\u0012$G\u0002\t45\t\u0001DG\r\u0004\u0011ki\u0011\u0001G\u000e\u001a\u0007!]R\"\u0001\r\u001dK=AI$D\u0001\u0019*e\u0019\u0001\"H\u0007\u00021wI2\u0001\u0003\u0010\u000e\u0003a\u0001\u0012d\u0001E\u0011\u001b\u0005A\u0012#\n\r\t>5!\u0011BA\u0005\u00021}A\u001a\"G\u0002\t45\t\u0001TC\r\u0004\u0011oi\u0011\u0001\u0007\u000f\u001a\u0013!}RbB\u0005\u0003\u0013\u0005A\"$\u0003\u0002\n\u0003a!\u0001\u0004I\u0013#\t\u0005A\t%\u0004\u0002\r\u0002a9\u0011D\u0002E\u0014\u001b\u0011I!!C\u0001\u0019\u0011aM\u0011d\u0001E\u0010\u001b\u0005A\u0002#G\u0002\t\"5\t\u0001$E\r\u0005\u00111i!\u0001$\u0001\u0019\u000fe!\u0001\"I\u0007\u0003\u0019\u0003A\u0002$G\u0002\t\u001a5\t\u0001$D\u00135\t\u0005A\u0019%\u0004\u0005\n\u0007%\u0011A\u0012\u0001\r\b\u0013\tI\u0011\u0001'\u0012\u0019Ee1\u0001rE\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0005\u0019\u0014e\u0019\u0001rD\u0007\u00021AI2\u0001#\t\u000e\u0003a\t\u0012\u0004\u0002\u0005\r\u001b\ta\t\u0001G\u0004\u001a\t!\tSB\u0001G\u00011aI2\u0001#\u0007\u000e\u0003ai\u0011d\u0003\u0003\u0002\u0011\u007fi\u0001\"\u0003\u0002\n\u0003aQ\u0012BA\u0005\u00021\u0011a\t\u0001\u0007\u0011&#\u0011\t\u0001bI\u0007\u0003\u0019\u0003A\u0012$G\u0002\t\"5\t\u0001$E\r\u0004\u0011\u000fj\u0011\u0001\u0007\u000e\u001a\u0007!]Q\"\u0001\r\bK\u0005\"\u0011\u0001\u0003\u0013\u000e\u0003a%\u0012d\u0001E\u0011\u001b\u0005A\u0012#G\u0002\tH5\t\u0001DG\r\u0007\u0011\u0013jA!\u0003\u0002\n\u0003a9\u0001$J\r\u0005\u00111i!\u0001$\u0001\u0019\u000fe\u0019\u0001\u0012D\u0007\u000215IB\u0001B\u0001\tL5\t\u0001\u0004B\u0013!\t\u0005AA%\u0004\u0002\r\u0002aI\u0012d\u0001E\u0011\u001b\u0005A\u0012#G\u0002\tH5\t\u0001DG\r\u0005\u0011/i!\u0001$\u0001\u0019\u000fe!\u0001\u0002D\u0007\u0003\u0019\u0003Ar!G\u0002\t\u001a5\t\u0001$D\r\u0005\t\u0005AY%D\u0001\u0019\t\u0015\"B!\u0001\u0005'\u001b\u0005AJ#G\u0002\t\"5\t\u0001$E\r\u0004\u0011?i\u0011\u0001\u0007\t\u001a\u0007!EQ\"\u0001\r\b3\rAy!D\u0001\u0019\u0011\u0015vA!\u0001E'\u001b\u0011I!!C\u0001\u0019\u0011aMQ#\u0001\r(3\u0013A\t#D\u0001\u0019#A\u001b\t!J\b\u0005\u0003!5SBC\u0005\u0006\u0013\u0011I!!C\u0001\u0019\u0011aM\u0011BA\u0005\u00021\u0011A\"%F\u0001\u0019\n\u0015~B!\u0001E(\u001b\u001dI!!C\u0001\u0019,%\u0011\u0011\"\u0001M#1\t*\u0012\u0001\u0007\t\u001a\u0010!\u001dR\u0002B\u0005\u0003\u0013\u0005A\u0002\u0002g\u0005Q\u0007\u0003IJ\u0001#\t\u000e\u0003a\t\u0002kA\u0001\u001a\n!eQ\"\u0001\r\u000e!\u000e\r\u0011F\u0003\u0003D\u0011!\tQ\"\u0001M\u0002#\u000e!Q\u0001A\u0007\u0003\t\u000bA1!\u000b\u0007\u0005\u0003\"A9!D\u0001\u0019\tU\t\u0001\u0014\u0002\u000f\"#\u000e\u0019QB\u0001\u0003\u0006\u0011\u0017\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "", "symbolUsageValidator", "Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;", "(Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;)V", "getSymbolUsageValidator", "()Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;", "startWithPackage", "", "Lorg/jetbrains/kotlin/psi/KtUserType;", "getStartWithPackage", "(Lorg/jetbrains/kotlin/psi/KtUserType;)Z", "collectCandidateDescriptors", "Lcom/intellij/util/SmartList;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "lastPart", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifierPart;", "packageOrClassDescriptor", "getMaxPossibleQualifierPrefix", "", "qualifiedExpressions", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "isVisible", "descriptor", "shouldBeVisibleFrom", "position", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifierPosition;", "processImportReference", "Lorg/jetbrains/kotlin/resolve/scopes/ImportingScope;", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "packageFragmentForVisibilityCheck", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "processSingleImport", "Lorg/jetbrains/kotlin/resolve/SingleImportScope;", "path", "recordPackageViews", "", "packageView", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "resolveDescriptorForType", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$TypeQualifierResolutionResult;", "userType", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "resolveNameExpressionAsQualifierForDiagnostics", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Qualifier;", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "resolvePackageHeader", "packageDirective", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "module", "resolveQualifierInExpressionAndUnroll", "Lorg/jetbrains/kotlin/resolve/calls/CallExpressionElement;", "isValue", "Lkotlin/Function1;", "resolveToPackageOrClass", "scopeForFirstPart", "resolveToPackageOrClassPrefix", "Lkotlin/Pair;", "", "storeQualifier", "referenceExpression", "storeResult", "descriptors", "", "isQualifier", "tryResolveDescriptorsWhichCannotBeImported", "asQualifierPartList", "Lorg/jetbrains/kotlin/psi/KtExpression;", "quickResolveToPackage", "QualifierPart", "QualifierPosition", "TypeQualifierResolutionResult"}, moduleName="kotlin-compiler")
public final class QualifiedExpressionResolver {
    @NotNull
    private final SymbolUsageValidator symbolUsageValidator;

    public final void resolvePackageHeader(@NotNull KtPackageDirective packageDirective, @NotNull ModuleDescriptor module2, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(packageDirective, "packageDirective");
        Intrinsics.checkParameterIsNotNull(module2, "module");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        List<KtSimpleNameExpression> packageNames = packageDirective.getPackageNames();
        for (IndexedValue indexedValue : kotlin.CollectionsKt.withIndex((Iterable)packageNames)) {
            KtSimpleNameExpression nameExpression;
            int index2 = indexedValue.component1();
            KtSimpleNameExpression ktSimpleNameExpression = nameExpression = (KtSimpleNameExpression)indexedValue.component2();
            Intrinsics.checkExpressionValueIsNotNull(ktSimpleNameExpression, "nameExpression");
            FqName fqName2 = packageDirective.getFqName(nameExpression);
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "packageDirective.getFqName(nameExpression)");
            this.storeResult(trace, ktSimpleNameExpression, module2.getPackage(fqName2), (DeclarationDescriptor)null, QualifierPosition.PACKAGE_HEADER, index2 != kotlin.CollectionsKt.getLastIndex(packageNames));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeQualifierResolutionResult resolveDescriptorForType(@NotNull KtUserType userType, @NotNull LexicalScope scope2, @NotNull BindingTrace trace) {
        void $receiver;
        Unit unit;
        void $receiver22;
        Object descriptor2;
        void qualifierPartList;
        void hasError;
        Intrinsics.checkParameterIsNotNull(userType, "userType");
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        if (userType.getQualifier() == null && !this.getStartWithPackage(userType)) {
            ClassifierDescriptor classifierDescriptor;
            KtSimpleNameExpression ktSimpleNameExpression = userType.getReferenceExpression();
            if (ktSimpleNameExpression != null) {
                void $receiver3;
                KtSimpleNameExpression ktSimpleNameExpression2 = ktSimpleNameExpression;
                KtSimpleNameExpression it2 = (KtSimpleNameExpression)$receiver3;
                HierarchicalScope hierarchicalScope = scope2;
                Name name = it2.getReferencedNameAsName();
                KtElement ktElement = it2;
                Intrinsics.checkExpressionValueIsNotNull(ktElement, "it");
                ClassifierDescriptor classifier2 = ScopeUtilsKt.findClassifier(hierarchicalScope, name, new KotlinLookupLocation(ktElement));
                KtSimpleNameExpression ktSimpleNameExpression3 = it2;
                Intrinsics.checkExpressionValueIsNotNull(ktSimpleNameExpression3, "it");
                this.storeResult(trace, ktSimpleNameExpression3, classifier2, scope2.getOwnerDescriptor(), QualifierPosition.TYPE, false);
                classifierDescriptor = classifier2;
            } else {
                classifierDescriptor = null;
            }
            ClassifierDescriptor descriptor3 = classifierDescriptor;
            return new TypeQualifierResolutionResult(this.asQualifierPartList(userType).getFirst(), descriptor3);
        }
        ModuleDescriptor module2 = DescriptorUtilsKt.getModule(scope2.getOwnerDescriptor());
        Pair<List<? extends QualifierPart>, Boolean> classifier2 = this.asQualifierPartList(userType);
        List<? extends QualifierPart> $receiver3 = classifier2.component1();
        boolean it2 = classifier2.component2();
        classifier2 = null;
        if (hasError != false) {
            DeclarationDescriptor declarationDescriptor = this.resolveToPackageOrClass((List<? extends QualifierPart>)qualifierPartList, module2, trace, scope2.getOwnerDescriptor(), scope2, QualifierPosition.TYPE);
            if (!(declarationDescriptor instanceof ClassifierDescriptor)) {
                declarationDescriptor = null;
            }
            descriptor2 = (ClassifierDescriptor)declarationDescriptor;
            return new TypeQualifierResolutionResult((List<? extends QualifierPart>)qualifierPartList, (ClassifierDescriptor)descriptor2);
        }
        descriptor2 = (Collection)qualifierPartList;
        boolean $receiver22 = $receiver22.size() >= 1;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            void value;
            if (value == false) {
                String message = "Too short qualifier list for user type " + userType + " : " + kotlin.CollectionsKt.joinToString$default((Iterable)qualifierPartList, null, null, null, 0, null, null, 63);
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        Collection $i$a$1 = (Collection)qualifierPartList;
        int n = 0;
        void var11_18 = qualifierPartList;
        QualifiedExpressionResolver qualifiedExpressionResolver = this;
        int n2 = $receiver.size();
        DeclarationDescriptor declarationDescriptor = qualifiedExpressionResolver.resolveToPackageOrClass(var11_18.subList(n, n2 - 1), module2, trace, scope2.getOwnerDescriptor(), AddToStdlibKt.check(scope2, (Function1)new Function1<LexicalScope, Boolean>(this, userType){
            final /* synthetic */ QualifiedExpressionResolver this$0;
            final /* synthetic */ KtUserType $userType;

            public final boolean invoke(@NotNull LexicalScope it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                return !QualifiedExpressionResolver.access$getStartWithPackage$p(this.this$0, this.$userType);
            }
            {
                this.this$0 = qualifiedExpressionResolver;
                this.$userType = ktUserType;
                super(1);
            }
        }), QualifierPosition.TYPE);
        if (declarationDescriptor == null) {
            return new TypeQualifierResolutionResult((List<? extends QualifierPart>)qualifierPartList, null);
        }
        DeclarationDescriptor qualifier2 = declarationDescriptor;
        QualifierPart lastPart = (QualifierPart)kotlin.CollectionsKt.last(qualifierPartList);
        DeclarationDescriptor declarationDescriptor2 = qualifier2;
        ClassifierDescriptor classifier3 = declarationDescriptor2 instanceof PackageViewDescriptor ? ((PackageViewDescriptor)qualifier2).getMemberScope().getContributedClassifier(lastPart.getName(), lastPart.getLocation()) : (declarationDescriptor2 instanceof ClassDescriptor ? ((ClassDescriptor)qualifier2).getUnsubstitutedInnerClassesScope().getContributedClassifier(lastPart.getName(), lastPart.getLocation()) : (ClassifierDescriptor)null);
        this.storeResult(trace, lastPart.getExpression(), classifier3, scope2.getOwnerDescriptor(), QualifierPosition.TYPE, false);
        return new TypeQualifierResolutionResult((List<? extends QualifierPart>)qualifierPartList, classifier3);
    }

    private final boolean getStartWithPackage(KtUserType $receiver) {
        KtUserType firstPart = $receiver;
        while (firstPart.getQualifier() != null) {
            if (firstPart.getQualifier() != null) continue;
            Intrinsics.throwNpe();
        }
        return firstPart.isAbsoluteInRootPackage();
    }

    private final Pair<List<? extends QualifierPart>, Boolean> asQualifierPartList(KtUserType $receiver) {
        boolean hasError = false;
        SmartList<QualifierPart> result2 = new SmartList<QualifierPart>();
        for (KtUserType userType = $receiver; userType != null; userType = userType.getQualifier()) {
            KtSimpleNameExpression referenceExpression = userType.getReferenceExpression();
            if (referenceExpression != null) {
                result2.add(new QualifierPart(referenceExpression.getReferencedNameAsName(), referenceExpression, userType.getTypeArgumentList()));
                continue;
            }
            hasError = true;
        }
        return TuplesKt.to(kotlin.CollectionsKt.asReversedMutable((List)result2), hasError);
    }

    @Nullable
    public final ImportingScope processImportReference(@NotNull KtImportDirective importDirective, @NotNull ModuleDescriptor moduleDescriptor, @NotNull BindingTrace trace, @Nullable PackageFragmentDescriptor packageFragmentForVisibilityCheck) {
        PackageFragmentDescriptor packageFragmentForCheck;
        PackageFragmentDescriptor packageFragmentDescriptor;
        Intrinsics.checkParameterIsNotNull(importDirective, "importDirective");
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        KtExpression ktExpression = importDirective.getImportedReference();
        if (ktExpression == null) {
            return null;
        }
        KtExpression importedReference = ktExpression;
        List<QualifierPart> path = this.asQualifierPartList(importedReference, trace);
        QualifierPart qualifierPart = kotlin.CollectionsKt.lastOrNull(path);
        if (qualifierPart == null) {
            return null;
        }
        QualifierPart lastPart = qualifierPart;
        if (packageFragmentForVisibilityCheck instanceof DeclarationDescriptorWithSource && Intrinsics.areEqual(packageFragmentForVisibilityCheck.getSource(), SourceElement.NO_SOURCE)) {
            KtElement ktElement = importDirective.getContainingKtFile();
            Intrinsics.checkExpressionValueIsNotNull(ktElement, "importDirective.getContainingKtFile()");
            packageFragmentDescriptor = new PackageFragmentWithCustomSource(packageFragmentForVisibilityCheck, new KotlinSourceElement(ktElement));
        } else {
            packageFragmentDescriptor = packageFragmentForCheck = packageFragmentForVisibilityCheck;
        }
        if (!importDirective.isAllUnder()) {
            return this.processSingleImport(moduleDescriptor, trace, importDirective, path, lastPart, packageFragmentForCheck);
        }
        DeclarationDescriptor declarationDescriptor = this.resolveToPackageOrClass(path, moduleDescriptor, trace, packageFragmentForCheck, null, QualifierPosition.IMPORT);
        if (declarationDescriptor == null) {
            return null;
        }
        DeclarationDescriptor packageOrClassDescriptor = declarationDescriptor;
        if (packageOrClassDescriptor instanceof ClassDescriptor && ((ClassDescriptor)packageOrClassDescriptor).getKind().isSingleton()) {
            trace.report(Errors.CANNOT_ALL_UNDER_IMPORT_FROM_SINGLETON.on((KtSimpleNameExpression)((PsiElement)lastPart.getExpression()), (ClassDescriptor)packageOrClassDescriptor));
        }
        return new AllUnderImportsScope(packageOrClassDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    private final SingleImportScope processSingleImport(ModuleDescriptor moduleDescriptor, BindingTrace trace, KtImportDirective importDirective, List<? extends QualifierPart> path, QualifierPart lastPart, PackageFragmentDescriptor packageFragmentForVisibilityCheck) {
        void destination;
        void $receiver;
        void $receiver2;
        void $receiver3;
        Name aliasName = KtPsiUtil.getAliasName(importDirective);
        if (aliasName == null) {
            this.resolveToPackageOrClass(path, moduleDescriptor, trace, packageFragmentForVisibilityCheck, null, QualifierPosition.IMPORT);
            return null;
        }
        Collection collection = path;
        int n = 0;
        List<? extends QualifierPart> list = path;
        QualifiedExpressionResolver qualifiedExpressionResolver = this;
        int n2 = $receiver3.size();
        DeclarationDescriptor declarationDescriptor = qualifiedExpressionResolver.resolveToPackageOrClass(list.subList(n, n2 - 1), moduleDescriptor, trace, packageFragmentForVisibilityCheck, null, QualifierPosition.IMPORT);
        if (declarationDescriptor == null) {
            return null;
        }
        DeclarationDescriptor packageOrClassDescriptor = declarationDescriptor;
        SmartList<DeclarationDescriptor> candidates = this.collectCandidateDescriptors(lastPart, packageOrClassDescriptor);
        if (!kotlin.CollectionsKt.isNotEmpty((Collection)candidates)) {
            this.tryResolveDescriptorsWhichCannotBeImported(trace, moduleDescriptor, packageOrClassDescriptor, lastPart);
            return null;
        }
        this.storeResult(trace, lastPart.getExpression(), (Collection<? extends DeclarationDescriptor>)candidates, (DeclarationDescriptor)packageFragmentForVisibilityCheck, QualifierPosition.IMPORT, false);
        Iterable iterable = candidates;
        void var15_15 = $receiver2;
        Collection collection2 = new ArrayList();
        for (Object element : $receiver) {
            DeclarationDescriptor it2;
            DeclarationDescriptor declarationDescriptor2 = it2 = (DeclarationDescriptor)element;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "it");
            if (!this.isVisible(declarationDescriptor2, packageFragmentForVisibilityCheck, QualifierPosition.IMPORT)) continue;
            destination.add(element);
        }
        List list2 = AddToStdlibKt.check((List)destination, processSingleImport.importedDescriptors.2.INSTANCE);
        if (list2 == null) {
            list2 = candidates;
        }
        List importedDescriptors2 = list2;
        return new SingleImportScope(aliasName, importedDescriptors2);
    }

    /*
     * WARNING - void declaration
     */
    private final SmartList<DeclarationDescriptor> collectCandidateDescriptors(QualifierPart lastPart, DeclarationDescriptor packageOrClassDescriptor) {
        SmartList<DeclarationDescriptor> descriptors = new SmartList<DeclarationDescriptor>();
        Name lastName = lastPart.getName();
        KotlinLookupLocation location2 = lastPart.getLocation();
        DeclarationDescriptor declarationDescriptor = packageOrClassDescriptor;
        if (declarationDescriptor instanceof PackageViewDescriptor) {
            MemberScope packageScope = ((PackageViewDescriptor)packageOrClassDescriptor).getMemberScope();
            CollectionsKt.addIfNotNull((Collection)descriptors, packageScope.getContributedClassifier(lastName, location2));
            descriptors.addAll(packageScope.getContributedVariables(lastName, location2));
            descriptors.addAll(packageScope.getContributedFunctions(lastName, location2));
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            CollectionsKt.addIfNotNull((Collection)descriptors, ((ClassDescriptor)packageOrClassDescriptor).getUnsubstitutedInnerClassesScope().getContributedClassifier(lastName, location2));
            MemberScope staticClassScope = ((ClassDescriptor)packageOrClassDescriptor).getStaticScope();
            descriptors.addAll(staticClassScope.getContributedFunctions(lastName, location2));
            descriptors.addAll(staticClassScope.getContributedVariables(lastName, location2));
            if (Intrinsics.areEqual((Object)((ClassDescriptor)packageOrClassDescriptor).getKind(), (Object)ClassKind.OBJECT)) {
                Collection destination;
                Iterable $receiver;
                Object object;
                Iterable destination2;
                Iterable $receiver2;
                void $receiver3;
                Iterable iterable = ((ClassDescriptor)packageOrClassDescriptor).getUnsubstitutedMemberScope().getContributedFunctions(lastName, location2);
                Collection<DeclarationDescriptor> collection = descriptors;
                void var10_11 = $receiver3;
                Collection collection2 = new ArrayList(kotlin.CollectionsKt.collectionSizeOrDefault($receiver3, 10));
                for (Object item : $receiver2) {
                    void it2;
                    FunctionDescriptor functionDescriptor = (FunctionDescriptor)item;
                    object = destination2;
                    FunctionImportedFromObject functionImportedFromObject = new FunctionImportedFromObject((FunctionDescriptor)it2);
                    object.add(functionImportedFromObject);
                }
                object = (List)destination2;
                ((AbstractCollection)collection).addAll((Collection)object);
                $receiver2 = ((ClassDescriptor)packageOrClassDescriptor).getUnsubstitutedMemberScope().getContributedVariables(lastName, location2);
                destination2 = $receiver2;
                Collection collection3 = new ArrayList();
                for (Object element : $receiver) {
                    if (!(element instanceof PropertyDescriptor)) continue;
                    destination.add(element);
                }
                $receiver2 = (List)destination;
                $receiver = $receiver2;
                destination = new ArrayList(kotlin.CollectionsKt.collectionSizeOrDefault($receiver2, 10));
                for (Object item : $receiver) {
                    void it3;
                    PropertyDescriptor $i$f$filterIsInstanceTo = (PropertyDescriptor)item;
                    collection = destination;
                    object = new PropertyImportedFromObject((PropertyDescriptor)it3);
                    collection.add((DeclarationDescriptor)object);
                }
                List properties2 = (List)destination;
                descriptors.addAll(properties2);
            }
        } else {
            throw (Throwable)new IllegalStateException("Should be class or package: " + packageOrClassDescriptor);
        }
        return descriptors;
    }

    private final void tryResolveDescriptorsWhichCannotBeImported(BindingTrace trace, ModuleDescriptor moduleDescriptor, DeclarationDescriptor packageOrClassDescriptor, QualifierPart lastPart) {
        SmartList<DeclarationDescriptor> descriptors = new SmartList<DeclarationDescriptor>();
        Name lastName = lastPart.getName();
        DeclarationDescriptor declarationDescriptor = packageOrClassDescriptor;
        if (declarationDescriptor instanceof PackageViewDescriptor) {
            FqName fqName2 = ((PackageViewDescriptor)packageOrClassDescriptor).getFqName().child(lastName);
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "packageOrClassDescriptor.fqName.child(lastName)");
            PackageViewDescriptor packageDescriptor = moduleDescriptor.getPackage(fqName2);
            if (!packageDescriptor.isEmpty()) {
                trace.report(Errors.PACKAGE_CANNOT_BE_IMPORTED.on((KtSimpleNameExpression)((PsiElement)lastPart.getExpression())));
                descriptors.add(packageOrClassDescriptor);
            }
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            MemberScope memberScope2 = ((ClassDescriptor)packageOrClassDescriptor).getUnsubstitutedMemberScope();
            descriptors.addAll(memberScope2.getContributedFunctions(lastName, lastPart.getLocation()));
            descriptors.addAll(memberScope2.getContributedVariables(lastName, lastPart.getLocation()));
            if (kotlin.CollectionsKt.isNotEmpty((Collection)descriptors)) {
                trace.report(Errors.CANNOT_BE_IMPORTED.on((KtSimpleNameExpression)((PsiElement)lastPart.getExpression()), lastName));
            }
        } else {
            throw (Throwable)new IllegalStateException("Should be class or package: " + packageOrClassDescriptor);
        }
        this.storeResult(trace, lastPart.getExpression(), (Collection<? extends DeclarationDescriptor>)descriptors, (DeclarationDescriptor)null, QualifierPosition.IMPORT, false);
    }

    /*
     * WARNING - void declaration
     */
    private final List<QualifierPart> asQualifierPartList(KtExpression $receiver, BindingTrace trace) {
        SmartList<QualifierPart> result2 = new SmartList<QualifierPart>();
        KtExpression expression = $receiver;
        while (expression != null) {
            KtExpression ktExpression = expression;
            if (ktExpression instanceof KtSimpleNameExpression) {
                result2.add(new QualifierPart(((KtSimpleNameExpression)expression).getReferencedNameAsName(), (KtSimpleNameExpression)expression, null, 4, null));
                break;
            }
            if (ktExpression instanceof KtQualifiedExpression) {
                Boolean bl;
                KtExpression ktExpression2 = ((KtQualifiedExpression)expression).getSelectorExpression();
                if (!(ktExpression2 instanceof KtSimpleNameExpression)) {
                    ktExpression2 = null;
                }
                if ((KtSimpleNameExpression)ktExpression2 != null) {
                    void $receiver2;
                    KtSimpleNameExpression it2 = (KtSimpleNameExpression)$receiver2;
                    bl = result2.add(new QualifierPart(it2.getReferencedNameAsName(), it2, null, 4, null));
                } else {
                    bl = null;
                }
                if (!((expression = ((KtQualifiedExpression)expression).getReceiverExpression()) instanceof KtSafeQualifiedExpression)) continue;
                trace.report(Errors.SAFE_CALL_IN_QUALIFIER.on(((KtSafeQualifiedExpression)expression).getOperationTokenNode().getPsi()));
                continue;
            }
            expression = null;
        }
        return kotlin.CollectionsKt.asReversedMutable((List)result2);
    }

    /*
     * WARNING - void declaration
     */
    private final DeclarationDescriptor resolveToPackageOrClass(List<? extends QualifierPart> path, ModuleDescriptor moduleDescriptor, BindingTrace trace, DeclarationDescriptor shouldBeVisibleFrom, LexicalScope scopeForFirstPart, QualifierPosition position) {
        void packageOrClassDescriptor;
        void endIndex;
        Pair pair = QualifiedExpressionResolver.resolveToPackageOrClassPrefix$default(this, path, moduleDescriptor, trace, shouldBeVisibleFrom, scopeForFirstPart, position, null, 64);
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)pair.component1();
        int n = ((Number)pair.component2()).intValue();
        pair = null;
        if (endIndex != path.size()) {
            return null;
        }
        return packageOrClassDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<DeclarationDescriptor, Integer> resolveToPackageOrClassPrefix(List<? extends QualifierPart> path, ModuleDescriptor moduleDescriptor, BindingTrace trace, DeclarationDescriptor shouldBeVisibleFrom, LexicalScope scopeForFirstPart, QualifierPosition position, Function1<? super KtSimpleNameExpression, ? extends Boolean> isValue) {
        void nextIndexAfterPrefix;
        void prefixDescriptor;
        ClassifierDescriptor classifierDescriptor;
        ClassifierDescriptor classifierDescriptor2;
        DeclarationDescriptor $receiver;
        if (path.isEmpty()) {
            FqName fqName2 = FqName.ROOT;
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "FqName.ROOT");
            return new Pair<DeclarationDescriptor, Integer>(moduleDescriptor.getPackage(fqName2), 0);
        }
        QualifierPart firstPart = kotlin.CollectionsKt.first(path);
        if (Intrinsics.areEqual((Object)position, (Object)QualifierPosition.EXPRESSION) && scopeForFirstPart != null && isValue != null && isValue.invoke(firstPart.getExpression()).booleanValue()) {
            return new Pair<Object, Integer>(null, 0);
        }
        LexicalScope lexicalScope = scopeForFirstPart;
        if (lexicalScope != null) {
            LexicalScope lexicalScope2 = lexicalScope;
            LexicalScope it2 = (LexicalScope)((Object)$receiver);
            classifierDescriptor2 = ScopeUtilsKt.findClassifier(it2, firstPart.getName(), firstPart.getLocation());
        } else {
            classifierDescriptor2 = classifierDescriptor = null;
        }
        if (classifierDescriptor != null) {
            QualifiedExpressionResolver.storeResult$default(this, trace, firstPart.getExpression(), classifierDescriptor, shouldBeVisibleFrom, position, false, 32);
        }
        Pair<Object, Integer> $i$a$1 = classifierDescriptor != null ? new Pair<Object, Integer>(classifierDescriptor, 1) : this.quickResolveToPackage(moduleDescriptor, path, trace, position);
        $receiver = (DeclarationDescriptor)$i$a$1.component1();
        int it2 = ((Number)$i$a$1.component2()).intValue();
        $i$a$1 = null;
        DeclarationDescriptor currentDescriptor = prefixDescriptor;
        void $i$f$let = nextIndexAfterPrefix;
        int n = path.size() - 1;
        if ($i$f$let <= n) {
            while (true) {
                DeclarationDescriptor nextPackageOrClassDescriptor;
                DeclarationDescriptor declarationDescriptor;
                void qualifierPartIndex;
                QualifierPart qualifierPart = path.get((int)qualifierPartIndex);
                DeclarationDescriptor declarationDescriptor2 = currentDescriptor;
                if (declarationDescriptor2 instanceof ClassDescriptor) {
                    declarationDescriptor = ((ClassDescriptor)currentDescriptor).getUnsubstitutedInnerClassesScope().getContributedClassifier(qualifierPart.getName(), qualifierPart.getLocation());
                } else if (declarationDescriptor2 instanceof PackageViewDescriptor) {
                    PackageViewDescriptor packageView;
                    PackageViewDescriptor packageViewDescriptor;
                    if (qualifierPart.getTypeArguments() == null) {
                        FqName fqName3 = ((PackageViewDescriptor)currentDescriptor).getFqName().child(qualifierPart.getName());
                        Intrinsics.checkExpressionValueIsNotNull(fqName3, "currentDescriptor.fqName.child(qualifierPart.name)");
                        packageViewDescriptor = moduleDescriptor.getPackage(fqName3);
                    } else {
                        packageViewDescriptor = packageView = (PackageViewDescriptor)null;
                    }
                    declarationDescriptor = packageView != null && !packageView.isEmpty() ? (DeclarationDescriptor)packageView : (DeclarationDescriptor)((PackageViewDescriptor)currentDescriptor).getMemberScope().getContributedClassifier(qualifierPart.getName(), qualifierPart.getLocation());
                } else {
                    declarationDescriptor = nextPackageOrClassDescriptor = (DeclarationDescriptor)null;
                }
                if (!Intrinsics.areEqual((Object)position, (Object)QualifierPosition.EXPRESSION) || nextPackageOrClassDescriptor != null) {
                    QualifiedExpressionResolver.storeResult$default(this, trace, qualifierPart.getExpression(), nextPackageOrClassDescriptor, shouldBeVisibleFrom, position, false, 32);
                }
                if (nextPackageOrClassDescriptor == null) {
                    return new Pair<DeclarationDescriptor, Integer>(currentDescriptor, (int)qualifierPartIndex);
                }
                currentDescriptor = nextPackageOrClassDescriptor;
                if (qualifierPartIndex == n) break;
                ++qualifierPartIndex;
            }
        }
        return new Pair<void, Integer>((void)currentDescriptor, path.size());
    }

    static /* bridge */ /* synthetic */ Pair resolveToPackageOrClassPrefix$default(QualifiedExpressionResolver qualifiedExpressionResolver, List list, ModuleDescriptor moduleDescriptor, BindingTrace bindingTrace, DeclarationDescriptor declarationDescriptor, LexicalScope lexicalScope, QualifierPosition qualifierPosition, Function1 function1, int n) {
        if ((n & 0x40) != 0) {
            function1 = null;
        }
        return qualifiedExpressionResolver.resolveToPackageOrClassPrefix(list, moduleDescriptor, bindingTrace, declarationDescriptor, lexicalScope, qualifierPosition, function1);
    }

    @Nullable
    public final Qualifier resolveNameExpressionAsQualifierForDiagnostics(@NotNull KtSimpleNameExpression expression, @NotNull Receiver receiver, @NotNull ExpressionTypingContext context) {
        DeclarationDescriptor qualifierDescriptor2;
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(receiver, "receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Name name = expression.getReferencedNameAsName();
        if (receiver instanceof PackageQualifier) {
            FqName childPackageFQN = ((PackageQualifier)receiver).getPackageView().getFqName().child(name);
            ModuleDescriptor moduleDescriptor = ((PackageQualifier)receiver).getPackageView().getModule();
            FqName fqName2 = childPackageFQN;
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "childPackageFQN");
            PackageViewDescriptor packageViewDescriptor = AddToStdlibKt.check(moduleDescriptor.getPackage(fqName2), resolveNameExpressionAsQualifierForDiagnostics.qualifierDescriptor.1.INSTANCE);
            declarationDescriptor = packageViewDescriptor != null ? (DeclarationDescriptor)packageViewDescriptor : (DeclarationDescriptor)((PackageQualifier)receiver).getPackageView().getMemberScope().getContributedClassifier(name, new KotlinLookupLocation(expression));
        } else if (receiver instanceof ClassQualifier) {
            declarationDescriptor = ((ClassQualifier)receiver).getScope().getContributedClassifier(name, new KotlinLookupLocation(expression));
        } else if (!receiver.exists()) {
            ClassifierDescriptor classifierDescriptor = ScopeUtilsKt.findClassifier(context.scope, name, new KotlinLookupLocation(expression));
            if (classifierDescriptor != null) {
                declarationDescriptor = classifierDescriptor;
            } else {
                ModuleDescriptor moduleDescriptor = DescriptorUtilsKt.getModule(context.scope.getOwnerDescriptor());
                FqName fqName3 = FqName.ROOT.child(name);
                Intrinsics.checkExpressionValueIsNotNull(fqName3, "FqName.ROOT.child(name)");
                declarationDescriptor = AddToStdlibKt.check(moduleDescriptor.getPackage(fqName3), resolveNameExpressionAsQualifierForDiagnostics.qualifierDescriptor.2.INSTANCE);
            }
        } else {
            declarationDescriptor = qualifierDescriptor2 = receiver instanceof ReceiverValue ? (DeclarationDescriptor)ScopeUtilsKt.findClassifier(ScopeUtilsKt.memberScopeAsImportingScope$default(((ReceiverValue)receiver).getType().getMemberScope(), null, 1), name, new KotlinLookupLocation(expression)) : (DeclarationDescriptor)null;
        }
        if (qualifierDescriptor2 != null) {
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            return QualifiedExpressionResolver.storeResult$default(this, bindingTrace, expression, qualifierDescriptor2, context.scope.getOwnerDescriptor(), QualifierPosition.EXPRESSION, false, 32);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CallExpressionElement> resolveQualifierInExpressionAndUnroll(@NotNull KtQualifiedExpression expression, @NotNull ExpressionTypingContext context, @NotNull Function1<? super KtSimpleNameExpression, ? extends Boolean> isValue) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(isValue, "isValue");
        List<KtQualifiedExpression> qualifiedExpressions = CallExpressionUnrollerKt.unrollToLeftMostQualifiedExpression(expression);
        List<QualifierPart> maxPossibleQualifierPrefix = this.getMaxPossibleQualifierPrefix(qualifiedExpressions);
        ModuleDescriptor moduleDescriptor = DescriptorUtilsKt.getModule(context.scope.getOwnerDescriptor());
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        int nextIndexAfterPrefix = ((Number)this.resolveToPackageOrClassPrefix(maxPossibleQualifierPrefix, moduleDescriptor, bindingTrace, context.scope.getOwnerDescriptor(), context.scope, QualifierPosition.EXPRESSION, isValue).getSecond()).intValue();
        int nextExpressionIndexAfterQualifier = nextIndexAfterPrefix == 0 ? 0 : nextIndexAfterPrefix - 1;
        Iterable iterable = qualifiedExpressions.subList(nextExpressionIndexAfterQualifier, qualifiedExpressions.size());
        void var9_9 = $receiver2;
        Collection collection = new ArrayList(kotlin.CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it2;
            KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)item;
            void var14_14 = destination;
            CallExpressionElement callExpressionElement = new CallExpressionElement((KtQualifiedExpression)it2);
            var14_14.add(callExpressionElement);
        }
        return (List)destination;
    }

    private final List<QualifierPart> getMaxPossibleQualifierPrefix(List<? extends KtQualifiedExpression> qualifiedExpressions) {
        if (qualifiedExpressions.isEmpty()) {
            return kotlin.CollectionsKt.emptyList();
        }
        KtQualifiedExpression first = kotlin.CollectionsKt.first(qualifiedExpressions);
        if (!(first instanceof KtDotQualifiedExpression)) {
            return kotlin.CollectionsKt.emptyList();
        }
        KtExpression firstReceiver = ((KtDotQualifiedExpression)first).getReceiverExpression();
        if (!(firstReceiver instanceof KtSimpleNameExpression)) {
            return kotlin.CollectionsKt.emptyList();
        }
        ArrayList<QualifierPart> qualifierParts = kotlin.CollectionsKt.arrayListOf(new QualifierPart[0]);
        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)firstReceiver;
        Intrinsics.checkExpressionValueIsNotNull(ktSimpleNameExpression, "firstReceiver");
        qualifierParts.add(new QualifierPart(ktSimpleNameExpression));
        for (KtQualifiedExpression ktQualifiedExpression : kotlin.CollectionsKt.dropLast(qualifiedExpressions, 1)) {
            KtExpression selector;
            if (!(ktQualifiedExpression instanceof KtDotQualifiedExpression) || !((selector = ((KtDotQualifiedExpression)ktQualifiedExpression).getSelectorExpression()) instanceof KtSimpleNameExpression)) break;
            qualifierParts.add(new QualifierPart((KtSimpleNameExpression)selector));
        }
        return qualifierParts;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<PackageViewDescriptor, Integer> quickResolveToPackage(ModuleDescriptor $receiver, List<? extends QualifierPart> path, BindingTrace trace, QualifierPosition position) {
        void $receiver2;
        void initial;
        int n;
        int n2;
        block8: {
            int n3;
            void $receiver3;
            List<? extends QualifierPart> list = path;
            IntRange intRange = kotlin.CollectionsKt.getIndices((Collection)$receiver3);
            int n4 = intRange.getFirst();
            if (n4 <= (n3 = intRange.getLast())) {
                while (true) {
                    void index2;
                    QualifierPart it2;
                    if ((it2 = (QualifierPart)$receiver3.get((int)index2)).getTypeArguments() != null) {
                        n2 = index2;
                        break block8;
                    }
                    if (index2 == n3) break;
                    ++index2;
                }
            }
            n2 = -1;
        }
        int $receiver3 = n2;
        int it22 = $receiver3;
        if (it22 == -1) {
            void $receiver4;
            Collection collection = path;
            n = $receiver4.size();
        } else {
            n = it22 + 1;
        }
        int possiblePackagePrefixSize = n;
        Iterable it22 = path.subList(0, possiblePackagePrefixSize);
        FqName $receiver4 = FqName.ROOT;
        FqName accumulator = initial;
        for (Object element : $receiver2) {
            void qualifierPart;
            QualifierPart qualifierPart2 = (QualifierPart)element;
            FqName fqName2 = accumulator;
            accumulator = fqName2.child(qualifierPart.getName());
        }
        FqName fqName3 = accumulator;
        int prefixSize = possiblePackagePrefixSize;
        while (!fqName3.isRoot()) {
            FqName fqName4 = fqName3;
            Intrinsics.checkExpressionValueIsNotNull(fqName4, "fqName");
            PackageViewDescriptor packageDescriptor = $receiver.getPackage(fqName4);
            if (!packageDescriptor.isEmpty()) {
                this.recordPackageViews(path.subList(0, prefixSize), packageDescriptor, trace, position);
                return new Pair<PackageViewDescriptor, Integer>(packageDescriptor, prefixSize);
            }
            fqName3 = fqName3.parent();
            --prefixSize;
        }
        FqName fqName5 = FqName.ROOT;
        Intrinsics.checkExpressionValueIsNotNull(fqName5, "FqName.ROOT");
        return new Pair<PackageViewDescriptor, Integer>($receiver.getPackage(fqName5), 0);
    }

    /*
     * WARNING - void declaration
     */
    private final void recordPackageViews(List<? extends QualifierPart> path, PackageViewDescriptor packageView, BindingTrace trace, QualifierPosition position) {
        void $receiver;
        List<? extends QualifierPart> list = path;
        int index2 = kotlin.CollectionsKt.getLastIndex($receiver);
        PackageViewDescriptor accumulator = packageView;
        while (index2 >= 0) {
            Unit unit;
            void currentView;
            int n = index2--;
            PackageViewDescriptor packageViewDescriptor = accumulator;
            QualifierPart qualifierPart = (QualifierPart)$receiver.get(n);
            QualifiedExpressionResolver.storeResult$default(this, trace, qualifierPart.getExpression(), (DeclarationDescriptor)currentView, null, position, false, 32);
            PackageViewDescriptor parentView = currentView.getContainingDeclaration();
            boolean bl = parentView != null;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value;
                if (value == false) {
                    String message = "Containing Declaration must be not null for package with fqName: " + currentView.getFqName() + ", " + ("path: " + kotlin.CollectionsKt.joinToString$default((Iterable)path, null, null, null, 0, null, null, 63) + ", packageView fqName: " + packageView.getFqName());
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            if (parentView != null) continue;
            Intrinsics.throwNpe();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void storeResult(BindingTrace trace, KtSimpleNameExpression referenceExpression, Collection<? extends DeclarationDescriptor> descriptors, DeclarationDescriptor shouldBeVisibleFrom, QualifierPosition position, boolean isQualifier) {
        void $receiver;
        Collection<? extends DeclarationDescriptor> collection = descriptors;
        if ($receiver.size() > 1) {
            Object descriptor2;
            void destination;
            void $receiver2;
            void $receiver3;
            Iterable $i$f$size = descriptors;
            void var9_9 = $receiver3;
            Collection collection2 = new ArrayList();
            for (Object element : $receiver2) {
                DeclarationDescriptor it2 = (DeclarationDescriptor)element;
                if (!this.isVisible(it2, shouldBeVisibleFrom, position)) continue;
                destination.add(element);
            }
            List visibleDescriptors = (List)destination;
            if (visibleDescriptors.isEmpty()) {
                Object t = kotlin.CollectionsKt.first((Iterable)descriptors);
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility");
                }
                descriptor2 = (DeclarationDescriptorWithVisibility)t;
                trace.report(Errors.INVISIBLE_REFERENCE.on((KtSimpleNameExpression)((PsiElement)referenceExpression), (DeclarationDescriptor)descriptor2, descriptor2.getVisibility(), (DeclarationDescriptor)descriptor2));
            } else {
                descriptor2 = visibleDescriptors;
                if ($receiver3.size() > 1) {
                    trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, referenceExpression, visibleDescriptors);
                } else {
                    this.storeResult(trace, referenceExpression, (DeclarationDescriptor)kotlin.CollectionsKt.single(visibleDescriptors), (DeclarationDescriptor)null, position, isQualifier);
                }
            }
        } else {
            this.storeResult(trace, referenceExpression, (DeclarationDescriptor)kotlin.CollectionsKt.singleOrNull((Iterable)descriptors), shouldBeVisibleFrom, position, isQualifier);
        }
    }

    private final Qualifier storeResult(BindingTrace trace, KtSimpleNameExpression referenceExpression, DeclarationDescriptor descriptor2, DeclarationDescriptor shouldBeVisibleFrom, QualifierPosition position, boolean isQualifier) {
        if (descriptor2 == null) {
            trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)referenceExpression), referenceExpression));
            return null;
        }
        trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, descriptor2);
        if (descriptor2 instanceof ClassifierDescriptor) {
            this.symbolUsageValidator.validateTypeUsage((ClassifierDescriptor)descriptor2, trace, referenceExpression);
        }
        if (descriptor2 instanceof DeclarationDescriptorWithVisibility) {
            DeclarationDescriptor fromToCheck;
            DeclarationDescriptor declarationDescriptor = fromToCheck = shouldBeVisibleFrom instanceof PackageFragmentDescriptor && Intrinsics.areEqual(((PackageFragmentDescriptor)shouldBeVisibleFrom).getSource(), SourceElement.NO_SOURCE) && !(referenceExpression.getContainingFile() instanceof DummyHolder) ? (DeclarationDescriptor)new PackageFragmentWithCustomSource((PackageFragmentDescriptor)shouldBeVisibleFrom, new KotlinSourceElement(referenceExpression.getContainingKtFile())) : shouldBeVisibleFrom;
            if (!this.isVisible(descriptor2, fromToCheck, position)) {
                trace.report(Errors.INVISIBLE_REFERENCE.on((KtSimpleNameExpression)((PsiElement)referenceExpression), descriptor2, ((DeclarationDescriptorWithVisibility)descriptor2).getVisibility(), descriptor2));
            }
        }
        return isQualifier ? this.storeQualifier(trace, referenceExpression, descriptor2) : (Qualifier)null;
    }

    static /* bridge */ /* synthetic */ Qualifier storeResult$default(QualifiedExpressionResolver qualifiedExpressionResolver, BindingTrace bindingTrace, KtSimpleNameExpression ktSimpleNameExpression, DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2, QualifierPosition qualifierPosition, boolean bl, int n) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return qualifiedExpressionResolver.storeResult(bindingTrace, ktSimpleNameExpression, declarationDescriptor, declarationDescriptor2, qualifierPosition, bl);
    }

    private final Qualifier storeQualifier(BindingTrace trace, KtSimpleNameExpression referenceExpression, DeclarationDescriptor descriptor2) {
        QualifierReceiver qualifierReceiver;
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof PackageViewDescriptor) {
            qualifierReceiver = new PackageQualifier(referenceExpression, (PackageViewDescriptor)descriptor2);
        } else if (declarationDescriptor instanceof ClassifierDescriptor) {
            ClassifierDescriptor classifierDescriptor = (ClassifierDescriptor)descriptor2;
            BindingContext bindingContext2 = trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "trace.bindingContext");
            qualifierReceiver = QualifierKt.createClassifierQualifier(referenceExpression, classifierDescriptor, bindingContext2);
        } else {
            return null;
        }
        QualifierReceiver qualifier2 = qualifierReceiver;
        trace.record(BindingContext.QUALIFIER, qualifier2.getExpression(), qualifier2);
        return qualifier2;
    }

    private final boolean isVisible(DeclarationDescriptor descriptor2, DeclarationDescriptor shouldBeVisibleFrom, QualifierPosition position) {
        if (!(descriptor2 instanceof DeclarationDescriptorWithVisibility) || shouldBeVisibleFrom == null) {
            return true;
        }
        Visibility visibility = ((DeclarationDescriptorWithVisibility)descriptor2).getVisibility();
        if (Intrinsics.areEqual((Object)position, (Object)QualifierPosition.IMPORT)) {
            if (Visibilities.isPrivate(visibility)) {
                return false;
            }
            if (!visibility.mustCheckInImports()) {
                return true;
            }
        }
        return Visibilities.isVisible(ReceiverValue.IRRELEVANT_RECEIVER, (DeclarationDescriptorWithVisibility)descriptor2, shouldBeVisibleFrom);
    }

    @NotNull
    public final SymbolUsageValidator getSymbolUsageValidator() {
        return this.symbolUsageValidator;
    }

    public QualifiedExpressionResolver(@NotNull SymbolUsageValidator symbolUsageValidator) {
        Intrinsics.checkParameterIsNotNull(symbolUsageValidator, "symbolUsageValidator");
        this.symbolUsageValidator = symbolUsageValidator;
    }

    public static final /* synthetic */ boolean access$getStartWithPackage$p(QualifiedExpressionResolver $this, KtUserType $receiver) {
        return $this.getStartWithPackage($receiver);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"%\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t!\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0011!1\t\u0002\u0007\u00013\u0005A\n!i\b\n\r!\tQ\u0002B\u0005\u0003\u0013\u0005A\"\u0001g\u0001\n\u000b\u0011\t\u0001RA\u0007\u0003\u0019\u0003A2!U\u0002\u0002\u0011\u000f){\u0001B\"\b\u0011\u001fiA!\u0003\u0002\n\u0003a\u0011\u00014AS\u0006\t\r;\u0001\u0002C\u0007\u0003\u0019\u0003A2!*\n\u0005\u0007\u000eA\t\"D\u0001\u0019\u0001e9A!\u0001\u0005\u0002\u001b\u0011I!!C\u0001\u0019\u0005a\r\u0011$\u0002\u0003\u0002\u0011\u000bi!\u0001$\u0001\u0019\u0007%jAa\u0011\u0005\t\t5!\u0011BA\u0005\u00021\u0013A\u001a\u0001H\u0012R\u0007\ri!\u0001B\u0003\t\f%ZAa\u0011\u0005\t\u00065\u0011A\u0012\u0001\r\u0004#\u000e!Q\u0001A\u0007\u0003\t\u0019Ai!K\u0007\u0005\u0007\"A\u0011!\u0004\u0003\n\u0005%\t\u0001D\u0001M\u0002#\u000e!Q\u0001A\u0007\u0003\t\u001dAY\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$TypeQualifierResolutionResult;", "", "qualifierParts", "", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifierPart;", "classifierDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "(Ljava/util/List;Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;)V", "allProjections", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "getAllProjections", "()Ljava/util/List;", "getClassifierDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "getQualifierParts", "component1", "component2", "copy"}, moduleName="kotlin-compiler")
    public static final class TypeQualifierResolutionResult {
        @NotNull
        private final List<? extends QualifierPart> qualifierParts;
        @Nullable
        private final ClassifierDescriptor classifierDescriptor;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<KtTypeProjection> getAllProjections() {
            void var3_3;
            void $receiver;
            Iterable $receiver2 = this.qualifierParts;
            Iterable iterable = $receiver2;
            Collection destination = new ArrayList();
            for (Object element : $receiver) {
                QualifierPart it2 = (QualifierPart)element;
                KtTypeArgumentList ktTypeArgumentList = it2.getTypeArguments();
                Iterable list = kotlin.CollectionsKt.orEmpty(ktTypeArgumentList != null ? ktTypeArgumentList.getArguments() : null);
                kotlin.CollectionsKt.addAll(destination, list);
            }
            return (List)var3_3;
        }

        @NotNull
        public final List<QualifierPart> getQualifierParts() {
            return this.qualifierParts;
        }

        @Nullable
        public final ClassifierDescriptor getClassifierDescriptor() {
            return this.classifierDescriptor;
        }

        public TypeQualifierResolutionResult(@NotNull List<? extends QualifierPart> qualifierParts, @Nullable ClassifierDescriptor classifierDescriptor) {
            Intrinsics.checkParameterIsNotNull(qualifierParts, "qualifierParts");
            this.qualifierParts = qualifierParts;
            this.classifierDescriptor = classifierDescriptor;
        }

        public /* synthetic */ TypeQualifierResolutionResult(List list, ClassifierDescriptor classifierDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                classifierDescriptor = null;
            }
            this(list, classifierDescriptor);
        }

        @NotNull
        public final List<QualifierPart> component1() {
            return this.qualifierParts;
        }

        @Nullable
        public final ClassifierDescriptor component2() {
            return this.classifierDescriptor;
        }

        @NotNull
        public final TypeQualifierResolutionResult copy(@NotNull List<? extends QualifierPart> qualifierParts, @Nullable ClassifierDescriptor classifierDescriptor) {
            Intrinsics.checkParameterIsNotNull(qualifierParts, "qualifierParts");
            return new TypeQualifierResolutionResult(qualifierParts, classifierDescriptor);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ TypeQualifierResolutionResult copy$default(TypeQualifierResolutionResult typeQualifierResolutionResult, List list, ClassifierDescriptor classifierDescriptor, int n) {
            if ((n & 1) != 0) {
                list = typeQualifierResolutionResult.qualifierParts;
            }
            if ((n & 2) != 0) {
                classifierDescriptor = typeQualifierResolutionResult.classifierDescriptor;
            }
            return typeQualifierResolutionResult.copy(list, classifierDescriptor);
        }

        public String toString() {
            return "TypeQualifierResolutionResult(qualifierParts=" + this.qualifierParts + ", classifierDescriptor=" + this.classifierDescriptor + ")";
        }

        public int hashCode() {
            List<? extends QualifierPart> list = this.qualifierParts;
            ClassifierDescriptor classifierDescriptor = this.classifierDescriptor;
            return (list != null ? ((Object)list).hashCode() : 0) * 31 + (classifierDescriptor != null ? classifierDescriptor.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof TypeQualifierResolutionResult)) break block3;
                    TypeQualifierResolutionResult typeQualifierResolutionResult = (TypeQualifierResolutionResult)object;
                    if (!Intrinsics.areEqual(this.qualifierParts, typeQualifierResolutionResult.qualifierParts) || !Intrinsics.areEqual(this.classifierDescriptor, typeQualifierResolutionResult.classifierDescriptor)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001B\u0003\u0005\u0007\u0012a\u0001!G\u0001\u0019\u0002\u0005>AaC\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005A!!)\t\n\u0007!\u0015Q\"\u0001\r\u0004\u0013\rA\u0011!D\u0001\u0019\u0004%)A!\u0001E\u0004\u001b\ta\t\u0001\u0007\u0003R\u0007\u0005AI!*\u0003\u0005\u0007\u001eA!\"D\u0001\u0019\u0007\u0015&AaQ\u0004\t\u00165\t\u00014AS\u0006\t\r;\u0001bC\u0007\u0003\u0019\u0003AB!*\u000b\u0005\u0007\u000eA9\"D\u0001\u0019\u0001e!A!\u0001E\u0003\u001b\u0005A2!\u0007\u0003\u0005\u0003!\tQ\"\u0001M\u00023\u0015!\u0011\u0001c\u0002\u000e\u00051\u0005\u0001\u0004B\u0015\u000b\t\rC\u0001\"A\u0007\u00021\u0007\t6\u0001B\u0003\u0001\u001b\t!Q\u0001c\u0003*\u0015\u0011\u0019\u0005\u0002\u0003\u0004\u000e\u0003a5\u0011k\u0001\u0003\u0006\u00015\u0011Aa\u0002E\bS)!1\t\u0003E\u0003\u001b\u0005A2!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0005\t\u0012%ZAa\u0011\u0005\t\b5\u0011A\u0012\u0001\r\u0005#\u000e!Q\u0001A\u0007\u0003\t%A\u0019\u0002"}, strings={"Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifierPart;", "", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;)V", "name", "Lorg/jetbrains/kotlin/name/Name;", "typeArguments", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;)V", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "location", "Lorg/jetbrains/kotlin/incremental/KotlinLookupLocation;", "getLocation", "()Lorg/jetbrains/kotlin/incremental/KotlinLookupLocation;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "getTypeArguments", "()Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "component1", "component2", "component3", "copy"}, moduleName="kotlin-compiler")
    public static final class QualifierPart {
        @NotNull
        private final KotlinLookupLocation location;
        @NotNull
        private final Name name;
        @NotNull
        private final KtSimpleNameExpression expression;
        @Nullable
        private final KtTypeArgumentList typeArguments;

        @NotNull
        public final KotlinLookupLocation getLocation() {
            return this.location;
        }

        @NotNull
        public final Name getName() {
            return this.name;
        }

        @NotNull
        public final KtSimpleNameExpression getExpression() {
            return this.expression;
        }

        @Nullable
        public final KtTypeArgumentList getTypeArguments() {
            return this.typeArguments;
        }

        public QualifierPart(@NotNull Name name, @NotNull KtSimpleNameExpression expression, @Nullable KtTypeArgumentList typeArguments) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            this.name = name;
            this.expression = expression;
            this.typeArguments = typeArguments;
            this.location = new KotlinLookupLocation(this.expression);
        }

        public /* synthetic */ QualifierPart(Name name, KtSimpleNameExpression ktSimpleNameExpression, KtTypeArgumentList ktTypeArgumentList, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                ktTypeArgumentList = null;
            }
            this(name, ktSimpleNameExpression, ktTypeArgumentList);
        }

        public QualifierPart(@NotNull KtSimpleNameExpression expression) {
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            this(expression.getReferencedNameAsName(), expression, null, 4, null);
        }

        @NotNull
        public final Name component1() {
            return this.name;
        }

        @NotNull
        public final KtSimpleNameExpression component2() {
            return this.expression;
        }

        @Nullable
        public final KtTypeArgumentList component3() {
            return this.typeArguments;
        }

        @NotNull
        public final QualifierPart copy(@NotNull Name name, @NotNull KtSimpleNameExpression expression, @Nullable KtTypeArgumentList typeArguments) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            return new QualifierPart(name, expression, typeArguments);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ QualifierPart copy$default(QualifierPart qualifierPart, Name name, KtSimpleNameExpression ktSimpleNameExpression, KtTypeArgumentList ktTypeArgumentList, int n) {
            if ((n & 1) != 0) {
                name = qualifierPart.name;
            }
            if ((n & 2) != 0) {
                ktSimpleNameExpression = qualifierPart.expression;
            }
            if ((n & 4) != 0) {
                ktTypeArgumentList = qualifierPart.typeArguments;
            }
            return qualifierPart.copy(name, ktSimpleNameExpression, ktTypeArgumentList);
        }

        public String toString() {
            return "QualifierPart(name=" + this.name + ", expression=" + this.expression + ", typeArguments=" + this.typeArguments + ")";
        }

        public int hashCode() {
            Name name = this.name;
            KtSimpleNameExpression ktSimpleNameExpression = this.expression;
            KtTypeArgumentList ktTypeArgumentList = this.typeArguments;
            return ((name != null ? ((Object)name).hashCode() : 0) * 31 + (ktSimpleNameExpression != null ? ktSimpleNameExpression.hashCode() : 0)) * 31 + (ktTypeArgumentList != null ? ktTypeArgumentList.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof QualifierPart)) break block3;
                    QualifierPart qualifierPart = (QualifierPart)object;
                    if (!Intrinsics.areEqual(this.name, qualifierPart.name) || !Intrinsics.areEqual(this.expression, qualifierPart.expression) || !Intrinsics.areEqual(this.typeArguments, qualifierPart.typeArguments)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\r\u0015\tA\"A\u0003\u0002\u0011!)\u0011\u0001\"\u0002\u0005\u0003\u0004a\u0001!\u0007\u0003\n\u0005%\t\u0001\u0004\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005\t$1\u0001B\u0003\u0007\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifierPosition;", "", "(Ljava/lang/String;I)V", "PACKAGE_HEADER", "IMPORT", "TYPE", "EXPRESSION"}, moduleName="kotlin-compiler")
    private static final class QualifierPosition
    extends Enum<QualifierPosition> {
        public static final /* enum */ QualifierPosition PACKAGE_HEADER;
        public static final /* enum */ QualifierPosition IMPORT;
        public static final /* enum */ QualifierPosition TYPE;
        public static final /* enum */ QualifierPosition EXPRESSION;
        private static final /* synthetic */ QualifierPosition[] $VALUES;

        static {
            QualifierPosition[] qualifierPositionArray = new QualifierPosition[4];
            QualifierPosition[] qualifierPositionArray2 = qualifierPositionArray;
            qualifierPositionArray[0] = PACKAGE_HEADER = new QualifierPosition();
            qualifierPositionArray[1] = IMPORT = new QualifierPosition();
            qualifierPositionArray[2] = TYPE = new QualifierPosition();
            qualifierPositionArray[3] = EXPRESSION = new QualifierPosition();
            $VALUES = qualifierPositionArray;
        }

        public static QualifierPosition[] values() {
            return (QualifierPosition[])$VALUES.clone();
        }

        public static QualifierPosition valueOf(String string) {
            return Enum.valueOf(QualifierPosition.class, string);
        }
    }
}

