/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.io.Closeable;
import java.util.ArrayList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.ComponentContainer;
import org.jetbrains.kotlin.container.ComponentDescriptor;
import org.jetbrains.kotlin.container.ComponentState;
import org.jetbrains.kotlin.container.ContainerConsistencyException;
import org.jetbrains.kotlin.container.SingletonDescriptor;
import org.jetbrains.kotlin.container.SingletonDescriptor$WhenMappings;
import org.jetbrains.kotlin.container.SingletonDescriptor$disposableObjects$1;
import org.jetbrains.kotlin.container.ValueResolveContext;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"E\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\t)\u0011\u0001D\u0001\u0006\u0003\u0011\u0015Q!\u0001\u0005\u0001\u000b\u0001)\u0011\u0001c\u0003\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005!)!B\u0001\t\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0005'1\u0001\u0011$\u0001M\u00013\u0005A\u0012!)\u0004\n\u0007!\rQ\"\u0001\r\u0003#\u000e\t\u0001RA\u0013\u0005\t-AQ\"D\u0001\u0019\u001c\u0015BA!\u0001\u0005\u000f\u001b\u0005AZ\"G\u0002\t\u00045\t\u0001DA\u0013\t\tIAa\"D\u0001\u0019\u0010e\u0019\u0001RD\u0007\u00021=)C\u0001B\u0001\t 5\t\u00014D\u0013\u0005\t-A\u0001#D\u0001\u0019\u0010\u0015BAA\u0001E\u0011\u001b\u0005AZ\"G\u0002\t#5\t\u0001$A\u0015\u000b\t\rC\u00012A\u0007\u00021\t\t6\u0001B\u0003\u0001\u001b\t!1\u0001c\u0002*!\u0011\t\u0005\u0002\u0003\u0003\u000e\t%\u0011\u0011\"\u0001\r\u00021\u0013a\u0012%U\u0002\u0007\u000b\t!a\u0001#\u0004\u000e\u0005\u0011)\u00012B\u0015\t\t\u0005c\u0002bB\u0007\u0003\u0019\u0003Az!U\u0002\u0002\u000b\u0001I#\u0002B&\t\u0011!i\u0011\u0001'\u0005\u001dWE\u001b1!\u0004\u0002\u0005\u0013!M\u0011&\u0004\u0003C9!QQ\"\u0001M\u000b#\u000e9Q\u0001A\u0007\u0003\t-A9\"\u0005\u0002\u0005\u0019!e\u0001"}, strings={"Lorg/jetbrains/kotlin/container/SingletonDescriptor;", "Lorg/jetbrains/kotlin/container/ComponentDescriptor;", "Ljava/io/Closeable;", "container", "Lorg/jetbrains/kotlin/container/ComponentContainer;", "(Lorg/jetbrains/kotlin/container/ComponentContainer;)V", "getContainer", "()Lorg/jetbrains/kotlin/container/ComponentContainer;", "disposableObjects", "Ljava/util/ArrayList;", "getDisposableObjects", "()Ljava/util/ArrayList;", "disposableObjects$delegate", "Lkotlin/Lazy;", "instance", "", "shouldInjectProperties", "", "getShouldInjectProperties", "()Z", "state", "Lorg/jetbrains/kotlin/container/ComponentState;", "getState", "()Lorg/jetbrains/kotlin/container/ComponentState;", "setState", "(Lorg/jetbrains/kotlin/container/ComponentState;)V", "close", "", "createInstance", "context", "Lorg/jetbrains/kotlin/container/ValueResolveContext;", "disposeImpl", "getValue", "registerDisposableObject", "ownedObject"}, moduleName="kotlin-compiler")
public abstract class SingletonDescriptor
implements Closeable,
ComponentDescriptor {
    private Object instance;
    @NotNull
    private ComponentState state;
    private final Lazy<? extends ArrayList<Closeable>> disposableObjects$delegate;
    @NotNull
    private final ComponentContainer container;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    @NotNull
    protected final ComponentState getState() {
        return this.state;
    }

    protected final void setState(@NotNull ComponentState componentState) {
        Intrinsics.checkParameterIsNotNull((Object)componentState, "<set-?>");
        this.state = componentState;
    }

    private final ArrayList<Closeable> getDisposableObjects() {
        return LazyKt.getValue(this.disposableObjects$delegate, this, $$delegatedProperties[0]);
    }

    @Override
    @NotNull
    public Object getValue() {
        if (Intrinsics.areEqual((Object)this.state, (Object)ComponentState.Corrupted)) {
            throw (Throwable)new ContainerConsistencyException("Component descriptor " + this + " is corrupted and cannot be accessed");
        }
        if (Intrinsics.areEqual((Object)this.state, (Object)ComponentState.Disposed)) {
            throw (Throwable)new ContainerConsistencyException("Component descriptor " + this + " is disposed and cannot be accessed");
        }
        if (this.instance == null) {
            this.createInstance(this.container);
        }
        Object object = this.instance;
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return object;
    }

    protected final void registerDisposableObject(@NotNull Closeable ownedObject) {
        Intrinsics.checkParameterIsNotNull(ownedObject, "ownedObject");
        this.getDisposableObjects().add(ownedObject);
    }

    @NotNull
    protected abstract Object createInstance(@NotNull ValueResolveContext var1);

    private final void createInstance(ComponentContainer container) {
        switch (SingletonDescriptor$WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                try {
                    this.instance = this.createInstance(container.createResolveContext(this));
                    return;
                }
                catch (Throwable ex) {
                    this.state = ComponentState.Corrupted;
                    for (Closeable disposable : this.getDisposableObjects()) {
                        disposable.close();
                    }
                    throw ex;
                }
            }
            case 2: {
                throw (Throwable)new ContainerConsistencyException("Could not create the component " + this + " because it is being initialized. Do we have undetected circular dependency?");
            }
            case 3: {
                throw (Throwable)new ContainerConsistencyException("Could not get the component " + this + ". Instance is null in Initialized state");
            }
            case 4: {
                throw (Throwable)new ContainerConsistencyException("Could not get the component " + this + " because it is corrupted");
            }
            case 5: {
                throw (Throwable)new ContainerConsistencyException("Could not get the component " + this + " because it is being disposed");
            }
            case 6: {
                throw (Throwable)new ContainerConsistencyException("Could not get the component " + this + " because it is already disposed");
            }
        }
    }

    private final void disposeImpl() {
        Object wereInstance = this.instance;
        this.state = ComponentState.Disposing;
        this.instance = null;
        try {
            if (wereInstance instanceof Closeable) {
                ((Closeable)wereInstance).close();
            }
            for (Closeable disposable : this.getDisposableObjects()) {
                disposable.close();
            }
        }
        catch (Throwable ex) {
            this.state = ComponentState.Corrupted;
            throw ex;
        }
        this.state = ComponentState.Disposed;
    }

    @Override
    public void close() {
        switch (SingletonDescriptor$WhenMappings.$EnumSwitchMapping$1[this.state.ordinal()]) {
            case 1: {
                this.disposeImpl();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                throw (Throwable)new ContainerConsistencyException("The component is being initialized and cannot be disposed.");
            }
            case 5: {
                throw (Throwable)new ContainerConsistencyException("The component is already in disposing state.");
            }
            case 6: {
                throw (Throwable)new ContainerConsistencyException("The component has already been destroyed.");
            }
        }
    }

    @Override
    public boolean getShouldInjectProperties() {
        return true;
    }

    @NotNull
    public final ComponentContainer getContainer() {
        return this.container;
    }

    static {
        $$delegatedProperties = new KProperty[]{SingletonDescriptor$disposableObjects$1.INSTANCE};
    }

    public SingletonDescriptor(@NotNull ComponentContainer container) {
        Intrinsics.checkParameterIsNotNull(container, "container");
        this.container = container;
        this.state = ComponentState.Null;
        this.disposableObjects$delegate = LazyKt.lazy(disposableObjects.2.INSTANCE);
    }

    @NotNull
    public static final /* synthetic */ ArrayList access$getDisposableObjects$p(SingletonDescriptor $this) {
        return $this.getDisposableObjects();
    }
}

