/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.inline.util.FunctionUtilsKt;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.HasName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"-\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0005\b\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001c\u0003\u0006\u0003\u0011\tQ\u0012\u0003\u0005\u0001\u001b\u0005A\n!G\u0002\t\u00035\t\u00014\u0001+\u0004\u00055UA!\u0001E\u0003\u001b\ta\t\u0001'\u0001\u001a\u0007!\tQ\"\u0001M\u0002)\u000e\u0011Q2\u0003\u0005\u0004\u001b\ta\t\u0001g\u0002\u001a\u0007!!Q\"\u0001M\u0002)\u000e\u0011Q2\u0003E\u0005\u001b\ta\t\u0001G\u0003\u001a\u0007!!Q\"\u0001M\u0002)\u000e\u0011QR\u0003\u0003\u0002\u0011\u0017i!\u0001$\u0001\u0019\re\u0019\u0001\"A\u0007\u00021\u0007!6AAG\t\u0011\u001bi\u0011\u0001G\u0004\u001a\u0007!\tQ\"\u0001M\u0002)\u000e\u0011Q\u0012\u0003E\b\u001b\u0005Ar!G\u0002\t\u00035\t\u00014\u0001+\u0004\u00055E\u0001\u0002C\u0007\u00021\u001dI2\u0001C\u0001\u000e\u0003a\rAk\u0001\u0002"}, strings={"getCallerQualifier", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "invocation", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsInvocation;", "InvocationUtilsKt", "getCallerQualifierImpl", "getSimpleIdent", "", "call", "getSimpleName", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsName;", "getStaticRef", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNode;", "hasCallerQualifier", "", "isCallInvocation", "isFunctionCreatorInvocation"}, moduleName="kotlin-compiler")
public final class InvocationUtilsKt {
    @Nullable
    public static final JsName getSimpleName(@NotNull JsInvocation call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        JsExpression qualifier2 = call.getQualifier();
        JsExpression jsExpression = qualifier2;
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        JsNameRef jsNameRef = (JsNameRef)jsExpression;
        return jsNameRef != null ? jsNameRef.getName() : null;
    }

    @Nullable
    public static final String getSimpleIdent(@NotNull JsInvocation call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        JsExpression qualifier2 = call.getQualifier();
        while (qualifier2 != null) {
            JsExpression jsExpression = qualifier2;
            if (jsExpression instanceof JsInvocation) {
                JsExpression callableQualifier = qualifier2;
                qualifier2 = ((JsInvocation)callableQualifier).getQualifier();
                if (!InvocationUtilsKt.isCallInvocation((JsInvocation)callableQualifier)) continue;
                JsExpression jsExpression2 = qualifier2;
                if (!(jsExpression2 instanceof JsNameRef)) {
                    jsExpression2 = null;
                }
                JsNameRef jsNameRef = (JsNameRef)jsExpression2;
                qualifier2 = jsNameRef != null ? jsNameRef.getQualifier() : null;
                continue;
            }
            if (!(jsExpression instanceof HasName)) break;
            JsName jsName = ((HasName)((Object)qualifier2)).getName();
            return jsName != null ? jsName.getIdent() : null;
        }
        return null;
    }

    public static final boolean isFunctionCreatorInvocation(@NotNull JsInvocation invocation) {
        JsNode staticRef2;
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        JsNode jsNode = staticRef2 = InvocationUtilsKt.getStaticRef(invocation);
        return jsNode instanceof JsFunction ? FunctionUtilsKt.isFunctionCreator((JsFunction)staticRef2) : false;
    }

    public static final boolean isCallInvocation(@NotNull JsInvocation invocation) {
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        JsExpression jsExpression = invocation.getQualifier();
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        JsNameRef qualifier2 = (JsNameRef)jsExpression;
        List<JsExpression> arguments2 = invocation.getArguments();
        JsNameRef jsNameRef = qualifier2;
        return Intrinsics.areEqual(jsNameRef != null ? jsNameRef.getIdent() : null, "call") && CollectionsKt.isNotEmpty((Collection)arguments2);
    }

    public static final boolean hasCallerQualifier(@NotNull JsInvocation invocation) {
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        return InvocationUtilsKt.getCallerQualifierImpl(invocation) != null;
    }

    @NotNull
    public static final JsExpression getCallerQualifier(@NotNull JsInvocation invocation) {
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        JsExpression jsExpression = InvocationUtilsKt.getCallerQualifierImpl(invocation);
        if (jsExpression == null) {
            throw (Throwable)((Object)new AssertionError((Object)"must check hasQualifier() before calling getQualifier"));
        }
        return jsExpression;
    }

    private static final JsExpression getCallerQualifierImpl(JsInvocation invocation) {
        JsExpression jsExpression = invocation.getQualifier();
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        JsNameRef jsNameRef = (JsNameRef)jsExpression;
        return jsNameRef != null ? jsNameRef.getQualifier() : null;
    }

    private static final JsNode getStaticRef(JsInvocation invocation) {
        JsName qualifierName;
        JsExpression qualifier2 = invocation.getQualifier();
        JsExpression jsExpression = qualifier2;
        if (!(jsExpression instanceof HasName)) {
            jsExpression = null;
        }
        HasName hasName = (HasName)((Object)jsExpression);
        JsName jsName = qualifierName = hasName != null ? hasName.getName() : null;
        return jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
    }
}

