/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.js.resolve.AbstractNativeAnnotationsChecker;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"5\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\b\u000b\u0001)\u0011\u0001\u0003\u0003\u0006\u0003\u0011\tQ!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011\u0001\u0002\t\r\u0001e\t\u0001\u0014AQ\u000f\u0013\rA\u0011!D\u0001\u0019\u0004%\u0019\u0001BA\u0007\u00021\u000bI1\u0001C\u0002\u000e\u0003a\u001d\u0011kA\u0001\t\t\u0015\u0002Ba\u0003E\u0005\u001b\u0005AR!G\u0002\t\f5\t\u0001DB\r\u0004\u0011\u001bi\u0011\u0001G\u0004\u001a\u0007!=Q\"\u0001\r\tS\u001d!\u0011\t\u0003\u0005\u0003\u001b\u0005A*!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\ri\u0011\u0001g\u0002R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/js/resolve/AbstractNativeIndexerChecker;", "Lorg/jetbrains/kotlin/js/resolve/AbstractNativeAnnotationsChecker;", "requiredAnnotation", "Lorg/jetbrains/kotlin/js/PredefinedAnnotation;", "indexerKind", "", "requiredParametersCount", "", "(Lorg/jetbrains/kotlin/js/PredefinedAnnotation;Ljava/lang/String;I)V", "additionalCheck", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;"}, moduleName="kotlin-compiler")
public abstract class AbstractNativeIndexerChecker
extends AbstractNativeAnnotationsChecker {
    private final String indexerKind;
    private final int requiredParametersCount;

    /*
     * WARNING - void declaration
     */
    @Override
    public void additionalCheck(@NotNull KtNamedFunction declaration, @NotNull FunctionDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder) {
        Object firstParamClassDescriptor;
        void $receiver;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        List<ValueParameterDescriptor> parameters2 = descriptor2.getValueParameters();
        KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(descriptor2);
        Collection collection = parameters2;
        if ($receiver.size() > 0 && Intrinsics.areEqual(firstParamClassDescriptor = DescriptorUtils.getClassDescriptorForType(parameters2.get(0).getType()), builtIns.getString()) ^ true && !DescriptorUtils.isSubclass((ClassDescriptor)firstParamClassDescriptor, builtIns.getNumber())) {
            diagnosticHolder.report(ErrorsJs.NATIVE_INDEXER_KEY_SHOULD_BE_STRING_OR_NUMBER.on((KtElement)((PsiElement)CollectionsKt.firstOrNull(declaration.getValueParameters())), this.indexerKind));
        }
        firstParamClassDescriptor = parameters2;
        if ($receiver.size() != this.requiredParametersCount) {
            diagnosticHolder.report(ErrorsJs.NATIVE_INDEXER_WRONG_PARAMETER_COUNT.on((KtElement)((PsiElement)declaration), this.requiredParametersCount, this.indexerKind));
        }
        for (KtParameter parameter : declaration.getValueParameters()) {
            if (!parameter.hasDefaultValue()) continue;
            diagnosticHolder.report(ErrorsJs.NATIVE_INDEXER_CAN_NOT_HAVE_DEFAULT_ARGUMENTS.on((KtElement)((PsiElement)parameter), this.indexerKind));
        }
    }

    public AbstractNativeIndexerChecker(@NotNull PredefinedAnnotation requiredAnnotation, @NotNull String indexerKind, int requiredParametersCount) {
        Intrinsics.checkParameterIsNotNull((Object)requiredAnnotation, "requiredAnnotation");
        Intrinsics.checkParameterIsNotNull(indexerKind, "indexerKind");
        super(requiredAnnotation);
        this.indexerKind = indexerKind;
        this.requiredParametersCount = requiredParametersCount;
    }
}

