/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.HasArguments;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsEmpty;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsEmptyExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsIf;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNew;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsObjectScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsParameter;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsProgram;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsVars;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public final class JsAstUtils {
    private static final JsNameRef DEFINE_PROPERTY = new JsNameRef("defineProperty");
    public static final JsNameRef CREATE_OBJECT = new JsNameRef("create");
    private static final JsNameRef VALUE = new JsNameRef("value");
    private static final JsPropertyInitializer WRITABLE = new JsPropertyInitializer(new JsNameRef("writable"), JsLiteral.TRUE);
    private static final JsPropertyInitializer ENUMERABLE = new JsPropertyInitializer(new JsNameRef("enumerable"), JsLiteral.TRUE);
    public static final String LENDS_JS_DOC_TAG = "lends";

    private JsAstUtils() {
    }

    @NotNull
    public static JsStatement convertToStatement(@NotNull JsNode jsNode) {
        if (jsNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsNode", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "convertToStatement"));
        }
        assert (jsNode instanceof JsExpression || jsNode instanceof JsStatement) : "Unexpected node of type: " + jsNode.getClass().toString();
        if (jsNode instanceof JsExpression) {
            JsStatement jsStatement = ((JsExpression)jsNode).makeStmt();
            if (jsStatement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "convertToStatement"));
            }
            return jsStatement;
        }
        JsStatement jsStatement = (JsStatement)jsNode;
        if (jsStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "convertToStatement"));
        }
        return jsStatement;
    }

    @NotNull
    public static JsBlock convertToBlock(@NotNull JsNode jsNode) {
        if (jsNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsNode", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "convertToBlock"));
        }
        if (jsNode instanceof JsBlock) {
            JsBlock jsBlock = (JsBlock)jsNode;
            if (jsBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "convertToBlock"));
            }
            return jsBlock;
        }
        JsBlock block = new JsBlock();
        block.getStatements().add(JsAstUtils.convertToStatement(jsNode));
        JsBlock jsBlock = block;
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "convertToBlock"));
        }
        return jsBlock;
    }

    @NotNull
    private static JsStatement deBlockIfPossible(@NotNull JsStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "deBlockIfPossible"));
        }
        if (statement instanceof JsBlock && ((JsBlock)statement).getStatements().size() == 1) {
            JsStatement jsStatement = ((JsBlock)statement).getStatements().get(0);
            if (jsStatement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "deBlockIfPossible"));
            }
            return jsStatement;
        }
        JsStatement jsStatement = statement;
        if (jsStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "deBlockIfPossible"));
        }
        return jsStatement;
    }

    @NotNull
    public static JsIf newJsIf(@NotNull JsExpression ifExpression, @NotNull JsStatement thenStatement, @Nullable JsStatement elseStatement) {
        if (ifExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifExpression", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "newJsIf"));
        }
        if (thenStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thenStatement", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "newJsIf"));
        }
        elseStatement = elseStatement != null ? JsAstUtils.deBlockIfPossible(elseStatement) : null;
        JsIf jsIf = new JsIf(ifExpression, JsAstUtils.deBlockIfPossible(thenStatement), elseStatement);
        if (jsIf == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "newJsIf"));
        }
        return jsIf;
    }

    @NotNull
    public static JsIf newJsIf(@NotNull JsExpression ifExpression, @NotNull JsStatement thenStatement) {
        if (ifExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifExpression", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "newJsIf"));
        }
        if (thenStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thenStatement", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "newJsIf"));
        }
        JsIf jsIf = JsAstUtils.newJsIf(ifExpression, thenStatement, null);
        if (jsIf == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "newJsIf"));
        }
        return jsIf;
    }

    @Nullable
    public static JsExpression extractExpressionFromStatement(@Nullable JsStatement statement) {
        return statement instanceof JsExpressionStatement ? ((JsExpressionStatement)statement).getExpression() : null;
    }

    @NotNull
    public static JsStatement mergeStatementInBlockIfNeeded(@NotNull JsStatement statement, @NotNull JsBlock block) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "mergeStatementInBlockIfNeeded"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "mergeStatementInBlockIfNeeded"));
        }
        if (block.isEmpty()) {
            JsStatement jsStatement = statement;
            if (jsStatement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "mergeStatementInBlockIfNeeded"));
            }
            return jsStatement;
        }
        if (JsAstUtils.isEmptyStatement(statement)) {
            JsStatement jsStatement = JsAstUtils.deBlockIfPossible(block);
            if (jsStatement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "mergeStatementInBlockIfNeeded"));
            }
            return jsStatement;
        }
        block.getStatements().add(statement);
        JsBlock jsBlock = block;
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "mergeStatementInBlockIfNeeded"));
        }
        return jsBlock;
    }

    public static boolean isEmptyStatement(@NotNull JsStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "isEmptyStatement"));
        }
        return statement instanceof JsEmpty;
    }

    public static boolean isEmptyExpression(@NotNull JsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "isEmptyExpression"));
        }
        return expression instanceof JsEmptyExpression;
    }

    @NotNull
    public static JsInvocation invokeKotlinFunction(@NotNull String name, JsExpression ... argument) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "invokeKotlinFunction"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "invokeKotlinFunction"));
        }
        JsInvocation jsInvocation = new JsInvocation((JsExpression)new JsNameRef(name, (JsExpression)Namer.KOTLIN_OBJECT_REF), argument);
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "invokeKotlinFunction"));
        }
        return jsInvocation;
    }

    @NotNull
    public static JsInvocation invokeMethod(@NotNull JsExpression thisObject, @NotNull String name, JsExpression ... arguments2) {
        if (thisObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisObject", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "invokeMethod"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "invokeMethod"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "invokeMethod"));
        }
        JsInvocation jsInvocation = new JsInvocation((JsExpression)new JsNameRef(name, thisObject), arguments2);
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "invokeMethod"));
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression toInt32(@NotNull JsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "toInt32"));
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.BIT_OR, expression, JsNumberLiteral.ZERO);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "toInt32"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsExpression charToInt(@NotNull JsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "charToInt"));
        }
        JsInvocation jsInvocation = JsAstUtils.invokeMethod(expression, "charCodeAt", JsNumberLiteral.ZERO);
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "charToInt"));
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression toShort(@NotNull JsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "toShort"));
        }
        JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction(OperatorConventions.SHORT.getIdentifier(), expression);
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "toShort"));
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression toByte(@NotNull JsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "toByte"));
        }
        JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction(OperatorConventions.BYTE.getIdentifier(), expression);
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "toByte"));
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression toLong(@NotNull JsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "toLong"));
        }
        JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction(OperatorConventions.LONG.getIdentifier(), expression);
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "toLong"));
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression toChar(@NotNull JsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "toChar"));
        }
        JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction(OperatorConventions.CHAR.getIdentifier(), expression);
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "toChar"));
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression compareTo(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "compareTo"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "compareTo"));
        }
        JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction(OperatorNameConventions.COMPARE_TO.getIdentifier(), left, right);
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "compareTo"));
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression primitiveCompareTo(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "primitiveCompareTo"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "primitiveCompareTo"));
        }
        JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction("primitiveCompareTo", left, right);
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "primitiveCompareTo"));
        }
        return jsInvocation;
    }

    @NotNull
    private static JsExpression rangeTo(@NotNull String rangeClassName, @NotNull JsExpression rangeStart, @NotNull JsExpression rangeEnd) {
        if (rangeClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeClassName", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "rangeTo"));
        }
        if (rangeStart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeStart", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "rangeTo"));
        }
        if (rangeEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeEnd", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "rangeTo"));
        }
        JsNameRef expr = new JsNameRef(rangeClassName, "Kotlin");
        JsNew numberRangeConstructorInvocation = new JsNew(expr);
        JsAstUtils.setArguments((HasArguments)numberRangeConstructorInvocation, rangeStart, rangeEnd);
        JsNew jsNew = numberRangeConstructorInvocation;
        if (jsNew == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "rangeTo"));
        }
        return jsNew;
    }

    @NotNull
    public static JsExpression numberRangeTo(@NotNull JsExpression rangeStart, @NotNull JsExpression rangeEnd) {
        if (rangeStart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeStart", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "numberRangeTo"));
        }
        if (rangeEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeEnd", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "numberRangeTo"));
        }
        JsExpression jsExpression = JsAstUtils.rangeTo("NumberRange", rangeStart, rangeEnd);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "numberRangeTo"));
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression charRangeTo(@NotNull JsExpression rangeStart, @NotNull JsExpression rangeEnd) {
        if (rangeStart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeStart", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "charRangeTo"));
        }
        if (rangeEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeEnd", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "charRangeTo"));
        }
        JsExpression jsExpression = JsAstUtils.rangeTo("CharRange", rangeStart, rangeEnd);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "charRangeTo"));
        }
        return jsExpression;
    }

    /*
     * WARNING - void declaration
     */
    public static JsExpression newLong(long value, @NotNull TranslationContext translationContext) {
        void context;
        if (translationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "newLong"));
        }
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            int low = (int)value;
            int high = (int)(value >> 32);
            SmartList<JsExpression> args = new SmartList<JsExpression>();
            args.add(context.program().getNumberLiteral(low));
            args.add(context.program().getNumberLiteral(high));
            return new JsNew(Namer.KOTLIN_LONG_NAME_REF, args);
        }
        if (value == 0L) {
            return new JsNameRef("ZERO", (JsExpression)Namer.KOTLIN_LONG_NAME_REF);
        }
        if (value == 1L) {
            return new JsNameRef("ONE", (JsExpression)Namer.KOTLIN_LONG_NAME_REF);
        }
        if (value == -1L) {
            return new JsNameRef("NEG_ONE", (JsExpression)Namer.KOTLIN_LONG_NAME_REF);
        }
        return JsAstUtils.longFromInt(context.program().getNumberLiteral((int)value));
    }

    @NotNull
    public static JsExpression longFromInt(@NotNull JsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "longFromInt"));
        }
        JsInvocation jsInvocation = JsAstUtils.invokeMethod(Namer.KOTLIN_LONG_NAME_REF, "fromInt", expression);
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "longFromInt"));
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression longFromNumber(@NotNull JsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "longFromNumber"));
        }
        JsInvocation jsInvocation = JsAstUtils.invokeMethod(Namer.KOTLIN_LONG_NAME_REF, "fromNumber", expression);
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "longFromNumber"));
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression equalsForObject(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "equalsForObject"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "equalsForObject"));
        }
        JsInvocation jsInvocation = JsAstUtils.invokeMethod(left, Namer.EQUALS_METHOD_NAME, right);
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "equalsForObject"));
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression compareForObject(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "compareForObject"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "compareForObject"));
        }
        JsInvocation jsInvocation = JsAstUtils.invokeMethod(left, Namer.COMPARE_TO_METHOD_NAME, right);
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "compareForObject"));
        }
        return jsInvocation;
    }

    @NotNull
    public static JsPrefixOperation negated(@NotNull JsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "negated"));
        }
        JsPrefixOperation jsPrefixOperation = new JsPrefixOperation(JsUnaryOperator.NOT, expression);
        if (jsPrefixOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "negated"));
        }
        return jsPrefixOperation;
    }

    @NotNull
    public static JsBinaryOperation and(@NotNull JsExpression op1, @NotNull JsExpression op2) {
        if (op1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op1", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "and"));
        }
        if (op2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op2", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "and"));
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.AND, op1, op2);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "and"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation or(@NotNull JsExpression op1, @NotNull JsExpression op2) {
        if (op1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op1", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "or"));
        }
        if (op2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op2", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "or"));
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.OR, op1, op2);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "or"));
        }
        return jsBinaryOperation;
    }

    public static void setQualifier(@NotNull JsExpression selector, @Nullable JsExpression receiver) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "setQualifier"));
        }
        assert (selector instanceof JsInvocation || selector instanceof JsNameRef);
        if (selector instanceof JsInvocation) {
            JsAstUtils.setQualifier(((JsInvocation)selector).getQualifier(), receiver);
            return;
        }
        JsAstUtils.setQualifierForNameRef((JsNameRef)selector, receiver);
    }

    private static void setQualifierForNameRef(@NotNull JsNameRef selector, @Nullable JsExpression receiver) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "setQualifierForNameRef"));
        }
        JsExpression qualifier2 = selector.getQualifier();
        if (qualifier2 == null) {
            selector.setQualifier(receiver);
        } else {
            JsAstUtils.setQualifier(qualifier2, receiver);
        }
    }

    @NotNull
    public static JsBinaryOperation equality(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg1", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "equality"));
        }
        if (arg2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg2", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "equality"));
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.REF_EQ, arg1, arg2);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "equality"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation inequality(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg1", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "inequality"));
        }
        if (arg2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg2", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "inequality"));
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.REF_NEQ, arg1, arg2);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "inequality"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation lessThanEq(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg1", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "lessThanEq"));
        }
        if (arg2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg2", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "lessThanEq"));
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.LTE, arg1, arg2);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "lessThanEq"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation lessThan(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg1", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "lessThan"));
        }
        if (arg2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg2", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "lessThan"));
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.LT, arg1, arg2);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "lessThan"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation greaterThan(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg1", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "greaterThan"));
        }
        if (arg2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg2", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "greaterThan"));
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.GT, arg1, arg2);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "greaterThan"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsExpression assignment(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "assignment"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "assignment"));
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.ASG, left, right);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "assignment"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation sum(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "sum"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "sum"));
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.ADD, left, right);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "sum"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation addAssign(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "addAssign"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "addAssign"));
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.ASG_ADD, left, right);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "addAssign"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation subtract(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "subtract"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "subtract"));
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.SUB, left, right);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "subtract"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation mul(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "mul"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "mul"));
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.MUL, left, right);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "mul"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation div(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "div"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "div"));
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.DIV, left, right);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "div"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation mod(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "mod"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "mod"));
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.MOD, left, right);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "mod"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsPrefixOperation not(@NotNull JsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "not"));
        }
        JsPrefixOperation jsPrefixOperation = new JsPrefixOperation(JsUnaryOperator.NOT, expression);
        if (jsPrefixOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "not"));
        }
        return jsPrefixOperation;
    }

    @NotNull
    public static JsBinaryOperation typeof(@NotNull JsExpression expression, @NotNull JsStringLiteral string) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "typeof"));
        }
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "typeof"));
        }
        JsBinaryOperation jsBinaryOperation = JsAstUtils.equality(new JsPrefixOperation(JsUnaryOperator.TYPEOF, expression), string);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "typeof"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsVars newVar(@NotNull JsName name, @Nullable JsExpression expr) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "newVar"));
        }
        JsVars jsVars = new JsVars(new JsVars.JsVar(name, expr));
        if (jsVars == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "newVar"));
        }
        return jsVars;
    }

    public static void setArguments(@NotNull HasArguments invocation, @NotNull List<JsExpression> newArgs) {
        if (invocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invocation", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "setArguments"));
        }
        if (newArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newArgs", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "setArguments"));
        }
        List<JsExpression> arguments2 = invocation.getArguments();
        assert (arguments2.isEmpty()) : "Arguments already set.";
        arguments2.addAll(newArgs);
    }

    public static void setArguments(@NotNull HasArguments invocation, JsExpression ... arguments2) {
        if (invocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invocation", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "setArguments"));
        }
        JsAstUtils.setArguments(invocation, Arrays.asList(arguments2));
    }

    public static void setParameters(@NotNull JsFunction function, @NotNull List<JsParameter> newParams) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "setParameters"));
        }
        if (newParams == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParams", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "setParameters"));
        }
        List<JsParameter> parameters2 = function.getParameters();
        assert (parameters2.isEmpty()) : "Arguments already set.";
        parameters2.addAll(newParams);
    }

    @NotNull
    public static JsExpression newSequence(@NotNull List<JsExpression> expressions) {
        if (expressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "newSequence"));
        }
        assert (!expressions.isEmpty());
        if (expressions.size() == 1) {
            JsExpression jsExpression = expressions.get(0);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "newSequence"));
            }
            return jsExpression;
        }
        JsExpression result2 = expressions.get(expressions.size() - 1);
        for (int i = expressions.size() - 2; i >= 0; --i) {
            result2 = new JsBinaryOperation(JsBinaryOperator.COMMA, expressions.get(i), result2);
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "newSequence"));
        }
        return jsExpression;
    }

    @NotNull
    public static JsFunction createFunctionWithEmptyBody(@NotNull JsScope parent2) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "createFunctionWithEmptyBody"));
        }
        JsFunction jsFunction = new JsFunction(parent2, new JsBlock(), "<anonymous>");
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "createFunctionWithEmptyBody"));
        }
        return jsFunction;
    }

    @NotNull
    public static List<JsExpression> toStringLiteralList(@NotNull List<String> strings, @NotNull JsProgram program) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "toStringLiteralList"));
        }
        if (program == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "program", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "toStringLiteralList"));
        }
        if (strings.isEmpty()) {
            List<JsExpression> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "toStringLiteralList"));
            }
            return list;
        }
        SmartList<JsExpression> result2 = new SmartList<JsExpression>();
        for (String str : strings) {
            result2.add(program.getStringLiteral(str));
        }
        SmartList<JsExpression> smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "toStringLiteralList"));
        }
        return smartList;
    }

    @NotNull
    public static JsInvocation defineProperty(@NotNull String name, @NotNull JsObjectLiteral value, @NotNull TranslationContext context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "defineProperty"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "defineProperty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "defineProperty"));
        }
        JsInvocation jsInvocation = new JsInvocation((JsExpression)DEFINE_PROPERTY, JsLiteral.THIS, context.program().getStringLiteral(name), value);
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "defineProperty"));
        }
        return jsInvocation;
    }

    @NotNull
    public static JsStatement defineSimpleProperty(@NotNull String name, @NotNull JsExpression value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "defineSimpleProperty"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "defineSimpleProperty"));
        }
        JsStatement jsStatement = JsAstUtils.assignment(new JsNameRef(name, (JsExpression)JsLiteral.THIS), value).makeStmt();
        if (jsStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "defineSimpleProperty"));
        }
        return jsStatement;
    }

    @NotNull
    public static JsObjectLiteral createDataDescriptor(@NotNull JsExpression value, boolean writable, boolean enumerable) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "createDataDescriptor"));
        }
        JsObjectLiteral dataDescriptor = new JsObjectLiteral();
        dataDescriptor.getPropertyInitializers().add(new JsPropertyInitializer(VALUE, value));
        if (writable) {
            dataDescriptor.getPropertyInitializers().add(WRITABLE);
        }
        if (enumerable) {
            dataDescriptor.getPropertyInitializers().add(ENUMERABLE);
        }
        JsObjectLiteral jsObjectLiteral = dataDescriptor;
        if (jsObjectLiteral == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "createDataDescriptor"));
        }
        return jsObjectLiteral;
    }

    @NotNull
    public static JsFunction createPackage(@NotNull List<JsStatement> to, @NotNull JsObjectScope scope2) {
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "createPackage"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "createPackage"));
        }
        JsFunction packageBlockFunction = JsAstUtils.createFunctionWithEmptyBody(scope2);
        JsName kotlinObjectAsParameter = packageBlockFunction.getScope().declareNameUnsafe("Kotlin");
        packageBlockFunction.getParameters().add(new JsParameter(kotlinObjectAsParameter));
        to.add(new JsInvocation((JsExpression)packageBlockFunction, Namer.KOTLIN_OBJECT_REF).makeStmt());
        JsFunction jsFunction = packageBlockFunction;
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "createPackage"));
        }
        return jsFunction;
    }

    @NotNull
    public static JsObjectLiteral wrapValue(@NotNull JsExpression label, @NotNull JsExpression value) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "wrapValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "wrapValue"));
        }
        JsObjectLiteral jsObjectLiteral = new JsObjectLiteral(Collections.singletonList(new JsPropertyInitializer(label, value)));
        if (jsObjectLiteral == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "wrapValue"));
        }
        return jsObjectLiteral;
    }

    public static JsExpression replaceRootReference(@NotNull JsNameRef fullQualifier, @NotNull JsExpression newQualifier) {
        if (fullQualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullQualifier", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "replaceRootReference"));
        }
        if (newQualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newQualifier", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "replaceRootReference"));
        }
        if (fullQualifier.getQualifier() == null) {
            assert (Namer.getRootPackageName().equals(fullQualifier.getIdent())) : "Expected root package, but: " + fullQualifier.getIdent();
            return newQualifier;
        }
        JsNameRef qualifier2 = fullQualifier = fullQualifier.deepCopy();
        while (true) {
            JsExpression parent2 = qualifier2.getQualifier();
            assert (parent2 instanceof JsNameRef) : "unexpected qualifier: " + parent2 + ", original: " + fullQualifier;
            if (((JsNameRef)parent2).getQualifier() == null) {
                assert (Namer.getRootPackageName().equals(((JsNameRef)parent2).getIdent()));
                qualifier2.setQualifier(newQualifier);
                return fullQualifier;
            }
            qualifier2 = (JsNameRef)parent2;
        }
    }

    @NotNull
    public static List<JsStatement> flattenStatement(@NotNull JsStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "flattenStatement"));
        }
        if (statement instanceof JsBlock) {
            List<JsStatement> list = ((JsBlock)statement).getStatements();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "flattenStatement"));
            }
            return list;
        }
        SmartList<JsStatement> smartList = new SmartList<JsStatement>(statement);
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/JsAstUtils", "flattenStatement"));
        }
        return smartList;
    }

    static {
        JsNameRef globalObjectReference = new JsNameRef("Object");
        DEFINE_PROPERTY.setQualifier(globalObjectReference);
        CREATE_OBJECT.setQualifier(globalObjectReference);
    }
}

