/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.HasName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsVisitor;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.util.AstUtil;

public class JsLabel
extends SourceInfoAwareJsNode
implements HasName,
JsStatement {
    private final JsName label;
    private JsStatement statement;

    public JsLabel(JsName label) {
        this.label = label;
    }

    public JsLabel(JsName label, JsStatement statement) {
        this.label = label;
        this.statement = statement;
    }

    @Override
    public JsName getName() {
        return this.label;
    }

    public JsStatement getStatement() {
        return this.statement;
    }

    public void setStatement(JsStatement statement) {
        this.statement = statement;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitLabel(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.statement);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.statement = v.acceptStatement(this.statement);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsLabel deepCopy() {
        JsLabel jsLabel = new JsLabel(this.label, AstUtil.deepCopy(this.statement.deepCopy())).withMetadataFrom(this);
        if (jsLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsLabel", "deepCopy"));
        }
        return jsLabel;
    }
}

