/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u001b\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t\u001f\u0015\tA!A\u0003\u0002\u0011\u0017)\u0011\u0001D\u0001\u000e\u0014\u0011\t\u0001\u0002A\u0007\u00021\u0003I2\u0001C\u0001\u000e\u0003a\u0005Aka\u0001\u000e\u001e!\u0011Q\u0002B\u0005\u0003\u0013\u0005A\n\u0001'\u0002\u001a\r!\u0019Q\u0002B\u0005\u0003\u0013\u0005A\n\u0001'\u0002U\u0007\u0007i\t\u0002c\u0002\u000e\u0003a!\u0011d\u0001\u0005\u0002\u001b\u0005AJ\u0001VB\u0002"}, strings={"createSynthesizedFunctionWithFirstParameterAsReceiver", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "descriptor", "SynthesizedInvokesKt", "createSynthesizedInvokes", "", "functions", "isSynthesizedInvoke", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;"}, moduleName="kotlin-compiler")
public final class SynthesizedInvokesKt {
    @NotNull
    public static final Collection<FunctionDescriptor> createSynthesizedInvokes(@NotNull Collection<? extends FunctionDescriptor> functions2) {
        Intrinsics.checkParameterIsNotNull(functions2, "functions");
        ArrayList<FunctionDescriptor> result2 = new ArrayList<FunctionDescriptor>(1);
        for (FunctionDescriptor functionDescriptor : functions2) {
            FunctionDescriptor functionDescriptor2;
            if (!(functionDescriptor instanceof FunctionInvokeDescriptor) || ((FunctionInvokeDescriptor)functionDescriptor).getValueParameters().isEmpty()) continue;
            DeclarationDescriptor declarationDescriptor = ((FunctionInvokeDescriptor)functionDescriptor).getContainingDeclaration();
            if (!(declarationDescriptor instanceof FunctionClassDescriptor)) {
                declarationDescriptor = null;
            }
            FunctionClassDescriptor functionClassDescriptor = (FunctionClassDescriptor)declarationDescriptor;
            if (Intrinsics.areEqual((Object)(functionClassDescriptor != null ? functionClassDescriptor.getFunctionKind() : null), (Object)FunctionClassDescriptor.Kind.Function)) {
                functionDescriptor2 = SynthesizedInvokesKt.createSynthesizedFunctionWithFirstParameterAsReceiver(functionDescriptor);
            } else {
                FunctionDescriptor invokeDeclaration;
                FunctionDescriptor functionDescriptor3 = invokeDeclaration = (FunctionDescriptor)CollectionsKt.single((Iterable)((FunctionInvokeDescriptor)functionDescriptor).getOverriddenDescriptors());
                Intrinsics.checkExpressionValueIsNotNull(functionDescriptor3, "invokeDeclaration");
                FunctionDescriptor synthesizedSuperFun = SynthesizedInvokesKt.createSynthesizedFunctionWithFirstParameterAsReceiver(functionDescriptor3);
                FunctionDescriptor fakeOverride = synthesizedSuperFun.copy(((FunctionInvokeDescriptor)functionDescriptor).getContainingDeclaration(), synthesizedSuperFun.getModality(), synthesizedSuperFun.getVisibility(), CallableMemberDescriptor.Kind.FAKE_OVERRIDE, true);
                fakeOverride.addOverriddenDescriptor(synthesizedSuperFun);
                FunctionDescriptor functionDescriptor4 = fakeOverride;
                functionDescriptor2 = functionDescriptor4;
                Intrinsics.checkExpressionValueIsNotNull(functionDescriptor4, "fakeOverride");
            }
            FunctionDescriptor synthesized = functionDescriptor2;
            ReceiverParameterDescriptor receiverParameterDescriptor = ((FunctionInvokeDescriptor)functionDescriptor).getDispatchReceiverParameter();
            if (receiverParameterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            result2.add(synthesized.substitute(TypeSubstitutor.create(receiverParameterDescriptor.getType())));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final FunctionDescriptor createSynthesizedFunctionWithFirstParameterAsReceiver(FunctionDescriptor descriptor2) {
        List list;
        void destination;
        void $receiver;
        void $receiver2;
        SimpleFunctionDescriptorImpl result2 = SimpleFunctionDescriptorImpl.create(descriptor2.getContainingDeclaration(), descriptor2.getAnnotations(), descriptor2.getName(), CallableMemberDescriptor.Kind.SYNTHESIZED, descriptor2.getSource());
        FunctionDescriptor original = descriptor2.getOriginal();
        Iterable iterable = CollectionsKt.drop((Iterable)original.getValueParameters(), 1);
        List<TypeParameterDescriptor> list2 = original.getTypeParameters();
        ReceiverParameterDescriptor receiverParameterDescriptor = original.getDispatchReceiverParameter();
        KotlinType kotlinType = CollectionsKt.first(original.getValueParameters()).getType();
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = result2;
        void var8_8 = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void p;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item;
            list = destination;
            CallableDescriptor callableDescriptor = result2;
            Intrinsics.checkExpressionValueIsNotNull(callableDescriptor, "result");
            ValueParameterDescriptor valueParameterDescriptor2 = null;
            int n = p.getIndex() - 1;
            Annotations annotations2 = p.getAnnotations();
            Intrinsics.checkExpressionValueIsNotNull(annotations2, "p.getAnnotations()");
            Name name = Name.identifier("p" + (p.getIndex() + 1));
            Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(\"p${p.index + 1}\")");
            KotlinType kotlinType2 = p.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "p.getType()");
            boolean bl = p.declaresDefaultValue();
            boolean bl2 = p.isCrossinline();
            boolean bl3 = p.isNoinline();
            KotlinType kotlinType3 = p.getVarargElementType();
            SourceElement sourceElement = p.getSource();
            Intrinsics.checkExpressionValueIsNotNull(sourceElement, "p.getSource()");
            ValueParameterDescriptorImpl valueParameterDescriptorImpl = new ValueParameterDescriptorImpl(callableDescriptor, valueParameterDescriptor2, n, annotations2, name, kotlinType2, bl, bl2, bl3, kotlinType3, sourceElement);
            list.add(valueParameterDescriptorImpl);
        }
        list = (List)destination;
        simpleFunctionDescriptorImpl.initialize(kotlinType, receiverParameterDescriptor, list2, list, original.getReturnType(), original.getModality(), original.getVisibility());
        result2.setOperator(original.isOperator());
        result2.setInfix(original.isInfix());
        result2.setExternal(original.isExternal());
        result2.setInline(original.isInline());
        result2.setTailrec(original.isTailrec());
        result2.setHasStableParameterNames(false);
        result2.setHasSynthesizedParameterNames(true);
        FunctionDescriptor functionDescriptor = result2;
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "result");
        return functionDescriptor;
    }

    public static final boolean isSynthesizedInvoke(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (Intrinsics.areEqual(descriptor2.getName(), OperatorNameConventions.INSTANCE.getINVOKE()) ^ true || !(descriptor2 instanceof FunctionDescriptor)) {
            return false;
        }
        FunctionDescriptor real = (FunctionDescriptor)descriptor2;
        while (!real.getKind().isReal()) {
            if ((FunctionDescriptor)CollectionsKt.singleOrNull((Iterable)real.getOverriddenDescriptors()) != null) continue;
            return false;
        }
        return Intrinsics.areEqual((Object)real.getKind(), (Object)CallableMemberDescriptor.Kind.SYNTHESIZED) && real.getContainingDeclaration() instanceof FunctionClassDescriptor;
    }
}

