/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorVisitor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"y\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003!\u0001R!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001c\u0003\u0006\u0003\u0011\tQ!\u0001\u0005\u0013\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0019Q!\u0001\u0007\u0002\u000b\u0001a\u0001\u0001e\f\u001a\u0003a\u0005Q\u0014a\f\"\u000e%\u0019\u0001\"A\u0007\u00021\u0007\t6!\u0001\u0005\u0003KA!\u0011\u0001c\u0003\u000e\u0003a1\u0011d\u0001E\u0007\u001b\u0005Ar!G\u0002\t\u00105\t\u0001\u0004C\r\u0004\u0011#i\u0011\u0001G\u0005&)!MQ\u0002B\u0005\u0002\t\u0007a\t\u0001\u0007\u0006\u001a\u0007!UQ\"\u0001\r\b3\rA\t\"D\u0001\u0019\u0013e)A!\u0001E\b\u001b\ta\t\u0001\u0007\u0005&%!YQ\u0002B\u0005\u0002\t\u0007a\t\u0001g\u0006\u001a\u0007!UQ\"\u0001\r\b3\rA\t\"D\u0001\u0019\u0013e\u0019\u0001rB\u0007\u00021!)#\u0003\u0003\u0007\u000e\t%\tA1\u0001G\u00011/I2\u0001#\u0005\u000e\u0003aI\u0011d\u0001E\r\u001b\u0005AR\"G\u0002\t\u001c5\t\u0001DD\u0013\u0018\t\u0005Ai\"\u0004\u0007\n\u000b%!\u0011BA\u0005\u00021\u001dAz\"C\u0002\n\u00051\u0005\u0001\u0004\u0003G\u00011=I2\u0001#\u0006\u000e\u0003a\u0001\u0012d\u0001E\t\u001b\u0005A\u0012\"\n\u0005\u0005\u0003!\u0005R\"\u0001\r\u00123\rA\u0019#D\u0001\u0019\u001d\u0015FB\u0001\u0001\u0005\u0013\u001b%I!!C\u0001\u0019\u001b%!\u0011bA\u0005\u0002\t\u0007A:\u0002'\n\u001a\u000b!\u0019RbA\u0005\u0002\t\u0007A:#G\u0002\t\u00125\t\u0001$C)\u0004\u0003\u0011!R%\u0006\u0003\u0002\u0011Sia!\u0003\u0003\n\u0007%\tA1\u0001\r\u000b1?I2\u0001C\u000b\u000e\u0003aq\u0011d\u0001E\b\u001b\u0005A\u0002\"G\u0002\t\u00125\t\u0001$C\u0013\u0015\u0011Wi\u0011\u0001\u0007\u0004\u001a\u0007!1R\"\u0001\r\t3\u0011A)\"\u0004\u0002\r\u0002a9\u0011d\u0001E\u0017\u001b\u0005Ar#G\u0002\t\u00125\t\u0001$C\u0015\u000b\t\u0001C\u0001\"A\u0007\u00021\u0007\t6\u0001B\u0003\u0001\u001b\t!)\u0001C\u0002*\u0015\u0011\u0001\u0005\u0002c\u0002\u000e\u0003a!\u0011k\u0001\u0003\u0006\u00015\u0011A\u0011\u0002\u0005\u0006"}, strings={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "getBuiltIns$kotlin_compiler", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "constantValueFactory", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValueFactory;", "getConstantValueFactory$kotlin_compiler", "()Lorg/jetbrains/kotlin/resolve/constants/ConstantValueFactory;", "checkCompileTimeConstant", "", "argumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "evaluateExpression", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "expression", "evaluateToConstantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "getAnnotationArgumentValue", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "getArgumentExpressionsForArrayCall", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "hasSpread", "", "argument", "resolveAnnotationArguments", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolveAnnotationArguments$kotlin_compiler", "resolveAnnotationValueArguments", "resolvedValueArgument", "updateNumberType", "numberType", "statementFilter", "Lorg/jetbrains/kotlin/resolve/StatementFilter;", "Companion"}, moduleName="kotlin-compiler")
public final class ConstantExpressionEvaluator {
    @NotNull
    private final ConstantValueFactory constantValueFactory;
    @NotNull
    private final KotlinBuiltIns builtIns;
    public static final Companion Companion = org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator$Companion.INSTANCE;

    @NotNull
    public final ConstantValueFactory getConstantValueFactory$kotlin_compiler() {
        return this.constantValueFactory;
    }

    public final void updateNumberType(@NotNull KotlinType numberType, @Nullable KtExpression expression, @NotNull StatementFilter statementFilter, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(numberType, "numberType");
        Intrinsics.checkParameterIsNotNull(statementFilter, "statementFilter");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        if (expression == null) {
            return;
        }
        BindingContextUtils.updateRecordedType(numberType, expression, trace, false);
        if (!(expression instanceof KtConstantExpression)) {
            KtExpression deparenthesized = KtPsiUtil.getLastElementDeparenthesized(expression, statementFilter);
            if (deparenthesized != expression) {
                this.updateNumberType(numberType, deparenthesized, statementFilter, trace);
            }
            return;
        }
        this.evaluateExpression(expression, trace, numberType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<ValueParameterDescriptor, ConstantValue<?>> resolveAnnotationArguments$kotlin_compiler(@NotNull ResolvedCall<?> resolvedCall, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        HashMap arguments2 = new HashMap();
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = resolvedCall.getValueArguments().entrySet().iterator();
        while (iterator2.hasNext()) {
            void $receiver;
            void $receiver2;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry2 = entry = iterator2.next();
            ValueParameterDescriptor parameterDescriptor = (ValueParameterDescriptor)$receiver2.getKey();
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> $i$f$component1 = entry;
            ResolvedValueArgument resolvedArgument = (ResolvedValueArgument)$receiver.getValue();
            ValueParameterDescriptor valueParameterDescriptor = parameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "parameterDescriptor");
            ResolvedValueArgument resolvedValueArgument = resolvedArgument;
            Intrinsics.checkExpressionValueIsNotNull(resolvedValueArgument, "resolvedArgument");
            ConstantValue<?> value = this.getAnnotationArgumentValue(trace, valueParameterDescriptor, resolvedValueArgument);
            if (value == null) continue;
            arguments2.put(parameterDescriptor, value);
        }
        return arguments2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ConstantValue<?> getAnnotationArgumentValue(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ResolvedValueArgument resolvedArgument) {
        void destination;
        void $receiver;
        void $receiver2;
        KotlinType constantType;
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(parameterDescriptor, "parameterDescriptor");
        Intrinsics.checkParameterIsNotNull(resolvedArgument, "resolvedArgument");
        KotlinType varargElementType = parameterDescriptor.getVarargElementType();
        boolean argumentsAsVararg = varargElementType != null && !this.hasSpread(resolvedArgument);
        KotlinType kotlinType = constantType = argumentsAsVararg ? varargElementType : parameterDescriptor.getType();
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        List<CompileTimeConstant<?>> compileTimeConstants = this.resolveAnnotationValueArguments(resolvedArgument, kotlinType, trace);
        Iterable iterable = compileTimeConstants;
        void var9_9 = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it2;
            CompileTimeConstant compileTimeConstant = (CompileTimeConstant)item;
            void var14_14 = destination;
            ConstantValue constantValue = it2.toConstantValue(constantType);
            var14_14.add(constantValue);
        }
        List constants = (List)destination;
        if (argumentsAsVararg) {
            if (parameterDescriptor.declaresDefaultValue() && compileTimeConstants.isEmpty()) {
                return null;
            }
            KotlinType kotlinType2 = parameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "parameterDescriptor.type");
            return this.constantValueFactory.createArrayValue(constants, kotlinType2);
        }
        return (ConstantValue)CollectionsKt.lastOrNull(constants);
    }

    private final void checkCompileTimeConstant(KtExpression argumentExpression, KotlinType expectedType, BindingTrace trace) {
        Pair<List<? extends KtExpression>, KotlinType> arrayArgument;
        KotlinType expressionType = trace.getType(argumentExpression);
        if (expressionType == null || !KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType, expectedType)) {
            return;
        }
        if (argumentExpression instanceof KtCallExpression && (arrayArgument = this.getArgumentExpressionsForArrayCall((KtCallExpression)argumentExpression, trace)) != null) {
            for (KtExpression ktExpression : arrayArgument.getFirst()) {
                KotlinType kotlinType = arrayArgument.getSecond();
                if (kotlinType == null) {
                    Intrinsics.throwNpe();
                }
                this.checkCompileTimeConstant(ktExpression, kotlinType, trace);
            }
        }
        BindingContext bindingContext2 = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "trace.bindingContext");
        CompileTimeConstant<?> constant = Companion.getConstant(argumentExpression, bindingContext2);
        if (constant != null && constant.getCanBeUsedInAnnotations()) {
            if (constant.getUsesNonConstValAsConstant()) {
                trace.report(Errors.NON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION.on((KtExpression)((PsiElement)argumentExpression)));
            }
            return;
        }
        ClassifierDescriptor classifierDescriptor = expressionType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null && DescriptorUtils.isEnumClass(classifierDescriptor)) {
            trace.report(Errors.ANNOTATION_PARAMETER_MUST_BE_ENUM_CONST.on((KtExpression)((PsiElement)argumentExpression)));
        } else if (classifierDescriptor instanceof ClassDescriptor && KotlinBuiltIns.isKClass((ClassDescriptor)classifierDescriptor)) {
            trace.report(Errors.ANNOTATION_PARAMETER_MUST_BE_KCLASS_LITERAL.on((KtExpression)((PsiElement)argumentExpression)));
        } else {
            trace.report(Errors.ANNOTATION_PARAMETER_MUST_BE_CONST.on((KtExpression)((PsiElement)argumentExpression)));
        }
    }

    private final Pair<List<? extends KtExpression>, KotlinType> getArgumentExpressionsForArrayCall(KtCallExpression expression, BindingTrace trace) {
        KtElement ktElement = expression;
        BindingContext bindingContext2 = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(ktElement, bindingContext2);
        if (resolvedCall == null || !CompileTimeConstantUtils.isArrayMethodCall(resolvedCall)) {
            return null;
        }
        Map.Entry argumentEntry = (Map.Entry)CollectionsKt.single((Iterable)resolvedCall.getValueArguments().entrySet());
        KotlinType kotlinType = ((ValueParameterDescriptor)argumentEntry.getKey()).getVarargElementType();
        if (kotlinType == null) {
            return null;
        }
        KotlinType elementType = kotlinType;
        ArrayList<KtExpression> result2 = CollectionsKt.arrayListOf(new KtExpression[0]);
        for (ValueArgument valueArgument : ((ResolvedValueArgument)argumentEntry.getValue()).getArguments()) {
            KtExpression valueArgumentExpression = valueArgument.getArgumentExpression();
            if (valueArgumentExpression == null) continue;
            result2.add(valueArgumentExpression);
        }
        return new Pair<List<? extends KtExpression>, KotlinType>(result2, elementType);
    }

    private final boolean hasSpread(ResolvedValueArgument argument) {
        List<ValueArgument> arguments2 = argument.getArguments();
        return arguments2.size() == 1 && arguments2.get(0).getSpreadElement() != null;
    }

    private final List<CompileTimeConstant<?>> resolveAnnotationValueArguments(ResolvedValueArgument resolvedValueArgument, KotlinType expectedType, BindingTrace trace) {
        ArrayList constants = new ArrayList();
        for (ValueArgument argument : resolvedValueArgument.getArguments()) {
            KtExpression argumentExpression;
            if (argument.getArgumentExpression() == null) {
                continue;
            }
            CompileTimeConstant<?> constant = this.evaluateExpression(argumentExpression, trace, expectedType);
            if (constant instanceof IntegerValueTypeConstant) {
                KotlinType defaultType2 = ((IntegerValueTypeConstant)constant).getType(expectedType);
                this.updateNumberType(defaultType2, argumentExpression, StatementFilter.Companion.getNONE(), trace);
            }
            if (constant != null) {
                constants.add(constant);
            }
            this.checkCompileTimeConstant(argumentExpression, expectedType, trace);
        }
        return constants;
    }

    @Nullable
    public final CompileTimeConstant<?> evaluateExpression(@NotNull KtExpression expression, @NotNull BindingTrace trace, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        ConstantExpressionEvaluatorVisitor visitor2 = new ConstantExpressionEvaluatorVisitor(this, trace);
        CompileTimeConstant compileTimeConstant = visitor2.evaluate(expression, expectedType);
        if (compileTimeConstant == null) {
            return null;
        }
        CompileTimeConstant constant = compileTimeConstant;
        return !constant.isError() ? constant : (CompileTimeConstant)null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ CompileTimeConstant evaluateExpression$default(ConstantExpressionEvaluator constantExpressionEvaluator, KtExpression ktExpression, BindingTrace bindingTrace, KotlinType kotlinType, int n) {
        if ((n & 4) != 0) {
            kotlinType = TypeUtils.NO_EXPECTED_TYPE;
        }
        return constantExpressionEvaluator.evaluateExpression(ktExpression, bindingTrace, kotlinType);
    }

    @Nullable
    public final ConstantValue<?> evaluateToConstantValue(@NotNull KtExpression expression, @NotNull BindingTrace trace, @NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        CompileTimeConstant<?> compileTimeConstant = this.evaluateExpression(expression, trace, expectedType);
        return compileTimeConstant != null ? compileTimeConstant.toConstantValue(expectedType) : null;
    }

    @NotNull
    public final KotlinBuiltIns getBuiltIns$kotlin_compiler() {
        return this.builtIns;
    }

    public ConstantExpressionEvaluator(@NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        this.builtIns = builtIns;
        this.constantValueFactory = new ConstantValueFactory(this.builtIns);
    }

    @JvmStatic
    @Nullable
    public static final CompileTimeConstant<?> getConstant(@NotNull KtExpression expression, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(bindingContext2, "bindingContext");
        return Companion.getConstant(expression, bindingContext2);
    }

    @JvmStatic
    @Nullable
    public static final CompileTimeConstant<?> getPossiblyErrorConstant(@NotNull KtExpression expression, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(bindingContext2, "bindingContext");
        return Companion.getPossiblyErrorConstant(expression, bindingContext2);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Aaq\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002K=!9\u0001c\u0001\u000e\t%\tA1\u0001G\u00011\tI2\u0001#\u0002\u000e\u0003a\u0019\u0011d\u0001E\u0004\u001b\u0005AB!J\b\u0005\b!%Q\u0002B\u0005\u0002\t\u0007a\t\u0001\u0007\u0002\u001a\u0007!\u0015Q\"\u0001\r\u00043\rA9!D\u0001\u0019\t\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator$Companion;", "", "()V", "getConstant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getPossiblyErrorConstant"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        @JvmStatic
        @Nullable
        public final CompileTimeConstant<?> getConstant(@NotNull KtExpression expression, @NotNull BindingContext bindingContext2) {
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            Intrinsics.checkParameterIsNotNull(bindingContext2, "bindingContext");
            CompileTimeConstant compileTimeConstant = this.getPossiblyErrorConstant(expression, bindingContext2);
            if (compileTimeConstant == null) {
                return null;
            }
            CompileTimeConstant constant = compileTimeConstant;
            return !constant.isError() ? constant : (CompileTimeConstant)null;
        }

        @JvmStatic
        @Nullable
        public final CompileTimeConstant<?> getPossiblyErrorConstant(@NotNull KtExpression expression, @NotNull BindingContext bindingContext2) {
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            Intrinsics.checkParameterIsNotNull(bindingContext2, "bindingContext");
            return (CompileTimeConstant)bindingContext2.get(BindingContext.COMPILE_TIME_VALUE, expression);
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

