/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.descriptors;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.impl.PackageFragmentDescriptorImpl;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.LazyEntity;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyPackageMemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

public class LazyPackageDescriptor
extends PackageFragmentDescriptorImpl
implements LazyEntity {
    private final MemberScope memberScope;
    private final PackageMemberDeclarationProvider declarationProvider;

    public LazyPackageDescriptor(@NotNull ModuleDescriptor module2, @NotNull FqName fqName2, @NotNull ResolveSession resolveSession2, @NotNull PackageMemberDeclarationProvider declarationProvider) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyPackageDescriptor", "<init>"));
        }
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyPackageDescriptor", "<init>"));
        }
        if (resolveSession2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSession", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyPackageDescriptor", "<init>"));
        }
        if (declarationProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationProvider", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyPackageDescriptor", "<init>"));
        }
        super(module2, fqName2);
        this.declarationProvider = declarationProvider;
        this.memberScope = new LazyPackageMemberScope(resolveSession2, declarationProvider, this);
        for (KtFile file : declarationProvider.getPackageFiles()) {
            resolveSession2.getTrace().record(BindingContext.FILE_TO_PACKAGE_FRAGMENT, file, this);
        }
    }

    @Override
    @NotNull
    public MemberScope getMemberScope() {
        MemberScope memberScope2 = this.memberScope;
        if (memberScope2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyPackageDescriptor", "getMemberScope"));
        }
        return memberScope2;
    }

    @Override
    public void forceResolveAllContents() {
        ForceResolveUtil.forceResolveAllContents(this.memberScope);
    }

    @NotNull
    public PackageMemberDeclarationProvider getDeclarationProvider() {
        PackageMemberDeclarationProvider packageMemberDeclarationProvider = this.declarationProvider;
        if (packageMemberDeclarationProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyPackageDescriptor", "getDeclarationProvider"));
        }
        return packageMemberDeclarationProvider;
    }
}

