/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"5\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003!\u0001Q!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\t\f\u0015\u0001Q!\u0001E\u0012\u000b\u0001)\u0011\u0001\u0003\t\u0006\u0003\u0011\u0015Q!\u0001\u0005\u0002\u000b\u0005!y\u0001\u0002\u0001\r\u0001U\u0011A\u0001\u0001E\u0001+\u0011!\t\u0001C\u0001\u0016\u0003a\r\u0011$\u0001\r\u0003C\u000b\t6!\u0001E\u0003K7A\t\"D\u0001\u0019\u0013e\u0019\u00012C\u0007\u00029\u0001I2\u0001\u0003\u0006\u000e\u0003q\u0005\u0011kA\u0001\t\u0016\u0015n\u0001bC\u0007\u00021%I2\u0001c\u0006\u000e\u0003q\u0001\u0011d\u0001\u0005\r\u001b\u0005a\u0002!U\u0002\u0002\u00113)[\u0002B\u0001\t\u001b5!\u0011BA\u0005\u00029\u0001AR!G\u0002\t\u00185\tA\u0004A)\u0004\u0003!mQU\u0003\u0003\u0002\u00119i\u0011\u0001\u0007\u0003\u001a\u0007!uQ\"\u0001\u000f\u0001#\u000e\t\u0001bDS\u000b\t\u0005Ay\"D\u0001\u0019\te\u0019\u0001RD\u0007\u00029\u0001\t6!\u0001\u0005\u0010K'A\u0001#D\u0001\u0019\u0013e\u0019\u00012C\u0007\u00029\u0001\t6!\u0001E\u0011S5!\u0011\t\u0003\u0005\u0004\u001b\u001dI!!C\u0001\u001d\u0001%\u0011\u0011\"\u0001\r\u00051\u000f\t6!A\u0003\u0001SA!\u0011\t\u0003E\u0005\u001b)I!!C\u0001\u001d\u0001%)\u0011\u0002B\u0005\u0003\u0013\u0005a\u0002\u0001G\u0003\u0019\bE\u001b\u0011!\u0002\u0001*\u001b\u0011\u0019\u0005\u0002c\u0003\u000e\t%\u0011\u0011\"\u0001O\u00011\u0019a2%U\u0002\u0004\u001b\t!i\u0001C\u0004*\u001b\u0011\t\u0005\u0002c\u0004\u000e\u000f%\u0011\u0011\"\u0001\u000f\u0001\u0013\tI\u0011\u0001(\u0001\u0019\bE\u001b\u0011!\u0002\u0001*\u0015\u0011\t\u0005\u0002\u0003\u0005\u000e\t%\u0011\u0011\"\u0001\u000f\u00011\u0015\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/kotlin/js/inline/clean/ReferenceTracker;", "Reference", "RemoveCandidate", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNode;", "", "()V", "reachable", "Ljava/util/IdentityHashMap;", "", "referenceFromTo", "", "removable", "", "getRemovable", "()Ljava/util/List;", "removableCandidates", "visited", "addCandidateForRemoval", "", "reference", "candidate", "(Ljava/lang/Object;Lcom/google/dart/compiler/backend/js/ast/JsNode;)V", "addRemovableReference", "referrer", "referenced", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getReferencedBy", "(Ljava/lang/Object;)Ljava/util/Set;", "isKnown", "ref", "(Ljava/lang/Object;)Z", "isReachable", "markReachable", "(Ljava/lang/Object;)V"}, moduleName="kotlin-compiler")
public final class ReferenceTracker<Reference, RemoveCandidate extends JsNode> {
    private final IdentityHashMap<Reference, Boolean> reachable = new IdentityHashMap();
    private final IdentityHashMap<Reference, RemoveCandidate> removableCandidates = new IdentityHashMap();
    private final IdentityHashMap<Reference, Set<Reference>> referenceFromTo = new IdentityHashMap();
    private final Set<Reference> visited = CollectionUtilsKt.IdentitySet();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RemoveCandidate> getRemovable() {
        void var3_3;
        Map.Entry it;
        Map $receiver$iv$iv;
        Map $receiver$iv = this.reachable;
        Map map2 = $receiver$iv;
        Object destination$iv$iv = new LinkedHashMap();
        Iterator iterator2 = MapsKt.iterator($receiver$iv$iv);
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv = iterator2.next();
            it = element$iv$iv;
            if (!((Boolean)it.getValue() == false)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList($receiver$iv.size());
        iterator2 = MapsKt.iterator($receiver$iv$iv);
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv = iterator2.next();
            it = item$iv$iv;
            Object object = destination$iv$iv;
            RemoveCandidate RemoveCandidate = this.removableCandidates.get(it.getKey());
            if (RemoveCandidate == null) {
                Intrinsics.throwNpe();
            }
            JsNode jsNode = (JsNode)RemoveCandidate;
            object.add(jsNode);
        }
        return (List)var3_3;
    }

    public final void addCandidateForRemoval(Reference reference, @NotNull RemoveCandidate candidate) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(candidate, "candidate");
        boolean value$iv = !this.isKnown(reference);
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                String message$iv = "Candidate for removal cannot be reassigned: " + candidate;
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        this.removableCandidates.put(reference, candidate);
        this.reachable.put(reference, false);
    }

    public final void addRemovableReference(Reference referrer, Reference referenced) {
        if (!this.isKnown(referenced)) {
            return;
        }
        this.getReferencedBy(referrer).add(referenced);
        if (this.isReachable(referrer)) {
            this.markReachable(referenced);
        }
    }

    public final void markReachable(Reference reference) {
        Collection destination$iv$iv;
        Object it;
        Iterable $receiver$iv$iv;
        if (!this.isKnown(reference)) {
            return;
        }
        this.visited.add(reference);
        Iterable $receiver$iv = this.getReferencedBy(reference);
        Object object = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = element$iv$iv;
            if (this.visited.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = element$iv$iv;
            if (!(this.isKnown(it) && !this.isReachable(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        object = $receiver$iv.iterator();
        while (object.hasNext()) {
            Object element$iv;
            Object it2 = element$iv = object.next();
            this.markReachable(it2);
        }
        this.visited.remove(reference);
        MapsKt.set(this.reachable, reference, true);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Reference> getReferencedBy(Reference referrer) {
        Set set;
        Map $receiver$iv = this.referenceFromTo;
        Object value$iv = $receiver$iv.get(referrer);
        if (value$iv == null) {
            Set answer$iv = CollectionUtilsKt.IdentitySet();
            $receiver$iv.put(referrer, answer$iv);
            set = answer$iv;
        } else {
            void var3_3;
            set = var3_3;
        }
        Set set2 = set;
        Intrinsics.checkExpressionValueIsNotNull(set2, "referenceFromTo.getOrPut\u2026entitySet<Reference>() })");
        return set2;
    }

    private final boolean isKnown(Reference ref) {
        return this.removableCandidates.containsKey(ref);
    }

    private final boolean isReachable(Reference ref) {
        Boolean bl = this.reachable.get(ref);
        return bl != null ? bl : false;
    }
}

