/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadataKt;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsProgram;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStringLiteral;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"!\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\r\u0003\u0015\tAQ\u0001\u0007\u0001!\u001fI\u0012\u0001'\u0001\u001e\u0002\u001f\t+\"C\u0002\t\u00035\t\u00014A\u0005\u0004\u0011\ti\u0011\u0001'\u0002R\u0007\u0005A1!\u000b\u0006\u0005\u0007\"A!!D\u0001\u0019\u0006E\u001bA!\u0002\u0001\u000e\u0005\u0011\u001d\u0001\u0002B\u0015\u000b\t\rC\u0001\u0012B\u0007\u00021\u0015a2%U\u0002\u0004\u001b\t!Y\u0001\u0003\u0004*\u0015\u0011\u0019\u0005\u0002C\u0001\u000e\u0003a\r\u0011k\u0001\u0003\u0006\u00015\u0011AQ\u0002\u0005\b"}, strings={"Lorg/jetbrains/kotlin/js/translate/expression/InlineMetadata;", "", "tag", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsStringLiteral;", "function", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunction;", "(Lcom/google/dart/compiler/backend/js/ast/JsStringLiteral;Lcom/google/dart/compiler/backend/js/ast/JsFunction;)V", "getFunction", "()Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "functionWithMetadata", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "getFunctionWithMetadata", "()Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "getTag", "()Lcom/google/dart/compiler/backend/js/ast/JsStringLiteral;", "Companion"}, moduleName="kotlin-compiler")
public final class InlineMetadata {
    @NotNull
    private final JsStringLiteral tag;
    @NotNull
    private final JsFunction function;
    public static final Companion Companion = org.jetbrains.kotlin.js.translate.expression.InlineMetadata$Companion.INSTANCE;

    @NotNull
    public final JsExpression getFunctionWithMetadata() {
        List<JsExpression> propertiesList = CollectionsKt.listOf(this.tag, this.function);
        return new JsInvocation((JsExpression)Namer.CREATE_INLINE_FUNCTION, propertiesList);
    }

    @NotNull
    public final JsStringLiteral getTag() {
        return this.tag;
    }

    @NotNull
    public final JsFunction getFunction() {
        return this.function;
    }

    public InlineMetadata(@NotNull JsStringLiteral tag, @NotNull JsFunction function) {
        Intrinsics.checkParameterIsNotNull(tag, "tag");
        Intrinsics.checkParameterIsNotNull(function, "function");
        this.tag = tag;
        this.function = function;
    }

    @JvmStatic
    @NotNull
    public static final InlineMetadata compose(@NotNull JsFunction function, @NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        return Companion.compose(function, descriptor2);
    }

    @JvmStatic
    @Nullable
    public static final InlineMetadata decompose(@Nullable JsExpression expression) {
        return Companion.decompose(expression);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tAaq\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002K1!9\u0001c\u0001\u000e\u0003a\u0011\u0011d\u0001E\u0003\u001b\u0005A2!G\u0002\t\b5\t\u0001\u0004B\u0013\u000b\t\u000fAI!\u0004\u0002\r\u0002a\u0011\u0011\u0004\u0002\u0005\u0006\u001b\ta\t\u0001g\u0003&\u0013\u0011\t\u0001BB\u0007\u0003\u0019\u0003A\"!G\u0002\t\u000e5\t\u0001d\u0002"}, strings={"Lorg/jetbrains/kotlin/js/translate/expression/InlineMetadata$Companion;", "", "()V", "compose", "Lorg/jetbrains/kotlin/js/translate/expression/InlineMetadata;", "function", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunction;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "decompose", "expression", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "decomposeCreateFunctionCall", "call", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsInvocation;"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        @JvmStatic
        @NotNull
        public final InlineMetadata compose(@NotNull JsFunction function, @NotNull CallableDescriptor descriptor2) {
            JsStringLiteral tag;
            Intrinsics.checkParameterIsNotNull(function, "function");
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            JsProgram program = function.getScope().getProgram();
            JsStringLiteral jsStringLiteral = tag = program.getStringLiteral(Namer.getFunctionTag(descriptor2));
            Intrinsics.checkExpressionValueIsNotNull(jsStringLiteral, "tag");
            return new InlineMetadata(jsStringLiteral, function);
        }

        @JvmStatic
        @Nullable
        public final InlineMetadata decompose(@Nullable JsExpression expression) {
            JsExpression jsExpression = expression;
            return jsExpression instanceof JsInvocation ? this.decomposeCreateFunctionCall((JsInvocation)expression) : (InlineMetadata)null;
        }

        private final InlineMetadata decomposeCreateFunctionCall(JsInvocation call) {
            if (Intrinsics.areEqual(Namer.CREATE_INLINE_FUNCTION, call.getQualifier()) ^ true) {
                return null;
            }
            List<JsExpression> arguments2 = call.getArguments();
            Collection $receiver$iv = arguments2;
            if ($receiver$iv.size() != InlineMetadataKt.access$getMETADATA_PROPERTIES_COUNT$p()) {
                return null;
            }
            JsExpression jsExpression = arguments2.get(0);
            if (!(jsExpression instanceof JsStringLiteral)) {
                jsExpression = null;
            }
            JsStringLiteral tag = (JsStringLiteral)jsExpression;
            JsExpression jsExpression2 = arguments2.get(1);
            if (!(jsExpression2 instanceof JsFunction)) {
                jsExpression2 = null;
            }
            JsFunction function = (JsFunction)jsExpression2;
            if (tag == null || function == null) {
                return null;
            }
            return new InlineMetadata(tag, function);
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

