/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.relocated.com.google.common.collect.HashMultimap;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Multimap;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Sets;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.TopLevelDescriptorProvider;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.utils.CollectionsKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"[\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0012\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u0019\u0001I\u0012\u0001'\u0001\"\u0016%\u0019\u0001\"A\u0007\u00021\u0007I1\u0001\u0003\u0002\u000e\u0003a\u0015\u0011kA\u0001\t\u0007\u0015:\u0001rA\u0007\u00021\u0011I2\u0001#\u0003\u000e\u0003a)Q%\u0005E\u0006\u001b\u0005AB!G\u0002\t\r5\t\u0001TB\r\n\u0011\u001diq!\u0003\u0002\n\u0003aA\u0011BA\u0005\u00021#Az!J\n\u0005\u0003!IQ\u0002B\u0005\u0003\u0013\u0005A\"\u0002g\u0005\u001a\u0007!1Q\"\u0001M\u00073\rA)\"D\u0001\u0019\u0011e\u0019\u0001bC\u0007\u00021/)c\u0002B\u0001\t\u00195\t\u0001\u0004B\r\n\u00113iq!\u0003\u0002\n\u0003ai\u0011BA\u0005\u00021)Az!J\u0006\t\u001c5\t\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001G\u0003\u001a\u0007!qQ\"\u0001M\u000fS\u001d!\u0011\t\u0003\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\ti\u0011\u0001'\u0002R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/DeclarationResolver;", "", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "checkRedeclarations", "", "c", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "checkRedeclarationsInPackages", "topLevelDescriptorProvider", "Lorg/jetbrains/kotlin/resolve/lazy/TopLevelDescriptorProvider;", "topLevelFqNames", "Lorg/jetbrains/kotlin/relocated/com/google/common/collect/Multimap;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/psi/KtElement;", "getTopLevelDescriptorsByFqName", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "fqName", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "reportRedeclarations", "descriptorMap", "Lorg/jetbrains/kotlin/name/Name;", "resolveAnnotationsOnFiles", "scopeProvider", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopeProvider;"}, moduleName="kotlin-compiler")
public final class DeclarationResolver {
    private final AnnotationResolver annotationResolver;
    private final BindingTrace trace;

    /*
     * WARNING - void declaration
     */
    public final void resolveAnnotationsOnFiles(@NotNull TopDownAnalysisContext c, @NotNull FileScopeProvider scopeProvider) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(scopeProvider, "scopeProvider");
        Map filesToScope2 = CollectionsKt.keysToMap((Iterable)c.getFiles(), (Function1)new Function1<KtFile, LexicalScope>(scopeProvider){
            final /* synthetic */ FileScopeProvider $scopeProvider;

            @NotNull
            public final LexicalScope invoke(KtFile it) {
                KtFile ktFile = it;
                Intrinsics.checkExpressionValueIsNotNull(ktFile, "it");
                return this.$scopeProvider.getFileResolutionScope(ktFile);
            }
            {
                this.$scopeProvider = fileScopeProvider;
                super(1);
            }
        });
        Iterator iterator2 = MapsKt.iterator(filesToScope2);
        while (iterator2.hasNext()) {
            void $receiver$iv;
            void $receiver$iv2;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            KtFile file = (KtFile)$receiver$iv2.getKey();
            Map.Entry $i$f$component1 = entry;
            LexicalScope fileScope = (LexicalScope)$receiver$iv.getValue();
            this.annotationResolver.resolveAnnotationsWithArguments(fileScope, file.getAnnotationEntries(), this.trace);
            this.annotationResolver.resolveAnnotationsWithArguments(fileScope, file.getDanglingAnnotations(), this.trace);
        }
    }

    public final void checkRedeclarations(@NotNull TopDownAnalysisContext c) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        for (ClassDescriptorWithResolutionScopes classDescriptor : kotlin.collections.CollectionsKt.mutableValues(c.getDeclaredClasses())) {
            HashMultimap descriptorMap = HashMultimap.create();
            for (DeclarationDescriptor desc : ResolutionScope.DefaultImpls.getContributedDescriptors$default(classDescriptor.getUnsubstitutedMemberScope(), null, null, 3)) {
                if (!(desc instanceof ClassDescriptor) && !(desc instanceof PropertyDescriptor)) continue;
                descriptorMap.put(desc.getName(), desc);
            }
            Multimap multimap = descriptorMap;
            Intrinsics.checkExpressionValueIsNotNull(multimap, "descriptorMap");
            this.reportRedeclarations(multimap);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportRedeclarations(Multimap<Name, DeclarationDescriptor> descriptorMap) {
        HashSet<Pair<PsiElement, Name>> redeclarations = Sets.newHashSet();
        for (Name pair : descriptorMap.keySet()) {
            void $receiver$iv;
            Collection<DeclarationDescriptor> descriptors;
            Collection<DeclarationDescriptor> collection = descriptors = descriptorMap.get(pair);
            if ($receiver$iv.size() <= 1) continue;
            for (DeclarationDescriptor descriptor2 : descriptors) {
                if (!(descriptor2 instanceof ClassDescriptor)) continue;
                for (DeclarationDescriptor descriptor22 : descriptors) {
                    if (descriptor2 == descriptor22) continue;
                    PsiElement psiElement2 = DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2);
                    if (psiElement2 == null) {
                        Intrinsics.throwNpe();
                    }
                    redeclarations.add(new Pair<PsiElement, Name>(psiElement2, descriptor2.getName()));
                    if (!(descriptor22 instanceof PropertyDescriptor)) continue;
                    PsiElement psiElement3 = DescriptorToSourceUtils.descriptorToDeclaration(descriptor22);
                    if (psiElement3 == null) {
                        Intrinsics.throwNpe();
                    }
                    redeclarations.add(new Pair<PsiElement, Name>(psiElement3, descriptor22.getName()));
                }
            }
        }
        for (Pair pair : redeclarations) {
            PsiElement first = (PsiElement)pair.component1();
            Name second = (Name)pair.component2();
            this.trace.report(Errors.REDECLARATION.on(first, second.asString()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void checkRedeclarationsInPackages(@NotNull TopLevelDescriptorProvider topLevelDescriptorProvider, @NotNull Multimap<FqName, KtElement> topLevelFqNames) {
        Intrinsics.checkParameterIsNotNull(topLevelDescriptorProvider, "topLevelDescriptorProvider");
        Intrinsics.checkParameterIsNotNull(topLevelFqNames, "topLevelFqNames");
        Iterator<Map.Entry<FqName, Collection<KtElement>>> iterator2 = MapsKt.mutableIterator(topLevelFqNames.asMap());
        while (iterator2.hasNext()) {
            void $receiver$iv;
            void $receiver$iv2;
            void $receiver$iv3;
            Map.Entry<FqName, Collection<KtElement>> entry;
            Map.Entry<FqName, Collection<KtElement>> entry2 = entry = iterator2.next();
            FqName fqName2 = (FqName)$receiver$iv3.getKey();
            Map.Entry<FqName, Collection<KtElement>> $i$f$component1 = entry;
            Collection declarationsOrPackageDirectives = (Collection)$receiver$iv2.getValue();
            if (fqName2.isRoot()) continue;
            FqName fqName3 = fqName2;
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "fqName");
            Set<DeclarationDescriptor> descriptors = this.getTopLevelDescriptorsByFqName(topLevelDescriptorProvider, fqName3, NoLookupLocation.WHEN_CHECK_REDECLARATIONS);
            Collection $i$f$component2 = descriptors;
            if ($receiver$iv.size() <= 1) continue;
            for (KtElement declarationOrPackageDirective : declarationsOrPackageDirectives) {
                PsiElement reportAt = declarationOrPackageDirective instanceof KtPackageDirective ? ((KtPackageDirective)declarationOrPackageDirective).getNameIdentifier() : (PsiElement)declarationOrPackageDirective;
                this.trace.report(Errors.REDECLARATION.on(reportAt, fqName2.shortName().asString()));
            }
        }
    }

    private final Set<DeclarationDescriptor> getTopLevelDescriptorsByFqName(TopLevelDescriptorProvider topLevelDescriptorProvider, FqName fqName2, LookupLocation location2) {
        HashSet<ClassDescriptor> descriptors = new HashSet<ClassDescriptor>();
        CollectionsKt.addIfNotNull((Collection)descriptors, topLevelDescriptorProvider.getPackageFragment(fqName2));
        descriptors.addAll(topLevelDescriptorProvider.getTopLevelClassDescriptors(fqName2, location2));
        return descriptors;
    }

    public DeclarationResolver(@NotNull AnnotationResolver annotationResolver, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(annotationResolver, "annotationResolver");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.annotationResolver = annotationResolver;
        this.trace = trace;
    }
}

