/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.PreliminaryDeclarationVisitor;

public class DataFlowValueFactory {
    private static final IdentifierInfo NO_IDENTIFIER_INFO = new IdentifierInfo(null, DataFlowValue.Kind.OTHER, false){

        public String toString() {
            return "NO_IDENTIFIER_INFO";
        }
    };

    private DataFlowValueFactory() {
    }

    @NotNull
    public static DataFlowValue createDataFlowValue(@NotNull KtExpression expression, @NotNull KotlinType type2, @NotNull ResolutionContext resolutionContext) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (resolutionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression, type2, resolutionContext.trace.getBindingContext(), resolutionContext.scope.getOwnerDescriptor());
        if (dataFlowValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        return dataFlowValue;
    }

    private static boolean isComplexExpression(@NotNull KtExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "isComplexExpression"));
        }
        if (expression instanceof KtBlockExpression || expression instanceof KtIfExpression || expression instanceof KtWhenExpression || expression instanceof KtBinaryExpression && ((KtBinaryExpression)expression).getOperationToken() == KtTokens.ELVIS) {
            return true;
        }
        if (expression instanceof KtParenthesizedExpression) {
            KtExpression deparenthesized = KtPsiUtil.deparenthesize(expression);
            return deparenthesized != null && DataFlowValueFactory.isComplexExpression(deparenthesized);
        }
        return false;
    }

    @NotNull
    public static DataFlowValue createDataFlowValue(@NotNull KtExpression expression, @NotNull KotlinType type2, @NotNull BindingContext bindingContext2, @NotNull DeclarationDescriptor containingDeclarationOrModule) {
        KtConstantExpression constantExpression;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (containingDeclarationOrModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclarationOrModule", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (expression instanceof KtConstantExpression && (constantExpression = (KtConstantExpression)expression).getNode().getElementType() == KtNodeTypes.NULL) {
            DataFlowValue dataFlowValue = DataFlowValue.nullValue(DescriptorUtilsKt.getBuiltIns(containingDeclarationOrModule));
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        if (type2.isError()) {
            DataFlowValue dataFlowValue = DataFlowValue.ERROR;
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        if (KotlinBuiltIns.isNullableNothing(type2)) {
            DataFlowValue dataFlowValue = DataFlowValue.nullValue(DescriptorUtilsKt.getBuiltIns(containingDeclarationOrModule));
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        if (ExpressionTypingUtils.isExclExclExpression(KtPsiUtil.deparenthesize(expression))) {
            DataFlowValue dataFlowValue = new DataFlowValue(expression, type2, DataFlowValue.Kind.OTHER, Nullability.NOT_NULL);
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        if (DataFlowValueFactory.isComplexExpression(expression)) {
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValueForComplexExpression(expression, type2);
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        IdentifierInfo result2 = DataFlowValueFactory.getIdForStableIdentifier(expression, bindingContext2, containingDeclarationOrModule);
        DataFlowValue dataFlowValue = new DataFlowValue(result2 == NO_IDENTIFIER_INFO ? expression : result2.id, type2, result2.kind, DataFlowValueFactory.getImmanentNullability(type2));
        if (dataFlowValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        return dataFlowValue;
    }

    @NotNull
    public static DataFlowValue createDataFlowValueForStableReceiver(@NotNull ReceiverValue receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValueForStableReceiver"));
        }
        KotlinType type2 = receiver.getType();
        DataFlowValue dataFlowValue = new DataFlowValue(receiver, type2, DataFlowValue.Kind.STABLE_VALUE, DataFlowValueFactory.getImmanentNullability(type2));
        if (dataFlowValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValueForStableReceiver"));
        }
        return dataFlowValue;
    }

    @NotNull
    public static DataFlowValue createDataFlowValue(@NotNull ReceiverValue receiverValue, @NotNull ResolutionContext resolutionContext) {
        if (receiverValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValue", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (resolutionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiverValue, resolutionContext.trace.getBindingContext(), resolutionContext.scope.getOwnerDescriptor());
        if (dataFlowValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        return dataFlowValue;
    }

    @NotNull
    public static DataFlowValue createDataFlowValue(@NotNull ReceiverValue receiverValue, @NotNull BindingContext bindingContext2, @NotNull DeclarationDescriptor containingDeclarationOrModule) {
        if (receiverValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValue", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (containingDeclarationOrModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclarationOrModule", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (receiverValue instanceof TransientReceiver || receiverValue instanceof ImplicitReceiver) {
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValueForStableReceiver(receiverValue);
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        if (receiverValue instanceof ExpressionReceiver) {
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(((ExpressionReceiver)receiverValue).getExpression(), receiverValue.getType(), bindingContext2, containingDeclarationOrModule);
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        throw new UnsupportedOperationException("Unsupported receiver value: " + receiverValue.getClass().getName());
    }

    @NotNull
    public static DataFlowValue createDataFlowValueForProperty(@NotNull KtProperty property, @NotNull VariableDescriptor variableDescriptor, @NotNull BindingContext bindingContext2, @Nullable ModuleDescriptor usageContainingModule) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValueForProperty"));
        }
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValueForProperty"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValueForProperty"));
        }
        KotlinType type2 = variableDescriptor.getType();
        DataFlowValue dataFlowValue = new DataFlowValue(variableDescriptor, type2, DataFlowValueFactory.variableKind(variableDescriptor, usageContainingModule, bindingContext2, property), DataFlowValueFactory.getImmanentNullability(type2));
        if (dataFlowValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValueForProperty"));
        }
        return dataFlowValue;
    }

    @NotNull
    private static DataFlowValue createDataFlowValueForComplexExpression(@NotNull KtExpression expression, @NotNull KotlinType type2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValueForComplexExpression"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValueForComplexExpression"));
        }
        DataFlowValue dataFlowValue = new DataFlowValue(expression, type2, DataFlowValue.Kind.STABLE_COMPLEX_EXPRESSION, DataFlowValueFactory.getImmanentNullability(type2));
        if (dataFlowValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createDataFlowValueForComplexExpression"));
        }
        return dataFlowValue;
    }

    @NotNull
    private static Nullability getImmanentNullability(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getImmanentNullability"));
        }
        Nullability nullability = TypeUtils.isNullableType(type2) ? Nullability.UNKNOWN : Nullability.NOT_NULL;
        if (nullability == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getImmanentNullability"));
        }
        return nullability;
    }

    @NotNull
    private static IdentifierInfo createInfo(Object id, DataFlowValue.Kind kind) {
        IdentifierInfo identifierInfo = new IdentifierInfo(id, kind, false);
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createInfo"));
        }
        return identifierInfo;
    }

    @NotNull
    private static IdentifierInfo createStableInfo(Object id) {
        IdentifierInfo identifierInfo = DataFlowValueFactory.createInfo(id, DataFlowValue.Kind.STABLE_VALUE);
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createStableInfo"));
        }
        return identifierInfo;
    }

    @NotNull
    private static IdentifierInfo createPackageOrClassInfo(Object id) {
        IdentifierInfo identifierInfo = new IdentifierInfo(id, DataFlowValue.Kind.STABLE_VALUE, true);
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createPackageOrClassInfo"));
        }
        return identifierInfo;
    }

    @NotNull
    private static IdentifierInfo combineInfo(@Nullable IdentifierInfo receiverInfo, @NotNull IdentifierInfo selectorInfo) {
        if (selectorInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "combineInfo"));
        }
        if (selectorInfo.id == null || receiverInfo == NO_IDENTIFIER_INFO) {
            IdentifierInfo identifierInfo = NO_IDENTIFIER_INFO;
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "combineInfo"));
            }
            return identifierInfo;
        }
        if (receiverInfo == null || receiverInfo.isPackage) {
            IdentifierInfo identifierInfo = selectorInfo;
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "combineInfo"));
            }
            return identifierInfo;
        }
        IdentifierInfo identifierInfo = DataFlowValueFactory.createInfo(Pair.create(receiverInfo.id, selectorInfo.id), receiverInfo.kind.isStable() ? selectorInfo.kind : DataFlowValue.Kind.OTHER);
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "combineInfo"));
        }
        return identifierInfo;
    }

    @NotNull
    private static IdentifierInfo createPostfixInfo(@NotNull KtPostfixExpression expression, @NotNull IdentifierInfo argumentInfo) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createPostfixInfo"));
        }
        if (argumentInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createPostfixInfo"));
        }
        if (argumentInfo == NO_IDENTIFIER_INFO) {
            IdentifierInfo identifierInfo = NO_IDENTIFIER_INFO;
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createPostfixInfo"));
            }
            return identifierInfo;
        }
        IdentifierInfo identifierInfo = DataFlowValueFactory.createInfo(Pair.create(expression, argumentInfo.id), argumentInfo.kind);
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "createPostfixInfo"));
        }
        return identifierInfo;
    }

    @NotNull
    private static IdentifierInfo getIdForStableIdentifier(@Nullable KtExpression expression, @NotNull BindingContext bindingContext2, @NotNull DeclarationDescriptor containingDeclarationOrModule) {
        KtPostfixExpression postfixExpression;
        IElementType operationType;
        KtExpression deparenthesized;
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
        }
        if (containingDeclarationOrModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclarationOrModule", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
        }
        if (expression != null && expression != (deparenthesized = KtPsiUtil.deparenthesize(expression))) {
            IdentifierInfo identifierInfo = DataFlowValueFactory.getIdForStableIdentifier(deparenthesized, bindingContext2, containingDeclarationOrModule);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
            }
            return identifierInfo;
        }
        if (expression instanceof KtQualifiedExpression) {
            KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)expression;
            KtExpression receiverExpression = qualifiedExpression.getReceiverExpression();
            KtExpression selectorExpression = qualifiedExpression.getSelectorExpression();
            IdentifierInfo receiverId = DataFlowValueFactory.getIdForStableIdentifier(receiverExpression, bindingContext2, containingDeclarationOrModule);
            IdentifierInfo selectorId = DataFlowValueFactory.getIdForStableIdentifier(selectorExpression, bindingContext2, containingDeclarationOrModule);
            IdentifierInfo identifierInfo = DataFlowValueFactory.combineInfo(receiverId, selectorId);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
            }
            return identifierInfo;
        }
        if (expression instanceof KtSimpleNameExpression) {
            IdentifierInfo identifierInfo = DataFlowValueFactory.getIdForSimpleNameExpression((KtSimpleNameExpression)expression, bindingContext2, containingDeclarationOrModule);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
            }
            return identifierInfo;
        }
        if (expression instanceof KtThisExpression) {
            KtThisExpression thisExpression = (KtThisExpression)expression;
            DeclarationDescriptor declarationDescriptor = bindingContext2.get(BindingContext.REFERENCE_TARGET, thisExpression.getInstanceReference());
            IdentifierInfo identifierInfo = DataFlowValueFactory.getIdForThisReceiver(declarationDescriptor);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
            }
            return identifierInfo;
        }
        if (expression instanceof KtPostfixExpression && ((operationType = (postfixExpression = (KtPostfixExpression)expression).getOperationReference().getReferencedNameElementType()) == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS)) {
            IdentifierInfo identifierInfo = DataFlowValueFactory.createPostfixInfo(postfixExpression, DataFlowValueFactory.getIdForStableIdentifier(postfixExpression.getBaseExpression(), bindingContext2, containingDeclarationOrModule));
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
            }
            return identifierInfo;
        }
        IdentifierInfo identifierInfo = NO_IDENTIFIER_INFO;
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForStableIdentifier"));
        }
        return identifierInfo;
    }

    @NotNull
    private static IdentifierInfo getIdForSimpleNameExpression(@NotNull KtSimpleNameExpression simpleNameExpression, @NotNull BindingContext bindingContext2, @NotNull DeclarationDescriptor containingDeclarationOrModule) {
        if (simpleNameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleNameExpression", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
        }
        if (containingDeclarationOrModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclarationOrModule", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
        }
        DeclarationDescriptor declarationDescriptor = bindingContext2.get(BindingContext.REFERENCE_TARGET, simpleNameExpression);
        if (declarationDescriptor instanceof VariableDescriptor) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(simpleNameExpression, bindingContext2);
            ModuleDescriptor usageModuleDescriptor = DescriptorUtils.getContainingModuleOrNull(containingDeclarationOrModule);
            IdentifierInfo receiverInfo = resolvedCall != null ? DataFlowValueFactory.getIdForImplicitReceiver(resolvedCall.getDispatchReceiver(), simpleNameExpression) : null;
            VariableDescriptor variableDescriptor = (VariableDescriptor)declarationDescriptor;
            IdentifierInfo identifierInfo = DataFlowValueFactory.combineInfo(receiverInfo, DataFlowValueFactory.createInfo(variableDescriptor, DataFlowValueFactory.variableKind(variableDescriptor, usageModuleDescriptor, bindingContext2, simpleNameExpression)));
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
            }
            return identifierInfo;
        }
        if (declarationDescriptor instanceof PackageViewDescriptor || declarationDescriptor instanceof ClassDescriptor) {
            IdentifierInfo identifierInfo = DataFlowValueFactory.createPackageOrClassInfo(declarationDescriptor);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
            }
            return identifierInfo;
        }
        IdentifierInfo identifierInfo = NO_IDENTIFIER_INFO;
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
        }
        return identifierInfo;
    }

    @Nullable
    private static IdentifierInfo getIdForImplicitReceiver(@Nullable ReceiverValue receiverValue, @Nullable KtExpression expression) {
        if (receiverValue instanceof ImplicitReceiver) {
            return DataFlowValueFactory.getIdForThisReceiver(((ImplicitReceiver)receiverValue).getDeclarationDescriptor());
        }
        assert (!(receiverValue instanceof TransientReceiver)) : "Transient receiver is implicit for an explicit expression: " + expression + ". Receiver: " + receiverValue;
        return null;
    }

    @NotNull
    private static IdentifierInfo getIdForThisReceiver(@Nullable DeclarationDescriptor descriptorOfThisReceiver) {
        if (descriptorOfThisReceiver instanceof CallableDescriptor) {
            ReceiverParameterDescriptor receiverParameter = ((CallableDescriptor)descriptorOfThisReceiver).getExtensionReceiverParameter();
            assert (receiverParameter != null) : "'This' refers to the callable member without a receiver parameter: " + descriptorOfThisReceiver;
            IdentifierInfo identifierInfo = DataFlowValueFactory.createStableInfo(receiverParameter.getValue());
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForThisReceiver"));
            }
            return identifierInfo;
        }
        if (descriptorOfThisReceiver instanceof ClassDescriptor) {
            IdentifierInfo identifierInfo = DataFlowValueFactory.createStableInfo(((ClassDescriptor)descriptorOfThisReceiver).getThisAsReceiverParameter().getValue());
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForThisReceiver"));
            }
            return identifierInfo;
        }
        IdentifierInfo identifierInfo = NO_IDENTIFIER_INFO;
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getIdForThisReceiver"));
        }
        return identifierInfo;
    }

    @NotNull
    private static DeclarationDescriptor getVariableContainingDeclaration(@NotNull VariableDescriptor variableDescriptor) {
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getVariableContainingDeclaration"));
        }
        DeclarationDescriptor containingDeclarationDescriptor = variableDescriptor.getContainingDeclaration();
        if (containingDeclarationDescriptor instanceof ConstructorDescriptor && ((ConstructorDescriptor)containingDeclarationDescriptor).isPrimary()) {
            containingDeclarationDescriptor = containingDeclarationDescriptor.getContainingDeclaration();
            assert (containingDeclarationDescriptor != null) : "No containing declaration for primary constructor";
        }
        DeclarationDescriptor declarationDescriptor = containingDeclarationDescriptor;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "getVariableContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    private static boolean isAccessedInsideClosure(@NotNull DeclarationDescriptor variableContainingDeclaration, @NotNull BindingContext bindingContext2, @NotNull KtElement accessElement) {
        if (variableContainingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableContainingDeclaration", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "isAccessedInsideClosure"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "isAccessedInsideClosure"));
        }
        if (accessElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessElement", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "isAccessedInsideClosure"));
        }
        for (PsiElement parent2 = accessElement.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            if (!(parent2 instanceof KtDeclarationWithBody) && !(parent2 instanceof KtClassOrObject)) continue;
            DeclarationDescriptor descriptor2 = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, parent2);
            if (variableContainingDeclaration.equals(descriptor2)) break;
            return true;
        }
        return false;
    }

    private static boolean isAccessedBeforeAllClosureWriters(@NotNull DeclarationDescriptor variableContainingDeclaration, @NotNull Set<KtDeclaration> writers, @NotNull BindingContext bindingContext2, @NotNull KtElement accessElement) {
        if (variableContainingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableContainingDeclaration", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "isAccessedBeforeAllClosureWriters"));
        }
        if (writers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writers", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "isAccessedBeforeAllClosureWriters"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "isAccessedBeforeAllClosureWriters"));
        }
        if (accessElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessElement", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "isAccessedBeforeAllClosureWriters"));
        }
        for (KtDeclaration writer : writers) {
            DeclarationDescriptor writerDescriptor = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, writer);
            if (variableContainingDeclaration.equals(writerDescriptor) || PsiUtilsKt.before(accessElement, writer)) continue;
            return false;
        }
        return true;
    }

    private static DataFlowValue.Kind propertyKind(@NotNull PropertyDescriptor propertyDescriptor, @Nullable ModuleDescriptor usageModule) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "propertyKind"));
        }
        if (propertyDescriptor.isVar()) {
            return DataFlowValue.Kind.MUTABLE_PROPERTY;
        }
        if (ModalityKt.isOverridable(propertyDescriptor)) {
            return DataFlowValue.Kind.PROPERTY_WITH_GETTER;
        }
        if (!DataFlowValueFactory.hasDefaultGetter(propertyDescriptor)) {
            return DataFlowValue.Kind.PROPERTY_WITH_GETTER;
        }
        if (!DataFlowValueFactory.invisibleFromOtherModules(propertyDescriptor)) {
            ModuleDescriptor declarationModule = DescriptorUtils.getContainingModule(propertyDescriptor);
            if (usageModule == null || !usageModule.equals(declarationModule)) {
                return DataFlowValue.Kind.ALIEN_PUBLIC_PROPERTY;
            }
        }
        return DataFlowValue.Kind.STABLE_VALUE;
    }

    private static DataFlowValue.Kind variableKind(@NotNull VariableDescriptor variableDescriptor, @Nullable ModuleDescriptor usageModule, @NotNull BindingContext bindingContext2, @NotNull KtElement accessElement) {
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "variableKind"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "variableKind"));
        }
        if (accessElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessElement", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "variableKind"));
        }
        if (variableDescriptor instanceof PropertyDescriptor) {
            return DataFlowValueFactory.propertyKind((PropertyDescriptor)variableDescriptor, usageModule);
        }
        if (!(variableDescriptor instanceof LocalVariableDescriptor) && !(variableDescriptor instanceof ParameterDescriptor)) {
            return DataFlowValue.Kind.OTHER;
        }
        if (!variableDescriptor.isVar()) {
            return DataFlowValue.Kind.STABLE_VALUE;
        }
        if (variableDescriptor instanceof SyntheticFieldDescriptor) {
            return DataFlowValue.Kind.MUTABLE_PROPERTY;
        }
        PreliminaryDeclarationVisitor preliminaryVisitor = PreliminaryDeclarationVisitor.Companion.getVisitorByVariable(variableDescriptor, bindingContext2);
        if (preliminaryVisitor == null) {
            return DataFlowValue.Kind.UNPREDICTABLE_VARIABLE;
        }
        Set<KtDeclaration> writers = preliminaryVisitor.writers(variableDescriptor);
        if (writers.isEmpty()) {
            return DataFlowValue.Kind.PREDICTABLE_VARIABLE;
        }
        DeclarationDescriptor variableContainingDeclaration = DataFlowValueFactory.getVariableContainingDeclaration(variableDescriptor);
        if (DataFlowValueFactory.isAccessedInsideClosure(variableContainingDeclaration, bindingContext2, accessElement)) {
            return DataFlowValue.Kind.UNPREDICTABLE_VARIABLE;
        }
        if (DataFlowValueFactory.isAccessedBeforeAllClosureWriters(variableContainingDeclaration, writers, bindingContext2, accessElement)) {
            return DataFlowValue.Kind.PREDICTABLE_VARIABLE;
        }
        return DataFlowValue.Kind.UNPREDICTABLE_VARIABLE;
    }

    public static boolean isStableValue(@NotNull VariableDescriptor variableDescriptor, @Nullable ModuleDescriptor usageModule) {
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "isStableValue"));
        }
        if (variableDescriptor.isVar()) {
            return false;
        }
        if (variableDescriptor instanceof PropertyDescriptor) {
            return DataFlowValueFactory.propertyKind((PropertyDescriptor)variableDescriptor, usageModule) == DataFlowValue.Kind.STABLE_VALUE;
        }
        return true;
    }

    private static boolean invisibleFromOtherModules(@NotNull DeclarationDescriptorWithVisibility descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory", "invisibleFromOtherModules"));
        }
        if (Visibilities.INVISIBLE_FROM_OTHER_MODULES.contains(descriptor2.getVisibility())) {
            return true;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (!(containingDeclaration instanceof DeclarationDescriptorWithVisibility)) {
            return false;
        }
        return DataFlowValueFactory.invisibleFromOtherModules((DeclarationDescriptorWithVisibility)containingDeclaration);
    }

    private static boolean hasDefaultGetter(PropertyDescriptor propertyDescriptor) {
        PropertyGetterDescriptor getter = propertyDescriptor.getGetter();
        return getter == null || getter.isDefault();
    }

    private static class IdentifierInfo {
        public final Object id;
        public final DataFlowValue.Kind kind;
        public final boolean isPackage;

        private IdentifierInfo(Object id, DataFlowValue.Kind kind, boolean isPackage) {
            this.id = id;
            this.kind = kind;
            this.isPackage = isPackage;
        }
    }
}

