/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.declarations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypedef;
import org.jetbrains.kotlin.relocated.com.google.common.collect.ArrayListMultimap;
import org.jetbrains.kotlin.resolve.lazy.ResolveSessionUtils;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassInfoUtil;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.data.KtScriptInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProvider;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"Y\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\"A\u0003\u0001\u000b\u0005Aq\"B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\t\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\t\u00012B\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001\u0001\u0003\u0014\u0019\u0001I\u0012\u0001'\u0001\u001e\u00027\tk!C\u0002\t\u00035\t\u00014A)\u0004\u0003!\u0011Q\u0005\u0003\u0003\u0013\u0011\u0011i\u0011\u0001'\u0003\u001a\u0007!\u0015Q\"\u0001M\u0004K-!1\u0002C\u0003\u000e\t%\u0011\u0011\"\u0001\r\u00071\u0017I2\u0001#\u0004\u000e\u0003a9Q%\u0006\u0003\f\u0011\u001fiA!\u0003\u0002\n\u0003aE\u0001\u0004C\r\u0004\u0011%i\u0011\u0001g\u0005\u001a\u0013!QQbB\u0005\u0003\u0013\u0005Ar!\u0003\u0002\n\u0003aY\u0001TC\u0013\f\t-A9\"\u0004\u0003\n\u0005%\t\u0001\u0004\u0004\r\t3\rAi!D\u0001\u0019\u000f\u0015ZAa\u0003E\r\u001b\u0011I!!C\u0001\u0019\u001baA\u0011d\u0001E\u0007\u001b\u0005Ar!\u000b\u0006\u0005\u0003\"A)!\u0004\u0003\n\u0005%\t\u0001t\u0001\r\u0004#\u000e\tQ\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/DeclarationProvider;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "(Lorg/jetbrains/kotlin/storage/StorageManager;)V", "index", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider$Index;", "doCreateIndex", "", "getClassOrObjectDeclarations", "", "Lorg/jetbrains/kotlin/resolve/lazy/data/KtClassLikeInfo;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getDeclarations", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "kindFilter", "Lorg/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;", "nameFilter", "Lkotlin/Function1;", "", "getFunctionDeclarations", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "getPropertyDeclarations", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Index"}, moduleName="kotlin-compiler")
public abstract class AbstractPsiBasedDeclarationProvider
implements DeclarationProvider {
    private final NotNullLazyValue<Index> index;

    protected abstract void doCreateIndex(@NotNull Index var1);

    @Override
    @NotNull
    public List<KtDeclaration> getDeclarations(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkParameterIsNotNull(kindFilter, "kindFilter");
        Intrinsics.checkParameterIsNotNull(nameFilter, "nameFilter");
        return ((Index)this.index.invoke()).getAllDeclarations();
    }

    @NotNull
    public List<KtNamedFunction> getFunctionDeclarations(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return CollectionsKt.toList(((Index)this.index.invoke()).getFunctions().get((Object)ResolveSessionUtils.safeNameForLazyResolve(name)));
    }

    @NotNull
    public List<KtProperty> getPropertyDeclarations(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return CollectionsKt.toList(((Index)this.index.invoke()).getProperties().get((Object)ResolveSessionUtils.safeNameForLazyResolve(name)));
    }

    @Override
    @NotNull
    public Collection<KtClassLikeInfo> getClassOrObjectDeclarations(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Collection collection = ((Index)this.index.invoke()).getClassesAndObjects().get((Object)ResolveSessionUtils.safeNameForLazyResolve(name));
        Intrinsics.checkExpressionValueIsNotNull(collection, "index().classesAndObject\u2026NameForLazyResolve(name)]");
        return collection;
    }

    public AbstractPsiBasedDeclarationProvider(@NotNull StorageManager storageManager) {
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        this.index = storageManager.createLazyValue((Function0)new Function0<Index>(this){
            final /* synthetic */ AbstractPsiBasedDeclarationProvider this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Index invoke() {
                void var1_1;
                Index index2 = new Index();
                this.this$0.doCreateIndex(index2);
                return var1_1;
            }
            {
                this.this$0 = abstractPsiBasedDeclarationProvider;
                super(0);
            }
        });
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"A\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0002\u000b\u0001!!\u0001\u0004\u0001\u001a\u0003a\u0005\u0011UA)\u0004\u0003!\tQe\u0002E\u000b\u001b\u0005A2\"G\u0002\t\u00185\t\u0001TA\u0015\u000e\t\rC\u00012A\u0007\u0005\u0013\tI\u0011\u0001'\u0002\u0019\u0005E\u001bA!\u0002\u0001\u000e\u0005\u0011\u0019\u0001rA\u0015+\t\rC\u0001\u0002B\u0007\"\u0013\u0019IQ\u0001e\u0003\u0016\u00051\u0005\u0001$\u0002\r\u0006\u0013\u0019IQ\u0001e\u0003\u0016\u00051\u0005\u0001D\u0002\r\u0007!\u0017)\u0002#\u0003\u0004\n\u000bA-QC\u0001G\u00011\u0015AR!\u0003\u0004\n\u000bA-QC\u0001G\u00011\u0019Ab\u0001$\u0001\u0019\na%\u0011k\u0001\u0003\u0006\u00015\u0011AQ\u0002\u0005\bS)\"1\t\u0003E\b\u001b\u0005Ja!C\u0003\u0011\fU\u0011A\u0012\u0001\r\u00061\u0015Ia!C\u0003\u0011\fU\u0011A\u0012\u0001\r\t1!\u0001Z!\u0006\t\n\r%)\u00013B\u000b\u0003\u0019\u0003AR\u0001G\u0003\n\r%)\u00013B\u000b\u0003\u0019\u0003A\u0002\u0002\u0007\u0005\r\u0002a%\u0001\u0014B)\u0004\t\u0015\u0001QB\u0001C\t\u0011\u001dI#\u0006B\"\t\u0011%i\u0011%\u0003\u0004\n\u000bA-QC\u0001G\u00011\u0015AR!\u0003\u0004\n\u000bA-QC\u0001G\u00011'A\u001a\u0002e\u0003\u0016!%1\u0011\"\u0002I\u0006+\ta\t\u0001G\u0003\u0019\u000b%1\u0011\"\u0002I\u0006+\ta\t\u0001g\u0005\u0019\u00141\u0005\u0001\u0014\u0002M\u0005#\u000e!Q\u0001A\u0007\u0003\t)Aq\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider$Index;", "", "()V", "allDeclarations", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getAllDeclarations", "()Ljava/util/ArrayList;", "classesAndObjects", "Lorg/jetbrains/kotlin/relocated/com/google/common/collect/ArrayListMultimap;", "Lorg/jetbrains/kotlin/name/Name;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/resolve/lazy/data/KtClassLikeInfo;", "getClassesAndObjects", "()Lcom/google/common/collect/ArrayListMultimap;", "functions", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "getFunctions", "properties", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getProperties", "putToIndex", "", "declaration"}, moduleName="kotlin-compiler")
    protected static final class Index {
        @NotNull
        private final ArrayList<KtDeclaration> allDeclarations = new ArrayList();
        private final ArrayListMultimap<Name, KtNamedFunction> functions = ArrayListMultimap.create();
        private final ArrayListMultimap<Name, KtProperty> properties = ArrayListMultimap.create();
        private final ArrayListMultimap<Name, KtClassLikeInfo> classesAndObjects = ArrayListMultimap.create();

        @NotNull
        public final ArrayList<KtDeclaration> getAllDeclarations() {
            return this.allDeclarations;
        }

        public final ArrayListMultimap<Name, KtNamedFunction> getFunctions() {
            return this.functions;
        }

        public final ArrayListMultimap<Name, KtProperty> getProperties() {
            return this.properties;
        }

        public final ArrayListMultimap<Name, KtClassLikeInfo> getClassesAndObjects() {
            return this.classesAndObjects;
        }

        public final void putToIndex(@NotNull KtDeclaration declaration) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            if (declaration instanceof KtAnonymousInitializer || declaration instanceof KtSecondaryConstructor) {
                return;
            }
            this.allDeclarations.add(declaration);
            if (declaration instanceof KtNamedFunction) {
                this.functions.put((Object)ResolveSessionUtils.safeNameForLazyResolve((KtNamedDeclaration)declaration), declaration);
            } else if (declaration instanceof KtProperty) {
                this.properties.put((Object)ResolveSessionUtils.safeNameForLazyResolve((KtNamedDeclaration)declaration), declaration);
            } else if (declaration instanceof KtClassOrObject) {
                this.classesAndObjects.put((Object)ResolveSessionUtils.safeNameForLazyResolve(((KtClassOrObject)declaration).getNameAsName()), (Object)KtClassInfoUtil.createClassLikeInfo((KtClassOrObject)declaration));
            } else if (declaration instanceof KtScript) {
                KtScriptInfo scriptInfo = new KtScriptInfo((KtScript)declaration);
                this.classesAndObjects.put((Object)scriptInfo.getScript().getNameAsName(), (Object)scriptInfo);
            } else if (!(declaration instanceof KtParameter || declaration instanceof KtTypedef || declaration instanceof KtDestructuringDeclaration)) {
                throw (Throwable)new IllegalArgumentException("Unknown declaration: " + declaration);
            }
        }
    }
}

