/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.JavaTypeSubstitutor;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassifierImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaTypeImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaTypeParameterImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaTypeSubstitutorImpl;

public class JavaClassifierTypeImpl
extends JavaTypeImpl<PsiClassType>
implements JavaClassifierType {
    private ResolutionResult resolutionResult;

    public JavaClassifierTypeImpl(@NotNull PsiClassType psiClassType) {
        if (psiClassType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClassType", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl", "<init>"));
        }
        super(psiClassType);
    }

    @Override
    @Nullable
    public JavaClassifier getClassifier() {
        this.resolve();
        return this.resolutionResult.classifier;
    }

    @Override
    @NotNull
    public JavaTypeSubstitutor getSubstitutor() {
        this.resolve();
        JavaTypeSubstitutor javaTypeSubstitutor = this.resolutionResult.substitutor;
        if (javaTypeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl", "getSubstitutor"));
        }
        return javaTypeSubstitutor;
    }

    private void resolve() {
        if (this.resolutionResult == null) {
            PsiClassType.ClassResolveResult result2 = ((PsiClassType)this.getPsi()).resolveGenerics();
            PsiClass psiClass = result2.getElement();
            PsiSubstitutor substitutor2 = result2.getSubstitutor();
            this.resolutionResult = new ResolutionResult(psiClass == null ? null : JavaClassifierImpl.create(psiClass), new JavaTypeSubstitutorImpl(JavaClassifierTypeImpl.convertSubstitutionMap(substitutor2.getSubstitutionMap())));
        }
    }

    @NotNull
    private static Map<JavaTypeParameter, JavaType> convertSubstitutionMap(@NotNull Map<PsiTypeParameter, PsiType> psiMap) {
        if (psiMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMap", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl", "convertSubstitutionMap"));
        }
        if (psiMap.isEmpty()) {
            Map<JavaTypeParameter, JavaType> map2 = Collections.emptyMap();
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl", "convertSubstitutionMap"));
            }
            return map2;
        }
        HashMap<JavaTypeParameter, JavaType> substitutionMap = new HashMap<JavaTypeParameter, JavaType>();
        for (Map.Entry<PsiTypeParameter, PsiType> entry : psiMap.entrySet()) {
            PsiType value = entry.getValue();
            substitutionMap.put(new JavaTypeParameterImpl(entry.getKey()), value == null ? null : JavaTypeImpl.create(value));
        }
        HashMap<JavaTypeParameter, JavaType> hashMap = substitutionMap;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl", "convertSubstitutionMap"));
        }
        return hashMap;
    }

    @Override
    @NotNull
    public Collection<JavaClassifierType> getSupertypes() {
        PsiType[] psiTypes = ((PsiClassType)this.getPsi()).getSuperTypes();
        if (psiTypes.length == 0) {
            List<JavaClassifierType> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl", "getSupertypes"));
            }
            return list;
        }
        ArrayList<JavaClassifierType> result2 = new ArrayList<JavaClassifierType>(psiTypes.length);
        for (PsiType psiType : psiTypes) {
            if (!(psiType instanceof PsiClassType)) {
                throw new IllegalStateException("Supertype should be a class: " + psiType + ", type: " + this.getPsi());
            }
            result2.add(new JavaClassifierTypeImpl((PsiClassType)psiType));
        }
        ArrayList<JavaClassifierType> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl", "getSupertypes"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        String string = ((PsiClassType)this.getPsi()).getPresentableText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl", "getPresentableText"));
        }
        return string;
    }

    @Override
    public boolean isRaw() {
        return ((PsiClassType)this.getPsi()).isRaw();
    }

    @Override
    @NotNull
    public List<JavaType> getTypeArguments() {
        JavaClassifier classifier2 = this.getClassifier();
        List<PsiTypeParameter> parameters2 = classifier2 instanceof JavaClassImpl ? JavaClassifierTypeImpl.getTypeParameters((PsiClass)((JavaClassImpl)classifier2).getPsi()) : Collections.emptyList();
        JavaTypeSubstitutor substitutor2 = this.getSubstitutor();
        ArrayList<JavaType> result2 = new ArrayList<JavaType>();
        for (PsiTypeParameter typeParameter : parameters2) {
            result2.add(substitutor2.substitute(new JavaTypeParameterImpl(typeParameter)));
        }
        ArrayList<JavaType> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl", "getTypeArguments"));
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiTypeParameter> getTypeParameters(@NotNull PsiClass owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl", "getTypeParameters"));
        }
        ArrayList result2 = null;
        for (PsiClass currentOwner = owner; currentOwner != null; currentOwner = currentOwner.getContainingClass()) {
            PsiTypeParameter[] typeParameters = currentOwner.getTypeParameters();
            if (typeParameters.length > 0) {
                if (result2 == null) {
                    result2 = new ArrayList(typeParameters.length);
                }
                Collections.addAll(result2, typeParameters);
            }
            if (currentOwner.hasModifierProperty("static")) break;
        }
        if (result2 == null) {
            List<PsiTypeParameter> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl", "getTypeParameters"));
            }
            return list;
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl", "getTypeParameters"));
        }
        return arrayList;
    }

    private static class ResolutionResult {
        private final JavaClassifier classifier;
        private final JavaTypeSubstitutor substitutor;

        private ResolutionResult(@Nullable JavaClassifier classifier2, @NotNull JavaTypeSubstitutor substitutor2) {
            if (substitutor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl$ResolutionResult", "<init>"));
            }
            this.classifier = classifier2;
            this.substitutor = substitutor2;
        }
    }
}

