/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast;

import java.util.Collection;
import java.util.Set;
import java.util.Stack;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsScope;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"9\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001\"\u0002\u0006\u0003!\tQ!\u0001\u0003\u0002\u000b\u0005AY!B\u0001\u0005\u0004\u0011YA\u0002\u0001\t\r3\u0005A\n!H\u0001\r\u001a\u0005V\u0011b\u0001\u0005\u0002\u001b\u0005A\n!C\u0002\t\u00045\t\u0001DA)\u0004\u0003!\u0015Q\u0005\u0003\u0003\f\u0011\u0019i\u0011\u0001'\u0004\u001a\u0007!9Q\"\u0001\r\u0003K!!1\u0002c\u0004\u000e\u0003a5\u0011d\u0001\u0005\b\u001b\u0005A\"!\n\u0005\u0005\u0017!AQ\"\u0001M\u00073\rA\t\"D\u0001\u0019\u0005\u0015\"Aa\u0003\u0005\n\u001b\u0005A\u001a\"J\u0005\u0005\u0017!QQB\u0001G\u00011\u001bI2\u0001#\u0005\u000e\u0003a\u0011Q\u0005\u0003\u0003\f\u0011+i\u0011\u0001G\u0006\u001a\u0007!]Q\"\u0001\r\u0003S1!\u0011\t\u0003\u0005\u0004\u001b\u0019IA!C\u0002\u0019\t%\n\u0001\u0004\u0001M\u0004#\u000e\tQ\u0001A\u0015\u000e\t\u0005C\u0001\u0012B\u0007\u0005\u0019\u0003AB!K\u0001\u0019\u0001q\t\u0013kA\u0002\u000e\u0005\u0011)\u00012\u0002"}, strings={"Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunctionScope;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope;", "parent", "description", "", "(Lcom/google/dart/compiler/backend/js/ast/JsScope;Ljava/lang/String;)V", "labelScopes", "Ljava/util/Stack;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunctionScope$LabelScope;", "topLabelScope", "getTopLabelScope", "()Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope$LabelScope;", "declareName", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsName;", "identifier", "declareNameUnsafe", "enterLabel", "label", "exitLabel", "", "findLabel", "hasOwnName", "", "name", "Companion", "LabelScope"}, moduleName="kotlin-compiler")
public class JsFunctionScope
extends JsScope {
    private final Stack<LabelScope> labelScopes;
    @NotNull
    public static final Set<String> RESERVED_WORDS;
    public static final Companion Companion;

    private final LabelScope getTopLabelScope() {
        return CollectionsKt.isNotEmpty((Collection)this.labelScopes) ? this.labelScopes.peek() : (LabelScope)null;
    }

    @Override
    @NotNull
    public JsName declareName(@NotNull String identifier) {
        Intrinsics.checkParameterIsNotNull(identifier, "identifier");
        JsName jsName = super.declareFreshName(identifier);
        Intrinsics.checkExpressionValueIsNotNull(jsName, "super.declareFreshName(identifier)");
        return jsName;
    }

    @Override
    public boolean hasOwnName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return Companion.getRESERVED_WORDS().contains(name) || super.hasOwnName(name);
    }

    @NotNull
    public JsName declareNameUnsafe(@NotNull String identifier) {
        Intrinsics.checkParameterIsNotNull(identifier, "identifier");
        JsName jsName = super.declareName(identifier);
        Intrinsics.checkExpressionValueIsNotNull(jsName, "super.declareName(identifier)");
        return jsName;
    }

    @NotNull
    public JsName enterLabel(@NotNull String label) {
        Intrinsics.checkParameterIsNotNull(label, "label");
        LabelScope scope2 = new LabelScope(this.getTopLabelScope(), label);
        this.labelScopes.push(scope2);
        return scope2.getLabelName();
    }

    public void exitLabel() {
        Unit unit;
        boolean value$iv = CollectionsKt.isNotEmpty((Collection)this.labelScopes);
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                String message$iv = "No scope to exit from";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        this.labelScopes.pop();
    }

    @Nullable
    public JsName findLabel(@NotNull String label) {
        Intrinsics.checkParameterIsNotNull(label, "label");
        LabelScope labelScope = this.getTopLabelScope();
        return labelScope != null ? labelScope.findName(label) : null;
    }

    public JsFunctionScope(@NotNull JsScope parent2, @NotNull String description) {
        Intrinsics.checkParameterIsNotNull(parent2, "parent");
        Intrinsics.checkParameterIsNotNull(description, "description");
        super(parent2, description, null);
        this.labelScopes = new Stack();
    }

    static {
        Companion = org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunctionScope$Companion.INSTANCE;
        RESERVED_WORDS = SetsKt.setOf("await", "break", "case", "catch", "continue", "debugger", "default", "delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "return", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "class", "const", "enum", "export", "extends", "import", "super", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield", "null", "true", "false", "eval", "arguments", "NaN", "Infinity", "undefined", "Kotlin");
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"%\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\b\u000b\u0005!!!B\u0001\r\u0003\u0015\tAQA\u0003\u0002\u0011\u0017!\u0011I\u0001\u0007\u00013\u0005A\n!)\t\n\u0010!\tQ\u0002\u0002G\u00011\u0001I\u0013\u0001g\u0001Q\u0007\u0003II\u0001\u0003\u0002\u000e\u0003a\u0015\u0001kA\u0001R\u0007\u0005A1!J\u0005\u0005\u0015!5QB\u0001G\u00011\u0015I2\u0001C\u0004\u000e\u0003a\u0015Q\u0005\u0003C\f\u0011\u001fi\u0011\u0001\u0007\u0005\u001a\u0007!9Q\"\u0001M\u0003S)!1\t\u0003\u0005\u0003\u001b\u0005A*!U\u0002\u0005\u000b\u0001i!\u0001b\u0002\t\t%RAa\u0011\u0005\t\n5\t\u0001$B)\u0004\t\u0015\u0001QB\u0001C\u0006\u0011\u0019\u0001"}, strings={"Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunctionScope$LabelScope;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope;", "parent", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunctionScope;", "ident", "", "(Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope;Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope$LabelScope;Ljava/lang/String;)V", "getIdent", "()Ljava/lang/String;", "labelName", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsName;", "getLabelName", "()Lcom/google/dart/compiler/backend/js/ast/JsName;", "findOwnName", "name", "hasOwnName", ""}, moduleName="kotlin-compiler")
    private final class LabelScope
    extends JsScope {
        @NotNull
        private final JsName labelName;
        @NotNull
        private final String ident;

        @NotNull
        public final JsName getLabelName() {
            return this.labelName;
        }

        @Override
        @Nullable
        protected JsName findOwnName(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            return Intrinsics.areEqual(name, this.ident) ? this.labelName : (JsName)null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean hasOwnName(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            if (Companion.getRESERVED_WORDS().contains(name)) return true;
            if (Intrinsics.areEqual(name, this.ident)) return true;
            JsName jsName = this.labelName;
            if (Intrinsics.areEqual(name, jsName != null ? jsName.getIdent() : null)) return true;
            JsScope jsScope = this.getParent();
            if (jsScope == null) return false;
            boolean bl = jsScope.hasOwnName(name);
            if (!bl) return false;
            return true;
        }

        public LabelScope(@Nullable LabelScope parent2, @NotNull String ident) {
            Intrinsics.checkParameterIsNotNull(ident, "ident");
            super(parent2, "Label scope for " + ident, null);
            this.ident = ident;
            String freshIdent = Companion.getRESERVED_WORDS().contains(this.ident) ? this.getFreshIdent(this.ident) : (parent2 != null ? parent2.getFreshIdent(this.ident) : this.ident);
            this.labelName = new JsName(JsFunctionScope.this, freshIdent);
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0019\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!\tR!\u0001\u0005\b\u000b\u0005!\u0011\u0001Bb\u0002\u0019\u0001I\u0012\u0001'\u0001\"\b\u0011\t\u0011kA\u0001\t\u0003%rAa\u0011\u0005\t\u00045!\u0011BA\u0005\u00021\u000bA\"!U\u0002\u0006\u000b\u0005a\t!\u0004\u0002\u0005\u0007!\u001d\u0001"}, strings={"Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunctionScope$Companion;", "", "()V", "RESERVED_WORDS", "", "", "getRESERVED_WORDS", "()Ljava/util/Set;"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final Set<String> getRESERVED_WORDS() {
            return RESERVED_WORDS;
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

