/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.utils.CollectionsKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"Y\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001E\u0006\u000b\u0005!)!B\u0001\t\u001f\u0015\tA\"A\u0003\u0002\t\r)\u0011\u0001C\u0001\u0006\u0003\u0011!Q!\u0001\u0007\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!\tR\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t \u0015\tA1\u0001\u0007\u00013\u0005A\n!)\u0004\n\u0007!\tQ\"\u0001M\u0002#\u000e\t\u0001BA\u0013\b\u00111i\u0011\u0001'\u0007\u001a\u0007!iQ\"\u0001M\u0004K=!\u0011\u0001c\u0007\u000e\u0003a-\u0011D\u0002E\u0003\u001b\u0011I!!C\u0001\u0019\baE\u0011d\u0001\u0005\u000f\u001b\u0005A\u0012\"\n\u0007\u0005\u0003!uQB\u0001G\u00011%Ib\u0001C\b\u000e\t%\u0011\u0011\"\u0001\r\n1#)s\u0001B\u0001\t 5!\u0011BA\u0005\u00021%A\n\"J\u0007\t!5\t\u0001\u0004A\r\n\u0011Ciq!\u0003\u0002\n\u0003a\r\u0012BA\u0005\u00021\u0017A\u0012#J\u000e\u0005\u0003!\u0011R\u0002B\u0005\u0003\u0013\u0005A\u0012\u0002'\n\u001a\r!\u0015Q\u0002B\u0005\u0003\u0013\u0005A:\u0001'\u0005\u001a\u0007!\u0019R\"\u0001M\u00143!!\u0011\u0001\u0003\u000b\u000e\u000b%\u0011\u0011\"\u0001\r\n\u0019\u0003AJ#\n\b\u0005\u0003!)R\u0002B\u0005\u0003\u0013\u0005A\u0012\u0002'\n\u001a\r!-R\u0002B\u0005\u0003\u0013\u0005A\u0012\u0002'\u0005&\u0007!9Q\"\u0001M\rKA!\u0011\u0001\u0003\f\u000e\u0003a-\u0011D\u0002E\u0003\u001b\u0011I!!C\u0001\u0019\baE\u0011\u0004\u0002\u0005\u000f\u001b\ta\t\u0001G\u0005*\u001b\u0011Y\u0005\u0002#\u0002\u000e\t%\u0011\u0011\"\u0001M\u00041\r\t6\u0001B\u0003\u0001\u001b\t!A\u0001#\u0003*%\u0011\u0019E\u0004\u0003\u0004\u000e\u0003a-\u0011d\u0001\u0005\u0006\u001b\u0005AZ\u0001I\u0011R\u0007\u001d)\u0001!\u0004\u0002\u0005\r!5\u0011C\u0001\u0003\b\u0011\u001fI3\u0002B!\u001d\u0011!iQ!\u0003\u0002\n\u0003aIA\u0012\u0001M\t#\u000e\tQ\u0001A\u0015\u000b\t-C\u0001\"A\u0007\u00021\u0007\t6\u0001B\u0003\u0001\u001b\t!\u0019\u0002\u0003\u0006*\u001b\u0011Y\u0005\u0002#\u0006\u000e\t%\u0011\u0011\"\u0001\r\n1#a2&U\u0002\u0004\u001b\t!1\u0002c\u0006"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBoundsImpl;", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds;", "typeVariable", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "(Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;)V", "bounds", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$Bound;", "getBounds", "()Ljava/util/ArrayList;", "<set-?>", "", "isFixed", "()Z", "setFixed", "(Z)V", "resultValues", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "getTypeVariable", "()Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "values", "getValues", "()Ljava/util/Collection;", "addBound", "", "bound", "checkOnlyInputTypes", "possibleAnswer", "commonSupertypeForNumberTypes", "numberLowerBounds", "computeValues", "filter", "condition", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/resolve/calls/inference/constraintPosition/ConstraintPosition;", "filterBounds", "", "kind", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$BoundKind;", "errorValues", "", "getIntersectionOfSupertypes", "types", "tryPossibleAnswer"}, moduleName="kotlin-compiler")
public final class TypeBoundsImpl
implements TypeBounds {
    @NotNull
    private final ArrayList<TypeBounds.Bound> bounds;
    private Collection<? extends KotlinType> resultValues;
    private boolean isFixed;
    @NotNull
    private final TypeVariable typeVariable;

    @NotNull
    public ArrayList<TypeBounds.Bound> getBounds() {
        return this.bounds;
    }

    public final boolean isFixed() {
        return this.isFixed;
    }

    public final void setFixed() {
        this.isFixed = true;
    }

    public final void addBound(@NotNull TypeBounds.Bound bound) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(bound, "bound");
        this.resultValues = null;
        boolean value$iv = Intrinsics.areEqual(bound.getTypeVariable(), this.getTypeVariable());
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                String message$iv = bound + " is added for incorrect type variable " + bound.getTypeVariable().getName() + ". Expected: " + this.getTypeVariable().getName();
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        ((ArrayList)this.getBounds()).add(bound);
    }

    private final Set<KotlinType> filterBounds(Collection<TypeBounds.Bound> bounds, TypeBounds.BoundKind kind, Collection<KotlinType> errorValues) {
        LinkedHashSet<KotlinType> result2 = new LinkedHashSet<KotlinType>();
        for (TypeBounds.Bound bound : bounds) {
            if (!Intrinsics.areEqual((Object)bound.getKind(), (Object)kind)) continue;
            if (!ErrorUtils.containsErrorType(bound.getConstrainingType())) {
                result2.add(bound.getConstrainingType());
                continue;
            }
            Collection<KotlinType> collection = errorValues;
            Boolean bl = collection != null ? Boolean.valueOf(collection.add(bound.getConstrainingType())) : null;
        }
        return result2;
    }

    static /* bridge */ /* synthetic */ Set filterBounds$default(TypeBoundsImpl typeBoundsImpl, Collection collection, TypeBounds.BoundKind boundKind, Collection collection2, int n) {
        if ((n & 4) != 0) {
            collection2 = null;
        }
        return typeBoundsImpl.filterBounds(collection, boundKind, collection2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeBoundsImpl filter(@NotNull Function1<? super ConstraintPosition, Boolean> condition) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(condition, "condition");
        TypeBoundsImpl result2 = new TypeBoundsImpl(this.getTypeVariable());
        Iterable iterable = this.getBounds();
        Collection collection = result2.getBounds();
        void var5_5 = $receiver$iv;
        Collection collection2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            TypeBounds.Bound it = (TypeBounds.Bound)element$iv$iv;
            if (!condition.invoke(it.getPosition()).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        ((ArrayList)collection).addAll(list);
        return result2;
    }

    @Override
    @NotNull
    public Collection<KotlinType> getValues() {
        if (this.resultValues == null) {
            this.resultValues = this.computeValues();
        }
        Collection<KotlinType> collection = this.resultValues;
        if (collection == null) {
            Intrinsics.throwNpe();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KotlinType> computeValues() {
        KotlinType intersectionOfUpperBounds;
        KotlinType superTypeOfAllLowerBounds;
        void numberLowerBounds;
        void generalLowerBounds;
        void $receiver$iv;
        boolean hasStrongBound;
        Object it;
        Object element$iv2;
        List bounds;
        LinkedHashSet values;
        block15: {
            boolean bl;
            Iterator destination$iv$iv;
            void $receiver$iv$iv;
            values = new LinkedHashSet();
            Iterable $receiver$iv2 = this.getBounds();
            Iterable iterable = $receiver$iv2;
            Collection collection = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                TypeBounds.Bound it2 = (TypeBounds.Bound)element$iv$iv;
                if (!it2.isProper()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            bounds = (List)((Object)destination$iv$iv);
            if (bounds.isEmpty()) {
                return kotlin.collections.CollectionsKt.listOf();
            }
            Iterable $receiver$iv3 = bounds;
            for (Object element$iv2 : $receiver$iv3) {
                it = (TypeBounds.Bound)element$iv2;
                if (!((TypeBounds.Bound)it).getPosition().isStrong()) continue;
                bl = true;
                break block15;
            }
            bl = hasStrongBound = false;
        }
        if (!hasStrongBound) {
            return kotlin.collections.CollectionsKt.listOf();
        }
        Set<KotlinType> exactBounds = this.filterBounds(bounds, TypeBounds.BoundKind.EXACT_BOUND, values);
        KotlinType bestFit = FlexibleTypesKt.singleBestRepresentative((Collection<? extends KotlinType>)exactBounds);
        if (bestFit != null && this.tryPossibleAnswer(bounds, bestFit)) {
            return kotlin.collections.CollectionsKt.listOf(bestFit);
        }
        values.addAll(exactBounds);
        Iterable $i$f$any = this.filterBounds(bounds, TypeBounds.BoundKind.LOWER_BOUND, values);
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv3 : $receiver$iv) {
            KotlinType it3 = (KotlinType)element$iv3;
            if (it3.getConstructor() instanceof IntegerValueTypeConstructor) {
                first$iv.add(element$iv3);
                continue;
            }
            second$iv.add(element$iv3);
        }
        Pair $i$a$1 = new Pair(first$iv, second$iv);
        element$iv2 = $i$a$1.component1();
        it = $i$a$1.component2();
        $i$a$1 = null;
        KotlinType superTypeOfLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes((Collection)generalLowerBounds);
        if (this.tryPossibleAnswer(bounds, superTypeOfLowerBounds)) {
            KotlinType kotlinType = superTypeOfLowerBounds;
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            return SetsKt.setOf(kotlinType);
        }
        CollectionsKt.addIfNotNull(values, superTypeOfLowerBounds);
        KotlinType superTypeOfNumberLowerBounds = this.commonSupertypeForNumberTypes((Collection)numberLowerBounds);
        if (this.tryPossibleAnswer(bounds, superTypeOfNumberLowerBounds)) {
            KotlinType kotlinType = superTypeOfNumberLowerBounds;
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            return SetsKt.setOf(kotlinType);
        }
        CollectionsKt.addIfNotNull(values, superTypeOfNumberLowerBounds);
        if (superTypeOfLowerBounds != null && superTypeOfNumberLowerBounds != null && this.tryPossibleAnswer(bounds, superTypeOfAllLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes((Collection<KotlinType>)kotlin.collections.CollectionsKt.listOf(superTypeOfLowerBounds, superTypeOfNumberLowerBounds)))) {
            KotlinType kotlinType = superTypeOfAllLowerBounds;
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            return SetsKt.setOf(kotlinType);
        }
        Set<KotlinType> upperBounds = this.filterBounds(bounds, TypeBounds.BoundKind.UPPER_BOUND, values);
        if (kotlin.collections.CollectionsKt.isNotEmpty((Collection)upperBounds) && (intersectionOfUpperBounds = TypeIntersector.intersectTypes(KotlinTypeChecker.DEFAULT, (Collection<KotlinType>)upperBounds)) != null && this.tryPossibleAnswer(bounds, intersectionOfUpperBounds)) {
            return SetsKt.setOf(intersectionOfUpperBounds);
        }
        values.addAll(TypeBoundsImpl.filterBounds$default(this, bounds, TypeBounds.BoundKind.UPPER_BOUND, null, 4));
        if (values.size() == 1 && this.getTypeVariable().hasOnlyInputTypesAnnotation() && !this.tryPossibleAnswer(bounds, (KotlinType)kotlin.collections.CollectionsKt.first(values))) {
            return kotlin.collections.CollectionsKt.listOf();
        }
        return values;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkOnlyInputTypes(Collection<TypeBounds.Bound> bounds, KotlinType possibleAnswer) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        boolean bl;
        Object it;
        Object element$iv2;
        Object $receiver$iv$iv2;
        block6: {
            Collection destination$iv$iv2;
            TypeBounds.Bound it2;
            if (!this.getTypeVariable().hasOnlyInputTypesAnnotation()) {
                return true;
            }
            Iterable $receiver$iv2 = bounds;
            Iterable iterable = $receiver$iv2;
            Collection collection = new ArrayList();
            Iterator iterator2 = $receiver$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                it2 = (TypeBounds.Bound)element$iv$iv;
                if (!(it2.isProper() && it2.getConstrainingType().getConstructor().isDenotable())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $receiver$iv2 = (List)destination$iv$iv2;
            $receiver$iv$iv2 = $receiver$iv2;
            destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
            iterator2 = $receiver$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv = iterator2.next();
                it2 = (TypeBounds.Bound)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                KotlinType kotlinType = it2.getConstrainingType();
                collection2.add(kotlinType);
            }
            Set typesInBoundsSet = kotlin.collections.CollectionsKt.toSet((List)destination$iv$iv2);
            $receiver$iv2 = typesInBoundsSet;
            for (Object element$iv2 : $receiver$iv2) {
                it = (KotlinType)element$iv2;
                if (!KotlinTypeChecker.DEFAULT.equalTypes((KotlinType)it, possibleAnswer)) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        $receiver$iv$iv2 = TypeBoundsImpl.filterBounds$default(this, bounds, TypeBounds.BoundKind.LOWER_BOUND, null, 4);
        element$iv2 = $receiver$iv;
        it = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KotlinType it3 = (KotlinType)element$iv$iv;
            if (!(it3.getConstructor() instanceof IntegerValueTypeConstructor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List numberLowerBounds = (List)destination$iv$iv;
        KotlinType superTypeOfNumberLowerBounds = this.commonSupertypeForNumberTypes(numberLowerBounds);
        return Intrinsics.areEqual(possibleAnswer, superTypeOfNumberLowerBounds);
    }

    private final boolean tryPossibleAnswer(Collection<TypeBounds.Bound> bounds, KotlinType possibleAnswer) {
        if (possibleAnswer == null) {
            return false;
        }
        if (!possibleAnswer.getConstructor().isDenotable() && !CapturedTypeConstructorKt.isCaptured(possibleAnswer)) {
            return false;
        }
        if (!this.checkOnlyInputTypes(bounds, possibleAnswer)) {
            return false;
        }
        for (TypeBounds.Bound bound : bounds) {
            TypeBounds.BoundKind boundKind = bound.getKind();
            if (!(Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.LOWER_BOUND) ? !KotlinTypeChecker.DEFAULT.isSubtypeOf(bound.getConstrainingType(), possibleAnswer) : (Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.UPPER_BOUND) ? !KotlinTypeChecker.DEFAULT.isSubtypeOf(possibleAnswer, bound.getConstrainingType()) : Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.EXACT_BOUND) && !KotlinTypeChecker.DEFAULT.equalTypes(bound.getConstrainingType(), possibleAnswer)))) continue;
            return false;
        }
        return true;
    }

    private final KotlinType commonSupertypeForNumberTypes(Collection<? extends KotlinType> numberLowerBounds) {
        if (numberLowerBounds.isEmpty()) {
            return null;
        }
        Set<KotlinType> intersectionOfSupertypes = this.getIntersectionOfSupertypes(numberLowerBounds);
        KotlinType kotlinType = TypeUtils.getDefaultPrimitiveNumberType((Collection<KotlinType>)intersectionOfSupertypes);
        if (kotlinType == null) {
            kotlinType = CommonSupertypes.commonSupertype(numberLowerBounds);
        }
        return kotlinType;
    }

    private final Set<KotlinType> getIntersectionOfSupertypes(Collection<? extends KotlinType> types2) {
        HashSet<KotlinType> upperBounds = new HashSet<KotlinType>();
        for (KotlinType kotlinType : types2) {
            Collection<KotlinType> supertypes2 = kotlinType.getConstructor().getSupertypes();
            if (upperBounds.isEmpty()) {
                upperBounds.addAll(supertypes2);
                continue;
            }
            Collection<KotlinType> collection = supertypes2;
            Intrinsics.checkExpressionValueIsNotNull(collection, "supertypes");
            upperBounds.retainAll(collection);
        }
        return upperBounds;
    }

    @Override
    @NotNull
    public TypeVariable getTypeVariable() {
        return this.typeVariable;
    }

    public TypeBoundsImpl(@NotNull TypeVariable typeVariable) {
        Intrinsics.checkParameterIsNotNull(typeVariable, "typeVariable");
        this.typeVariable = typeVariable;
        this.bounds = new ArrayList();
    }

    @Override
    @Nullable
    public KotlinType getValue() {
        return TypeBounds.DefaultImpls.getValue(this);
    }
}

