/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tower;

import java.util.Collection;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateWithBoundDispatchReceiver;
import org.jetbrains.kotlin.resolve.calls.tower.CompositeScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ExplicitReceiverScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.NoExplicitReceiverScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.QualifierScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerLevel;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessorsKt;
import org.jetbrains.kotlin.resolve.calls.tower.TowerContext;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"7\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003!yQ!\u0001\u0007\u0002\u000b\u0005a\u0011!\u0002\u0001\u000e0\u0011\u0001\u0001\u0002A\u0007\u0005\u0013\tI\u0011\u0001J\u0001\u0019\u0002E\u0011A\u0001\u0001\u0005\u00023\u0019A\u0019!\u0004\u0003\n\u0005%\tA%\u0001\r\u00033\u0011A)!\u0004\u0002\r\u0002a\u0019Aka\u0002\u000ea\u0011\t\u0001\u0002B\u0007\u0005\u0013\tI\u0011\u0001J\u0001\u0019\u0002E\u0011A\u0001\u0001\u0005\u00023\u0019A\u0019!\u0004\u0003\n\u0005%\tA%\u0001\r\u00033\u0011A)!\u0004\u0002\r\u0002a\u0019\u0011t\u0006E\u0005\u001bWI!!C\u0001\u0019\f%\u0011\u0011\"\u0001\r\u0007\u0013\rI!\u0001$\u0001\u0019\u000e%9\u0011BB\u0005\u0005\u0013\rI\u0011\u0001b\u0001\u0019\u0010a9\u0001$B)\u0004\u0003\u0011AAka\u0002\u000e0\u0011\u0001\u0001\u0012C\u0007\u0005\u0013\tI\u0011\u0001J\u0001\u0019\u0002E\u0011A\u0001\u0001\u0005\u00023\u0019A\u0019!\u0004\u0003\n\u0005%\tA%\u0001\r\u00033\u0011A)!\u0004\u0002\r\u0002a\u0019Aka\u0002"}, strings={"createFunctionProcessor", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerProcessor;", "C", "context", "Lorg/jetbrains/kotlin/resolve/calls/tower/TowerContext;", "explicitReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "ScopeTowerProcessorsKt", "createSimpleProcessor", "collectCandidates", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerLevel;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateWithBoundDispatchReceiver;", "Lkotlin/Extension;", "createVariableProcessor"}, moduleName="kotlin-compiler")
public final class ScopeTowerProcessorsKt {
    private static final <C> ScopeTowerProcessor<C> createSimpleProcessor(TowerContext<C> context, Receiver explicitReceiver, Function3<? super ScopeTowerLevel, ? super Name, ? super ReceiverValue, ? extends Collection<? extends CandidateWithBoundDispatchReceiver<?>>> collectCandidates) {
        Unit unit;
        if (explicitReceiver instanceof ReceiverValue) {
            return new ExplicitReceiverScopeTowerProcessor<C>(context, (ReceiverValue)explicitReceiver, collectCandidates);
        }
        if (explicitReceiver instanceof QualifierReceiver) {
            Receiver receiver;
            QualifierScopeTowerProcessor<C> qualifierProcessor = new QualifierScopeTowerProcessor<C>(context, (QualifierReceiver)explicitReceiver, collectCandidates);
            Receiver receiver2 = explicitReceiver;
            if (!(receiver2 instanceof ClassQualifier)) {
                receiver2 = null;
            }
            if ((receiver = (ClassQualifier)receiver2) == null || (receiver = receiver.getClassValueReceiver()) == null) {
                return qualifierProcessor;
            }
            Receiver classValue = receiver;
            return new CompositeScopeTowerProcessor(qualifierProcessor, new ExplicitReceiverScopeTowerProcessor<C>(context, (ReceiverValue)classValue, collectCandidates));
        }
        boolean value$iv = explicitReceiver == null;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                StringBuilder stringBuilder = new StringBuilder().append("Illegal explicit receiver: ").append(explicitReceiver).append("(");
                Receiver receiver = explicitReceiver;
                if (receiver == null) {
                    Intrinsics.throwNpe();
                }
                String message$iv = stringBuilder.append(receiver.getClass().getSimpleName()).append(")").toString();
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        return new NoExplicitReceiverScopeTowerProcessor<C>(context, collectCandidates);
    }

    @NotNull
    public static final <C> ScopeTowerProcessor<C> createVariableProcessor(@NotNull TowerContext<C> context, @Nullable Receiver explicitReceiver) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        return ScopeTowerProcessorsKt.createSimpleProcessor(context, explicitReceiver, (Function3)((Object)Reflection.function(createVariableProcessor.1.INSTANCE)));
    }

    @NotNull
    public static final <C> ScopeTowerProcessor<C> createFunctionProcessor(@NotNull TowerContext<C> context, @Nullable Receiver explicitReceiver) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        return ScopeTowerProcessorsKt.createSimpleProcessor(context, explicitReceiver, (Function3)((Object)Reflection.function(createFunctionProcessor.1.INSTANCE)));
    }
}

