/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.varianceChecker;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.Map;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyAccessorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.resolve.typeBinding.TypeArgumentBinding;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBinding;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBindingKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"!\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u0005)\u0001!B\u0001\r\u0003\u0015\tAA\u0001\u0007\u0001!\u0017I\u0012\u0001'\u0001\u001e\u0003\u00171\u0011UB\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005A!!J\u0004\t\u00065\t\u0001dA\r\u0004\u0011\u000fi\u0011\u0001\u0007\u0003&\u0011\u0011\t\u0001\u0012B\u0007\u00021\rI2\u0001c\u0002\u000e\u0003a!Q\u0005\u0003\u0003\u0002\u0011\u0015i\u0011\u0001G\u0002\u001a\u0007!\u001dQ\"\u0001\r\u0005S\u001d!\u0011\t\u0003\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/varianceChecker/VarianceChecker;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "check", "", "c", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "checkClasses", "checkMembers", "Companion", "VarianceConflictDiagnosticData"}, moduleName="kotlin-compiler")
public final class VarianceChecker {
    private final BindingTrace trace;
    public static final Companion Companion = org.jetbrains.kotlin.resolve.varianceChecker.VarianceChecker$Companion.INSTANCE;

    public final void check(@NotNull TopDownAnalysisContext c) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        this.checkClasses(c);
        this.checkMembers(c);
    }

    private final void checkClasses(TopDownAnalysisContext c) {
        Map<KtClassOrObject, ClassDescriptorWithResolutionScopes> map2 = c.getDeclaredClasses();
        if (map2 == null) {
            Intrinsics.throwNpe();
        }
        for (KtClassOrObject jetClassOrObject : CollectionsKt.mutableKeys(map2)) {
            if (!(jetClassOrObject instanceof KtClass)) continue;
            for (KtSuperTypeListEntry specifier : jetClassOrObject.getSuperTypeListEntries()) {
                Boolean bl;
                KtTypeReference ktTypeReference = specifier.getTypeReference();
                if (ktTypeReference != null) {
                    BindingContext bindingContext2 = this.trace.getBindingContext();
                    Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "trace.getBindingContext()");
                    bl = VarianceChecker.Companion.checkTypePosition(ktTypeReference, bindingContext2, Variance.OUT_VARIANCE, this.trace);
                    continue;
                }
                bl = null;
            }
            KtTypeParameterListOwner ktTypeParameterListOwner = jetClassOrObject;
            BindingContext bindingContext3 = this.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext3, "trace.getBindingContext()");
            VarianceChecker.Companion.checkTypeParameters(ktTypeParameterListOwner, bindingContext3, Variance.OUT_VARIANCE, this.trace);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkMembers(TopDownAnalysisContext c) {
        Iterator<Map.Entry<KtCallableDeclaration, CallableMemberDescriptor>> iterator2 = MapsKt.mutableIterator(c.getMembers());
        while (iterator2.hasNext()) {
            void $receiver$iv;
            void $receiver$iv2;
            Map.Entry<KtCallableDeclaration, CallableMemberDescriptor> entry;
            Map.Entry<KtCallableDeclaration, CallableMemberDescriptor> entry2 = entry = iterator2.next();
            KtCallableDeclaration declaration = (KtCallableDeclaration)$receiver$iv2.getKey();
            Map.Entry<KtCallableDeclaration, CallableMemberDescriptor> $i$f$component1 = entry;
            CallableMemberDescriptor descriptor2 = (CallableMemberDescriptor)$receiver$iv.getValue();
            if (Visibilities.isPrivate(descriptor2.getVisibility())) continue;
            BindingContext bindingContext2 = this.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "trace.getBindingContext()");
            KtCallableDeclaration ktCallableDeclaration = declaration;
            Intrinsics.checkExpressionValueIsNotNull(ktCallableDeclaration, "declaration");
            CallableDescriptor callableDescriptor = descriptor2;
            Intrinsics.checkExpressionValueIsNotNull(callableDescriptor, "descriptor");
            VarianceChecker.Companion.checkCallableDeclaration(bindingContext2, ktCallableDeclaration, callableDescriptor, this.trace);
        }
    }

    public VarianceChecker(@NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.trace = trace;
    }

    @JvmStatic
    public static final void recordPrivateToThisIfNeeded(@NotNull BindingTrace trace, @NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Companion.recordPrivateToThisIfNeeded(trace, descriptor2);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u001dA\u0002A\r\u00021\u0003\tk\"C\u0002\t\u00035\t\u00014A\u0005\u0004\u0011\ti\u0011\u0001'\u0002\n\u0007!\u0019Q\"\u0001M\u0004#\u000e\t\u0001\u0002B\u0015\u000b\t\rC\u0001\"A\u0007\u00021\u0007\t6\u0001B\u0003\u0001\u001b\t!I\u0001C\u0003*\u0015\u0011\u0019\u0005\u0002C\u0002\u000e\u0003a\u001d\u0011k\u0001\u0003\u0006\u00015\u0011A1\u0002\u0005\u0007S)!1\t\u0003\u0005\u0003\u001b\u0005A*!U\u0002\u0005\u000b\u0001i!\u0001\"\u0004\t\u000f\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/varianceChecker/VarianceChecker$VarianceConflictDiagnosticData;", "", "containingType", "Lorg/jetbrains/kotlin/types/KotlinType;", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "occurrencePosition", "Lorg/jetbrains/kotlin/types/Variance;", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;Lorg/jetbrains/kotlin/types/Variance;)V", "getContainingType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getOccurrencePosition", "()Lorg/jetbrains/kotlin/types/Variance;", "getTypeParameter", "()Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;"}, moduleName="kotlin-compiler")
    public static final class VarianceConflictDiagnosticData {
        @NotNull
        private final KotlinType containingType;
        @NotNull
        private final TypeParameterDescriptor typeParameter;
        @NotNull
        private final Variance occurrencePosition;

        @NotNull
        public final KotlinType getContainingType() {
            return this.containingType;
        }

        @NotNull
        public final TypeParameterDescriptor getTypeParameter() {
            return this.typeParameter;
        }

        @NotNull
        public final Variance getOccurrencePosition() {
            return this.occurrencePosition;
        }

        public VarianceConflictDiagnosticData(@NotNull KotlinType containingType, @NotNull TypeParameterDescriptor typeParameter, @NotNull Variance occurrencePosition) {
            Intrinsics.checkParameterIsNotNull(containingType, "containingType");
            Intrinsics.checkParameterIsNotNull(typeParameter, "typeParameter");
            Intrinsics.checkParameterIsNotNull((Object)occurrencePosition, "occurrencePosition");
            this.containingType = containingType;
            this.typeParameter = typeParameter;
            this.occurrencePosition = occurrencePosition;
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"a\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0003\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0005\u0007\ba\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\tQ\u0005\u0006\u0003\u0002\u0011\u0007i\u0011\u0001\u0007\u0002\u001a\u0007!\u0015Q\"\u0001\r\u00043\rA9!D\u0001\u0019\te\u0019\u0001\u0012B\u0007\u00021\u0015I2\u0001c\u0003\u000e\u0003a1Q\u0005\u0003\u0003\u0002\u0011\u001bi\u0011\u0001\u0007\u0002\u001a\u0007!%Q\"\u0001\r\u0006K!!\u0011\u0001C\u0004\u000e\u0003a=\u0011d\u0001E\u0005\u001b\u0005A\u0002\"\n\u0007\u0005\b!EQ\"\u0001M\b3\rA)!D\u0001\u0019\u0013e\u0019\u0001\u0012B\u0007\u00021!){\u0002B!\t\u0011'i\u0011\u0001\u0007\u0002\u0016\u0003a\u0011\u00114\u0002\u0005\u000b\u001b\ta\t\u0001\u0007\u0002Q\u0007\u0003\t6!\u0001E\u000bK[!\u0011\u0001C\u0006\u000e\u0003a\u0011Q#\u0001M\f3\u0013A)!D\u0001\u0019\u0007A\u001b\t!'\u0003\t\u00195\t\u0001\u0014\u0004)\u0004\u0003e%\u00012B\u0007\u00021\u0019\u000161A\u0013\u001b\t\u0005AQ\"\u0004\u0002\r\u0002a\u0011Q#\u0001M\u000e3\u0013A)!D\u0001\u0019\u0007A\u001b\t!'\u0003\t\u001d5\t\u0001\u0014\u0004)\u0004\u0003e%\u00012B\u0007\u00021\u0019\u000161A)\u0004\u0003!uQ5\u0007\u0003\u0002\u00115i\u0011\u0001\u0007\u0002\u0016\t%\u0011\u0011\"\u0001M\u00101=IJ\u0001\u0003\t\u000e\u0003a\u0005\u0002k!\u0001\u001a\n!qQ\"\u0001M\r!\u000e\t\u0011\u0014\u0002E\u0006\u001b\u0005Ab\u0001UB\u0002KQ!\u0011\u0001C\u0007\u000e\u0003a\u0011Q\u0003B\u0005\u0003\u0013\u0005Az\u0002G\b\u001a\n!qQ\"\u0001M\r!\u000e\u0005\u0011\u0014\u0002E\u0006\u001b\u0005Ab\u0001U\u0002\u0002"}, strings={"Lorg/jetbrains/kotlin/resolve/varianceChecker/VarianceChecker$Companion;", "", "()V", "checkCallableDeclaration", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "declaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "diagnosticSink", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "isIrrelevant", "recordPrivateToThis", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "recordPrivateToThisIfNeeded", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "and", "other", "(ZLjava/lang/Boolean;)Z", "checkTypeParameters", "Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwner;", "typePosition", "Lorg/jetbrains/kotlin/types/Variance;", "checkTypePosition", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "position", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/types/Variance;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;)Ljava/lang/Boolean;", "Lorg/jetbrains/kotlin/resolve/typeBinding/TypeBinding;", "Lcom/intellij/psi/PsiElement;", "containingType", "Lorg/jetbrains/kotlin/types/KotlinType;"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        @JvmStatic
        public final void recordPrivateToThisIfNeeded(@NotNull BindingTrace trace, @NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull(trace, "trace");
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            if (this.isIrrelevant(descriptor2) || Intrinsics.areEqual(descriptor2.getVisibility(), Visibilities.PRIVATE) ^ true) {
                return;
            }
            PsiElement psiElement2 = KotlinSourceElementKt.getPsi(descriptor2.getSource());
            if (!(psiElement2 instanceof KtCallableDeclaration)) {
                return;
            }
            BindingContext bindingContext2 = trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "trace.getBindingContext()");
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)psiElement2;
            CallableDescriptor callableDescriptor = descriptor2;
            DiagnosticSink diagnosticSink = DiagnosticSink.DO_NOTHING;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticSink, "DiagnosticSink.DO_NOTHING");
            if (!this.checkCallableDeclaration(bindingContext2, ktCallableDeclaration, callableDescriptor, diagnosticSink)) {
                this.recordPrivateToThis(descriptor2);
            }
        }

        private final boolean isIrrelevant(CallableDescriptor descriptor2) {
            boolean bl;
            block2: {
                DeclarationDescriptor containingClass = descriptor2.getContainingDeclaration();
                if (!(containingClass instanceof ClassDescriptor)) {
                    return true;
                }
                Iterable $receiver$iv = ((ClassDescriptor)containingClass).getTypeConstructor().getParameters();
                for (Object element$iv : $receiver$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                    if (Intrinsics.areEqual((Object)it.getVariance(), (Object)Variance.INVARIANT)) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            return bl;
        }

        private final void recordPrivateToThis(CallableMemberDescriptor descriptor2) {
            if (descriptor2 instanceof FunctionDescriptorImpl) {
                ((FunctionDescriptorImpl)descriptor2).setVisibility(Visibilities.PRIVATE_TO_THIS);
            } else if (descriptor2 instanceof PropertyDescriptorImpl) {
                ((PropertyDescriptorImpl)descriptor2).setVisibility(Visibilities.PRIVATE_TO_THIS);
                Iterator<PropertyAccessorDescriptor> iterator2 = ((PropertyDescriptorImpl)descriptor2).getAccessors().iterator();
                while (iterator2.hasNext()) {
                    PropertyAccessorDescriptor accessor;
                    PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = iterator2.next();
                    if (propertyAccessorDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.impl.PropertyAccessorDescriptorImpl");
                    }
                    ((PropertyAccessorDescriptorImpl)propertyAccessorDescriptor).setVisibility(Visibilities.PRIVATE_TO_THIS);
                }
            } else {
                throw (Throwable)new IllegalStateException("Unexpected descriptor type: " + descriptor2.getClass().getName());
            }
        }

        private final boolean checkCallableDeclaration(BindingContext trace, KtCallableDeclaration declaration, CallableDescriptor descriptor2, DiagnosticSink diagnosticSink) {
            if (this.isIrrelevant(descriptor2)) {
                return true;
            }
            boolean noError = true;
            noError &= this.checkTypeParameters(declaration, trace, Variance.IN_VARIANCE, diagnosticSink);
            KtTypeReference ktTypeReference = declaration.getReceiverTypeReference();
            noError = this.and(noError, ktTypeReference != null ? this.checkTypePosition(ktTypeReference, trace, Variance.IN_VARIANCE, diagnosticSink) : null);
            for (KtParameter parameter : declaration.getValueParameters()) {
                KtTypeReference ktTypeReference2 = parameter.getTypeReference();
                noError = this.and(noError, ktTypeReference2 != null ? this.checkTypePosition(ktTypeReference2, trace, Variance.IN_VARIANCE, diagnosticSink) : null);
            }
            Variance returnTypePosition = descriptor2 instanceof VariableDescriptor && ((VariableDescriptor)descriptor2).isVar() ? Variance.INVARIANT : Variance.OUT_VARIANCE;
            TypeBinding<PsiElement> typeBinding = TypeBindingKt.createTypeBindingForReturnType(declaration, trace);
            noError = this.and(noError, typeBinding != null ? Boolean.valueOf(this.checkTypePosition(typeBinding, returnTypePosition, diagnosticSink)) : null);
            return noError;
        }

        private final boolean checkTypeParameters(KtTypeParameterListOwner $receiver, BindingContext trace, Variance typePosition, DiagnosticSink diagnosticSink) {
            boolean noError = true;
            for (KtTypeParameter typeParameter : $receiver.getTypeParameters()) {
                KtTypeReference ktTypeReference = typeParameter.getExtendsBound();
                noError = this.and(noError, ktTypeReference != null ? this.checkTypePosition(ktTypeReference, trace, typePosition, diagnosticSink) : null);
            }
            for (KtTypeConstraint typeConstraint : $receiver.getTypeConstraints()) {
                KtTypeReference ktTypeReference = typeConstraint.getBoundTypeReference();
                noError = this.and(noError, ktTypeReference != null ? this.checkTypePosition(ktTypeReference, trace, typePosition, diagnosticSink) : null);
            }
            return noError;
        }

        private final Boolean checkTypePosition(KtTypeReference $receiver, BindingContext trace, Variance position, DiagnosticSink diagnosticSink) {
            TypeBinding<KtTypeElement> typeBinding = TypeBindingKt.createTypeBinding($receiver, trace);
            return typeBinding != null ? Boolean.valueOf(this.checkTypePosition(typeBinding, position, diagnosticSink)) : null;
        }

        private final boolean checkTypePosition(TypeBinding<? extends PsiElement> $receiver, Variance position, DiagnosticSink diagnosticSink) {
            return this.checkTypePosition($receiver, $receiver.getKotlinType(), position, diagnosticSink);
        }

        private final boolean checkTypePosition(TypeBinding<? extends PsiElement> $receiver, KotlinType containingType, Variance position, DiagnosticSink diagnosticSink) {
            ClassifierDescriptor classifierDescriptor = $receiver.getKotlinType().getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor instanceof TypeParameterDescriptor) {
                Variance declarationVariance = ((TypeParameterDescriptor)classifierDescriptor).getVariance();
                if (!declarationVariance.allowsPosition(position)) {
                    Annotations annotations2 = $receiver.getKotlinType().getAnnotations();
                    FqName fqName2 = KotlinBuiltIns.FQ_NAMES.unsafeVariance;
                    Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.unsafeVariance");
                    if (!annotations2.hasAnnotation(fqName2)) {
                        diagnosticSink.report(Errors.TYPE_VARIANCE_CONFLICT.on($receiver.getPsiElement(), new VarianceConflictDiagnosticData(containingType, (TypeParameterDescriptor)classifierDescriptor, position)));
                    }
                }
                return declarationVariance.allowsPosition(position);
            }
            boolean noError = true;
            for (TypeArgumentBinding<? extends PsiElement> argumentBinding : $receiver.getArgumentBindings()) {
                Variance newPosition;
                Variance variance;
                TypeCheckingProcedure.EnrichedProjectionKind projectionKind;
                TypeCheckingProcedure.EnrichedProjectionKind enrichedProjectionKind;
                if (argumentBinding == null || argumentBinding.getTypeParameterDescriptor() == null) continue;
                TypeParameterDescriptor typeParameterDescriptor = argumentBinding.getTypeParameterDescriptor();
                if (typeParameterDescriptor == null) {
                    Intrinsics.throwNpe();
                }
                if (TypeCheckingProcedure.getEffectiveProjectionKind(typeParameterDescriptor, argumentBinding.getTypeProjection()) == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)(enrichedProjectionKind = projectionKind), (Object)TypeCheckingProcedure.EnrichedProjectionKind.OUT)) {
                    variance = position;
                } else if (Intrinsics.areEqual((Object)enrichedProjectionKind, (Object)TypeCheckingProcedure.EnrichedProjectionKind.IN)) {
                    variance = position.opposite();
                } else if (Intrinsics.areEqual((Object)enrichedProjectionKind, (Object)TypeCheckingProcedure.EnrichedProjectionKind.INV)) {
                    variance = Variance.INVARIANT;
                } else if (Intrinsics.areEqual((Object)enrichedProjectionKind, (Object)TypeCheckingProcedure.EnrichedProjectionKind.STAR)) {
                    variance = null;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                if ((newPosition = variance) == null) continue;
                noError &= this.checkTypePosition(argumentBinding.getTypeBinding(), containingType, newPosition, diagnosticSink);
            }
            return noError;
        }

        private final boolean and(boolean $receiver, Boolean other) {
            return other == null ? $receiver : $receiver & other;
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

