/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.openapi.util.Ref;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Sets;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.types.CastDiagnosticsUtil;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.TypeReconstructionUtil;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

public class PatternMatchingTypingVisitor
extends ExpressionTypingVisitor {
    protected PatternMatchingTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "<init>"));
        }
        super(facade);
    }

    @Override
    public KotlinTypeInfo visitIsExpression(@NotNull KtIsExpression expression, ExpressionTypingContext contextWithExpectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "visitIsExpression"));
        }
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KtExpression leftHandSide = expression.getLeftHandSide();
        KotlinTypeInfo typeInfo = this.facade.safeGetTypeInfo(leftHandSide, (ExpressionTypingContext)context.replaceScope(context.scope));
        KotlinType knownType = typeInfo.getType();
        if (expression.getTypeReference() != null) {
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(leftHandSide, knownType, context);
            DataFlowInfo conditionInfo = this.checkTypeForIs(context, knownType, expression.getTypeReference(), dataFlowValue).thenInfo;
            DataFlowInfo newDataFlowInfo = conditionInfo.and(typeInfo.getDataFlowInfo());
            context.trace.record(BindingContext.DATAFLOW_INFO_AFTER_CONDITION, expression, newDataFlowInfo);
        }
        return this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(this.components.builtIns.getBooleanType()), (KtExpression)expression, (ResolutionContext)contextWithExpectedType);
    }

    @Override
    public KotlinTypeInfo visitWhenExpression(@NotNull KtWhenExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "visitWhenExpression"));
        }
        return this.visitWhenExpression(expression, context, false);
    }

    public KotlinTypeInfo visitWhenExpression(KtWhenExpression expression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        KotlinType resultType;
        KotlinType subjectType;
        WhenChecker.checkDeprecatedWhenSyntax(contextWithExpectedType.trace, expression);
        WhenChecker.checkReservedPrefix(contextWithExpectedType.trace, expression);
        this.components.dataFlowAnalyzer.recordExpectedType(contextWithExpectedType.trace, expression, contextWithExpectedType.expectedType);
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KtExpression subjectExpression = expression.getSubjectExpression();
        boolean loopBreakContinuePossible = false;
        if (subjectExpression == null) {
            subjectType = ErrorUtils.createErrorType("Unknown type");
        } else {
            KotlinTypeInfo typeInfo = this.facade.safeGetTypeInfo(subjectExpression, context);
            loopBreakContinuePossible = typeInfo.getJumpOutPossible();
            subjectType = typeInfo.getType();
            assert (subjectType != null);
            if (TypeUtils.isNullableType(subjectType) && !WhenChecker.containsNullCase(expression, context.trace)) {
                TemporaryBindingTrace trace = TemporaryBindingTrace.create(context.trace, "Temporary trace for when subject nullability");
                ExpressionTypingContext subjectContext = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.makeNotNullable(subjectType))).replaceBindingTrace(trace);
                SmartCastResult castResult = this.components.dataFlowAnalyzer.checkPossibleCast(subjectType, KtPsiUtil.safeDeparenthesize(subjectExpression), subjectContext);
                if (castResult != null && castResult.isCorrect()) {
                    trace.commit();
                }
            }
            context = (ExpressionTypingContext)context.replaceDataFlowInfo(typeInfo.getDataFlowInfo());
        }
        DataFlowValue subjectDataFlowValue = subjectExpression != null ? DataFlowValueFactory.createDataFlowValue(subjectExpression, subjectType, context) : DataFlowValue.nullValue(this.components.builtIns);
        HashSet<KotlinType> expressionTypes = Sets.newHashSet();
        DataFlowInfo commonDataFlowInfo = null;
        DataFlowInfo elseDataFlowInfo = context.dataFlowInfo;
        DataFlowValue whenValue = DataFlowValueFactory.createDataFlowValue(expression, this.components.builtIns.getNullableAnyType(), context);
        for (KtWhenEntry whenEntry : expression.getEntries()) {
            DataFlowInfos infosForCondition = this.getDataFlowInfosForEntryCondition(whenEntry, (ExpressionTypingContext)context.replaceDataFlowInfo(elseDataFlowInfo), subjectExpression, subjectType, subjectDataFlowValue);
            elseDataFlowInfo = elseDataFlowInfo.and(infosForCondition.elseInfo);
            KtExpression bodyExpression = whenEntry.getExpression();
            if (bodyExpression == null) continue;
            LexicalWritableScope scopeToExtend = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.WHEN);
            ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceScope(scopeToExtend)).replaceDataFlowInfo(infosForCondition.thenInfo)).replaceContextDependency(ContextDependency.INDEPENDENT);
            CoercionStrategy coercionStrategy = isStatement ? CoercionStrategy.COERCION_TO_UNIT : CoercionStrategy.NO_COERCION;
            KotlinTypeInfo typeInfo = this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(scopeToExtend, Collections.singletonList(bodyExpression), coercionStrategy, newContext);
            loopBreakContinuePossible |= typeInfo.getJumpOutPossible();
            KotlinType type2 = typeInfo.getType();
            if (type2 != null) {
                expressionTypes.add(type2);
                DataFlowValue entryValue = DataFlowValueFactory.createDataFlowValue(bodyExpression, type2, context);
                typeInfo = typeInfo.replaceDataFlowInfo(typeInfo.getDataFlowInfo().assign(whenValue, entryValue));
            }
            if (commonDataFlowInfo == null) {
                commonDataFlowInfo = typeInfo.getDataFlowInfo();
                continue;
            }
            commonDataFlowInfo = commonDataFlowInfo.or(typeInfo.getDataFlowInfo());
        }
        if (commonDataFlowInfo == null) {
            commonDataFlowInfo = context.dataFlowInfo;
        } else if (expression.getElseExpression() == null && !WhenChecker.isWhenExhaustive(expression, context.trace)) {
            commonDataFlowInfo = commonDataFlowInfo.or(context.dataFlowInfo);
        }
        KotlinType kotlinType = resultType = expressionTypes.isEmpty() ? null : CommonSupertypes.commonSupertype(expressionTypes);
        if (resultType != null) {
            DataFlowValue resultValue = DataFlowValueFactory.createDataFlowValue(expression, resultType, context);
            commonDataFlowInfo = commonDataFlowInfo.assign(resultValue, whenValue);
        }
        return TypeInfoFactoryKt.createTypeInfo(expressionTypes.isEmpty() ? null : this.components.dataFlowAnalyzer.checkType(this.components.dataFlowAnalyzer.checkImplicitCast(resultType, (KtExpression)expression, (ResolutionContext)contextWithExpectedType, isStatement), (KtExpression)expression, (ResolutionContext)contextWithExpectedType), commonDataFlowInfo, loopBreakContinuePossible, contextWithExpectedType.dataFlowInfo);
    }

    @NotNull
    private DataFlowInfos getDataFlowInfosForEntryCondition(@NotNull KtWhenEntry whenEntry, @NotNull ExpressionTypingContext context, @Nullable KtExpression subjectExpression, @NotNull KotlinType subjectType, @NotNull DataFlowValue subjectDataFlowValue) {
        if (whenEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whenEntry", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "getDataFlowInfosForEntryCondition"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "getDataFlowInfosForEntryCondition"));
        }
        if (subjectType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subjectType", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "getDataFlowInfosForEntryCondition"));
        }
        if (subjectDataFlowValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subjectDataFlowValue", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "getDataFlowInfosForEntryCondition"));
        }
        if (whenEntry.isElse()) {
            DataFlowInfos dataFlowInfos = new DataFlowInfos(context.dataFlowInfo);
            if (dataFlowInfos == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "getDataFlowInfosForEntryCondition"));
            }
            return dataFlowInfos;
        }
        DataFlowInfos infos = null;
        ExpressionTypingContext contextForCondition = context;
        for (KtWhenCondition condition : whenEntry.getConditions()) {
            DataFlowInfos conditionInfos = this.checkWhenCondition(subjectExpression, subjectType, condition, contextForCondition, subjectDataFlowValue);
            infos = infos != null ? new DataFlowInfos(infos.thenInfo.or(conditionInfos.thenInfo), infos.elseInfo.and(conditionInfos.elseInfo)) : conditionInfos;
            contextForCondition = (ExpressionTypingContext)contextForCondition.replaceDataFlowInfo(conditionInfos.elseInfo);
        }
        DataFlowInfos dataFlowInfos = infos != null ? infos : new DataFlowInfos(context.dataFlowInfo);
        if (dataFlowInfos == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "getDataFlowInfosForEntryCondition"));
        }
        return dataFlowInfos;
    }

    private DataFlowInfos checkWhenCondition(final @Nullable KtExpression subjectExpression, final KotlinType subjectType, KtWhenCondition condition, final ExpressionTypingContext context, final DataFlowValue subjectDataFlowValue) {
        final Ref<DataFlowInfos> newDataFlowInfo = new Ref<DataFlowInfos>(PatternMatchingTypingVisitor.noChange(context));
        condition.accept(new KtVisitorVoid(){

            @Override
            public void visitWhenConditionInRange(@NotNull KtWhenConditionInRange condition) {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$1", "visitWhenConditionInRange"));
                }
                KtExpression rangeExpression = condition.getRangeExpression();
                if (rangeExpression == null) {
                    return;
                }
                if (subjectExpression == null) {
                    context.trace.report(Errors.EXPECTED_CONDITION.on(condition));
                    DataFlowInfo dataFlowInfo = PatternMatchingTypingVisitor.this.facade.getTypeInfo(rangeExpression, context).getDataFlowInfo();
                    newDataFlowInfo.set(new DataFlowInfos(dataFlowInfo, dataFlowInfo));
                    return;
                }
                ValueArgument argumentForSubject = CallMaker.makeExternalValueArgument(subjectExpression);
                KotlinTypeInfo typeInfo = PatternMatchingTypingVisitor.this.facade.checkInExpression(condition, condition.getOperationReference(), argumentForSubject, rangeExpression, context);
                DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
                newDataFlowInfo.set(new DataFlowInfos(dataFlowInfo, dataFlowInfo));
                KotlinType type2 = typeInfo.getType();
                if (type2 == null || !KotlinBuiltIns.isBoolean(type2)) {
                    context.trace.report(Errors.TYPE_MISMATCH_IN_RANGE.on(condition));
                }
            }

            @Override
            public void visitWhenConditionIsPattern(@NotNull KtWhenConditionIsPattern condition) {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$1", "visitWhenConditionIsPattern"));
                }
                if (subjectExpression == null) {
                    context.trace.report(Errors.EXPECTED_CONDITION.on(condition));
                }
                if (condition.getTypeReference() != null) {
                    DataFlowInfos result2 = PatternMatchingTypingVisitor.this.checkTypeForIs(context, subjectType, condition.getTypeReference(), subjectDataFlowValue);
                    if (condition.isNegated()) {
                        newDataFlowInfo.set(new DataFlowInfos(result2.elseInfo, result2.thenInfo));
                    } else {
                        newDataFlowInfo.set(result2);
                    }
                }
            }

            @Override
            public void visitWhenConditionWithExpression(@NotNull KtWhenConditionWithExpression condition) {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$1", "visitWhenConditionWithExpression"));
                }
                KtExpression expression = condition.getExpression();
                if (expression != null) {
                    newDataFlowInfo.set(PatternMatchingTypingVisitor.this.checkTypeForExpressionCondition(context, expression, subjectType, subjectExpression == null, subjectDataFlowValue));
                }
            }

            @Override
            public void visitKtElement(@NotNull KtElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$1", "visitKtElement"));
                }
                context.trace.report(Errors.UNSUPPORTED.on(element, this.getClass().getCanonicalName()));
            }
        });
        return newDataFlowInfo.get();
    }

    private DataFlowInfos checkTypeForExpressionCondition(ExpressionTypingContext context, KtExpression expression, KotlinType subjectType, boolean conditionExpected, DataFlowValue subjectDataFlowValue) {
        if (expression == null) {
            return PatternMatchingTypingVisitor.noChange(context);
        }
        KotlinTypeInfo typeInfo = this.facade.getTypeInfo(expression, context);
        KotlinType type2 = typeInfo.getType();
        if (type2 == null) {
            return PatternMatchingTypingVisitor.noChange(context);
        }
        context = (ExpressionTypingContext)context.replaceDataFlowInfo(typeInfo.getDataFlowInfo());
        if (conditionExpected) {
            KotlinType booleanType = this.components.builtIns.getBooleanType();
            if (KotlinTypeChecker.DEFAULT.equalTypes(booleanType, type2)) {
                DataFlowInfo ifInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(expression, true, context);
                DataFlowInfo elseInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(expression, false, context);
                return new DataFlowInfos(ifInfo, elseInfo);
            }
            context.trace.report(Errors.TYPE_MISMATCH_IN_CONDITION.on(expression, type2));
            return PatternMatchingTypingVisitor.noChange(context);
        }
        PatternMatchingTypingVisitor.checkTypeCompatibility(context, type2, subjectType, expression);
        DataFlowValue expressionDataFlowValue = DataFlowValueFactory.createDataFlowValue(expression, type2, context);
        DataFlowInfos result2 = PatternMatchingTypingVisitor.noChange(context);
        result2 = new DataFlowInfos(result2.thenInfo.equate(subjectDataFlowValue, expressionDataFlowValue), result2.elseInfo.disequate(subjectDataFlowValue, expressionDataFlowValue));
        return result2;
    }

    private DataFlowInfos checkTypeForIs(ExpressionTypingContext context, KotlinType subjectType, KtTypeReference typeReferenceAfterIs, DataFlowValue subjectDataFlowValue) {
        ClassDescriptor targetDescriptor;
        if (typeReferenceAfterIs == null) {
            return PatternMatchingTypingVisitor.noChange(context);
        }
        TypeResolutionContext typeResolutionContext = new TypeResolutionContext(context.scope, context.trace, true, true);
        PossiblyBareType possiblyBareTarget = this.components.typeResolver.resolvePossiblyBareType(typeResolutionContext, typeReferenceAfterIs);
        KotlinType targetType = TypeReconstructionUtil.reconstructBareType(typeReferenceAfterIs, possiblyBareTarget, subjectType, context.trace, this.components.builtIns);
        if (DynamicTypesKt.isDynamic(targetType)) {
            context.trace.report(Errors.DYNAMIC_NOT_ALLOWED.on(typeReferenceAfterIs));
        }
        if ((targetDescriptor = TypeUtils.getClassDescriptor(targetType)) != null && DescriptorUtils.isEnumEntry(targetDescriptor)) {
            context.trace.report(Errors.IS_ENUM_ENTRY.on(typeReferenceAfterIs));
        }
        if (!subjectType.isMarkedNullable() && targetType.isMarkedNullable()) {
            KtTypeElement element = typeReferenceAfterIs.getTypeElement();
            assert (element instanceof KtNullableType) : "element must be instance of " + KtNullableType.class.getName();
            KtNullableType nullableType = (KtNullableType)element;
            context.trace.report(Errors.USELESS_NULLABLE_CHECK.on(nullableType));
        }
        PatternMatchingTypingVisitor.checkTypeCompatibility(context, targetType, subjectType, typeReferenceAfterIs);
        if (CastDiagnosticsUtil.isCastErased(subjectType, targetType, KotlinTypeChecker.DEFAULT)) {
            context.trace.report(Errors.CANNOT_CHECK_FOR_ERASED.on(typeReferenceAfterIs, targetType));
        }
        return new DataFlowInfos(context.dataFlowInfo.establishSubtyping(subjectDataFlowValue, targetType), context.dataFlowInfo);
    }

    private static DataFlowInfos noChange(ExpressionTypingContext context) {
        return new DataFlowInfos(context.dataFlowInfo, context.dataFlowInfo);
    }

    private static void checkTypeCompatibility(@NotNull ExpressionTypingContext context, @Nullable KotlinType type2, @NotNull KotlinType subjectType, @NotNull KtElement reportErrorOn) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "checkTypeCompatibility"));
        }
        if (subjectType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subjectType", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "checkTypeCompatibility"));
        }
        if (reportErrorOn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportErrorOn", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "checkTypeCompatibility"));
        }
        if (type2 == null) {
            return;
        }
        if (TypeIntersector.isIntersectionEmpty(type2, subjectType)) {
            context.trace.report(Errors.INCOMPATIBLE_TYPES.on(reportErrorOn, type2, subjectType));
            return;
        }
        if (KotlinBuiltIns.isNullableNothing(type2) && !TypeUtils.isNullableType(subjectType)) {
            context.trace.report(Errors.SENSELESS_NULL_IN_WHEN.on(reportErrorOn));
        }
    }

    private static class DataFlowInfos {
        private final DataFlowInfo thenInfo;
        private final DataFlowInfo elseInfo;

        private DataFlowInfos(DataFlowInfo thenInfo, DataFlowInfo elseInfo) {
            this.thenInfo = thenInfo;
            this.elseInfo = elseInfo;
        }

        private DataFlowInfos(DataFlowInfo info) {
            this(info, info);
        }
    }
}

