/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.types.KotlinType;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"9\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0011\u0019\u0017\u0001\u0004\u0001\u001a\u0003a\u0005\u0011u\u0001\u0003\u0002#\u000e\t\u0001\"A\u0013,\t\u000fA\u0019!D\u0001\u0019\u0005e\u0019\u0001RA\u0007\u00021\rI2\u0001c\u0002\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005AB!G\u0003\t\u000b5\u0019\u0011\"\u0001C\u00021\u0017I\"\u0002\u0003\u0004\u000e\u0011%\u0011\u0011\"\u0001\r\u0005\u0013\rI!\u0001$\u0001\u0019\u000fa5\u0011$\u0003E\b\u001b\u001dI!!C\u0001\u0019\u0011%\u0011\u0011\"\u0001M\t1\u001b\u0001"}, strings={"Lorg/jetbrains/kotlin/types/expressions/SenselessComparisonChecker;", "", "()V", "checkSenselessComparisonWithNull", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "left", "Lorg/jetbrains/kotlin/psi/KtExpression;", "right", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "getType", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getNullability", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/Nullability;"}, moduleName="kotlin-compiler")
public final class SenselessComparisonChecker {
    public static final SenselessComparisonChecker INSTANCE;
    public static final SenselessComparisonChecker INSTANCE$;

    @JvmStatic
    public static final void checkSenselessComparisonWithNull(@NotNull KtBinaryExpression expression, @NotNull KtExpression left, @NotNull KtExpression right, @NotNull ResolutionContext<?> context, @NotNull Function1<? super KtExpression, ? extends KotlinType> getType2, @NotNull Function1<? super DataFlowValue, ? extends Nullability> getNullability) {
        boolean bl;
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(left, "left");
        Intrinsics.checkParameterIsNotNull(right, "right");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(getType2, "getType");
        Intrinsics.checkParameterIsNotNull(getNullability, "getNullability");
        if (KtPsiUtil.isNullConstant(left)) {
            ktExpression = right;
        } else if (KtPsiUtil.isNullConstant(right)) {
            ktExpression = left;
        } else {
            return;
        }
        KtExpression expr = ktExpression;
        KotlinType type2 = getType2.invoke(expr);
        if (type2 == null || type2.isError()) {
            return;
        }
        KtSimpleNameExpression operationSign = expression.getOperationReference();
        DataFlowValue value = DataFlowValueFactory.createDataFlowValue(expr, type2, context);
        boolean equality = Intrinsics.areEqual(operationSign.getReferencedNameElementType(), KtTokens.EQEQ) || Intrinsics.areEqual(operationSign.getReferencedNameElementType(), KtTokens.EQEQEQ);
        DataFlowValue dataFlowValue = value;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowValue, "value");
        Nullability nullability = getNullability.invoke(dataFlowValue);
        if (Intrinsics.areEqual((Object)nullability, (Object)Nullability.NULL)) {
            bl = equality;
        } else if (Intrinsics.areEqual((Object)nullability, (Object)Nullability.NOT_NULL)) {
            bl = !equality;
        } else if (Intrinsics.areEqual((Object)nullability, (Object)Nullability.IMPOSSIBLE)) {
            bl = false;
        } else {
            return;
        }
        boolean expressionIsAlways = bl;
        context.trace.report(Errors.SENSELESS_COMPARISON.on((KtBinaryExpression)((PsiElement)expression), expression, expressionIsAlways));
    }

    private SenselessComparisonChecker() {
        INSTANCE = this;
        INSTANCE$ = this;
    }

    static {
        new SenselessComparisonChecker();
    }
}

