/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"5\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\u0002A\u0003\u0001\u000b\u0005AA!B\u0001\u0005\u0006\u0015\t\u00012B\u0003\u0002\t\u0007)\u0011\u0001C\u0001\u0006\u0003\u0011\rQ!\u0001E\u0015\u000b\u0005!\u0019\u0001b\u0002\r\u0001A]QC\u0001\u0003\u0001\u0011\u0003IB!\u0003\u0002\n\u0003\u0011\u0006\u0001$AO\u0002\u0017/a\u0011u\u0001\u0003\u0002#\u000e\t\u00012AS\u000b\t-Aa!D\u0001\u0019\u000ee\u0019\u0001bB\u0007\u00029\u0001\t6!\u0001E\bK\u0011!1\u0002\u0003\u0005\u000e\u0003aEQe\u0003\u0003L\t!IQ\"\u0001M\u00073\rA\u0019\"D\u0001\u001d\u0001E\u001b\u0011\u0001c\u0004&\u0010\u0011YE\u0001\u0003\u0006\u000e\t%\u0011\u0011\"\u0001\u000f\u00011+I\u0003\u0002B!\u001d\u0011\ti!\u0001$\u0001\u0019\u0006E\u001b\u0011!\u0002\u0001*\u001b\u0011YE\u0004C\u0002\u000e\u0003a\u001d\u0011kA\u0004\u0006\u00015\u0011A\u0001\u0002E\u0005#\t!Q\u0001c\u0003"}, strings={"Lorg/jetbrains/kotlin/utils/SmartSet;", "T", "Ljava/util/AbstractSet;", "()V", "data", "", "size", "", "getSize", "()I", "setSize", "(I)V", "add", "", "e", "(Ljava/lang/Object;)Z", "clear", "", "contains", "o", "iterator", "", "ArrayIterator", "Companion", "SingletonIterator"}, moduleName="kotlin-compiler")
public final class SmartSet<T>
extends AbstractSet<T> {
    private Object data;
    private int size;
    private static final int ARRAY_THRESHOLD = 5;
    public static final Companion Companion = org.jetbrains.kotlin.utils.SmartSet$Companion.INSTANCE;

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        Iterator iterator2;
        if (this.size() == 0) {
            iterator2 = Collections.emptySet().iterator();
        } else if (this.size() == 1) {
            iterator2 = new SingletonIterator<Object>(this.data);
        } else if (this.size() < SmartSet.Companion.getARRAY_THRESHOLD()) {
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            iterator2 = new ArrayIterator<Object>((Object[])object);
        } else {
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.MutableSet<T>");
            }
            iterator2 = TypeIntrinsics.asMutableSet(object).iterator();
        }
        return iterator2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(T e) {
        if (this.size() == 0) {
            this.data = e;
        } else if (this.size() == 1) {
            void elements$iv;
            Object[] objectArray;
            if (Intrinsics.areEqual(this.data, e)) {
                return false;
            }
            Object[] objectArray2 = new Object[]{this.data, e};
            SmartSet smartSet = this;
            smartSet.data = objectArray = (Object[])elements$iv;
        } else if (this.size() < SmartSet.Companion.getARRAY_THRESHOLD()) {
            Object[] objectArray;
            SmartSet smartSet;
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] arr = (Object[])object;
            if (ArraysKt.contains(arr, e)) {
                return false;
            }
            SmartSet smartSet2 = this;
            if (this.size() == SmartSet.Companion.getARRAY_THRESHOLD() - 1) {
                void $receiver$iv2;
                LinkedHashSet<Object> $i$f$arrayOf = SetsKt.linkedSetOf(Arrays.copyOf(arr, arr.length));
                SmartSet smartSet3 = smartSet2;
                LinkedHashSet $receiver = (LinkedHashSet)$receiver$iv2;
                $receiver.add(e);
                void var4_9 = $receiver$iv2;
                smartSet = smartSet3;
                objectArray = var4_9;
            } else {
                void $receiver$iv;
                Object[] $receiver;
                Object[] $receiver$iv2 = Arrays.copyOf(arr, this.size() + 1);
                SmartSet smartSet4 = smartSet2;
                Object[] $i$a$1 = $receiver = $receiver$iv2;
                Object[] objectArray3 = $receiver;
                int n = ((void)$receiver$iv).length;
                objectArray3[n - 1] = e;
                Object[] objectArray4 = $receiver$iv2;
                smartSet = smartSet4;
                objectArray = objectArray4;
            }
            smartSet.data = objectArray;
        } else {
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.MutableSet<T>");
            }
            Set set = TypeIntrinsics.asMutableSet(object);
            if (!set.add(e)) {
                return false;
            }
        }
        SmartSet smartSet = this;
        smartSet.setSize(smartSet.size() + 1);
        return true;
    }

    @Override
    public void clear() {
        this.data = null;
        this.setSize(0);
    }

    @Override
    public boolean contains(Object o) {
        boolean bl;
        if (this.size() == 0) {
            bl = false;
        } else if (this.size() == 1) {
            bl = Intrinsics.areEqual(this.data, o);
        } else if (this.size() < SmartSet.Companion.getARRAY_THRESHOLD()) {
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            bl = ArraysKt.contains((Object[])object, o);
        } else {
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Set<T>");
            }
            bl = ((Set)object).contains(o);
        }
        return bl;
    }

    private SmartSet() {
    }

    static {
        ARRAY_THRESHOLD = 5;
    }

    public /* synthetic */ SmartSet(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @JvmStatic
    @NotNull
    public static final <T> SmartSet<T> create() {
        return Companion.create();
    }

    @JvmStatic
    @NotNull
    public static final <T> SmartSet<T> create(@NotNull Set<? extends T> set) {
        Intrinsics.checkParameterIsNotNull(set, "set");
        return Companion.create(set);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u001b\u0015\tA\"A\u0003\u0001\u000b\u0005AI#B\u0001\u0005\u0005\u0015\t\u00012B\u0003\u0002\t\u0007)\u0011\u0001#\u0001\u0005\u00031\u0001QC\u0001C\u0001\u0011\u0003IB!\u0003\u0002\n\u0003\u0011\u0006\u0001$AQ\u0007\u0013\rA\u0019!D\u0001\u001d\u0002E\u001b\u0011\u0001\u0003\u0002&\n\u0011YE\u0001C\u0002\u000e\u0003a\u001dQe\u0002\u0003L\t!!Q\"\u0001O\u0001#\u000e\t\u0001\u0012B\u0013\u0005\t-AQ!D\u0001\u0019\f%BA!\u0011\u0005\t\u00045\tA\u0014A)\u0004\u0005\u0015\t\u0001RA\u0015\b\t\u0005c\u0002bA\u0007\u00021\u000f\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/kotlin/utils/SmartSet$SingletonIterator;", "T", "", "element", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "hasNext", "", "next", "()Ljava/lang/Object;", "remove", ""}, moduleName="kotlin-compiler")
    private static final class SingletonIterator<T>
    implements Iterator<T>,
    KMutableIterator {
        private boolean hasNext;
        private final T element;

        @Override
        public T next() {
            if (!this.hasNext) {
                throw (Throwable)new NoSuchElementException();
            }
            this.hasNext = false;
            return this.element;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @NotNull
        public Void remove() {
            throw (Throwable)new UnsupportedOperationException();
        }

        public SingletonIterator(T element) {
            this.element = element;
            this.hasNext = true;
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"'\u0015\tA\"A\u0003\u0001\u000b\u0005AI#\u0002\u0001\u0006\u0003!EQ!\u0001\u0003\u0002\u000b\u0005AA#\u0002\u0001\u0006\u0003!-Q!\u0001C\u0002\u000b\u0005A\t\u0001B\u0001\r\u0001U\u0011A\u0011\u0001E\u00013\u0011I!!C\u0001%\u0002a\t\u00115C\u0005\u0007\u0011\u0007iA!\u0003\u0002\n\u0003q\u0005\u0001DA)\u0004\u0003!\u0015Q\u0015\u0002\u0003L\t!!Q\"\u0001M\u0005K\u001d!1\n\u0002\u0005\u0006\u001b\u0005a\n!U\u0002\u0002\u0011\u0017)C\u0001B\u0006\t\r5\t\u0001TB\u0015\u000b\t\u0005C\u0001bA\u0007\u0005\u0013\tI\u0011\u0001(\u0001\u0019\bE\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/kotlin/utils/SmartSet$ArrayIterator;", "T", "", "array", "", "([Ljava/lang/Object;)V", "arrayIterator", "", "hasNext", "", "next", "()Ljava/lang/Object;", "remove", ""}, moduleName="kotlin-compiler")
    private static final class ArrayIterator<T>
    implements Iterator<T>,
    KMutableIterator {
        private final Iterator<T> arrayIterator;

        @Override
        public boolean hasNext() {
            return this.arrayIterator.hasNext();
        }

        @Override
        public T next() {
            return this.arrayIterator.next();
        }

        @NotNull
        public Void remove() {
            throw (Throwable)new UnsupportedOperationException();
        }

        public ArrayIterator(@NotNull T[] array) {
            Intrinsics.checkParameterIsNotNull(array, "array");
            this.arrayIterator = ArrayIteratorKt.iterator(array);
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"!\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!!Q!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\"\u0005\u0003D\u00041\u0001\u0011$\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005)#\u0002b\u0002\t\b5!\u0011BA\u0005\u0002I\u0013AB!\u0005\u0002\u0005\u0002!%Q%\u0005C\u0004\u0011\u000fiA!\u0003\u0002\n\u0003\u0011&\u0001\u0004B\t\u0003\t\u0003AI!\u0007\u0004\t\u000b5!\u0011BA\u0005\u0002I\u0013AZ!k\u0006\u0005\u0003\"\u000b\u00012A\u0007\u00021\t\t6!B\u0003\u0002\u0019\u0003i!\u0001\"\u0002\t\u0007\u0001"}, strings={"Lorg/jetbrains/kotlin/utils/SmartSet$Companion;", "", "()V", "ARRAY_THRESHOLD", "", "getARRAY_THRESHOLD", "()I", "create", "Lorg/jetbrains/kotlin/utils/SmartSet;", "T", "set", ""}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final int getARRAY_THRESHOLD() {
            return ARRAY_THRESHOLD;
        }

        @JvmStatic
        @NotNull
        public final <T> SmartSet<T> create() {
            return new SmartSet(null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final <T> SmartSet<T> create(@NotNull Set<? extends T> set) {
            void var2_2;
            Intrinsics.checkParameterIsNotNull(set, "set");
            SmartSet $receiver$iv = new SmartSet(null);
            SmartSet $receiver = $receiver$iv;
            $receiver.addAll(set);
            return (SmartSet)var2_2;
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

