/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.repl.messages;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.repl.messages.DiagnosticMessageHolder;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"/\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\t\u000f\u0015\tAAA\u0003\u0002\u0011\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001\u0001\u0007\u00013\u0005A\n!)\u0002R\u0007\u0005A\u0011!\n\t\u0005\u0017!-Q\"\u0001\r\u00073\rAi!D\u0001\u0019\u0007e\u0019\u0001bB\u0007\u00021\u001fI2\u0001\u0003\u0005\u000e\u0003a\u001d\u0011\u0006\u0005\u0003B\u0011!\rQBC\u0005\t\u0013\u001dI!!C\u0001\u0019\u0007%\u0011\u0011\"\u0001M\u00041\u000bA\"!U\u0002\u0002\u000b\u0001I#\u0002B&\t\u0011\u0011i\u0011\u0001g\u0002\u001dWE\u001b1!\u0004\u0002\u0005\n!)\u0001"}, strings={"Lorg/jetbrains/kotlin/cli/jvm/repl/messages/ReplIdeDiagnosticMessageHolder;", "Lorg/jetbrains/kotlin/cli/jvm/repl/messages/DiagnosticMessageHolder;", "()V", "diagnostics", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "", "renderedDiagnostics", "getRenderedDiagnostics", "()Ljava/lang/String;", "report", "", "diagnostic", "file", "Lcom/intellij/psi/PsiFile;", "render"}, moduleName="kotlin-compiler")
public final class ReplIdeDiagnosticMessageHolder
implements DiagnosticMessageHolder {
    private final ArrayList<Pair<Diagnostic, String>> diagnostics = CollectionsKt.arrayListOf(new Pair[0]);

    @Override
    public void report(@NotNull Diagnostic diagnostic, @NotNull PsiFile file, @NotNull String render) {
        Intrinsics.checkParameterIsNotNull(diagnostic, "diagnostic");
        Intrinsics.checkParameterIsNotNull(file, "file");
        Intrinsics.checkParameterIsNotNull(render, "render");
        this.diagnostics.add(new Pair<Diagnostic, String>(diagnostic, render));
    }

    @Override
    @NotNull
    public String getRenderedDiagnostics() {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document errorReport = docBuilder.newDocument();
        Element rootElement = errorReport.createElement("report");
        errorReport.appendChild(rootElement);
        for (Pair<Diagnostic, String> pair : this.diagnostics) {
            Diagnostic diagnostic = pair.component1();
            String message = pair.component2();
            TextRange errorRange = DiagnosticUtils.firstRange(diagnostic.getTextRanges());
            Element reportEntry = errorReport.createElement("reportEntry");
            reportEntry.setAttribute("severity", diagnostic.getSeverity().toString());
            reportEntry.setAttribute("rangeStart", String.valueOf(errorRange.getStartOffset()));
            reportEntry.setAttribute("rangeEnd", String.valueOf(errorRange.getEndOffset()));
            reportEntry.appendChild(errorReport.createTextNode(StringUtil.escapeXml(message)));
            rootElement.appendChild(reportEntry);
        }
        DOMImplementation dOMImplementation = errorReport.getImplementation();
        if (dOMImplementation == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.ls.DOMImplementationLS");
        }
        DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)dOMImplementation);
        LSSerializer lsSerializer = domImplementation.createLSSerializer();
        String string = lsSerializer.writeToString(errorReport);
        Intrinsics.checkExpressionValueIsNotNull(string, "lsSerializer.writeToString(errorReport)");
        return string;
    }
}

