/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreter;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantBoxedValuesCollection;
import org.jetbrains.kotlin.relocated.com.google.common.collect.ImmutableSet;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

class RedundantBoxingInterpreter
extends BoxingInterpreter {
    private static final ImmutableSet<Integer> PERMITTED_OPERATIONS_OPCODES = ImmutableSet.of(Integer.valueOf(58), Integer.valueOf(25), Integer.valueOf(87), Integer.valueOf(89), Integer.valueOf(192), Integer.valueOf(193), new Integer[0]);
    private static final ImmutableSet<Integer> PRIMITIVE_TYPES_SORTS_WITH_WRAPPER_EXTENDS_NUMBER = ImmutableSet.of(Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), new Integer[0]);
    private final RedundantBoxedValuesCollection values = new RedundantBoxedValuesCollection();

    public RedundantBoxingInterpreter(InsnList insnList) {
        super(insnList);
    }

    @Override
    public BasicValue binaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value1, @NotNull BasicValue value2) throws AnalyzerException {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "binaryOperation"));
        }
        if (value1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value1", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "binaryOperation"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value2", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "binaryOperation"));
        }
        this.processOperationWithBoxedValue(value1, insn);
        this.processOperationWithBoxedValue(value2, insn);
        return super.binaryOperation(insn, value1, value2);
    }

    @Override
    public BasicValue ternaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value1, @NotNull BasicValue value2, @NotNull BasicValue value3) throws AnalyzerException {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "ternaryOperation"));
        }
        if (value1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value1", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "ternaryOperation"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value2", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "ternaryOperation"));
        }
        if (value3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value3", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "ternaryOperation"));
        }
        this.processOperationWithBoxedValue(value3, insn);
        return super.ternaryOperation(insn, value1, value2, value3);
    }

    @Override
    @Nullable
    public BasicValue unaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value) throws AnalyzerException {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "unaryOperation"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "unaryOperation"));
        }
        if ((insn.getOpcode() == 192 || insn.getOpcode() == 193) && value instanceof BoxedBasicValue) {
            TypeInsnNode typeInsn = (TypeInsnNode)insn;
            if (!RedundantBoxingInterpreter.isSafeCast((BoxedBasicValue)value, typeInsn.desc)) {
                this.markValueAsDirty((BoxedBasicValue)value);
            }
        }
        this.processOperationWithBoxedValue(value, insn);
        return super.unaryOperation(insn, value);
    }

    private static boolean isSafeCast(@NotNull BoxedBasicValue value, @NotNull String targetInternalName) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "isSafeCast"));
        }
        if (targetInternalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetInternalName", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "isSafeCast"));
        }
        if (targetInternalName.equals(Type.getInternalName(Object.class))) {
            return true;
        }
        if (targetInternalName.equals(Type.getInternalName(Number.class))) {
            return PRIMITIVE_TYPES_SORTS_WITH_WRAPPER_EXTENDS_NUMBER.contains(value.getPrimitiveType().getSort());
        }
        return value.getType().getInternalName().equals(targetInternalName);
    }

    @Override
    @NotNull
    public BasicValue copyOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value) throws AnalyzerException {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "copyOperation"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "copyOperation"));
        }
        if (value instanceof BoxedBasicValue && insn.getOpcode() == 58) {
            ((BoxedBasicValue)value).addVariableIndex(((VarInsnNode)insn).var);
        }
        this.processOperationWithBoxedValue(value, insn);
        BasicValue basicValue = super.copyOperation(insn, value);
        if (basicValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "copyOperation"));
        }
        return basicValue;
    }

    public void processPopInstruction(@NotNull AbstractInsnNode insnNode, @NotNull BasicValue value) {
        if (insnNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insnNode", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "processPopInstruction"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "processPopInstruction"));
        }
        this.processOperationWithBoxedValue(value, insnNode);
    }

    @Override
    protected void onNewBoxedValue(@NotNull BoxedBasicValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "onNewBoxedValue"));
        }
        this.values.add(value);
    }

    @Override
    protected void onUnboxing(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value, @NotNull Type resultType) {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "onUnboxing"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "onUnboxing"));
        }
        if (resultType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultType", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "onUnboxing"));
        }
        if (value.getPrimitiveType().equals(resultType)) {
            RedundantBoxingInterpreter.addAssociatedInsn(value, insn);
        } else {
            value.addUnboxingWithCastTo(insn, resultType);
        }
    }

    @Override
    protected void onMethodCallWithBoxedValue(@NotNull BoxedBasicValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "onMethodCallWithBoxedValue"));
        }
        this.markValueAsDirty(value);
    }

    @Override
    protected void onMergeFail(@NotNull BoxedBasicValue v) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "onMergeFail"));
        }
        this.markValueAsDirty(v);
    }

    @Override
    protected void onMergeSuccess(@NotNull BoxedBasicValue v, @NotNull BoxedBasicValue w) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "onMergeSuccess"));
        }
        if (w == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "w", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "onMergeSuccess"));
        }
        this.values.merge(v, w);
    }

    private void processOperationWithBoxedValue(@Nullable BasicValue value, @NotNull AbstractInsnNode insnNode) {
        if (insnNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insnNode", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "processOperationWithBoxedValue"));
        }
        if (value instanceof BoxedBasicValue) {
            if (!PERMITTED_OPERATIONS_OPCODES.contains(insnNode.getOpcode())) {
                this.markValueAsDirty((BoxedBasicValue)value);
            } else {
                RedundantBoxingInterpreter.addAssociatedInsn((BoxedBasicValue)value, insnNode);
            }
        }
    }

    private void markValueAsDirty(@NotNull BoxedBasicValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "markValueAsDirty"));
        }
        this.values.remove(value);
    }

    private static void addAssociatedInsn(@NotNull BoxedBasicValue value, @NotNull AbstractInsnNode insn) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "addAssociatedInsn"));
        }
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "addAssociatedInsn"));
        }
        if (value.isSafeToRemove()) {
            value.addInsn(insn);
        }
    }

    @NotNull
    public RedundantBoxedValuesCollection getCandidatesBoxedValues() {
        RedundantBoxedValuesCollection redundantBoxedValuesCollection = this.values;
        if (redundantBoxedValuesCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "getCandidatesBoxedValues"));
        }
        return redundantBoxedValuesCollection;
    }
}

