/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.KProperty;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.LazyClasspathWatcher;
import org.jetbrains.kotlin.daemon.LazyClasspathWatcher$log$1;
import org.jetbrains.kotlin.daemon.LazyClasspathWatcherKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"K\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u001d\u0015\t\u0001bB\u0003\u0001\u000b\u0005AI!B\u0001\u0005\u0007\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001E\u0006\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tAa\u0001\u0007\u00013\u0005A\n!(\u0001\u0011COIa\u0001C\u0001\u000e\t%\u0011\u0011\"\u0001\r\u00031\u0007IA\u0001B\u0001\t\u00065\t\u0001dA\u0005\u0005\t\u0005A9!D\u0001\u0019\u0007E\u001b\u0011\u0001\u0003\u0003*\u0015\u0011\u0019\u0005\u0002#\u0002\u000e\u0003a\u0019\u0011k\u0001\u0003\u0006\u00015\u0011A\u0011\u0002\u0005\u0006S)!1\t\u0003E\u0004\u001b\u0005A2!U\u0002\u0005\u000b\u0001i!\u0001b\u0003\t\u000b%ZA!\u0011\u000f\t\r5)\u0011BA\u0005\u00021\u001da\t\u0001'\u0004R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"Ay!D\u0001\u0019\u0011E\u001b\u0011!\u0002\u0001*\u0015\u0011\u0019\u0005\u0002#\u0005\u000e\u0003aIAdI)\u0004\u00075\u0011A\u0011\u0003E\nS\u001d!\u0011\t\u0003\u0005\u000b\u001b\u0005A*\"U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011-i\u0011\u0001g\u0006R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"AA\"D\u0001\u0019\u0018E\u001b\u0011!\u0002\u0001*#\u0011\t\u0005\u0002#\u0007\u000e\u000bAmQC\u0001G\u000115AR\u0002H\u0011R\u0007\u0019)!\u0001B\b\t 5\u0011AA\u0004E\u000f"}, strings={"Lorg/jetbrains/kotlin/daemon/LazyClasspathWatcher;", "", "classpath", "", "", "checkPeriod", "", "digestCheckPeriod", "(Ljava/lang/Iterable;JJ)V", "getCheckPeriod", "()J", "getDigestCheckPeriod", "fileIds", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/daemon/LazyClasspathWatcher$FileId;", "fileIdsLock", "Ljava/util/concurrent/Semaphore;", "isChanged", "", "()Z", "lastChangedStatus", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastDigestUpdate", "Ljava/util/concurrent/atomic/AtomicLong;", "lastUpdate", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Ljava/util/logging/Logger;", "log$delegate", "Lkotlin/Lazy;", "FileId"}, moduleName="kotlin-compiler")
public final class LazyClasspathWatcher {
    private final Semaphore fileIdsLock;
    private ArrayList<FileId> fileIds;
    private final AtomicBoolean lastChangedStatus;
    private final AtomicLong lastUpdate;
    private final AtomicLong lastDigestUpdate;
    private final Lazy<Logger> log$delegate;
    private final long checkPeriod;
    private final long digestCheckPeriod;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    private final Logger getLog() {
        return LazyKt.getValue(this.log$delegate, this, $$delegatedProperties[0]);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isChanged() {
        FileId fileId;
        if (this.lastChangedStatus.get()) {
            return true;
        }
        long nowMs = TimeUnit.MILLISECONDS.toMillis(System.nanoTime());
        if (nowMs - this.lastUpdate.get() < this.checkPeriod) {
            return false;
        }
        boolean checkDigest = nowMs - this.lastDigestUpdate.get() > this.digestCheckPeriod;
        this.fileIdsLock.acquire();
        this.fileIdsLock.release();
        ArrayList<FileId> arrayList = this.fileIds;
        if (arrayList != null) {
            Object v2;
            block12: {
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = arrayList;
                void var5_4 = $receiver$iv;
                for (Object element$iv$iv : $receiver$iv$iv) {
                    boolean bl;
                    FileId it = (FileId)element$iv$iv;
                    try {
                        boolean bl2;
                        if (!it.getFile().exists()) {
                            this.getLog().info("cp changed: " + it.getFile() + " doesn't exist any more");
                            bl2 = true;
                        } else if ((it.getFile().lastModified() != it.getLastModified() || checkDigest) && !Arrays.equals(it.getDigest(), LazyClasspathWatcherKt.md5Digest(it.getFile()))) {
                            this.getLog().info("cp changed: " + it.getFile() + " digests differ");
                            bl2 = true;
                        } else {
                            bl2 = false;
                        }
                        bl = bl2;
                    }
                    catch (IOException e) {
                        this.getLog().log(Level.INFO, "cp changed: " + it.getFile() + " access throws the exception", e);
                        bl = true;
                    }
                    if (!bl) continue;
                    v2 = element$iv$iv;
                    break block12;
                }
                v2 = null;
            }
            fileId = v2;
        } else {
            fileId = null;
        }
        boolean changed = fileId != null;
        this.lastUpdate.set(TimeUnit.MILLISECONDS.toMillis(System.nanoTime()));
        if (checkDigest) {
            this.lastDigestUpdate.set(this.lastUpdate.get());
        }
        return changed;
    }

    public final long getCheckPeriod() {
        return this.checkPeriod;
    }

    public final long getDigestCheckPeriod() {
        return this.digestCheckPeriod;
    }

    public LazyClasspathWatcher(final @NotNull Iterable<String> classpath, long checkPeriod, long digestCheckPeriod) {
        Intrinsics.checkParameterIsNotNull(classpath, "classpath");
        this.checkPeriod = checkPeriod;
        this.digestCheckPeriod = digestCheckPeriod;
        this.fileIdsLock = new Semaphore(1);
        this.lastChangedStatus = new AtomicBoolean(false);
        this.lastUpdate = new AtomicLong(0L);
        this.lastDigestUpdate = new AtomicLong(0L);
        this.log$delegate = LazyKt.lazy(log.2.INSTANCE);
        this.fileIdsLock.acquire();
        Function0 function0 = new Function0<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public final void invoke() {
                try {
                    List list;
                    void destination$iv$iv;
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    Iterable iterable = classpath;
                    LazyClasspathWatcher lazyClasspathWatcher = this;
                    void var3_5 = $receiver$iv;
                    Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        list = destination$iv$iv;
                        File file = new File((String)it);
                        list.add(file);
                    }
                    list = (List)destination$iv$iv;
                    lazyClasspathWatcher.fileIds = SequencesKt.toArrayList(SequencesKt.map(SequencesKt.flatMap(CollectionsKt.asSequence(list), 2.INSTANCE), 3.INSTANCE));
                    long nowMs = TimeUnit.MILLISECONDS.toMillis(System.nanoTime());
                    lastUpdate.set(nowMs);
                    lastDigestUpdate.set(nowMs);
                }
                catch (IOException e) {
                    this.getLog().log(Level.WARNING, "Error on walking classpath", e);
                }
                finally {
                    fileIdsLock.release();
                }
            }
        };
        boolean bl = true;
        int n = 0;
        String string = null;
        ClassLoader classLoader = null;
        boolean bl2 = true;
        ThreadsKt.thread$default(bl, classLoader, string, n, bl2, function0, 14);
    }

    public /* synthetic */ LazyClasspathWatcher(Iterable iterable, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = LazyClasspathWatcherKt.getDEFAULT_CLASSPATH_WATCH_PERIOD_MS();
        }
        if ((n & 4) != 0) {
            l2 = LazyClasspathWatcherKt.getDEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS();
        }
        this(iterable, l, l2);
    }

    static {
        $$delegatedProperties = new KProperty[]{LazyClasspathWatcher$log$1.INSTANCE};
    }

    @Nullable
    public static final /* synthetic */ ArrayList access$getFileIds$p(LazyClasspathWatcher $this) {
        return $this.fileIds;
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001E\u0005\u000b\u0001)\u0011\u0001C\u0005\u0006\u0003\u0011-A!\u0011\u0003\r\u0001e\t\u0001\u0014AQ\u000f\u0013\rA\u0011!D\u0001\u0019\u0004%\u0019\u0001BA\u0007\u00021\u000bI1\u0001C\u0002\u000e\u0003a\u001d\u0011kA\u0001\t\t\u0015&AaQ\u0004\t\u00105\t\u00014AS\u0005\t\r;\u0001\u0002C\u0007\u00021\u000b)K\u0001B\"\b\u0011#i\u0011\u0001g\u0002&(\u0011\u00195\u0001C\u0005\u000e\u0003a\u0001\u0011\u0004\u0002\u0003\u0002\u0011\u0005i\u0011\u0001g\u0001\u001a\t\u0011\t\u0001BA\u0007\u00021\u000bIB\u0001B\u0001\t\u00075\t\u0001tA\u0015\u000b\t\rC\u0001bA\u0007\u00021\u000f\t6\u0001B\u0003\u0001\u001b\t!I\u0001C\u0003*\u0015\u0011\u0019\u0005\u0002C\u0001\u000e\u0003a\r\u0011k\u0001\u0003\u0006\u00015\u0011A1\u0002\u0005\u0007S)!1\t\u0003\u0005\u0003\u001b\u0005A*!U\u0002\u0005\u000b\u0001i!\u0001\"\u0004\t\u000f\u0001"}, strings={"Lorg/jetbrains/kotlin/daemon/LazyClasspathWatcher$FileId;", "", "file", "Ljava/io/File;", "lastModified", "", "digest", "", "(Ljava/io/File;J[B)V", "getDigest", "()[B", "getFile", "()Ljava/io/File;", "getLastModified", "()J", "component1", "component2", "component3", "copy"}, moduleName="kotlin-compiler")
    private static final class FileId {
        @NotNull
        private final File file;
        private final long lastModified;
        @NotNull
        private final byte[] digest;

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public final long getLastModified() {
            return this.lastModified;
        }

        @NotNull
        public final byte[] getDigest() {
            return this.digest;
        }

        public FileId(@NotNull File file, long lastModified, @NotNull byte[] digest) {
            Intrinsics.checkParameterIsNotNull(file, "file");
            Intrinsics.checkParameterIsNotNull(digest, "digest");
            this.file = file;
            this.lastModified = lastModified;
            this.digest = digest;
        }

        @NotNull
        public final File component1() {
            return this.file;
        }

        public final long component2() {
            return this.lastModified;
        }

        @NotNull
        public final byte[] component3() {
            return this.digest;
        }

        @NotNull
        public final FileId copy(@NotNull File file, long lastModified, @NotNull byte[] digest) {
            Intrinsics.checkParameterIsNotNull(file, "file");
            Intrinsics.checkParameterIsNotNull(digest, "digest");
            return new FileId(file, lastModified, digest);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ FileId copy$default(FileId fileId, File file, long l, byte[] byArray, int n) {
            if ((n & 1) != 0) {
                file = fileId.file;
            }
            if ((n & 2) != 0) {
                l = fileId.lastModified;
            }
            if ((n & 4) != 0) {
                byArray = fileId.digest;
            }
            return fileId.copy(file, l, byArray);
        }

        public String toString() {
            return "FileId(file=" + this.file + ", lastModified=" + this.lastModified + ", digest=" + Arrays.toString(this.digest) + ")";
        }

        public int hashCode() {
            File file = this.file;
            long l = this.lastModified;
            return ((file != null ? ((Object)file).hashCode() : 0) * 31 + (int)(l ^ l >>> 32)) * 31 + (this.digest != null ? Arrays.hashCode(this.digest) : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FileId)) break block3;
                    FileId fileId = (FileId)object;
                    if (!Intrinsics.areEqual(this.file, fileId.file) || !(this.lastModified == fileId.lastModified) || !Intrinsics.areEqual(this.digest, fileId.digest)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

