/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.operation;

import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.AbstractBinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.LongCompareToBOIF;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.relocated.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.utils.FunctionsKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011MQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0005G\u0006a\u0001!G\u0001\u0019\u0002u\r\u00113\u0005\n\"\b\u0011\t\u0011kA\u0001\t\u0003\u0015JAa\u0003\u0005\u000e\u001b\ta\t\u0001g\u0007\u001a\u0007!qQ\"\u0001M\u000fKY!1\u0002C\b\u000e'%1\u0011\"\u0002I\u0011+\ta\t\u0001\u0007\t\u0019!A\u0005R#C\u0005\u0007\u0013\u0015\u0001\n#\u0006\u0002\r\u0002a\u0001\u0002\u0004\u0005G\u00011?Az\"K\u0004\u0005\u0003\"A\u0019!D\u0001\u0019\u0005E\u001b\u0011!\u0002\u0001*\u001a\u0011\u0019\u0005\u0002#\u0002\u000e\ba\u0019\u0011kA\u0001\u0005\bE\u001bA!\u0002\u0001\u000e\u0005\u0011!\u0001\u0012BU\r\t\rC\u0001\"BG\u00041\r\t6!\u0001C\u0004#\u000e!Q\u0001A\u0007\u0003\t\u0017AI!K\u0004\u0005\u0003\"Aa!D\u0001\u0019\u0005E\u001b\u0011!\u0002\u0001*\u001a\u0011\u0019\u0005\u0002#\u0004\u000e\ba\u0019\u0011kA\u0001\u0005\bE\u001bA!\u0002\u0001\u000e\u0005\u00119\u0001\u0012B\u0015\b\t\u0005C\u0001rB\u0007\u00021\t\t6!A\u0003\u0001S3!1\t\u0003\u0005\t\u001b\u000fA2!U\u0002\u0002\t\u000f\t6\u0001B\u0003\u0001\u001b\t!\t\u0002#\u0003*\u001a\u0011\u0019\u0005\u0002C\u0005\u000e\ba\u0019\u0011kA\u0001\u0005\bE\u001bA!\u0002\u0001\u000e\u0005\u0011M\u0001\u0012B\u0015\b\t\u0005C\u0001BC\u0007\u00021\t\t6!A\u0003\u0001S3!1\t\u0003E\u000b\u001b\u000fA2!U\u0002\u0002\t\u000f\t6\u0001B\u0003\u0001\u001b\t!1\u0002#\u0003*\u000f\u0011\t\u0005\u0002c\u0006\u000e\u0003a\u0011\u0011kA\u0001\u0006\u0001%fAa\u0011\u0005\t\u00195\u001d\u0001dA)\u0004\u0003\u0011\u001d\u0011k\u0001\u0003\u0006\u00015\u0011A\u0011\u0004E\u0005"}, strings={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/LongCompareToBOIF;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsicFactory;", "()V", "CHAR_COMPARE_TO_LONG", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/LongCompareToBOIF$CompareToBinaryIntrinsic;", "CHAR_COMPARE_TO_LONG_PATTERN", "Lorg/jetbrains/kotlin/js/patterns/DescriptorPredicate;", "Lorg/jetbrains/annotations/NotNull;", "getCHAR_COMPARE_TO_LONG_PATTERN", "()Lorg/jetbrains/kotlin/js/patterns/DescriptorPredicate;", "FLOATING_POINT_COMPARE_TO_LONG_PATTERN", "getFLOATING_POINT_COMPARE_TO_LONG_PATTERN", "INTEGER_COMPARE_TO_LONG", "INTEGER_COMPARE_TO_LONG_PATTERN", "getINTEGER_COMPARE_TO_LONG_PATTERN", "LONG_COMPARE_TO_CHAR", "LONG_COMPARE_TO_CHAR_PATTERN", "getLONG_COMPARE_TO_CHAR_PATTERN", "LONG_COMPARE_TO_FLOATING_POINT_PATTERN", "getLONG_COMPARE_TO_FLOATING_POINT_PATTERN", "LONG_COMPARE_TO_INTEGER", "LONG_COMPARE_TO_INTEGER_PATTERN", "getLONG_COMPARE_TO_INTEGER_PATTERN", "LONG_COMPARE_TO_LONG", "LONG_COMPARE_TO_LONG_PATTERN", "getLONG_COMPARE_TO_LONG_PATTERN", "getIntrinsic", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getSupportTokens", "Lorg/jetbrains/kotlin/relocated/com/google/common/collect/ImmutableSet;", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "CompareToBinaryIntrinsic", "FLOATING_POINT_COMPARE_TO_LONG", "LONG_COMPARE_TO_FLOATING_POINT"}, moduleName="kotlin-compiler")
public final class LongCompareToBOIF
implements BinaryOperationIntrinsicFactory {
    @NotNull
    public static final DescriptorPredicate FLOATING_POINT_COMPARE_TO_LONG_PATTERN;
    @NotNull
    public static final DescriptorPredicate LONG_COMPARE_TO_FLOATING_POINT_PATTERN;
    @NotNull
    public static final DescriptorPredicate INTEGER_COMPARE_TO_LONG_PATTERN;
    @NotNull
    public static final DescriptorPredicate CHAR_COMPARE_TO_LONG_PATTERN;
    @NotNull
    public static final DescriptorPredicate LONG_COMPARE_TO_INTEGER_PATTERN;
    @NotNull
    public static final DescriptorPredicate LONG_COMPARE_TO_CHAR_PATTERN;
    @NotNull
    public static final DescriptorPredicate LONG_COMPARE_TO_LONG_PATTERN;
    private static final CompareToBinaryIntrinsic INTEGER_COMPARE_TO_LONG;
    private static final CompareToBinaryIntrinsic CHAR_COMPARE_TO_LONG;
    private static final CompareToBinaryIntrinsic LONG_COMPARE_TO_INTEGER;
    private static final CompareToBinaryIntrinsic LONG_COMPARE_TO_CHAR;
    private static final CompareToBinaryIntrinsic LONG_COMPARE_TO_LONG;
    public static final LongCompareToBOIF INSTANCE;
    public static final LongCompareToBOIF INSTANCE$;

    @NotNull
    public final DescriptorPredicate getFLOATING_POINT_COMPARE_TO_LONG_PATTERN() {
        return FLOATING_POINT_COMPARE_TO_LONG_PATTERN;
    }

    @NotNull
    public final DescriptorPredicate getLONG_COMPARE_TO_FLOATING_POINT_PATTERN() {
        return LONG_COMPARE_TO_FLOATING_POINT_PATTERN;
    }

    @NotNull
    public final DescriptorPredicate getINTEGER_COMPARE_TO_LONG_PATTERN() {
        return INTEGER_COMPARE_TO_LONG_PATTERN;
    }

    @NotNull
    public final DescriptorPredicate getCHAR_COMPARE_TO_LONG_PATTERN() {
        return CHAR_COMPARE_TO_LONG_PATTERN;
    }

    @NotNull
    public final DescriptorPredicate getLONG_COMPARE_TO_INTEGER_PATTERN() {
        return LONG_COMPARE_TO_INTEGER_PATTERN;
    }

    @NotNull
    public final DescriptorPredicate getLONG_COMPARE_TO_CHAR_PATTERN() {
        return LONG_COMPARE_TO_CHAR_PATTERN;
    }

    @NotNull
    public final DescriptorPredicate getLONG_COMPARE_TO_LONG_PATTERN() {
        return LONG_COMPARE_TO_LONG_PATTERN;
    }

    public ImmutableSet<KtSingleValueToken> getSupportTokens() {
        return OperatorConventions.COMPARISON_OPERATIONS;
    }

    @Override
    @Nullable
    public BinaryOperationIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (JsDescriptorUtils.isBuiltin(descriptor2)) {
            return FLOATING_POINT_COMPARE_TO_LONG_PATTERN.apply(descriptor2) ? (AbstractBinaryOperationIntrinsic)FLOATING_POINT_COMPARE_TO_LONG.INSTANCE : (LONG_COMPARE_TO_FLOATING_POINT_PATTERN.apply(descriptor2) ? (AbstractBinaryOperationIntrinsic)LONG_COMPARE_TO_FLOATING_POINT.INSTANCE : (INTEGER_COMPARE_TO_LONG_PATTERN.apply(descriptor2) ? (AbstractBinaryOperationIntrinsic)INTEGER_COMPARE_TO_LONG : (CHAR_COMPARE_TO_LONG_PATTERN.apply(descriptor2) ? (AbstractBinaryOperationIntrinsic)CHAR_COMPARE_TO_LONG : (LONG_COMPARE_TO_INTEGER_PATTERN.apply(descriptor2) ? (AbstractBinaryOperationIntrinsic)LONG_COMPARE_TO_INTEGER : (LONG_COMPARE_TO_CHAR_PATTERN.apply(descriptor2) ? (AbstractBinaryOperationIntrinsic)LONG_COMPARE_TO_CHAR : (LONG_COMPARE_TO_LONG_PATTERN.apply(descriptor2) ? (AbstractBinaryOperationIntrinsic)LONG_COMPARE_TO_LONG : (AbstractBinaryOperationIntrinsic)null))))));
        }
        return null;
    }

    private LongCompareToBOIF() {
        INSTANCE = this;
        INSTANCE$ = this;
        FLOATING_POINT_COMPARE_TO_LONG_PATTERN = PatternBuilder.pattern("Double|Float.compareTo(Long)");
        LONG_COMPARE_TO_FLOATING_POINT_PATTERN = PatternBuilder.pattern("Long.compareTo(Float|Double)");
        INTEGER_COMPARE_TO_LONG_PATTERN = PatternBuilder.pattern("Int|Short|Byte.compareTo(Long)");
        CHAR_COMPARE_TO_LONG_PATTERN = PatternBuilder.pattern("Char.compareTo(Long)");
        LONG_COMPARE_TO_INTEGER_PATTERN = PatternBuilder.pattern("Long.compareTo(Int|Short|Byte)");
        LONG_COMPARE_TO_CHAR_PATTERN = PatternBuilder.pattern("Long.compareTo(Char)");
        LONG_COMPARE_TO_LONG_PATTERN = PatternBuilder.pattern("Long.compareTo(Long)");
        INTEGER_COMPARE_TO_LONG = new CompareToBinaryIntrinsic(INTEGER_COMPARE_TO_LONG.1.INSTANCE, FunctionsKt.identity());
        CHAR_COMPARE_TO_LONG = new CompareToBinaryIntrinsic(CHAR_COMPARE_TO_LONG.1.INSTANCE, FunctionsKt.identity());
        LONG_COMPARE_TO_INTEGER = new CompareToBinaryIntrinsic(FunctionsKt.identity(), LONG_COMPARE_TO_INTEGER.1.INSTANCE);
        LONG_COMPARE_TO_CHAR = new CompareToBinaryIntrinsic(FunctionsKt.identity(), LONG_COMPARE_TO_CHAR.1.INSTANCE);
        LONG_COMPARE_TO_LONG = new CompareToBinaryIntrinsic(FunctionsKt.identity(), FunctionsKt.identity());
    }

    static {
        new LongCompareToBOIF();
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tA!Y\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002KQ!1\u0002c\u0001\u000e\u0003a\u0011\u0011d\u0001E\u0003\u001b\u0005A2!G\u0002\t\b5\t\u0001DA\r\u0004\u0011\u0011i\u0011\u0001\u0007\u0002\u001a\u0007!%Q\"\u0001\r\u0006"}, strings={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/LongCompareToBOIF$FLOATING_POINT_COMPARE_TO_LONG;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/AbstractBinaryOperationIntrinsic;", "()V", "apply", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "left", "right", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;"}, moduleName="kotlin-compiler")
    private static final class FLOATING_POINT_COMPARE_TO_LONG
    extends AbstractBinaryOperationIntrinsic {
        public static final FLOATING_POINT_COMPARE_TO_LONG INSTANCE;
        public static final FLOATING_POINT_COMPARE_TO_LONG INSTANCE$;

        @Override
        @NotNull
        public JsExpression apply(@NotNull KtBinaryExpression expression, @NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            Intrinsics.checkParameterIsNotNull(left, "left");
            Intrinsics.checkParameterIsNotNull(right, "right");
            Intrinsics.checkParameterIsNotNull(context, "context");
            JsBinaryOperator operator = OperatorTable.getBinaryOperator(PsiUtils.getOperationToken(expression));
            return new JsBinaryOperation(operator, left, JsAstUtils.invokeMethod(right, "toNumber", new JsExpression[0]));
        }

        private FLOATING_POINT_COMPARE_TO_LONG() {
            INSTANCE = this;
            INSTANCE$ = this;
        }

        static {
            new FLOATING_POINT_COMPARE_TO_LONG();
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tA!Y\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002KQ!1\u0002c\u0001\u000e\u0003a\u0011\u0011d\u0001E\u0003\u001b\u0005A2!G\u0002\t\b5\t\u0001DA\r\u0004\u0011\u0011i\u0011\u0001\u0007\u0002\u001a\u0007!%Q\"\u0001\r\u0006"}, strings={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/LongCompareToBOIF$LONG_COMPARE_TO_FLOATING_POINT;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/AbstractBinaryOperationIntrinsic;", "()V", "apply", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "left", "right", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;"}, moduleName="kotlin-compiler")
    private static final class LONG_COMPARE_TO_FLOATING_POINT
    extends AbstractBinaryOperationIntrinsic {
        public static final LONG_COMPARE_TO_FLOATING_POINT INSTANCE;
        public static final LONG_COMPARE_TO_FLOATING_POINT INSTANCE$;

        @Override
        @NotNull
        public JsExpression apply(@NotNull KtBinaryExpression expression, @NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            Intrinsics.checkParameterIsNotNull(left, "left");
            Intrinsics.checkParameterIsNotNull(right, "right");
            Intrinsics.checkParameterIsNotNull(context, "context");
            JsBinaryOperator operator = OperatorTable.getBinaryOperator(PsiUtils.getOperationToken(expression));
            return new JsBinaryOperation(operator, JsAstUtils.invokeMethod(left, "toNumber", new JsExpression[0]), right);
        }

        private LONG_COMPARE_TO_FLOATING_POINT() {
            INSTANCE = this;
            INSTANCE$ = this;
        }

        static {
            new LONG_COMPARE_TO_FLOATING_POINT();
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\u000f)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\t\u0005a\u0001!G\u0001\u0019\u0002\u00056\u0012\"\u0003\u0005\u0002\u001b\u001dI!!C\u0001\u0019\u0005%\u0011\u0011\"\u0001\r\u00031\u0007I\u0011\u0002#\u0002\u000e\u000f%\u0011\u0011\"\u0001\r\u0003\u0013\tI\u0011\u0001\u0007\u0002\u0019\u0004E\u001b\u0011\u0001C\u0002&)\u0011Y\u0001\"B\u0007\u00021\tI2\u0001c\u0003\u000e\u0003a1\u0011d\u0001E\u0007\u001b\u0005A\"!G\u0002\t\u000f5\t\u0001DA\r\u0004\u0011\u001fi\u0011\u0001\u0007\u0005*!\u0011\u0019\u0005\u0002C\u0001\u000e\u000f%\u0011\u0011\"\u0001\r\u0003\u0013\tI\u0011\u0001\u0007\u0002\u0019\u0004E\u001bA!\u0002\u0001\u000e\u0005\u0011\u001d\u0001\u0002B\u0015\u0011\t\rC\u0001RA\u0007\b\u0013\tI\u0011\u0001\u0007\u0002\n\u0005%\t\u0001D\u0001M\u0002#\u000e!Q\u0001A\u0007\u0003\t\u0013AA\u0001"}, strings={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/LongCompareToBOIF$CompareToBinaryIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/AbstractBinaryOperationIntrinsic;", "toLeft", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "toRight", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getToLeft", "()Lkotlin/jvm/functions/Function1;", "getToRight", "apply", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "left", "right", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;"}, moduleName="kotlin-compiler")
    private static final class CompareToBinaryIntrinsic
    extends AbstractBinaryOperationIntrinsic {
        @NotNull
        private final Function1<JsExpression, JsExpression> toLeft;
        @NotNull
        private final Function1<JsExpression, JsExpression> toRight;

        @Override
        @NotNull
        public JsExpression apply(@NotNull KtBinaryExpression expression, @NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            Intrinsics.checkParameterIsNotNull(left, "left");
            Intrinsics.checkParameterIsNotNull(right, "right");
            Intrinsics.checkParameterIsNotNull(context, "context");
            JsBinaryOperator operator = OperatorTable.getBinaryOperator(PsiUtils.getOperationToken(expression));
            JsExpression compareInvocation = JsAstUtils.compareForObject(this.toLeft.invoke(left), this.toRight.invoke(right));
            return new JsBinaryOperation(operator, compareInvocation, JsNumberLiteral.ZERO);
        }

        @NotNull
        public final Function1<JsExpression, JsExpression> getToLeft() {
            return this.toLeft;
        }

        @NotNull
        public final Function1<JsExpression, JsExpression> getToRight() {
            return this.toRight;
        }

        public CompareToBinaryIntrinsic(@NotNull Function1<? super JsExpression, ? extends JsExpression> toLeft, @NotNull Function1<? super JsExpression, ? extends JsExpression> toRight) {
            Intrinsics.checkParameterIsNotNull(toLeft, "toLeft");
            Intrinsics.checkParameterIsNotNull(toRight, "toRight");
            this.toLeft = toLeft;
            this.toRight = toRight;
        }
    }
}

