/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.IntRange;
import kotlin.PreconditionsKt;
import kotlin.Sequence;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.KotlinLocalClass;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.context.TypeLazinessToken;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtSelfType;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.PlatformTypesMappedToKotlinChecker;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.TypeResolver$Companion$WhenMappings;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallableDescriptors;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.LazyEntity;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LazyScopeAdapter;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.DelegatingFlexibleType;
import org.jetbrains.kotlin.types.DelegatingType;
import org.jetbrains.kotlin.types.DynamicTypesSettings;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypeCapabilities;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"m\u0004)\u0011\u0001D\u0001\u0006\u0003!\u0001Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011A)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0002B\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\b\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u0003!-Q!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001C\u0003\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u00031\tQ!\u0001\u0003\u0002\u0019\u0001\u0001*&G\u0001\u0019\u0002u\t)fKQ'\u0013\rA\u0011!D\u0001\u0019\u0004%\u0019\u0001BA\u0007\u00021\u000bI1\u0001C\u0002\u000e\u0003a\u001d\u0011b\u0001\u0005\u0005\u001b\u0005AJ!C\u0002\t\u000b5\t\u00014B\u0005\u0004\u0011\u0019i\u0011\u0001'\u0004\n\u0007!9Q\"\u0001M\b\u0013\rA\u0001\"D\u0001\u0019\u0012%\u0019\u0001\"C\u0007\u00021'\t6!\u0001\u0005\u000bKI!\u0011\u0001#\u0006\u000e\t%\u0011\u0011\"\u0001M\f1-I2\u0001\u0003\u0007\u000e\u0003ae\u0011D\u0002\u0005\u000e\u001b\u0011I!!C\u0001\u0019\u001caYQe\u0006\u0003\u0002\u00119iQ!\u0003\u0002\n\u0003auA\u0012\u0001\r\f3\rAq\"D\u0001\u0019 e\u0019\u0001\u0002E\u0007\u00021CIb\u0001C\t\u000e\t%\u0011\u0011\"\u0001M\u00121-)C\u0003B\u0001\t%5\t\u0001TE\r\u0004\u0011=i\u0011\u0001g\b\u001a\r!\u0019R\u0002B\u0005\u0003\u0013\u0005Aj\u0002G\u0006\u001a\t\u0011\t\u0001rE\u0007\u00021Q)C\u0002B\u0001\t*5\t\u0001TE\r\u0004\u0011=i\u0011\u0001g\b\u001a\u0007!)R\"\u0001M\u0016K!!\u0011\u0001\u0003\f\u000e\u0003a5\u0012d\u0001\u0005\u0018\u001b\u0005Az#\n\u0007\u0005\u0003!AR\"\u0001M\u00193\rAq\"D\u0001\u0019 e\u0019\u0001\"G\u0007\u000217)\u0003\u0003c\r\u000e\u00051\u0005\u0001DG\r\u0004\u0011ki\u0011\u0001G\u000e\u001a\u0007!]R\"\u0001\r\u001d3\rAI$D\u0001\u0019;\u0015z\u00012H\u0007\u00021yI2\u0001#\u000e\u000e\u0003aY\u0012d\u0001E\u001c\u001b\u0005AB$G\u0002\t:5\t\u0001$H\u0013\f\u0011{i\u0011\u0001'\n\u001a\u0007!yQ\"\u0001M\u00103\rAQ#D\u0001\u0019,\u0015bA!\u0001\u0005 \u001b\u0005Az#G\u0002\t\u001f5\t\u0001tD\r\u0004\u0011Ui\u0011\u0001g\u000b&'!yR\"\u0001M\u00183\rA)$D\u0001\u00197e\u0019\u0001\"F\u0007\u00021WI2\u0001#\u000f\u000e\u0003ai\u0012d\u0001E \u001b\u0005A\u0002%J\t\u0005\u0003!\u0005S\"\u0001M\u00133\rAq\"D\u0001\u0019 e\u0019\u0001\"I\u0007\u00021\u0007JB\u0001\u0003\u0012\u000e\u00051\u0005\u0001TI\u0013\u0019\t\u0005A1%D\u0001\u0019&e\u0019\u0001bD\u0007\u00021?I2\u0001C\u0011\u000e\u0003a\r\u0013d\u0001\u0005\u0011\u001b\u0005A\n#G\u0002\t/5\t\u0001\u0004H\r\u0004\u0011\u000fj\u0011\u0001\u0007\u0010&1\u0011\t\u0001\u0002J\u0007\u00021_I2\u0001C\b\u000e\u0003a}\u0011d\u0001\u0005\"\u001b\u0005A\u001a%G\u0002\tJ5\t\u00014D\r\u0004\u0011\u0015j\u0011\u0001g\u0013\u001a\u0007!9R\"\u0001\r\u001dKY!\u0011\u0001\u0003\u0014\u000e\t%\u0011\u0011\"\u0001M'1-I2\u0001C\b\u000e\u0003a}\u0011d\u0001\u0005(\u001b\u0005Az%\u0007\u0004\t'5!\u0011BA\u0005\u00021;A2\"J\f\u0005\u0003!AS\u0002B\u0005\u0003\u0013\u0005Aj\u0005G\u0006\u001a\u0007!yQ\"\u0001M\u00103\u0019A1#\u0004\u0003\n\u0005%\t\u0001T\u0004\r\f3\u0011!\u0011\u0001c\n\u000e\u0003a!RE\u0003\u0003\u0002\u0011#jA!\u0003\u0002\n\u0003a\u0005\u0002dC\u000b\u0003\u0019\u0003A\"$j\u0006\u0005\u0003!IS\"\u0001\r!+\u0005AZ\"'\u0003\t\u001f5\t\u0001t\u0004)\u0004\u0002\u0015^A!\u0001E*\u001b\u0005A\u0002%F\u0001\u0019Ue%\u0001\u0002E\u0007\u00021C\u00016\u0011A\u0015\b\t\u0005C\u0001\"A\u0007\u00021\u0007\t6!A\u0003\u0001S\u001d!\u0011\t\u0003\u0005\t\u001b\u0005A\n\"U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\u001di\u0011\u0001g\u0004R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"AA!D\u0001\u0019\nE\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002C\u0005\u000e\u0003aM\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\r5\t\u0001TB)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!\u0019Q\"\u0001M\u0004#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001BA\u0007\u00021\u000b\t6!A\u0003\u0001S\u001d!\u0011\t\u0003\u0005\u0006\u001b\u0005AZ!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/TypeResolver;", "", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "qualifiedExpressionResolver", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "flexibleTypeCapabilitiesProvider", "Lorg/jetbrains/kotlin/resolve/TypeResolver$FlexibleTypeCapabilitiesProvider;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "lazinessToken", "Lorg/jetbrains/kotlin/context/TypeLazinessToken;", "dynamicTypesSettings", "Lorg/jetbrains/kotlin/types/DynamicTypesSettings;", "dynamicCallableDescriptors", "Lorg/jetbrains/kotlin/resolve/calls/tasks/DynamicCallableDescriptors;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "(Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/TypeResolver$FlexibleTypeCapabilitiesProvider;Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/context/TypeLazinessToken;Lorg/jetbrains/kotlin/types/DynamicTypesSettings;Lorg/jetbrains/kotlin/resolve/calls/tasks/DynamicCallableDescriptors;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;)V", "appendDefaultArgumentsForInnerScope", "", "Lorg/jetbrains/kotlin/types/TypeProjectionImpl;", "fromIndex", "", "constructorParameters", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "collectArgumentsForClassTypeConstructor", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "c", "Lorg/jetbrains/kotlin/resolve/TypeResolutionContext;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "qualifierParts", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifierPart;", "createErrorTypeAndResolveArguments", "Lorg/jetbrains/kotlin/resolve/PossiblyBareType;", "argumentElements", "message", "", "doResolvePossiblyBareType", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "forceResolveTypeContents", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "getScopeForTypeParameter", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "typeParameterDescriptor", "resolveClass", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "userType", "Lorg/jetbrains/kotlin/psi/KtUserType;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "resolveDescriptorForType", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$TypeQualifierResolutionResult;", "resolvePossiblyBareType", "resolveType", "checkBounds", "", "resolveTypeElement", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "typeElement", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "resolveTypeForClass", "qualifierResolutionResult", "resolveTypeForTypeParameter", "typeParameter", "referenceExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "resolveTypeProjections", "Lorg/jetbrains/kotlin/types/TypeProjection;", "constructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "resolveTypeProjectionsWithErrorConstructor", "classDescriptorChain", "isDeclaredInScope", "isInsideOfClass", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Companion", "FlexibleTypeCapabilitiesProvider"}, moduleName="kotlin-compiler")
public final class TypeResolver {
    private final AnnotationResolver annotationResolver;
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    private final ModuleDescriptor moduleDescriptor;
    private final FlexibleTypeCapabilitiesProvider flexibleTypeCapabilitiesProvider;
    private final StorageManager storageManager;
    private final TypeLazinessToken lazinessToken;
    private final DynamicTypesSettings dynamicTypesSettings;
    private final DynamicCallableDescriptors dynamicCallableDescriptors;
    private final IdentifierChecker identifierChecker;
    public static final Companion Companion = org.jetbrains.kotlin.resolve.TypeResolver$Companion.INSTANCE;

    @NotNull
    public final KotlinType resolveType(@NotNull LexicalScope scope2, @NotNull KtTypeReference typeReference, @NotNull BindingTrace trace, boolean checkBounds) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(typeReference, "typeReference");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        return this.resolveType(new TypeResolutionContext(scope2, trace, checkBounds, false), typeReference);
    }

    private final KotlinType resolveType(TypeResolutionContext c, KtTypeReference typeReference) {
        Unit unit;
        boolean value$iv = !c.allowBareTypes;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                String message$iv = "Use resolvePossiblyBareType() when bare types are allowed";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        KotlinType kotlinType = this.resolvePossiblyBareType(c, typeReference).getActualType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "resolvePossiblyBareType(\u2026eference).getActualType()");
        return kotlinType;
    }

    @NotNull
    public final PossiblyBareType resolvePossiblyBareType(@NotNull TypeResolutionContext c, @NotNull KtTypeReference typeReference) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(typeReference, "typeReference");
        KotlinType cachedType = (KotlinType)c.trace.getBindingContext().get(BindingContext.TYPE, typeReference);
        if (cachedType != null) {
            PossiblyBareType possiblyBareType = PossiblyBareType.type(cachedType);
            Intrinsics.checkExpressionValueIsNotNull(possiblyBareType, "type(cachedType)");
            return possiblyBareType;
        }
        KotlinType debugType = CodeFragmentUtilKt.getDebugTypeInfo(typeReference);
        if (debugType != null) {
            c.trace.record(BindingContext.TYPE, typeReference, debugType);
            PossiblyBareType possiblyBareType = PossiblyBareType.type(debugType);
            Intrinsics.checkExpressionValueIsNotNull(possiblyBareType, "type(debugType)");
            return possiblyBareType;
        }
        if (!c.allowBareTypes && !c.forceResolveLazyTypes && this.lazinessToken.isLazy()) {
            @KotlinLocalClass(version={1, 0, 1})
            @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"&\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\"A\u0003\u0001+\u0003\u0001A!\u0002\u0007\u00013\u0005A\n!G\u0001\u0019\u0003\u0005\u0016\u0011kA\u0001\t\u0004\u0015\"Aa\u0003\u0005\u0005\u001b\u0005AJ!*\u0004\u0005\u0015!)Qr\u0001\r\u0004#\u000e\tAqAU\r\t\u0005C\u0001BAG\u0007\u0013\u0013I9\u0001G\u0002R\u0007\u0005!9\u0001'\u0002R\u0007\u0005)\u0001\u0001"}, strings={"org/jetbrains/kotlin/resolve/TypeResolver$resolvePossiblyBareType$LazyKotlinType", "Lorg/jetbrains/kotlin/types/DelegatingType;", "Lorg/jetbrains/kotlin/resolve/lazy/LazyEntity;", "(Lorg/jetbrains/kotlin/resolve/TypeResolver;Lorg/jetbrains/kotlin/resolve/TypeResolutionContext;Lorg/jetbrains/kotlin/psi/KtTypeReference;)V", "_delegate", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/annotations/NotNull;", "forceResolveAllContents", "", "getDelegate"}, moduleName="kotlin-compiler")
            public final class LazyKotlinType
            extends DelegatingType
            implements LazyEntity {
                private final NotNullLazyValue<KotlinType> _delegate;
                final /* synthetic */ TypeResolver this$0;
                final /* synthetic */ TypeResolutionContext $c;
                final /* synthetic */ KtTypeReference $typeReference;

                @NotNull
                protected KotlinType getDelegate() {
                    return (KotlinType)this._delegate.invoke();
                }

                public void forceResolveAllContents() {
                    ForceResolveUtil.forceResolveAllContents(this.getConstructor());
                    Iterable $receiver$iv = this.getArguments();
                    for (T element$iv : $receiver$iv) {
                        TypeProjection it = (TypeProjection)element$iv;
                        ForceResolveUtil.forceResolveAllContents(it.getType());
                    }
                }

                public LazyKotlinType(TypeResolver $outer, TypeResolutionContext $captured_local_variable$1, KtTypeReference $captured_local_variable$2) {
                    this.this$0 = $outer;
                    this.$c = $captured_local_variable$1;
                    this.$typeReference = $captured_local_variable$2;
                    this._delegate = TypeResolver.access$getStorageManager$p($outer).createLazyValue((Function0)new Function0<KotlinType>(this){
                        final /* synthetic */ LazyKotlinType this$0;

                        @NotNull
                        public final KotlinType invoke() {
                            return TypeResolver.access$doResolvePossiblyBareType(this.this$0.this$0, this.this$0.$c, this.this$0.$typeReference).getActualType();
                        }
                        {
                            this.this$0 = lazyKotlinType;
                            super(0);
                        }
                    });
                }
            }
            LazyKotlinType lazyKotlinType = new LazyKotlinType(this, c, typeReference);
            c.trace.record(BindingContext.TYPE, typeReference, lazyKotlinType);
            PossiblyBareType possiblyBareType = PossiblyBareType.type(lazyKotlinType);
            Intrinsics.checkExpressionValueIsNotNull(possiblyBareType, "type(lazyKotlinType)");
            return possiblyBareType;
        }
        PossiblyBareType type2 = this.doResolvePossiblyBareType(c, typeReference);
        if (!type2.isBare()) {
            c.trace.record(BindingContext.TYPE, typeReference, type2.getActualType());
        }
        return type2;
    }

    private final PossiblyBareType doResolvePossiblyBareType(TypeResolutionContext c, KtTypeReference typeReference) {
        Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithoutArguments(c.scope, typeReference.getAnnotationEntries(), c.trace);
        KtTypeElement typeElement = typeReference.getTypeElement();
        Annotations annotations3 = annotations2;
        Intrinsics.checkExpressionValueIsNotNull(annotations3, "annotations");
        PossiblyBareType type2 = this.resolveTypeElement(c, annotations3, typeElement);
        BindingTrace bindingTrace = c.trace;
        LexicalScope lexicalScope = c.scope;
        Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "c.scope");
        BindingContextUtilsKt.recordScope(bindingTrace, lexicalScope, typeReference);
        if (!type2.isBare()) {
            for (TypeProjection argument : type2.getActualType().getArguments()) {
                KotlinType kotlinType = argument.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "argument.type");
                this.forceResolveTypeContents(kotlinType);
            }
        }
        return type2;
    }

    private final void forceResolveTypeContents(KotlinType type2) {
        type2.getAnnotations();
        if (FlexibleTypesKt.isFlexible(type2)) {
            this.forceResolveTypeContents(FlexibleTypesKt.flexibility(type2).getLowerBound());
            this.forceResolveTypeContents(FlexibleTypesKt.flexibility(type2).getUpperBound());
        } else {
            type2.getConstructor();
            for (TypeProjection projection : type2.getArguments()) {
                if (projection.isStarProjection()) continue;
                KotlinType kotlinType = projection.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "projection.type");
                this.forceResolveTypeContents(kotlinType);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final PossiblyBareType resolveTypeElement(TypeResolutionContext c, Annotations annotations2, KtTypeElement typeElement) {
        PossiblyBareType possiblyBareType;
        Unit unit;
        void result2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        KtTypeElement ktTypeElement = typeElement;
        if (ktTypeElement != null) {
            ktTypeElement.accept(new KtVisitorVoid(this, c, (Ref.ObjectRef)result2, annotations2){
                final /* synthetic */ TypeResolver this$0;
                final /* synthetic */ TypeResolutionContext $c;
                final /* synthetic */ Ref.ObjectRef $result;
                final /* synthetic */ Annotations $annotations;

                /*
                 * WARNING - void declaration
                 */
                public void visitUserType(@NotNull KtUserType type2) {
                    PossiblyBareType possiblyBareType;
                    void classifierDescriptor;
                    QualifiedExpressionResolver.TypeQualifierResolutionResult qualifierResolutionResults;
                    Intrinsics.checkParameterIsNotNull(type2, "type");
                    LexicalScope lexicalScope = this.$c.scope;
                    Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "c.scope");
                    BindingTrace bindingTrace = this.$c.trace;
                    Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.trace");
                    QualifiedExpressionResolver.TypeQualifierResolutionResult typeQualifierResolutionResult = qualifierResolutionResults = this.this$0.resolveDescriptorForType(lexicalScope, type2, bindingTrace);
                    List<QualifiedExpressionResolver.QualifierPart> list = typeQualifierResolutionResult.component1();
                    ClassifierDescriptor classifierDescriptor2 = typeQualifierResolutionResult.component2();
                    typeQualifierResolutionResult = null;
                    if (classifierDescriptor == null) {
                        TypeConstructor typeConstructor2 = ErrorUtils.createErrorType("No type").getConstructor();
                        Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "ErrorUtils.createErrorType(\"No type\").constructor");
                        List arguments2 = TypeResolver.access$resolveTypeProjections(this.this$0, this.$c, typeConstructor2, qualifierResolutionResults.getAllProjections());
                        this.$result.element = PossiblyBareType.type(ErrorUtils.createErrorTypeWithArguments(DebugTextUtilKt.getDebugText(type2), arguments2));
                        return;
                    }
                    KtSimpleNameExpression referenceExpression = type2.getReferenceExpression();
                    String referencedName = type2.getReferencedName();
                    if (referenceExpression == null || referencedName == null) {
                        return;
                    }
                    this.$c.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, classifierDescriptor);
                    Ref.ObjectRef objectRef = this.$result;
                    void var7_7 = classifierDescriptor;
                    if (var7_7 instanceof TypeParameterDescriptor) {
                        Unit unit;
                        void qualifierParts;
                        boolean bl = qualifierParts.size() == 1;
                        Ref.ObjectRef objectRef2 = objectRef;
                        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                            void value$iv;
                            if (value$iv == false) {
                                String message$iv = "Type parameter can be resolved only by it's short name, but '" + type2.getText() + "' is contradiction " + ("with " + qualifierParts.size() + " qualifier parts");
                                throw (Throwable)((Object)new AssertionError((Object)message$iv));
                            }
                            unit = Unit.INSTANCE;
                        } else {
                            unit = Unit.INSTANCE;
                        }
                        objectRef = objectRef2;
                        possiblyBareType = PossiblyBareType.type(TypeResolver.access$resolveTypeForTypeParameter(this.this$0, this.$c, this.$annotations, (TypeParameterDescriptor)classifierDescriptor, referenceExpression, type2));
                    } else {
                        possiblyBareType = var7_7 instanceof ClassDescriptor ? TypeResolver.access$resolveTypeForClass(this.this$0, this.$c, this.$annotations, (ClassDescriptor)classifierDescriptor, type2, qualifierResolutionResults) : (PossiblyBareType)((Object)PreconditionsKt.error("Unexpected classifier type: " + classifierDescriptor.getClass()));
                    }
                    objectRef.element = possiblyBareType;
                }

                public void visitNullableType(@NotNull KtNullableType nullableType) {
                    Intrinsics.checkParameterIsNotNull(nullableType, "nullableType");
                    KtTypeElement innerType = nullableType.getInnerType();
                    PossiblyBareType baseType = TypeResolver.access$resolveTypeElement(this.this$0, this.$c, this.$annotations, innerType);
                    if (baseType.isNullable() || innerType instanceof KtNullableType || innerType instanceof KtDynamicType) {
                        this.$c.trace.report(Errors.REDUNDANT_NULLABLE.on((KtNullableType)((PsiElement)nullableType)));
                    }
                    this.$result.element = baseType.makeNullable();
                }

                /*
                 * WARNING - void declaration
                 */
                public void visitFunctionType(@NotNull KtFunctionType type2) {
                    KotlinType kotlinType;
                    void destination$iv$iv;
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    Object it;
                    E element$iv3;
                    void $receiver$iv2;
                    KotlinType kotlinType2;
                    Object element$iv22;
                    Intrinsics.checkParameterIsNotNull(type2, "type");
                    KtTypeReference receiverTypeRef = type2.getReceiverTypeReference();
                    Iterable $receiver$iv3 = type2.getParameters();
                    for (Object element$iv22 : $receiver$iv3) {
                        KtParameter it2 = (KtParameter)element$iv22;
                        IdentifierChecker identifierChecker = TypeResolver.access$getIdentifierChecker$p(this.this$0);
                        KtDeclaration ktDeclaration = it2;
                        Intrinsics.checkExpressionValueIsNotNull(ktDeclaration, "it");
                        DiagnosticSink diagnosticSink = this.$c.trace;
                        Intrinsics.checkExpressionValueIsNotNull(diagnosticSink, "c.trace");
                        identifierChecker.checkDeclaration(ktDeclaration, diagnosticSink);
                    }
                    if (receiverTypeRef == null) {
                        kotlinType2 = null;
                    } else {
                        TypeResolutionContext typeResolutionContext = this.$c.noBareTypes();
                        Intrinsics.checkExpressionValueIsNotNull(typeResolutionContext, "c.noBareTypes()");
                        kotlinType2 = TypeResolver.access$resolveType(this.this$0, typeResolutionContext, receiverTypeRef);
                    }
                    KotlinType receiverType = kotlinType2;
                    Iterable iterable = type2.getParameters();
                    for (E element$iv3 : $receiver$iv2) {
                        it = (KtParameter)element$iv3;
                        KtParameter ktParameter = it;
                        Intrinsics.checkExpressionValueIsNotNull(ktParameter, "it");
                        this.checkParameterInFunctionType(ktParameter);
                    }
                    element$iv22 = type2.getParameters();
                    element$iv3 = $receiver$iv;
                    it = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void it3;
                        KtParameter ktParameter = (KtParameter)item$iv$iv;
                        void var11_11 = destination$iv$iv;
                        TypeResolutionContext typeResolutionContext = this.$c.noBareTypes();
                        Intrinsics.checkExpressionValueIsNotNull(typeResolutionContext, "c.noBareTypes()");
                        KtTypeReference ktTypeReference = it3.getTypeReference();
                        if (ktTypeReference == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull(ktTypeReference, "it.getTypeReference()!!");
                        KotlinType kotlinType3 = TypeResolver.access$resolveType(this.this$0, typeResolutionContext, ktTypeReference);
                        var11_11.add(kotlinType3);
                    }
                    List parameterTypes = (List)destination$iv$iv;
                    KtTypeReference returnTypeRef = type2.getReturnTypeReference();
                    if (returnTypeRef != null) {
                        TypeResolutionContext typeResolutionContext = this.$c.noBareTypes();
                        Intrinsics.checkExpressionValueIsNotNull(typeResolutionContext, "c.noBareTypes()");
                        kotlinType = TypeResolver.access$resolveType(this.this$0, typeResolutionContext, returnTypeRef);
                    } else {
                        KotlinType kotlinType4 = TypeResolver.access$getModuleDescriptor$p(this.this$0).getBuiltIns().getUnitType();
                        kotlinType = kotlinType4;
                        Intrinsics.checkExpressionValueIsNotNull(kotlinType4, "moduleDescriptor.builtIns.getUnitType()");
                    }
                    KotlinType returnType2 = kotlinType;
                    this.$result.element = PossiblyBareType.type(TypeResolver.access$getModuleDescriptor$p(this.this$0).getBuiltIns().getFunctionType(this.$annotations, receiverType, parameterTypes, returnType2));
                }

                public void visitDynamicType(@NotNull KtDynamicType type2) {
                    Intrinsics.checkParameterIsNotNull(type2, "type");
                    this.$result.element = PossiblyBareType.type(TypeResolver.access$getDynamicCallableDescriptors$p(this.this$0).getDynamicType());
                    if (!TypeResolver.access$getDynamicTypesSettings$p(this.this$0).getDynamicTypesAllowed()) {
                        this.$c.trace.report(Errors.UNSUPPORTED.on(type2, "Dynamic types are not supported in this context"));
                    }
                }

                public void visitSelfType(@NotNull KtSelfType type2) {
                    Intrinsics.checkParameterIsNotNull(type2, "type");
                    this.$c.trace.report(Errors.UNSUPPORTED.on(type2, "Self-types are not supported"));
                }

                public void visitKtElement(@NotNull KtElement element) {
                    Intrinsics.checkParameterIsNotNull(element, "element");
                    this.$c.trace.report(Errors.UNSUPPORTED.on(element, "Self-types are not supported yet"));
                }

                /*
                 * WARNING - void declaration
                 */
                private final void checkParameterInFunctionType(KtParameter param) {
                    Unit unit;
                    Object $receiver$iv;
                    KtModifierList modifierList;
                    if (param.hasDefaultValue()) {
                        BindingTrace bindingTrace = this.$c.trace;
                        KtExpression ktExpression = param.getDefaultValue();
                        if (ktExpression == null) {
                            Intrinsics.throwNpe();
                        }
                        bindingTrace.report(Errors.UNSUPPORTED.on(ktExpression, "default value of parameter in function type"));
                    }
                    if (param.getName() != null) {
                        for (KtAnnotationEntry annotationEntry : param.getAnnotationEntries()) {
                            this.$c.trace.report(Errors.UNSUPPORTED.on(annotationEntry, "annotation on parameter in function type"));
                        }
                    }
                    if ((modifierList = param.getModifierList()) != null) {
                        void destination$iv$iv;
                        void $receiver$iv$iv$iv;
                        Iterator<T> $receiver$iv$iv;
                        $receiver$iv = KtTokens.MODIFIER_KEYWORDS_ARRAY;
                        Object[] objectArray = $receiver$iv;
                        Collection collection = new ArrayList<E>();
                        void var6_6 = $receiver$iv$iv;
                        for (int i = 0; i < ((void)$receiver$iv$iv$iv).length; ++i) {
                            Boolean bl;
                            void element$iv$iv$iv = $receiver$iv$iv$iv[i];
                            void element$iv$iv = element$iv$iv$iv;
                            KtModifierKeywordToken it = (KtModifierKeywordToken)element$iv$iv;
                            if (modifierList.getModifier(it) != null) {
                                void $receiver$iv$iv$iv2;
                                void it$iv$iv = $receiver$iv$iv$iv2;
                                bl = destination$iv$iv.add(it$iv$iv);
                                continue;
                            }
                            bl = null;
                        }
                        $receiver$iv = (List)destination$iv$iv;
                        $receiver$iv$iv = $receiver$iv.iterator();
                        while ($receiver$iv$iv.hasNext()) {
                            T element$iv = $receiver$iv$iv.next();
                            PsiElement it = (PsiElement)element$iv;
                            this.$c.trace.report(Errors.UNSUPPORTED.on(it, "modifier on parameter in function type"));
                        }
                    }
                    PsiElement psiElement2 = param.getValOrVarKeyword();
                    if (psiElement2 != null) {
                        $receiver$iv = psiElement2;
                        PsiElement it = (PsiElement)$receiver$iv;
                        this.$c.trace.report(Errors.UNSUPPORTED.on(it, "val or val on parameter in function type"));
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$c = $captured_local_variable$1;
                    this.$result = $captured_local_variable$2;
                    this.$annotations = $captured_local_variable$3;
                }
            });
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if ((possiblyBareType = (PossiblyBareType)result2.element) == null) {
            Object object = typeElement;
            if (object == null || (object = DebugTextUtilKt.getDebugText((KtElement)object)) == null) {
                object = "No type element";
            }
            PossiblyBareType possiblyBareType2 = PossiblyBareType.type(ErrorUtils.createErrorType((String)object));
            possiblyBareType = possiblyBareType2;
            Intrinsics.checkExpressionValueIsNotNull(possiblyBareType2, "type(ErrorUtils.createEr\u2026() ?: \"No type element\"))");
        }
        return possiblyBareType;
    }

    private final KotlinType resolveTypeForTypeParameter(TypeResolutionContext c, Annotations annotations2, TypeParameterDescriptor typeParameter, KtSimpleNameExpression referenceExpression, KtUserType type2) {
        KotlinType kotlinType;
        DeclarationDescriptor containing;
        MemberScope scopeForTypeParameter = this.getScopeForTypeParameter(c, typeParameter);
        TypeConstructor typeConstructor2 = ErrorUtils.createErrorType("No type").getConstructor();
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "ErrorUtils.createErrorType(\"No type\").constructor");
        List<KtTypeProjection> list = type2.getTypeArguments();
        Intrinsics.checkExpressionValueIsNotNull(list, "type.typeArguments");
        List<TypeProjection> arguments2 = this.resolveTypeProjections(c, typeConstructor2, list);
        if (!arguments2.isEmpty()) {
            c.trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on((KtElement)((PsiElement)type2.getTypeArgumentList()), 0));
        }
        if ((containing = typeParameter.getContainingDeclaration()) instanceof ClassDescriptor) {
            DescriptorResolver.checkHasOuterClassInstance(c.scope, c.trace, referenceExpression, (ClassDescriptor)containing);
        }
        if (scopeForTypeParameter instanceof ErrorUtils.ErrorScope) {
            KotlinType kotlinType2 = ErrorUtils.createErrorType("?");
            kotlinType = kotlinType2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "ErrorUtils.createErrorType(\"?\")");
        } else {
            TypeConstructor typeConstructor3 = typeParameter.getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "typeParameter.typeConstructor");
            kotlinType = KotlinTypeImpl.Companion.create(annotations2, typeConstructor3, TypeUtils.hasNullableLowerBound(typeParameter), CollectionsKt.listOf(), scopeForTypeParameter);
        }
        return kotlinType;
    }

    private final MemberScope getScopeForTypeParameter(TypeResolutionContext c, TypeParameterDescriptor typeParameterDescriptor) {
        MemberScope memberScope2;
        if (c.checkBounds) {
            MemberScope memberScope3 = TypeIntersector.getUpperBoundsAsType(typeParameterDescriptor).getMemberScope();
            memberScope2 = memberScope3;
            Intrinsics.checkExpressionValueIsNotNull(memberScope3, "TypeIntersector.getUpper\u2026erDescriptor).memberScope");
        } else {
            memberScope2 = new LazyScopeAdapter(LockBasedStorageManager.NO_LOCKS.createLazyValue((Function0)new Function0<MemberScope>(typeParameterDescriptor){
                final /* synthetic */ TypeParameterDescriptor $typeParameterDescriptor;

                @NotNull
                public final MemberScope invoke() {
                    return TypeIntersector.getUpperBoundsAsType(this.$typeParameterDescriptor).getMemberScope();
                }
                {
                    this.$typeParameterDescriptor = typeParameterDescriptor;
                    super(0);
                }
            }));
        }
        return memberScope2;
    }

    /*
     * WARNING - void declaration
     */
    private final PossiblyBareType resolveTypeForClass(TypeResolutionContext c, Annotations annotations2, ClassDescriptor classDescriptor, KtUserType type2, QualifiedExpressionResolver.TypeQualifierResolutionResult qualifierResolutionResult) {
        Unit unit;
        Unit unit2;
        TypeConstructor typeConstructor2 = classDescriptor.getTypeConstructor();
        List<KtTypeProjection> projectionFromAllQualifierParts = qualifierResolutionResult.getAllProjections();
        List<TypeParameterDescriptor> parameters2 = typeConstructor2.getParameters();
        if (c.allowBareTypes && projectionFromAllQualifierParts.isEmpty() && CollectionsKt.isNotEmpty((Collection)parameters2)) {
            PossiblyBareType possiblyBareType = PossiblyBareType.bare(typeConstructor2, false);
            Intrinsics.checkExpressionValueIsNotNull(possiblyBareType, "PossiblyBareType.bare(typeConstructor, false)");
            return possiblyBareType;
        }
        if (ErrorUtils.isError(classDescriptor)) {
            return this.createErrorTypeAndResolveArguments(c, projectionFromAllQualifierParts, "[Error type: " + typeConstructor2 + "]");
        }
        List<KtTypeProjection> list = this.collectArgumentsForClassTypeConstructor(c, classDescriptor, qualifierResolutionResult.getQualifierParts());
        if (list == null) {
            return this.createErrorTypeAndResolveArguments(c, projectionFromAllQualifierParts, typeConstructor2.toString());
        }
        List<KtTypeProjection> collectedArgumentAsTypeProjections = list;
        boolean bl = collectedArgumentAsTypeProjections.size() <= parameters2.size();
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            void value$iv;
            if (value$iv == false) {
                String message$iv = "Collected arguments count should be not greater then parameters count," + (" but " + collectedArgumentAsTypeProjections.size() + " instead of " + parameters2.size() + " found in " + type2.getText());
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = Unit.INSTANCE;
        }
        TypeConstructor typeConstructor3 = typeConstructor2;
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "typeConstructor");
        List<TypeProjection> argumentsFromUserType = this.resolveTypeProjections(c, typeConstructor3, collectedArgumentAsTypeProjections);
        Collection collection = argumentsFromUserType;
        int n = argumentsFromUserType.size();
        List<TypeParameterDescriptor> list2 = parameters2;
        Intrinsics.checkExpressionValueIsNotNull(list2, "parameters");
        List arguments2 = CollectionsKt.plus(collection, (Iterable)this.appendDefaultArgumentsForInnerScope(n, list2));
        boolean message$iv = arguments2.size() == parameters2.size();
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            void value$iv;
            if (value$iv == false) {
                String message$iv2 = "Collected arguments count should be equal to parameters count," + (" but " + collectedArgumentAsTypeProjections.size() + " instead of " + parameters2.size() + " found in " + type2.getText());
                throw (Throwable)((Object)new AssertionError((Object)message$iv2));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        if (Intrinsics.areEqual(Flexibility.Companion.getFLEXIBLE_TYPE_CLASSIFIER().asSingleFqName().toUnsafe(), DescriptorUtils.getFqName(classDescriptor)) && parameters2.size() == 2) {
            KotlinType kotlinType = ((TypeProjection)arguments2.get(0)).getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "arguments[0].type");
            KotlinType kotlinType2 = ((TypeProjection)arguments2.get(1)).getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "arguments[1].type");
            PossiblyBareType possiblyBareType = PossiblyBareType.type(DelegatingFlexibleType.Companion.create(kotlinType, kotlinType2, this.flexibleTypeCapabilitiesProvider.getCapabilities()));
            Intrinsics.checkExpressionValueIsNotNull(possiblyBareType, "type(DelegatingFlexibleT\u2026bilities())\n            )");
            return possiblyBareType;
        }
        KotlinTypeImpl resultingType = KotlinTypeImpl.Companion.create(annotations2, classDescriptor, false, arguments2);
        if (c.checkBounds) {
            int n2;
            TypeSubstitutor substitutor2 = TypeSubstitutor.create(resultingType);
            IntRange intRange = CollectionsKt.getIndices((Collection)parameters2);
            int message$iv2 = intRange.getFirst();
            if (message$iv2 <= (n2 = intRange.getLast())) {
                while (true) {
                    KtTypeReference typeReference;
                    void i;
                    TypeParameterDescriptor parameter = parameters2.get((int)i);
                    KotlinType argument = ((TypeProjection)arguments2.get((int)i)).getType();
                    KtTypeProjection ktTypeProjection = CollectionsKt.getOrNull(collectedArgumentAsTypeProjections, (int)i);
                    KtTypeReference ktTypeReference = typeReference = ktTypeProjection != null ? ktTypeProjection.getTypeReference() : null;
                    if (typeReference != null) {
                        DescriptorResolver.checkBounds(typeReference, argument, parameter, substitutor2, c.trace);
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
        }
        if (TypeUtilsKt.isArrayOfNothing(resultingType)) {
            c.trace.report(Errors.UNSUPPORTED.on(type2, "Array<Nothing> is illegal"));
        }
        PossiblyBareType possiblyBareType = PossiblyBareType.type(resultingType);
        Intrinsics.checkExpressionValueIsNotNull(possiblyBareType, "type(resultingType)");
        return possiblyBareType;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtTypeProjection> collectArgumentsForClassTypeConstructor(TypeResolutionContext c, ClassDescriptor classDescriptor, List<QualifiedExpressionResolver.QualifierPart> qualifierParts) {
        Object qualifierPart;
        List<ClassDescriptor> classDescriptorChain2 = this.classDescriptorChain(classDescriptor);
        List<QualifiedExpressionResolver.QualifierPart> reversedQualifierParts = CollectionsKt.asReversed(qualifierParts);
        boolean wasStatic = false;
        SmartList result2 = new SmartList();
        int n = 0;
        int classChainLastIndex = Math.min(classDescriptorChain2.size(), reversedQualifierParts.size()) - 1;
        int n2 = classChainLastIndex;
        if (n <= n2) {
            while (true) {
                List<Object> currentParameters;
                void index2;
                qualifierPart = reversedQualifierParts.get((int)index2);
                KtTypeArgumentList ktTypeArgumentList = ((QualifiedExpressionResolver.QualifierPart)qualifierPart).getTypeArguments();
                List<KtTypeProjection> currentArguments = CollectionsKt.orEmpty(ktTypeArgumentList != null ? ktTypeArgumentList.getArguments() : null);
                List<TypeParameterDescriptor> declaredTypeParameters = classDescriptorChain2.get((int)index2).getDeclaredTypeParameters();
                List<Object> list = currentParameters = wasStatic ? CollectionsKt.emptyList() : declaredTypeParameters;
                if (wasStatic && CollectionsKt.isNotEmpty((Collection)currentArguments) && CollectionsKt.isNotEmpty((Collection)declaredTypeParameters)) {
                    BindingTrace bindingTrace = c.trace;
                    KtTypeArgumentList ktTypeArgumentList2 = ((QualifiedExpressionResolver.QualifierPart)qualifierPart).getTypeArguments();
                    if (ktTypeArgumentList2 == null) {
                        Intrinsics.throwNpe();
                    }
                    bindingTrace.report(Errors.TYPE_ARGUMENTS_FOR_OUTER_CLASS_WHEN_NESTED_REFERENCED.on((KtTypeArgumentList)((PsiElement)ktTypeArgumentList2)));
                    return null;
                }
                if (currentArguments.size() != currentParameters.size()) {
                    KtTypeArgumentList ktTypeArgumentList3 = ((QualifiedExpressionResolver.QualifierPart)qualifierPart).getTypeArguments();
                    c.trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on((KtElement)((PsiElement)(ktTypeArgumentList3 != null ? (KtElement)ktTypeArgumentList3 : (KtElement)((QualifiedExpressionResolver.QualifierPart)qualifierPart).getExpression())), currentParameters.size()));
                    return null;
                }
                result2.addAll(currentArguments);
                boolean bl = wasStatic = wasStatic || !classDescriptorChain2.get((int)index2).isInner();
                if (index2 == n2) break;
                ++index2;
            }
        }
        List<QualifiedExpressionResolver.QualifierPart> nonClassQualifierParts = reversedQualifierParts.subList(Math.min(classChainLastIndex + 1, reversedQualifierParts.size()), reversedQualifierParts.size());
        for (QualifiedExpressionResolver.QualifierPart qualifierPart2 : nonClassQualifierParts) {
            if (qualifierPart2.getTypeArguments() == null) continue;
            c.trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on((KtElement)((PsiElement)qualifierPart2.getTypeArguments()), 0));
            return null;
        }
        List<TypeParameterDescriptor> parameters2 = classDescriptor.getTypeConstructor().getParameters();
        if (result2.size() < parameters2.size()) {
            boolean bl;
            block9: {
                void $receiver$iv;
                qualifierPart = parameters2.subList(result2.size(), parameters2.size());
                for (Object element$iv : $receiver$iv) {
                    TypeParameterDescriptor parameter = (TypeParameterDescriptor)element$iv;
                    if (!(!this.isDeclaredInScope(parameter, c))) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
            if (bl) {
                c.trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on((KtElement)((PsiElement)CollectionsKt.last(qualifierParts).getExpression()), parameters2.size()));
                return null;
            }
        }
        return result2;
    }

    private final List<ClassDescriptor> classDescriptorChain(ClassifierDescriptor $receiver) {
        return SequencesKt.toList(SequencesKt.sequence((Function0)new Function0<ClassDescriptor>($receiver){
            final /* synthetic */ ClassifierDescriptor receiver$0;

            @Nullable
            public final ClassDescriptor invoke() {
                ClassifierDescriptor classifierDescriptor = this.receiver$0;
                if (!(classifierDescriptor instanceof ClassDescriptor)) {
                    classifierDescriptor = null;
                }
                return (ClassDescriptor)classifierDescriptor;
            }
            {
                this.receiver$0 = classifierDescriptor;
                super(0);
            }
        }, (Function1)classDescriptorChain.2.INSTANCE));
    }

    private final boolean isDeclaredInScope(TypeParameterDescriptor $receiver, TypeResolutionContext c) {
        Unit unit;
        boolean value$iv = $receiver.getContainingDeclaration() instanceof ClassDescriptor;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                String message$iv = "This function is implemented for classes only, but " + $receiver.getContainingDeclaration() + " was given";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        HierarchicalScope hierarchicalScope = c.scope;
        Name name = $receiver.getName();
        Intrinsics.checkExpressionValueIsNotNull(name, "name");
        ClassifierDescriptor classifierDescriptor = ScopeUtilsKt.findClassifier(hierarchicalScope, name, NoLookupLocation.WHEN_RESOLVING_DEFAULT_TYPE_ARGUMENTS);
        if (classifierDescriptor == null) {
            return false;
        }
        ClassifierDescriptor contributedClassifier = classifierDescriptor;
        if (Intrinsics.areEqual(contributedClassifier.getTypeConstructor(), $receiver.getTypeConstructor())) {
            return true;
        }
        DeclarationDescriptor declarationDescriptor = $receiver.getOriginal().getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        return this.isInsideOfClass(c.scope.getOwnerDescriptor(), (ClassDescriptor)declarationDescriptor);
    }

    private final boolean isInsideOfClass(DeclarationDescriptor $receiver, ClassDescriptor classDescriptor) {
        boolean bl;
        block1: {
            Sequence<DeclarationDescriptor> $receiver$iv = SequencesKt.sequence($receiver, (Function1)isInsideOfClass.1.INSTANCE);
            Iterator<DeclarationDescriptor> iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                DeclarationDescriptor element$iv = iterator2.next();
                DeclarationDescriptor it = element$iv;
                if (!Intrinsics.areEqual(it.getOriginal(), classDescriptor)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final List<TypeProjection> resolveTypeProjectionsWithErrorConstructor(TypeResolutionContext c, List<? extends KtTypeProjection> argumentElements, String message) {
        TypeConstructor typeConstructor2 = ErrorUtils.createErrorTypeConstructor(message);
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "ErrorUtils.createErrorTypeConstructor(message)");
        return this.resolveTypeProjections(c, typeConstructor2, argumentElements);
    }

    static /* bridge */ /* synthetic */ List resolveTypeProjectionsWithErrorConstructor$default(TypeResolver typeResolver, TypeResolutionContext typeResolutionContext, List list, String string, int n) {
        if ((n & 4) != 0) {
            string = "Error type for resolving type projections";
        }
        return typeResolver.resolveTypeProjectionsWithErrorConstructor(typeResolutionContext, list, string);
    }

    private final PossiblyBareType createErrorTypeAndResolveArguments(TypeResolutionContext c, List<? extends KtTypeProjection> argumentElements, String message) {
        PossiblyBareType possiblyBareType = PossiblyBareType.type(ErrorUtils.createErrorTypeWithArguments(message, TypeResolver.resolveTypeProjectionsWithErrorConstructor$default(this, c, argumentElements, null, 4)));
        Intrinsics.checkExpressionValueIsNotNull(possiblyBareType, "type(ErrorUtils.createEr\u2026or(c, argumentElements)))");
        return possiblyBareType;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TypeProjectionImpl> appendDefaultArgumentsForInnerScope(int fromIndex, List<? extends TypeParameterDescriptor> constructorParameters) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = constructorParameters.subList(fromIndex, constructorParameters.size());
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            void var9_9 = destination$iv$iv;
            DeclarationDescriptorWithSource declarationDescriptorWithSource = it.getOriginal();
            if (declarationDescriptorWithSource == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.TypeParameterDescriptor");
            }
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(((TypeParameterDescriptor)declarationDescriptorWithSource).getDefaultType());
            var9_9.add(typeProjectionImpl);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TypeProjection> resolveTypeProjections(TypeResolutionContext c, TypeConstructor constructor, List<? extends KtTypeProjection> argumentElements) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = argumentElements;
        void var5_5 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            TypeProjection typeProjection;
            void i;
            void argumentElement;
            int n = index$iv$iv++;
            KtTypeProjection ktTypeProjection = (KtTypeProjection)item$iv$iv;
            int n2 = n;
            void var12_12 = destination$iv$iv;
            KtProjectionKind projectionKind = argumentElement.getProjectionKind();
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)argumentElement;
            BindingTrace bindingTrace = c.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.trace");
            ModifierCheckerCore.INSTANCE.check(ktModifierListOwner, bindingTrace, null);
            if (Intrinsics.areEqual((Object)projectionKind, (Object)KtProjectionKind.STAR)) {
                void $receiver$iv2;
                List<TypeParameterDescriptor> parameters2 = constructor.getParameters();
                Collection collection2 = parameters2;
                if ($receiver$iv2.size() > i) {
                    TypeParameterDescriptor parameterDescriptor = parameters2.get((int)i);
                    TypeProjection typeProjection2 = TypeUtils.makeStarProjection(parameterDescriptor);
                    typeProjection = typeProjection2;
                    Intrinsics.checkExpressionValueIsNotNull(typeProjection2, "TypeUtils.makeStarProjection(parameterDescriptor)");
                } else {
                    typeProjection = new TypeProjectionImpl(Variance.OUT_VARIANCE, ErrorUtils.createErrorType("*"));
                }
            } else {
                void $receiver$iv3;
                TypeResolutionContext typeResolutionContext = c.noBareTypes();
                Intrinsics.checkExpressionValueIsNotNull(typeResolutionContext, "c.noBareTypes()");
                KtTypeReference ktTypeReference = argumentElement.getTypeReference();
                if (ktTypeReference == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(ktTypeReference, "argumentElement.getTypeReference()!!");
                KotlinType type2 = this.resolveType(typeResolutionContext, ktTypeReference);
                KtProjectionKind ktProjectionKind = projectionKind;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktProjectionKind, "projectionKind");
                Variance kind = Companion.resolveProjectionKind(ktProjectionKind);
                Collection $i$f$size = constructor.getParameters();
                if ($receiver$iv3.size() > i) {
                    TypeParameterDescriptor parameterDescriptor = constructor.getParameters().get((int)i);
                    if (Intrinsics.areEqual((Object)kind, (Object)Variance.INVARIANT) ^ true && Intrinsics.areEqual((Object)parameterDescriptor.getVariance(), (Object)Variance.INVARIANT) ^ true) {
                        if (Intrinsics.areEqual((Object)kind, (Object)parameterDescriptor.getVariance())) {
                            c.trace.report(Errors.REDUNDANT_PROJECTION.on((KtTypeProjection)((PsiElement)argumentElement), constructor.getDeclarationDescriptor()));
                        } else {
                            c.trace.report(Errors.CONFLICTING_PROJECTION.on((KtTypeProjection)((PsiElement)argumentElement), constructor.getDeclarationDescriptor()));
                        }
                    }
                }
                typeProjection = new TypeProjectionImpl(kind, type2);
            }
            TypeProjection typeProjection3 = typeProjection;
            var12_12.add(typeProjection3);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final ClassifierDescriptor resolveClass(@NotNull LexicalScope scope2, @NotNull KtUserType userType, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(userType, "userType");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        return this.resolveDescriptorForType(scope2, userType, trace).getClassifierDescriptor();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final QualifiedExpressionResolver.TypeQualifierResolutionResult resolveDescriptorForType(@NotNull LexicalScope scope2, @NotNull KtUserType userType, @NotNull BindingTrace trace) {
        QualifiedExpressionResolver.TypeQualifierResolutionResult result2;
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(userType, "userType");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        if (userType.getQualifier() != null) {
            KtUserType ktUserType = userType.getQualifier();
            if (ktUserType == null) {
                Intrinsics.throwNpe();
            }
            for (KtTypeProjection typeArgument : ktUserType.getTypeArguments()) {
                Unit unit;
                if (typeArgument.getTypeReference() != null) {
                    void $receiver$iv;
                    KtTypeReference it;
                    KtTypeReference ktTypeReference = it = (KtTypeReference)$receiver$iv;
                    Intrinsics.checkExpressionValueIsNotNull(ktTypeReference, "it");
                    this.forceResolveTypeContents(this.resolveType(scope2, ktTypeReference, trace, true));
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
        }
        if ((result2 = this.qualifiedExpressionResolver.resolveDescriptorForType(userType, scope2, trace)).getClassifierDescriptor() != null) {
            PlatformTypesMappedToKotlinChecker.reportPlatformClassMappedToKotlin(this.moduleDescriptor, trace, userType, result2.getClassifierDescriptor());
        }
        return result2;
    }

    public TypeResolver(@NotNull AnnotationResolver annotationResolver, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver, @NotNull ModuleDescriptor moduleDescriptor, @NotNull FlexibleTypeCapabilitiesProvider flexibleTypeCapabilitiesProvider, @NotNull StorageManager storageManager, @NotNull TypeLazinessToken lazinessToken, @NotNull DynamicTypesSettings dynamicTypesSettings, @NotNull DynamicCallableDescriptors dynamicCallableDescriptors, @NotNull IdentifierChecker identifierChecker) {
        Intrinsics.checkParameterIsNotNull(annotationResolver, "annotationResolver");
        Intrinsics.checkParameterIsNotNull(qualifiedExpressionResolver, "qualifiedExpressionResolver");
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkParameterIsNotNull(flexibleTypeCapabilitiesProvider, "flexibleTypeCapabilitiesProvider");
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Intrinsics.checkParameterIsNotNull(lazinessToken, "lazinessToken");
        Intrinsics.checkParameterIsNotNull(dynamicTypesSettings, "dynamicTypesSettings");
        Intrinsics.checkParameterIsNotNull(dynamicCallableDescriptors, "dynamicCallableDescriptors");
        Intrinsics.checkParameterIsNotNull(identifierChecker, "identifierChecker");
        this.annotationResolver = annotationResolver;
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
        this.moduleDescriptor = moduleDescriptor;
        this.flexibleTypeCapabilitiesProvider = flexibleTypeCapabilitiesProvider;
        this.storageManager = storageManager;
        this.lazinessToken = lazinessToken;
        this.dynamicTypesSettings = dynamicTypesSettings;
        this.dynamicCallableDescriptors = dynamicCallableDescriptors;
        this.identifierChecker = identifierChecker;
    }

    @NotNull
    public static final /* synthetic */ StorageManager access$getStorageManager$p(TypeResolver $this) {
        return $this.storageManager;
    }

    @NotNull
    public static final /* synthetic */ PossiblyBareType access$doResolvePossiblyBareType(TypeResolver $this, @NotNull TypeResolutionContext c, @NotNull KtTypeReference typeReference) {
        return $this.doResolvePossiblyBareType(c, typeReference);
    }

    @NotNull
    public static final /* synthetic */ List access$resolveTypeProjections(TypeResolver $this, @NotNull TypeResolutionContext c, @NotNull TypeConstructor constructor, @NotNull List argumentElements) {
        return $this.resolveTypeProjections(c, constructor, argumentElements);
    }

    @NotNull
    public static final /* synthetic */ KotlinType access$resolveTypeForTypeParameter(TypeResolver $this, @NotNull TypeResolutionContext c, @NotNull Annotations annotations2, @NotNull TypeParameterDescriptor typeParameter, @NotNull KtSimpleNameExpression referenceExpression, @NotNull KtUserType type2) {
        return $this.resolveTypeForTypeParameter(c, annotations2, typeParameter, referenceExpression, type2);
    }

    @NotNull
    public static final /* synthetic */ PossiblyBareType access$resolveTypeForClass(TypeResolver $this, @NotNull TypeResolutionContext c, @NotNull Annotations annotations2, @NotNull ClassDescriptor classDescriptor, @NotNull KtUserType type2, @NotNull QualifiedExpressionResolver.TypeQualifierResolutionResult qualifierResolutionResult) {
        return $this.resolveTypeForClass(c, annotations2, classDescriptor, type2, qualifierResolutionResult);
    }

    @NotNull
    public static final /* synthetic */ PossiblyBareType access$resolveTypeElement(TypeResolver $this, @NotNull TypeResolutionContext c, @NotNull Annotations annotations2, @Nullable KtTypeElement typeElement) {
        return $this.resolveTypeElement(c, annotations2, typeElement);
    }

    @NotNull
    public static final /* synthetic */ IdentifierChecker access$getIdentifierChecker$p(TypeResolver $this) {
        return $this.identifierChecker;
    }

    @NotNull
    public static final /* synthetic */ KotlinType access$resolveType(TypeResolver $this, @NotNull TypeResolutionContext c, @NotNull KtTypeReference typeReference) {
        return $this.resolveType(c, typeReference);
    }

    @NotNull
    public static final /* synthetic */ ModuleDescriptor access$getModuleDescriptor$p(TypeResolver $this) {
        return $this.moduleDescriptor;
    }

    @NotNull
    public static final /* synthetic */ DynamicCallableDescriptors access$getDynamicCallableDescriptors$p(TypeResolver $this) {
        return $this.dynamicCallableDescriptors;
    }

    @NotNull
    public static final /* synthetic */ DynamicTypesSettings access$getDynamicTypesSettings$p(TypeResolver $this) {
        return $this.dynamicTypesSettings;
    }

    @JvmStatic
    @NotNull
    public static final Variance resolveProjectionKind(@NotNull KtProjectionKind projectionKind) {
        Intrinsics.checkParameterIsNotNull((Object)projectionKind, "projectionKind");
        return Companion.resolveProjectionKind(projectionKind);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0011\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tAa\u0003\u0007\u00013\u0005A\n!)\u0002R\u0007\u0005A\u0011!\n\u0003\u0005\u0017!\rQ\"\u0001\r\u0003"}, strings={"Lorg/jetbrains/kotlin/resolve/TypeResolver$FlexibleTypeCapabilitiesProvider;", "", "()V", "getCapabilities", "Lorg/jetbrains/kotlin/types/FlexibleTypeCapabilities;"}, moduleName="kotlin-compiler")
    public static class FlexibleTypeCapabilitiesProvider {
        @NotNull
        public FlexibleTypeCapabilities getCapabilities() {
            return FlexibleTypeCapabilities.NONE.INSTANCE;
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0017\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005!19\u0001\u0007\u00013\u0005A\n!i\u0002\u0005\u0003E\u001b\u0011\u0001C\u0001&\u0011\u0011\u001d\u00012A\u0007\u00021\tI2\u0001#\u0002\u000e\u0003a\u0019\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/TypeResolver$Companion;", "", "()V", "resolveProjectionKind", "Lorg/jetbrains/kotlin/types/Variance;", "projectionKind", "Lorg/jetbrains/kotlin/psi/KtProjectionKind;"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        @JvmStatic
        @NotNull
        public final Variance resolveProjectionKind(@NotNull KtProjectionKind projectionKind) {
            Variance variance;
            Intrinsics.checkParameterIsNotNull((Object)projectionKind, "projectionKind");
            switch (TypeResolver$Companion$WhenMappings.$EnumSwitchMapping$0[projectionKind.ordinal()]) {
                case 1: {
                    variance = Variance.IN_VARIANCE;
                    break;
                }
                case 2: {
                    variance = Variance.OUT_VARIANCE;
                    break;
                }
                case 3: {
                    variance = Variance.INVARIANT;
                    break;
                }
                default: {
                    throw (Throwable)new IllegalStateException("Illegal projection kind:" + (Object)((Object)projectionKind));
                }
            }
            return variance;
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

