/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.relocated.com.google.protobuf.GeneratedMessageLite;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.serialization.AnnotationSerializer;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializerExtension;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.StringTableImpl;
import org.jetbrains.kotlin.types.KotlinType;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"k\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\u0019\u0005!1\u0002\u0004\u0001\u001a\u0003a\u0005\u0011UB\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005A!!\n\u0003\u0005\u0017!%Q\"\u0001\r\u0005K1!1\u0002C\u0003\u000e\u0003a-\u0011d\u0001\u0005\u0007\u001b\u0005Aj!G\u0002\t\u000f5\t\u0001tB\u0013\r\t-A\u0001\"D\u0001\u0019\fe\u0019\u0001BB\u0007\u00021#I2\u0001C\u0004\u000e\u0003aIQ\u0005\u0004\u0003\f\u0011'i\u0011\u0001g\u0003\u001a\u0007!1Q\"\u0001M\u00073\rAq!D\u0001\u0019\u0015\u0015bAa\u0003E\u000b\u001b\u0005AZ!G\u0002\t\r5\t\u0001dC\r\u0004\u0011\u001di\u0011\u0001g\u0006&\u0019\u0011Y\u0001\u0002D\u0007\u00021\u0017I2\u0001\u0003\u0004\u000e\u0003ae\u0011d\u0001\u0005\b\u001b\u0005AR\"\n\u0007\u0005\u0017!mQ\"\u0001M\u00063\rAa\"D\u0001\u0019\u001ee\u0019\u0001bB\u0007\u00021=)C\u0002B\u0006\t 5\t\u00014B\r\u0004\u0011\u0019i\u0011\u0001\u0007\t\u001a\u0007!9Q\"\u0001M\u0011S\u001d!\u0011\t\u0003E\u0003\u001b\u0005A2!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"A9!D\u0001\u0019\tE\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "Lorg/jetbrains/kotlin/serialization/SerializerExtension;", "protocol", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "(Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;)V", "annotationSerializer", "Lorg/jetbrains/kotlin/serialization/AnnotationSerializer;", "stringTable", "Lorg/jetbrains/kotlin/serialization/StringTableImpl;", "getStringTable", "serializeClass", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "proto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class$Builder;", "serializeConstructor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Constructor$Builder;", "serializeEnumEntry", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$EnumEntry$Builder;", "serializeFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Function$Builder;", "serializeProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Property$Builder;", "serializeType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Type$Builder;", "serializeValueParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$ValueParameter$Builder;"}, moduleName="kotlin-compiler")
public class KotlinSerializerExtensionBase
extends SerializerExtension {
    private final StringTableImpl stringTable;
    private final AnnotationSerializer annotationSerializer;
    private final SerializerExtensionProtocol protocol;

    @Override
    @NotNull
    public StringTableImpl getStringTable() {
        return this.stringTable;
    }

    @Override
    public void serializeClass(@NotNull ClassDescriptor descriptor2, @NotNull ProtoBuf.Class.Builder proto) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        for (AnnotationDescriptor annotation2 : descriptor2.getAnnotations()) {
            proto.addExtension(this.protocol.getClassAnnotation(), this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeConstructor(@NotNull ConstructorDescriptor descriptor2, @NotNull ProtoBuf.Constructor.Builder proto) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        for (AnnotationDescriptor annotation2 : descriptor2.getAnnotations()) {
            proto.addExtension(this.protocol.getConstructorAnnotation(), this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeFunction(@NotNull FunctionDescriptor descriptor2, @NotNull ProtoBuf.Function.Builder proto) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        for (AnnotationDescriptor annotation2 : descriptor2.getAnnotations()) {
            proto.addExtension(this.protocol.getFunctionAnnotation(), this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeProperty(@NotNull PropertyDescriptor descriptor2, @NotNull ProtoBuf.Property.Builder proto) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        for (AnnotationDescriptor annotation2 : descriptor2.getAnnotations()) {
            proto.addExtension(this.protocol.getPropertyAnnotation(), this.annotationSerializer.serializeAnnotation(annotation2));
        }
        ConstantValue<?> constantValue = descriptor2.getCompileTimeInitializer();
        if (constantValue == null) {
            return;
        }
        ConstantValue<?> constantInitializer = constantValue;
        if (!(constantInitializer instanceof NullValue)) {
            GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, ProtoBuf.Annotation.Argument.Value> generatedExtension = this.protocol.getCompileTimeValue();
            ConstantValue<?> constantValue2 = constantInitializer;
            Intrinsics.checkExpressionValueIsNotNull(constantValue2, "constantInitializer");
            proto.setExtension(generatedExtension, this.annotationSerializer.valueProto(constantValue2).build());
        }
    }

    @Override
    public void serializeEnumEntry(@NotNull ClassDescriptor descriptor2, @NotNull ProtoBuf.EnumEntry.Builder proto) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        for (AnnotationDescriptor annotation2 : descriptor2.getAnnotations()) {
            proto.addExtension(this.protocol.getEnumEntryAnnotation(), this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeValueParameter(@NotNull ValueParameterDescriptor descriptor2, @NotNull ProtoBuf.ValueParameter.Builder proto) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        for (AnnotationDescriptor annotation2 : descriptor2.getAnnotations()) {
            proto.addExtension(this.protocol.getParameterAnnotation(), this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeType(@NotNull KotlinType type2, @NotNull ProtoBuf.Type.Builder proto) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        for (AnnotationDescriptor annotation2 : type2.getAnnotations()) {
            proto.addExtension(this.protocol.getTypeAnnotation(), this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    public KotlinSerializerExtensionBase(@NotNull SerializerExtensionProtocol protocol) {
        Intrinsics.checkParameterIsNotNull(protocol, "protocol");
        this.protocol = protocol;
        this.stringTable = new StringTableImpl();
        this.annotationSerializer = new AnnotationSerializer(this.stringTable);
    }
}

