/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithDifferentJvmName;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithSpecialGenericSignature;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinSpecialProperties;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaCallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaClassDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.checker.TypeCheckingProcedure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JvmName(name="SpecialBuiltinMembers")
public final class SpecialBuiltinMembers {
    private static final FqName child(FqName $receiver, String name) {
        FqName fqName2 = $receiver.child(Name.identifier(name));
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "child(Name.identifier(name))");
        return fqName2;
    }

    private static final FqName childSafe(FqNameUnsafe $receiver, String name) {
        FqName fqName2 = $receiver.child(Name.identifier(name)).toSafe();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "child(Name.identifier(name)).toSafe()");
        return fqName2;
    }

    @Nullable
    public static final <T extends CallableMemberDescriptor> T getOverriddenBuiltinWithDifferentJvmName(T $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (BuiltinMethodsWithDifferentJvmName.INSTANCE.getORIGINAL_SHORT_NAMES().contains($receiver.getName()) ^ true && BuiltinSpecialProperties.INSTANCE.getSPECIAL_SHORT_NAMES$kotlin_core().contains(DescriptorUtilsKt.getPropertyIfAccessor($receiver).getName()) ^ true) {
            return (T)((CallableMemberDescriptor)null);
        }
        T t = $receiver;
        return (T)(t instanceof PropertyDescriptor || t instanceof PropertyAccessorDescriptor ? DescriptorUtilsKt.firstOverridden($receiver, getOverriddenBuiltinWithDifferentJvmName.1.INSTANCE) : DescriptorUtilsKt.firstOverridden($receiver, getOverriddenBuiltinWithDifferentJvmName.2.INSTANCE));
    }

    public static final boolean doesOverrideBuiltinWithDifferentJvmName(CallableMemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmName($receiver) != null;
    }

    @Nullable
    public static final <T extends CallableMemberDescriptor> T getOverriddenSpecialBuiltin(T $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        T t = SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmName($receiver);
        if (t != null) {
            T $receiver$iv = t;
            T it = $receiver$iv;
            return it;
        }
        if (!BuiltinMethodsWithSpecialGenericSignature.INSTANCE.getSameAsBuiltinMethodWithErasedValueParameters($receiver.getName())) {
            return (T)((CallableMemberDescriptor)null);
        }
        return (T)DescriptorUtilsKt.firstOverridden($receiver, getOverriddenSpecialBuiltin.2.INSTANCE);
    }

    @Nullable
    public static final <T extends CallableMemberDescriptor> T getOverriddenBuiltinReflectingJvmDescriptor(T $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        T t = SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmName($receiver);
        if (t != null) {
            T $receiver$iv = t;
            T it = $receiver$iv;
            return it;
        }
        if (!BuiltinMethodsWithSpecialGenericSignature.INSTANCE.getSameAsBuiltinMethodWithErasedValueParameters($receiver.getName())) {
            return (T)((CallableMemberDescriptor)null);
        }
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtilsKt.firstOverridden($receiver, getOverriddenBuiltinReflectingJvmDescriptor.2.INSTANCE);
        return (T)(callableMemberDescriptor != null ? callableMemberDescriptor.getOriginal() : null);
    }

    @Nullable
    public static final String getJvmMethodNameIfSpecial(@NotNull CallableMemberDescriptor callableMemberDescriptor) {
        String string;
        CallableMemberDescriptor overriddenBuiltin;
        CallableMemberDescriptor callableMemberDescriptor2;
        Intrinsics.checkParameterIsNotNull(callableMemberDescriptor, "callableMemberDescriptor");
        if (Intrinsics.areEqual(DescriptorUtilsKt.getPropertyIfAccessor(callableMemberDescriptor).getName(), DescriptorUtils.ENUM_VALUES)) {
            DeclarationDescriptor containingDeclaration = callableMemberDescriptor.getContainingDeclaration();
            if (callableMemberDescriptor instanceof PropertyAccessorDescriptor && containingDeclaration instanceof ClassDescriptor && Intrinsics.areEqual((Object)((ClassDescriptor)containingDeclaration).getKind(), (Object)ClassKind.ENUM_CLASS)) {
                return DescriptorUtils.ENUM_VALUES.asString();
            }
        }
        if ((callableMemberDescriptor2 = SpecialBuiltinMembers.getOverriddenBuiltinThatAffectsJvmName(callableMemberDescriptor)) == null || (callableMemberDescriptor2 = DescriptorUtilsKt.getPropertyIfAccessor(callableMemberDescriptor2)) == null) {
            return null;
        }
        CallableMemberDescriptor callableMemberDescriptor3 = overriddenBuiltin = callableMemberDescriptor2;
        if (callableMemberDescriptor3 instanceof PropertyDescriptor) {
            string = BuiltinSpecialProperties.INSTANCE.getBuiltinSpecialPropertyGetterName(overriddenBuiltin);
        } else {
            Name name = BuiltinMethodsWithDifferentJvmName.INSTANCE.getJvmName(overriddenBuiltin);
            string = name != null ? name.asString() : null;
        }
        return string;
    }

    private static final CallableMemberDescriptor getOverriddenBuiltinThatAffectsJvmName(CallableMemberDescriptor callableMemberDescriptor) {
        CallableMemberDescriptor callableMemberDescriptor2 = SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmName(callableMemberDescriptor);
        if (callableMemberDescriptor2 == null) {
            return null;
        }
        CallableMemberDescriptor overriddenBuiltin = callableMemberDescriptor2;
        if (SpecialBuiltinMembers.isFromBuiltins(callableMemberDescriptor)) {
            return overriddenBuiltin;
        }
        return null;
    }

    public static final boolean hasRealKotlinSuperClassWithOverrideOf(ClassDescriptor $receiver, @NotNull CallableDescriptor specialCallableDescriptor) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(specialCallableDescriptor, "specialCallableDescriptor");
        DeclarationDescriptor declarationDescriptor = specialCallableDescriptor.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        KotlinType builtinContainerDefaultType = ((ClassDescriptor)declarationDescriptor).getDefaultType();
        ClassDescriptor superClassDescriptor = DescriptorUtils.getSuperClassDescriptor($receiver);
        while (superClassDescriptor != null) {
            if (!(superClassDescriptor instanceof JavaClassDescriptor)) {
                boolean doesOverrideBuiltinDeclaration;
                boolean bl = doesOverrideBuiltinDeclaration = TypeCheckingProcedure.findCorrespondingSupertype(superClassDescriptor.getDefaultType(), builtinContainerDefaultType) != null;
                if (doesOverrideBuiltinDeclaration) {
                    PackageFragmentDescriptor containingPackageFragment = DescriptorUtils.getParentOfType(superClassDescriptor, PackageFragmentDescriptor.class);
                    return !DescriptorUtilsKt.getBuiltIns(superClassDescriptor).isBuiltInPackageFragment(containingPackageFragment);
                }
            }
            superClassDescriptor = DescriptorUtils.getSuperClassDescriptor(superClassDescriptor);
        }
        return false;
    }

    public static final boolean isFromJava(CallableMemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return DescriptorUtilsKt.getPropertyIfAccessor($receiver) instanceof JavaCallableMemberDescriptor && DescriptorUtilsKt.getPropertyIfAccessor($receiver).getContainingDeclaration() instanceof JavaClassDescriptor;
    }

    public static final boolean isFromBuiltins(CallableMemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        FqName fqName2 = DescriptorUtilsKt.fqNameOrNull(DescriptorUtilsKt.getPropertyIfAccessor($receiver));
        if (fqName2 == null) {
            return false;
        }
        FqName fqName3 = fqName2;
        return fqName3.toUnsafe().startsWith(KotlinBuiltIns.BUILT_INS_PACKAGE_NAME) && Intrinsics.areEqual(DescriptorUtilsKt.getModule($receiver), DescriptorUtilsKt.getBuiltIns($receiver).getBuiltInsModule());
    }

    public static final boolean isFromJavaOrBuiltins(CallableMemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return SpecialBuiltinMembers.isFromJava($receiver) || SpecialBuiltinMembers.isFromBuiltins($receiver);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<Name, List<Name>> getInversedShortNamesMap(Map<FqName, Name> $receiver) {
        void var3_3;
        void $receiver$iv$iv$iv;
        List list$iv$iv;
        Iterable answer$iv$iv$iv;
        Object value$iv$iv$iv;
        Map map2;
        Object $receiver$iv$iv;
        Object $receiver$iv = $receiver.entrySet();
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        Object object = $receiver$iv$iv.iterator();
        while (object.hasNext()) {
            Object object2;
            void key$iv$iv$iv;
            void $receiver$iv$iv$iv2;
            Object element$iv$iv = object.next();
            Map.Entry it = (Map.Entry)element$iv$iv;
            Name key$iv$iv = (Name)it.getValue();
            map2 = destination$iv$iv;
            value$iv$iv$iv = $receiver$iv$iv$iv2.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv2.put(key$iv$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($receiver$iv.size()));
        object = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void destination$iv$iv2;
            void $receiver$iv$iv2;
            void $receiver$iv2;
            void entry;
            void it$iv$iv;
            void destination$iv$iv$iv;
            Map.Entry $i$a$1 = (Map.Entry)element$iv$iv$iv;
            void var7_7 = destination$iv$iv$iv;
            map2 = it$iv$iv.getKey();
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map3 = map2;
            void var14_14 = var7_7;
            answer$iv$iv$iv = (Iterable)entry.getValue();
            list$iv$iv = $receiver$iv2;
            Collection $i$f$getOrPut = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                Map.Entry entry2 = (Map.Entry)item$iv$iv;
                void var19_19 = destination$iv$iv2;
                Name name = ((FqName)it.getKey()).shortName();
                var19_19.add(name);
            }
            List list2 = (List)destination$iv$iv2;
            var14_14.put(map3, list2);
        }
        return var3_3;
    }

    @NotNull
    public static final /* synthetic */ FqName access$childSafe(FqNameUnsafe $receiver, @NotNull String name) {
        return SpecialBuiltinMembers.childSafe($receiver, name);
    }

    @NotNull
    public static final /* synthetic */ FqName access$child(FqName $receiver, @NotNull String name) {
        return SpecialBuiltinMembers.child($receiver, name);
    }

    @NotNull
    public static final /* synthetic */ Map access$getInversedShortNamesMap(Map $receiver) {
        return SpecialBuiltinMembers.getInversedShortNamesMap($receiver);
    }
}

