/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.com.google.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationWithTarget;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.SerializerExtensionProtocol;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotatedCallableKind;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationAndConstantLoader;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoContainer;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnnotationAndConstantLoaderImpl
implements AnnotationAndConstantLoader<AnnotationDescriptor, ConstantValue<?>, AnnotationWithTarget> {
    private final AnnotationDeserializer deserializer;
    private final SerializerExtensionProtocol protocol;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationDescriptor> loadClassAnnotations(@NotNull ProtoBuf.Class classProto, @NotNull NameResolver nameResolver) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(classProto, "classProto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Iterable<ProtoBuf.Annotation> $receiver$iv = classProto.getExtension(this.protocol.getClassAnnotation());
        List<ProtoBuf.Annotation> list2 = $receiver$iv;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List<ProtoBuf.Annotation> annotations2 = list2;
        $receiver$iv = annotations2;
        Iterable<ProtoBuf.Annotation> $i$f$orEmpty = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void proto;
            ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
            void var10_10 = destination$iv$iv;
            AnnotationDescriptor annotationDescriptor = this.deserializer.deserializeAnnotation((ProtoBuf.Annotation)proto, nameResolver);
            var10_10.add(annotationDescriptor);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationWithTarget> loadCallableAnnotations(@NotNull ProtoContainer container, @NotNull MessageLite proto, @NotNull AnnotatedCallableKind kind) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        List<ProtoBuf.Annotation> list2;
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        Object object = proto;
        if (object instanceof ProtoBuf.Constructor) {
            list2 = ((ProtoBuf.Constructor)proto).getExtension(this.protocol.getConstructorAnnotation());
        } else if (object instanceof ProtoBuf.Function) {
            list2 = ((ProtoBuf.Function)proto).getExtension(this.protocol.getFunctionAnnotation());
        } else if (object instanceof ProtoBuf.Property) {
            list2 = ((ProtoBuf.Property)proto).getExtension(this.protocol.getPropertyAnnotation());
        } else {
            void message$iv;
            String string = "Unknown message: " + proto;
            throw (Throwable)new IllegalStateException(message$iv.toString());
        }
        object = list2;
        Iterable<Object> iterable = $receiver$iv;
        if (iterable == null) {
            iterable = CollectionsKt.emptyList();
        }
        void annotations2 = iterable;
        $receiver$iv = (Iterable)annotations2;
        Iterable $i$f$orEmpty = $receiver$iv;
        Collection $i$f$error = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void proto2;
            ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
            void var11_12 = destination$iv$iv;
            AnnotationWithTarget annotationWithTarget = new AnnotationWithTarget(this.deserializer.deserializeAnnotation((ProtoBuf.Annotation)proto2, container.getNameResolver()), null);
            var11_12.add(annotationWithTarget);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationDescriptor> loadEnumEntryAnnotations(@NotNull ProtoContainer container, @NotNull ProtoBuf.EnumEntry proto) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Iterable<ProtoBuf.Annotation> $receiver$iv = proto.getExtension(this.protocol.getEnumEntryAnnotation());
        List<ProtoBuf.Annotation> list2 = $receiver$iv;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List<ProtoBuf.Annotation> annotations2 = list2;
        $receiver$iv = annotations2;
        Iterable<ProtoBuf.Annotation> $i$f$orEmpty = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void proto2;
            ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
            void var10_10 = destination$iv$iv;
            AnnotationDescriptor annotationDescriptor = this.deserializer.deserializeAnnotation((ProtoBuf.Annotation)proto2, container.getNameResolver());
            var10_10.add(annotationDescriptor);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationDescriptor> loadValueParameterAnnotations(@NotNull ProtoContainer container, @NotNull MessageLite message, @NotNull AnnotatedCallableKind kind, int parameterIndex, @NotNull ProtoBuf.ValueParameter proto) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(message, "message");
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        List<ProtoBuf.Annotation> list2 = proto.getExtension(this.protocol.getParameterAnnotation());
        Iterable<Object> iterable = $receiver$iv;
        if (iterable == null) {
            iterable = CollectionsKt.emptyList();
        }
        void annotations2 = iterable;
        $receiver$iv = (Iterable)annotations2;
        Iterable $i$f$orEmpty = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void proto2;
            ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
            void var13_13 = destination$iv$iv;
            AnnotationDescriptor annotationDescriptor = this.deserializer.deserializeAnnotation((ProtoBuf.Annotation)proto2, container.getNameResolver());
            var13_13.add(annotationDescriptor);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> loadExtensionReceiverParameterAnnotations(@NotNull ProtoContainer container, @NotNull MessageLite message, @NotNull AnnotatedCallableKind kind) {
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(message, "message");
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationDescriptor> loadTypeAnnotations(@NotNull ProtoBuf.Type proto, @NotNull NameResolver nameResolver) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Iterable<ProtoBuf.Annotation> $receiver$iv = proto.getExtension(this.protocol.getTypeAnnotation());
        List<ProtoBuf.Annotation> list2 = $receiver$iv;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        $receiver$iv = list2;
        Iterable<ProtoBuf.Annotation> $i$f$orEmpty = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
            void var9_9 = destination$iv$iv;
            AnnotationDescriptor annotationDescriptor = this.deserializer.deserializeAnnotation((ProtoBuf.Annotation)it, nameResolver);
            var9_9.add(annotationDescriptor);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationDescriptor> loadTypeParameterAnnotations(@NotNull ProtoBuf.TypeParameter proto, @NotNull NameResolver nameResolver) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Iterable<ProtoBuf.Annotation> $receiver$iv = proto.getExtension(this.protocol.getTypeParameterAnnotation());
        List<ProtoBuf.Annotation> list2 = $receiver$iv;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        $receiver$iv = list2;
        Iterable<ProtoBuf.Annotation> $i$f$orEmpty = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
            void var9_9 = destination$iv$iv;
            AnnotationDescriptor annotationDescriptor = this.deserializer.deserializeAnnotation((ProtoBuf.Annotation)it, nameResolver);
            var9_9.add(annotationDescriptor);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public ConstantValue<?> loadPropertyConstant(@NotNull ProtoContainer container, @NotNull ProtoBuf.Property proto, @NotNull KotlinType expectedType) {
        ProtoBuf.Annotation.Argument.Value value;
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        if (!proto.hasExtension(this.protocol.getCompileTimeValue())) {
            return null;
        }
        ProtoBuf.Annotation.Argument.Value value2 = value = proto.getExtension(this.protocol.getCompileTimeValue());
        Intrinsics.checkExpressionValueIsNotNull(value2, "value");
        return this.deserializer.resolveValue(expectedType, value2, container.getNameResolver());
    }

    public AnnotationAndConstantLoaderImpl(@NotNull ModuleDescriptor module, @NotNull SerializerExtensionProtocol protocol) {
        Intrinsics.checkParameterIsNotNull(module, "module");
        Intrinsics.checkParameterIsNotNull(protocol, "protocol");
        this.protocol = protocol;
        this.deserializer = new AnnotationDeserializer(module);
    }
}

