/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.AccessorForPropertyBackingField;
import org.jetbrains.kotlin.codegen.ArgumentGenerator;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.BranchedValue;
import org.jetbrains.kotlin.codegen.BuiltinSpecialBridgesKt;
import org.jetbrains.kotlin.codegen.CallBasedArgumentGenerator;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClosureCodegen;
import org.jetbrains.kotlin.codegen.CodegenStatementVisitor;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.DefaultCallArgs;
import org.jetbrains.kotlin.codegen.FieldAccessorKind;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.FunctionReferenceGenerationStrategy;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.InterfaceImplBodyCodegen;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.PropertyReferenceCodegen;
import org.jetbrains.kotlin.codegen.RangeCodegenUtil;
import org.jetbrains.kotlin.codegen.SamCodegenUtil;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.StackValueWithLeaveTask;
import org.jetbrains.kotlin.codegen.TailRecursionCodegen;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.ConstructorContext;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.LocalLookup;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.ScriptContext;
import org.jetbrains.kotlin.codegen.extensions.ExpressionCodegenExtension;
import org.jetbrains.kotlin.codegen.inline.InlineCodegen;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.inline.NameGenerator;
import org.jetbrains.kotlin.codegen.inline.ReificationArgument;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeParametersUsages;
import org.jetbrains.kotlin.codegen.inline.TypeParameterMappings;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicPropertyGetter;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.codegen.when.SwitchCodegen;
import org.jetbrains.kotlin.codegen.when.SwitchCodegenUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.jvm.bindingContextSlices.BindingContextSlicesKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.descriptors.SamConstructorDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Maps;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.scopes.receivers.CastImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class ExpressionCodegen
extends KtVisitor<StackValue, StackValue>
implements LocalLookup {
    private final GenerationState state;
    final JetTypeMapper typeMapper;
    private final BindingContext bindingContext;
    public final InstructionAdapter v;
    public final FrameMap myFrameMap;
    private final MethodContext context;
    private final Type returnType;
    private final CodegenStatementVisitor statementVisitor;
    private final MemberCodegen<?> parentCodegen;
    private final TailRecursionCodegen tailRecursionCodegen;
    public final CallGenerator defaultCallGenerator;
    private final Stack<BlockStackElement> blockStackElements;
    public final Map<KtElement, StackValue> tempVariables;
    private int myLastLineNumber;
    private boolean shouldMarkLineNumbers;
    private int finallyDepth;

    public ExpressionCodegen(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull Type returnType2, @NotNull MethodContext context, @NotNull GenerationState state2, @NotNull MemberCodegen<?> parentCodegen) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "<init>"));
        }
        if (frameMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameMap", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "<init>"));
        }
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "<init>"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "<init>"));
        }
        if (parentCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "<init>"));
        }
        this.statementVisitor = new CodegenStatementVisitor(this);
        this.defaultCallGenerator = new CallGenerator.DefaultCallGenerator(this);
        this.blockStackElements = new Stack();
        this.tempVariables = Maps.newHashMap();
        this.myLastLineNumber = -1;
        this.shouldMarkLineNumbers = true;
        this.finallyDepth = 0;
        this.state = state2;
        this.typeMapper = state2.getTypeMapper();
        this.bindingContext = state2.getBindingContext();
        this.v = new InstructionAdapter(mv);
        this.myFrameMap = frameMap;
        this.context = context;
        this.returnType = returnType2;
        this.parentCodegen = parentCodegen;
        this.tailRecursionCodegen = new TailRecursionCodegen(context, this, this.v, state2);
    }

    @NotNull
    public GenerationState getState() {
        GenerationState generationState = this.state;
        if (generationState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getState"));
        }
        return generationState;
    }

    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext = this.bindingContext;
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getBindingContext"));
        }
        return bindingContext;
    }

    @NotNull
    public MemberCodegen<?> getParentCodegen() {
        MemberCodegen<?> memberCodegen = this.parentCodegen;
        if (memberCodegen == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getParentCodegen"));
        }
        return memberCodegen;
    }

    @NotNull
    public ObjectLiteralResult generateObjectLiteral(@NotNull KtObjectLiteralExpression literal) {
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateObjectLiteral"));
        }
        KtObjectDeclaration objectDeclaration = literal.getObjectDeclaration();
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, objectDeclaration);
        assert (classDescriptor != null);
        Type asmType = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, objectDeclaration);
        ClassBuilder classBuilder2 = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(objectDeclaration, classDescriptor), asmType, literal.getContainingFile());
        ClassContext objectContext = this.context.intoAnonymousClass(classDescriptor, this, OwnerKind.IMPLEMENTATION);
        ImplementationBodyCodegen literalCodegen = new ImplementationBodyCodegen(objectDeclaration, objectContext, classBuilder2, this.state, this.getParentCodegen(), true);
        literalCodegen.generate();
        ExpressionCodegen.addReifiedParametersFromSignature(literalCodegen, classDescriptor);
        this.propagateChildReifiedTypeParametersUsages(literalCodegen.getReifiedTypeParametersUsages());
        ObjectLiteralResult objectLiteralResult = new ObjectLiteralResult(literalCodegen.getReifiedTypeParametersUsages().wereUsedReifiedParameters(), classDescriptor);
        if (objectLiteralResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateObjectLiteral"));
        }
        return objectLiteralResult;
    }

    private static void addReifiedParametersFromSignature(@NotNull MemberCodegen member, @NotNull ClassDescriptor descriptor2) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "addReifiedParametersFromSignature"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "addReifiedParametersFromSignature"));
        }
        for (KotlinType type2 : descriptor2.getTypeConstructor().getSupertypes()) {
            for (TypeProjection supertypeArgument : type2.getArguments()) {
                TypeParameterDescriptor parameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(supertypeArgument.getType());
                if (parameterDescriptor == null || !parameterDescriptor.isReified()) continue;
                member.getReifiedTypeParametersUsages().addUsedReifiedParameter(parameterDescriptor.getName().asString());
            }
        }
    }

    @NotNull
    private StackValue castToRequiredTypeOfInterfaceIfNeeded(StackValue inner, @NotNull ClassDescriptor provided, @NotNull ClassDescriptor required) {
        if (provided == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provided", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "castToRequiredTypeOfInterfaceIfNeeded"));
        }
        if (required == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "required", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "castToRequiredTypeOfInterfaceIfNeeded"));
        }
        if (!JvmCodegenUtil.isJvmInterface(provided) && JvmCodegenUtil.isJvmInterface(required)) {
            StackValue stackValue = StackValue.coercion(inner, this.asmType(required.getDefaultType()));
            if (stackValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "castToRequiredTypeOfInterfaceIfNeeded"));
            }
            return stackValue;
        }
        StackValue stackValue = inner;
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "castToRequiredTypeOfInterfaceIfNeeded"));
        }
        return stackValue;
    }

    public StackValue genQualified(StackValue receiver, KtElement selector) {
        return this.genQualified(receiver, selector, this);
    }

    private StackValue genQualified(StackValue receiver, KtElement selector, KtVisitor<StackValue, StackValue> visitor2) {
        if (this.tempVariables.containsKey(selector)) {
            throw new IllegalStateException("Inconsistent state: expression saved to a temporary variable is a selector");
        }
        if (!(selector instanceof KtBlockExpression)) {
            this.markStartLineNumber(selector);
        }
        try {
            StackValue samValue;
            if (selector instanceof KtExpression && (samValue = this.genSamInterfaceValue((KtExpression)selector, visitor2)) != null) {
                return samValue;
            }
            StackValue stackValue = selector.accept(visitor2, receiver);
            RuntimeAssertionInfo runtimeAssertionInfo = null;
            if (selector instanceof KtExpression) {
                runtimeAssertionInfo = this.bindingContext.get(BindingContextSlicesKt.getRUNTIME_ASSERTION_INFO(), (KtExpression)selector);
            }
            if (BuiltinSpecialBridgesKt.isValueArgumentForCallToMethodWithTypeCheckBarrier(selector, this.bindingContext)) {
                return stackValue;
            }
            return AsmUtil.genNotNullAssertions(this.state, stackValue, runtimeAssertionInfo);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (Throwable error) {
            String message = error.getMessage();
            throw new CompilationException(message != null ? message : "null", error, selector);
        }
    }

    public StackValue gen(KtElement expr) {
        StackValue tempVar = this.tempVariables.get(expr);
        return tempVar != null ? tempVar : this.genQualified(StackValue.none(), expr);
    }

    public void gen(KtElement expr, Type type2) {
        ScriptContext context;
        StackValue value;
        StackValue stackValue = value = Type.VOID_TYPE.equals(type2) ? this.genStatement(expr) : this.gen(expr);
        if (value.type != Type.VOID_TYPE && this.state.getReplSpecific().getShouldGenerateScriptResultValue() && expr == (context = this.getScriptContext()).getLastStatement()) {
            StackValue.Field resultValue = StackValue.field(context.getResultFieldInfo(), (StackValue)StackValue.LOCAL_0);
            resultValue.store(value, this.v);
            this.state.getReplSpecific().setHasResult(true);
            return;
        }
        value.put(type2, this.v);
    }

    @NotNull
    private ScriptContext getScriptContext() {
        CodegenContext context = this.getContext();
        while (!(context instanceof ScriptContext)) {
            context = ((CodegenContext)context).getParentContext();
        }
        ScriptContext scriptContext = (ScriptContext)context;
        if (scriptContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getScriptContext"));
        }
        return scriptContext;
    }

    public StackValue genLazy(KtElement expr, Type type2) {
        StackValue value = this.gen(expr);
        return StackValue.coercion(value, type2);
    }

    private StackValue genStatement(KtElement statement) {
        return this.genQualified(StackValue.none(), statement, this.statementVisitor);
    }

    @Override
    public StackValue visitClass(@NotNull KtClass klass, StackValue data) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitClass"));
        }
        return this.visitClassOrObject(klass);
    }

    private StackValue visitClassOrObject(KtClassOrObject declaration) {
        ClassDescriptor descriptor2 = this.bindingContext.get(BindingContext.CLASS, declaration);
        assert (descriptor2 != null);
        Type asmType = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, declaration);
        ClassBuilder classBuilder2 = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(declaration, descriptor2), asmType, declaration.getContainingFile());
        ClassContext objectContext = this.context.intoAnonymousClass(descriptor2, this, OwnerKind.IMPLEMENTATION);
        new ImplementationBodyCodegen(declaration, objectContext, classBuilder2, this.state, this.getParentCodegen(), true).generate();
        if (declaration instanceof KtClass && ((KtClass)declaration).isInterface()) {
            Type traitImplType = this.state.getTypeMapper().mapDefaultImpls(descriptor2);
            ClassBuilder traitImplBuilder = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.TraitImpl(declaration, descriptor2), traitImplType, declaration.getContainingFile());
            ClassContext traitImplContext = this.context.intoAnonymousClass(descriptor2, this, OwnerKind.DEFAULT_IMPLS);
            new InterfaceImplBodyCodegen(declaration, traitImplContext, traitImplBuilder, this.state, this.parentCodegen).generate();
        }
        return StackValue.none();
    }

    @Override
    public StackValue visitObjectDeclaration(@NotNull KtObjectDeclaration declaration, StackValue data) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitObjectDeclaration"));
        }
        return this.visitClassOrObject(declaration);
    }

    @Override
    public StackValue visitExpression(@NotNull KtExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitExpression"));
        }
        throw new UnsupportedOperationException("Codegen for " + expression + " is not yet implemented");
    }

    @Override
    public StackValue visitSuperExpression(@NotNull KtSuperExpression expression, StackValue data) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitSuperExpression"));
        }
        return StackValue.thisOrOuter(this, ExpressionCodegen.getSuperCallLabelTarget(this.context, expression), true, false);
    }

    @NotNull
    public static ClassDescriptor getSuperCallLabelTarget(@NotNull CodegenContext<?> context, @NotNull KtSuperExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getSuperCallLabelTarget"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getSuperCallLabelTarget"));
        }
        BindingContext bindingContext = context.getState().getBindingContext();
        PsiElement labelPsi = bindingContext.get(BindingContext.LABEL_TARGET, expression.getTargetLabel());
        ClassDescriptor labelTarget = (ClassDescriptor)bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, labelPsi);
        DeclarationDescriptor descriptor2 = bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getInstanceReference());
        if (labelTarget != null) {
            ClassDescriptor classDescriptor = labelTarget;
            if (classDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getSuperCallLabelTarget"));
            }
            return classDescriptor;
        }
        assert (descriptor2 instanceof ClassDescriptor) : "Don't know how to generate super-call to not a class";
        CodegenContext result2 = ExpressionCodegen.getParentContextSubclassOf((ClassDescriptor)descriptor2, context);
        assert (result2 != null) : "Can't find parent context for " + descriptor2;
        ClassDescriptor classDescriptor = result2.getThisDescriptor();
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getSuperCallLabelTarget"));
        }
        return classDescriptor;
    }

    @NotNull
    private Type asmType(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "asmType"));
        }
        Type type3 = this.typeMapper.mapType(type2);
        if (type3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "asmType"));
        }
        return type3;
    }

    @NotNull
    public Type expressionType(@Nullable KtExpression expression) {
        KotlinType type2 = this.expressionJetType(expression);
        Type type3 = type2 == null ? Type.VOID_TYPE : this.asmType(type2);
        if (type3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "expressionType"));
        }
        return type3;
    }

    @Nullable
    public KotlinType expressionJetType(@Nullable KtExpression expression) {
        return expression != null ? this.bindingContext.getType(expression) : null;
    }

    @Override
    public StackValue visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitParenthesizedExpression"));
        }
        return this.genQualified(receiver, expression.getExpression());
    }

    @Override
    public StackValue visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitAnnotatedExpression"));
        }
        return this.genQualified(receiver, expression.getBaseExpression());
    }

    private static boolean isEmptyExpression(@Nullable KtElement expr) {
        KtBlockExpression blockExpression;
        List<KtExpression> statements;
        if (expr == null) {
            return true;
        }
        return expr instanceof KtBlockExpression && ((statements = (blockExpression = (KtBlockExpression)expr).getStatements()).size() == 0 || statements.size() == 1 && ExpressionCodegen.isEmptyExpression(statements.get(0)));
    }

    @Override
    public StackValue visitIfExpression(@NotNull KtIfExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitIfExpression"));
        }
        return this.generateIfExpression(expression, false);
    }

    StackValue generateIfExpression(final @NotNull KtIfExpression expression, final boolean isStatement) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateIfExpression"));
        }
        final Type asmType = isStatement ? Type.VOID_TYPE : this.expressionType(expression);
        final StackValue condition = this.gen(expression.getCondition());
        final KtExpression thenExpression = expression.getThen();
        final KtExpression elseExpression = expression.getElse();
        if (ExpressionCodegen.isEmptyExpression(thenExpression)) {
            if (ExpressionCodegen.isEmptyExpression(elseExpression)) {
                return StackValue.coercion(condition, asmType);
            }
            return this.generateSingleBranchIf(condition, expression, elseExpression, false, isStatement);
        }
        if (ExpressionCodegen.isEmptyExpression(elseExpression)) {
            return this.generateSingleBranchIf(condition, expression, thenExpression, true, isStatement);
        }
        return StackValue.operation(asmType, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                Label elseLabel = new Label();
                BranchedValue.Companion.condJump(condition, elseLabel, true, v);
                Label end = new Label();
                ExpressionCodegen.this.gen(thenExpression, asmType);
                v.goTo(end);
                v.mark(elseLabel);
                ExpressionCodegen.this.gen(elseExpression, asmType);
                ExpressionCodegen.this.markLineNumber(expression, isStatement);
                v.mark(end);
                return Unit.INSTANCE;
            }
        });
    }

    @Override
    public StackValue visitWhileExpression(@NotNull KtWhileExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitWhileExpression"));
        }
        Label condition = new Label();
        this.v.mark(condition);
        Label end = new Label();
        this.blockStackElements.push(new LoopBlockStackElement(end, condition, ExpressionCodegen.targetLabel(expression)));
        StackValue conditionValue = this.gen(expression.getCondition());
        BranchedValue.Companion.loopJump(conditionValue, end, true, this.v);
        this.generateLoopBody(expression.getBody());
        this.v.goTo(condition);
        this.v.mark(end);
        this.blockStackElements.pop();
        return StackValue.onStack(Type.VOID_TYPE);
    }

    @Override
    public StackValue visitDoWhileExpression(@NotNull KtDoWhileExpression expression, StackValue receiver) {
        StackValue conditionValue;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitDoWhileExpression"));
        }
        Label beginLoopLabel = new Label();
        this.v.mark(beginLoopLabel);
        Label breakLabel = new Label();
        Label continueLabel = new Label();
        this.blockStackElements.push(new LoopBlockStackElement(breakLabel, continueLabel, ExpressionCodegen.targetLabel(expression)));
        PseudoInsnsKt.fakeAlwaysFalseIfeq(this.v, continueLabel);
        KtExpression body = expression.getBody();
        KtExpression condition = expression.getCondition();
        if (body instanceof KtBlockExpression) {
            List<KtExpression> doWhileStatements = ((KtBlockExpression)body).getStatements();
            ArrayList<KtExpression> statements = new ArrayList<KtExpression>(doWhileStatements.size() + 1);
            statements.addAll(doWhileStatements);
            statements.add(condition);
            conditionValue = this.generateBlock(statements, false, continueLabel, null);
        } else {
            if (body != null) {
                this.gen(body, Type.VOID_TYPE);
            }
            this.v.mark(continueLabel);
            conditionValue = this.gen(condition);
        }
        BranchedValue.Companion.loopJump(conditionValue, beginLoopLabel, false, this.v);
        this.v.mark(breakLabel);
        this.blockStackElements.pop();
        return StackValue.none();
    }

    @Override
    public StackValue visitForExpression(@NotNull KtForExpression forExpression, StackValue receiver) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall;
        if (forExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forExpression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitForExpression"));
        }
        RangeCodegenUtil.BinaryCall binaryCall = RangeCodegenUtil.getRangeAsBinaryCall(forExpression);
        if (binaryCall != null && (resolvedCall = CallUtilKt.getResolvedCall(binaryCall.op, this.bindingContext)) != null && RangeCodegenUtil.isOptimizableRangeTo(resolvedCall.getResultingDescriptor())) {
            this.generateForLoop(new ForInRangeLiteralLoopGenerator(forExpression, binaryCall));
            return StackValue.none();
        }
        KtExpression loopRange = forExpression.getLoopRange();
        assert (loopRange != null);
        KotlinType loopRangeType = this.bindingContext.getType(loopRange);
        assert (loopRangeType != null);
        Type asmLoopRangeType = this.asmType(loopRangeType);
        if (asmLoopRangeType.getSort() == 9) {
            this.generateForLoop(new ForInArrayLoopGenerator(forExpression));
            return StackValue.none();
        }
        if (RangeCodegenUtil.isRange(loopRangeType)) {
            this.generateForLoop(new ForInRangeInstanceLoopGenerator(forExpression));
            return StackValue.none();
        }
        if (RangeCodegenUtil.isProgression(loopRangeType)) {
            this.generateForLoop(new ForInProgressionExpressionLoopGenerator(forExpression));
            return StackValue.none();
        }
        this.generateForLoop(new IteratorForLoopGenerator(forExpression));
        return StackValue.none();
    }

    private OwnerKind contextKind() {
        return this.context.getContextKind();
    }

    private void generateForLoop(AbstractForLoopGenerator generator) {
        Label loopExit = new Label();
        Label loopEntry = new Label();
        Label continueLabel = new Label();
        generator.beforeLoop();
        generator.checkEmptyLoop(loopExit);
        this.v.mark(loopEntry);
        generator.checkPreCondition(loopExit);
        PseudoInsnsKt.fakeAlwaysFalseIfeq(this.v, continueLabel);
        generator.beforeBody();
        this.blockStackElements.push(new LoopBlockStackElement(loopExit, continueLabel, ExpressionCodegen.targetLabel(generator.forExpression)));
        generator.body();
        this.blockStackElements.pop();
        this.v.mark(continueLabel);
        generator.afterBody(loopExit);
        this.v.goTo(loopEntry);
        this.v.mark(loopExit);
        generator.afterLoop();
    }

    private void generateLoopBody(@Nullable KtExpression body) {
        if (body != null) {
            this.gen(body, Type.VOID_TYPE);
        }
    }

    @Override
    public StackValue visitBreakExpression(@NotNull KtBreakExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitBreakExpression"));
        }
        return this.generateBreakOrContinueExpression(expression, true, new Label());
    }

    @Override
    public StackValue visitContinueExpression(@NotNull KtContinueExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitContinueExpression"));
        }
        return this.generateBreakOrContinueExpression(expression, false, new Label());
    }

    @NotNull
    private StackValue generateBreakOrContinueExpression(@NotNull KtExpressionWithLabel expression, boolean isBreak, final @NotNull Label afterBreakContinueLabel) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateBreakOrContinueExpression"));
        }
        if (afterBreakContinueLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterBreakContinueLabel", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateBreakOrContinueExpression"));
        }
        assert (expression instanceof KtContinueExpression || expression instanceof KtBreakExpression);
        if (!this.blockStackElements.isEmpty()) {
            BlockStackElement stackElement = this.blockStackElements.peek();
            if (stackElement instanceof FinallyBlockStackElement) {
                FinallyBlockStackElement finallyBlockStackElement = (FinallyBlockStackElement)stackElement;
                this.genFinallyBlockOrGoto(finallyBlockStackElement, null, afterBreakContinueLabel);
            } else if (stackElement instanceof LoopBlockStackElement) {
                LoopBlockStackElement loopBlockStackElement = (LoopBlockStackElement)stackElement;
                KtSimpleNameExpression labelElement = expression.getTargetLabel();
                if (labelElement == null || loopBlockStackElement.targetLabel != null && labelElement.getReferencedName().equals(loopBlockStackElement.targetLabel.getReferencedName())) {
                    final Label label = isBreak ? loopBlockStackElement.breakLabel : loopBlockStackElement.continueLabel;
                    StackValue stackValue = StackValue.operation(Type.VOID_TYPE, new Function1<InstructionAdapter, Unit>(){

                        @Override
                        public Unit invoke(InstructionAdapter adapter) {
                            PseudoInsnsKt.fixStackAndJump(ExpressionCodegen.this.v, label);
                            ExpressionCodegen.this.v.mark(afterBreakContinueLabel);
                            return Unit.INSTANCE;
                        }
                    });
                    if (stackValue == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateBreakOrContinueExpression"));
                    }
                    return stackValue;
                }
            } else {
                throw new UnsupportedOperationException("Wrong BlockStackElement in processing stack");
            }
            this.blockStackElements.pop();
            StackValue result2 = this.generateBreakOrContinueExpression(expression, isBreak, afterBreakContinueLabel);
            this.blockStackElements.push(stackElement);
            StackValue stackValue = result2;
            if (stackValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateBreakOrContinueExpression"));
            }
            return stackValue;
        }
        throw new UnsupportedOperationException("Target label for break/continue not found");
    }

    private StackValue generateSingleBranchIf(final StackValue condition, final KtIfExpression ifExpression, final KtExpression expression, final boolean inverse, final boolean isStatement) {
        Type targetType = isStatement ? Type.VOID_TYPE : this.expressionType(ifExpression);
        return StackValue.operation(targetType, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                Label elseLabel = new Label();
                BranchedValue.Companion.condJump(condition, elseLabel, inverse, v);
                if (isStatement) {
                    ExpressionCodegen.this.gen(expression, Type.VOID_TYPE);
                    v.mark(elseLabel);
                } else {
                    Type targetType = ExpressionCodegen.this.expressionType(ifExpression);
                    ExpressionCodegen.this.gen(expression, targetType);
                    Label end = new Label();
                    v.goTo(end);
                    v.mark(elseLabel);
                    StackValue.putUnitInstance(v);
                    ExpressionCodegen.this.markStartLineNumber(ifExpression);
                    v.mark(end);
                }
                return null;
            }
        });
    }

    @Override
    public StackValue visitConstantExpression(@NotNull KtConstantExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitConstantExpression"));
        }
        ConstantValue<?> compileTimeValue = ExpressionCodegen.getCompileTimeConstant(expression, this.bindingContext);
        assert (compileTimeValue != null);
        return StackValue.constant(compileTimeValue.getValue(), this.expressionType(expression));
    }

    @Nullable
    public static ConstantValue<?> getCompileTimeConstant(@NotNull KtExpression expression, @NotNull BindingContext bindingContext) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getCompileTimeConstant"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getCompileTimeConstant"));
        }
        CompileTimeConstant<?> compileTimeValue = ConstantExpressionEvaluator.getConstant(expression, bindingContext);
        if (compileTimeValue == null) {
            return null;
        }
        KotlinType expectedType = bindingContext.getType(expression);
        return compileTimeValue.toConstantValue(expectedType);
    }

    @Override
    public StackValue visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitStringTemplateExpression"));
        }
        StringBuilder constantValue = new StringBuilder("");
        final KtStringTemplateEntry[] entries = expression.getEntries();
        if (entries.length == 1 && entries[0] instanceof KtStringTemplateEntryWithExpression) {
            KtExpression expr = entries[0].getExpression();
            return AsmUtil.genToString(this.gen(expr), this.expressionType(expr));
        }
        for (KtStringTemplateEntry entry : entries) {
            if (entry instanceof KtLiteralStringTemplateEntry) {
                constantValue.append(entry.getText());
                continue;
            }
            if (entry instanceof KtEscapeStringTemplateEntry) {
                constantValue.append(((KtEscapeStringTemplateEntry)entry).getUnescapedValue());
                continue;
            }
            constantValue = null;
            break;
        }
        if (constantValue != null) {
            Type type2 = this.expressionType(expression);
            return StackValue.constant(constantValue.toString(), type2);
        }
        return StackValue.operation(AsmTypes.JAVA_STRING_TYPE, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                AsmUtil.genStringBuilderConstructor(v);
                for (KtStringTemplateEntry entry : entries) {
                    if (entry instanceof KtStringTemplateEntryWithExpression) {
                        ExpressionCodegen.this.invokeAppend(entry.getExpression());
                        continue;
                    }
                    String text = entry instanceof KtEscapeStringTemplateEntry ? ((KtEscapeStringTemplateEntry)entry).getUnescapedValue() : entry.getText();
                    v.aconst(text);
                    AsmUtil.genInvokeAppendMethod(v, AsmTypes.JAVA_STRING_TYPE);
                }
                v.invokevirtual("java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
                return Unit.INSTANCE;
            }
        });
    }

    @Override
    public StackValue visitBlockExpression(@NotNull KtBlockExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitBlockExpression"));
        }
        return this.generateBlock(expression, false);
    }

    @Override
    public StackValue visitNamedFunction(@NotNull KtNamedFunction function, StackValue data) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitNamedFunction"));
        }
        return this.visitNamedFunction(function, data, false);
    }

    public StackValue visitNamedFunction(@NotNull KtNamedFunction function, StackValue data, boolean isStatement) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitNamedFunction"));
        }
        assert (data == StackValue.none());
        if (KtPsiUtil.isScriptDeclaration(function)) {
            return StackValue.none();
        }
        StackValue closure = this.genClosure(function, null);
        if (isStatement) {
            DeclarationDescriptor descriptor2 = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function);
            int index2 = this.lookupLocalIndex(descriptor2);
            closure.put(AsmTypes.OBJECT_TYPE, this.v);
            this.v.store(index2, AsmTypes.OBJECT_TYPE);
            return StackValue.none();
        }
        return closure;
    }

    @Override
    public StackValue visitLambdaExpression(@NotNull KtLambdaExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitLambdaExpression"));
        }
        if (Boolean.TRUE.equals(this.bindingContext.get(BindingContext.BLOCK, expression))) {
            return this.gen(expression.getFunctionLiteral().getBodyExpression());
        }
        return this.genClosure(expression.getFunctionLiteral(), null);
    }

    @NotNull
    private StackValue genClosure(KtDeclarationWithBody declaration, @Nullable SamType samType) {
        FunctionDescriptor descriptor2 = this.bindingContext.get(BindingContext.FUNCTION, declaration);
        assert (descriptor2 != null) : "Function is not resolved to descriptor: " + declaration.getText();
        StackValue stackValue = this.genClosure(declaration, descriptor2, new FunctionGenerationStrategy.FunctionDefault(this.state, descriptor2, declaration), samType, null);
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genClosure"));
        }
        return stackValue;
    }

    @NotNull
    private StackValue genClosure(@NotNull KtElement declaration, @NotNull FunctionDescriptor descriptor2, @NotNull FunctionGenerationStrategy strategy, @Nullable SamType samType, @Nullable FunctionDescriptor functionReferenceTarget) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genClosure"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genClosure"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genClosure"));
        }
        ClassBuilder cv = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(declaration, descriptor2), CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, descriptor2), declaration.getContainingFile());
        ClosureCodegen closureCodegen = new ClosureCodegen(this.state, declaration, samType, this.context.intoClosure(descriptor2, this, this.typeMapper), functionReferenceTarget, strategy, this.parentCodegen, cv);
        closureCodegen.generate();
        if (closureCodegen.getReifiedTypeParametersUsages().wereUsedReifiedParameters()) {
            ReifiedTypeInliner.putNeedClassReificationMarker(this.v);
            this.propagateChildReifiedTypeParametersUsages(closureCodegen.getReifiedTypeParametersUsages());
        }
        StackValue stackValue = closureCodegen.putInstanceOnStack(this);
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genClosure"));
        }
        return stackValue;
    }

    @Override
    public StackValue visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitObjectLiteralExpression"));
        }
        final ObjectLiteralResult objectLiteralResult = this.generateObjectLiteral(expression);
        final ClassDescriptor classDescriptor = objectLiteralResult.classDescriptor;
        final Type type2 = this.typeMapper.mapType(classDescriptor);
        return StackValue.operation(type2, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                if (objectLiteralResult.wereReifiedMarkers) {
                    ReifiedTypeInliner.putNeedClassReificationMarker(v);
                }
                v.anew(type2);
                v.dup();
                ExpressionCodegen.this.pushClosureOnStack(classDescriptor, true, ExpressionCodegen.this.defaultCallGenerator);
                ConstructorDescriptor primaryConstructor2 = classDescriptor.getUnsubstitutedPrimaryConstructor();
                assert (primaryConstructor2 != null) : "There should be primary constructor for object literal";
                ResolvedCall<ConstructorDescriptor> superCall = BindingContextUtils.getDelegationConstructorCall(ExpressionCodegen.this.bindingContext, primaryConstructor2);
                if (superCall != null) {
                    ConstructorDescriptor superConstructor = superCall.getResultingDescriptor();
                    ConstructorDescriptor constructorToCall = SamCodegenUtil.resolveSamAdapter(superConstructor);
                    List<ValueParameterDescriptor> superValueParameters = superConstructor.getValueParameters();
                    int params = superValueParameters.size();
                    List<Type> superMappedTypes = ExpressionCodegen.this.typeMapper.mapToCallableMethod(constructorToCall, false).getValueParameterTypes();
                    assert (superMappedTypes.size() >= params) : String.format("Incorrect number of mapped parameters vs arguments: %d < %d for %s", superMappedTypes.size(), params, classDescriptor);
                    ArrayList<ResolvedValueArgument> valueArguments2 = new ArrayList<ResolvedValueArgument>(params);
                    ArrayList<ValueParameterDescriptor> valueParameters = new ArrayList<ValueParameterDescriptor>(params);
                    ArrayList<Type> mappedTypes = new ArrayList<Type>(params);
                    for (ValueParameterDescriptor parameter : superValueParameters) {
                        ResolvedValueArgument argument = superCall.getValueArguments().get(parameter);
                        if (argument instanceof DefaultValueArgument) continue;
                        valueArguments2.add(argument);
                        valueParameters.add(parameter);
                        mappedTypes.add(superMappedTypes.get(parameter.getIndex()));
                    }
                    CallBasedArgumentGenerator argumentGenerator = new CallBasedArgumentGenerator(ExpressionCodegen.this, ExpressionCodegen.this.defaultCallGenerator, valueParameters, mappedTypes);
                    ((ArgumentGenerator)argumentGenerator).generate(valueArguments2, valueArguments2);
                }
                Collection<ConstructorDescriptor> constructors2 = classDescriptor.getConstructors();
                assert (constructors2.size() == 1) : "Unexpected number of constructors for class: " + classDescriptor + " " + constructors2;
                ConstructorDescriptor constructorDescriptor = CollectionsKt.single(constructors2);
                JvmMethodSignature constructor = ExpressionCodegen.this.typeMapper.mapSignature(SamCodegenUtil.resolveSamAdapter(constructorDescriptor));
                v.invokespecial(type2.getInternalName(), "<init>", constructor.getAsmMethod().getDescriptor(), false);
                return Unit.INSTANCE;
            }
        });
    }

    public void pushClosureOnStack(@NotNull ClassDescriptor classDescriptor, boolean putThis, @NotNull CallGenerator callGenerator) {
        KotlinType captureReceiver;
        ClassDescriptor captureThis;
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "pushClosureOnStack"));
        }
        if (callGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callGenerator", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "pushClosureOnStack"));
        }
        CalculatedClosure closure = this.bindingContext.get(CodegenBinding.CLOSURE, classDescriptor);
        if (closure == null) {
            return;
        }
        int paramIndex = 0;
        if (putThis && (captureThis = closure.getCaptureThis()) != null) {
            StackValue thisOrOuter = this.generateThisOrOuter(captureThis, false);
            assert (!AsmUtil.isPrimitive(thisOrOuter.type)) : "This or outer should be non primitive: " + thisOrOuter.type;
            callGenerator.putCapturedValueOnStack(thisOrOuter, thisOrOuter.type, paramIndex++);
        }
        if ((captureReceiver = closure.getCaptureReceiverType()) != null) {
            Type asmType = this.typeMapper.mapType(captureReceiver);
            StackValue.Local capturedReceiver = StackValue.local(AsmUtil.getReceiverIndex(this.context, (CallableMemberDescriptor)this.context.getContextDescriptor()), asmType);
            callGenerator.putCapturedValueOnStack(capturedReceiver, capturedReceiver.type, paramIndex++);
        }
        for (Map.Entry<DeclarationDescriptor, EnclosedValueDescriptor> entry : closure.getCaptureVariables().entrySet()) {
            Type sharedVarType = this.typeMapper.getSharedVarType(entry.getKey());
            if (sharedVarType == null) {
                sharedVarType = this.typeMapper.mapType((VariableDescriptor)entry.getKey());
            }
            StackValue capturedVar = this.lookupOuterValue(entry.getValue());
            callGenerator.putCapturedValueOnStack(capturedVar, sharedVarType, paramIndex++);
        }
        ClassDescriptor superClass = DescriptorUtilsKt.getSuperClassNotAny(classDescriptor);
        if (superClass != null) {
            this.pushClosureOnStack(superClass, putThis && closure.getCaptureThis() == null, callGenerator);
        }
    }

    StackValue generateBlock(@NotNull KtBlockExpression expression, boolean isStatement) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateBlock"));
        }
        if (expression.getParent() instanceof KtNamedFunction) {
            return this.generateBlock(expression.getStatements(), isStatement, null, this.context.getMethodEndLabel());
        }
        return this.generateBlock(expression.getStatements(), isStatement, null, null);
    }

    @NotNull
    public StackValue lookupOuterValue(EnclosedValueDescriptor d) {
        DeclarationDescriptor descriptor2 = d.getDescriptor();
        for (LocalLookup.LocalLookupCase aCase : LocalLookup.LocalLookupCase.values()) {
            if (!aCase.isCase(descriptor2)) continue;
            StackValue stackValue = aCase.outerValue(d, this);
            if (stackValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lookupOuterValue"));
            }
            return stackValue;
        }
        throw new IllegalStateException("Can't get outer value in " + this + " for " + d);
    }

    private StackValue generateBlock(List<KtExpression> statements, boolean isStatement, Label labelBeforeLastExpression, final @Nullable Label labelBlockEnd) {
        final Label blockEnd = labelBlockEnd != null ? labelBlockEnd : new Label();
        final ArrayList<Function<StackValue, Void>> leaveTasks = Lists.newArrayList();
        StackValue answer = StackValue.none();
        Iterator<KtExpression> iterator2 = statements.iterator();
        while (iterator2.hasNext()) {
            StackValue result2;
            boolean isExpression;
            KtNamedDeclaration declaration;
            KtExpression possiblyLabeledStatement = iterator2.next();
            KtExpression statement = KtPsiUtil.safeDeparenthesize(possiblyLabeledStatement);
            if (statement instanceof KtNamedDeclaration && KtPsiUtil.isScriptDeclaration(declaration = (KtNamedDeclaration)statement)) continue;
            this.putDescriptorIntoFrameMap(statement);
            boolean bl = isExpression = !iterator2.hasNext() && !isStatement;
            if (isExpression && labelBeforeLastExpression != null) {
                this.v.mark(labelBeforeLastExpression);
            }
            StackValue stackValue = result2 = isExpression ? this.gen(possiblyLabeledStatement) : this.genStatement(possiblyLabeledStatement);
            if (!iterator2.hasNext()) {
                answer = result2;
            } else {
                result2.put(Type.VOID_TYPE, this.v);
            }
            this.addLeaveTaskToRemoveDescriptorFromFrameMap(statement, blockEnd, leaveTasks);
        }
        return new StackValueWithLeaveTask(answer, (Function1<? super StackValue, Unit>)new Function1<StackValue, Unit>(){

            @Override
            public Unit invoke(StackValue value) {
                if (labelBlockEnd == null) {
                    ExpressionCodegen.this.v.mark(blockEnd);
                }
                for (Function task : Lists.reverse(leaveTasks)) {
                    task.fun(value);
                }
                return Unit.INSTANCE;
            }
        });
    }

    @NotNull
    private Type getVariableType(@NotNull VariableDescriptor variableDescriptor) {
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getVariableType"));
        }
        Type sharedVarType = this.typeMapper.getSharedVarType(variableDescriptor);
        Type type2 = sharedVarType != null ? sharedVarType : this.asmType(variableDescriptor.getType());
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getVariableType"));
        }
        return type2;
    }

    private static boolean isSharedVarType(@NotNull Type type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "isSharedVarType"));
        }
        return type2.getSort() == 10 && type2.getInternalName().startsWith("kotlin/jvm/internal/Ref$");
    }

    private void putDescriptorIntoFrameMap(@NotNull KtElement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putDescriptorIntoFrameMap"));
        }
        if (statement instanceof KtDestructuringDeclaration) {
            KtDestructuringDeclaration multiDeclaration = (KtDestructuringDeclaration)statement;
            for (KtDestructuringDeclarationEntry entry : multiDeclaration.getEntries()) {
                this.putLocalVariableIntoFrameMap(entry);
            }
        }
        if (statement instanceof KtVariableDeclaration) {
            this.putLocalVariableIntoFrameMap((KtVariableDeclaration)statement);
        }
        if (statement instanceof KtNamedFunction) {
            DeclarationDescriptor descriptor2 = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, statement);
            assert (descriptor2 instanceof FunctionDescriptor) : "Couldn't find function declaration in binding context " + statement.getText();
            Type type2 = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)descriptor2);
            this.myFrameMap.enter(descriptor2, type2);
        }
    }

    private void putLocalVariableIntoFrameMap(@NotNull KtVariableDeclaration statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putLocalVariableIntoFrameMap"));
        }
        VariableDescriptor variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, statement);
        assert (variableDescriptor != null) : "Couldn't find variable declaration in binding context " + statement.getText();
        Type type2 = this.getVariableType(variableDescriptor);
        int index2 = this.myFrameMap.enter(variableDescriptor, type2);
        if (ExpressionCodegen.isSharedVarType(type2)) {
            this.markLineNumber(statement, false);
            this.v.anew(type2);
            this.v.dup();
            this.v.invokespecial(type2.getInternalName(), "<init>", "()V", false);
            this.v.store(index2, AsmTypes.OBJECT_TYPE);
        }
    }

    private void addLeaveTaskToRemoveDescriptorFromFrameMap(@NotNull KtElement statement, @NotNull Label blockEnd, @NotNull List<Function<StackValue, Void>> leaveTasks) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "addLeaveTaskToRemoveDescriptorFromFrameMap"));
        }
        if (blockEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockEnd", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "addLeaveTaskToRemoveDescriptorFromFrameMap"));
        }
        if (leaveTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leaveTasks", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "addLeaveTaskToRemoveDescriptorFromFrameMap"));
        }
        if (statement instanceof KtDestructuringDeclaration) {
            KtDestructuringDeclaration multiDeclaration = (KtDestructuringDeclaration)statement;
            for (KtDestructuringDeclarationEntry entry : multiDeclaration.getEntries()) {
                this.addLeaveTaskToRemoveLocalVariableFromFrameMap(entry, blockEnd, leaveTasks);
            }
        }
        if (statement instanceof KtVariableDeclaration) {
            this.addLeaveTaskToRemoveLocalVariableFromFrameMap((KtVariableDeclaration)statement, blockEnd, leaveTasks);
        }
        if (statement instanceof KtNamedFunction) {
            this.addLeaveTaskToRemoveNamedFunctionFromFrameMap((KtNamedFunction)statement, blockEnd, leaveTasks);
        }
    }

    private void addLeaveTaskToRemoveLocalVariableFromFrameMap(@NotNull KtVariableDeclaration statement, final Label blockEnd, @NotNull List<Function<StackValue, Void>> leaveTasks) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "addLeaveTaskToRemoveLocalVariableFromFrameMap"));
        }
        if (leaveTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leaveTasks", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "addLeaveTaskToRemoveLocalVariableFromFrameMap"));
        }
        final VariableDescriptor variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, statement);
        assert (variableDescriptor != null);
        final Type type2 = this.getVariableType(variableDescriptor);
        final Label scopeStart = new Label();
        this.v.mark(scopeStart);
        leaveTasks.add(new Function<StackValue, Void>(){

            @Override
            public Void fun(StackValue answer) {
                int index2 = ExpressionCodegen.this.myFrameMap.leave(variableDescriptor);
                if (ExpressionCodegen.isSharedVarType(type2)) {
                    ExpressionCodegen.this.v.aconst(null);
                    ExpressionCodegen.this.v.store(index2, AsmTypes.OBJECT_TYPE);
                }
                ExpressionCodegen.this.v.visitLocalVariable(variableDescriptor.getName().asString(), type2.getDescriptor(), null, scopeStart, blockEnd, index2);
                return null;
            }
        });
    }

    private void addLeaveTaskToRemoveNamedFunctionFromFrameMap(final @NotNull KtNamedFunction statement, final Label blockEnd, @NotNull List<Function<StackValue, Void>> leaveTasks) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "addLeaveTaskToRemoveNamedFunctionFromFrameMap"));
        }
        if (leaveTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leaveTasks", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "addLeaveTaskToRemoveNamedFunctionFromFrameMap"));
        }
        final FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, statement);
        assert (functionDescriptor != null);
        final Type type2 = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, functionDescriptor);
        final Label scopeStart = new Label();
        this.v.mark(scopeStart);
        leaveTasks.add(new Function<StackValue, Void>(){

            @Override
            public Void fun(StackValue answer) {
                int index2 = ExpressionCodegen.this.myFrameMap.leave(functionDescriptor);
                assert (!functionDescriptor.getName().isSpecial()) : "Local variable should be generated only for function with name: " + statement.getText();
                ExpressionCodegen.this.v.visitLocalVariable(functionDescriptor.getName().asString() + "$", type2.getDescriptor(), null, scopeStart, blockEnd, index2);
                return null;
            }
        });
    }

    public boolean isShouldMarkLineNumbers() {
        return this.shouldMarkLineNumbers;
    }

    public void setShouldMarkLineNumbers(boolean shouldMarkLineNumbers) {
        this.shouldMarkLineNumbers = shouldMarkLineNumbers;
    }

    public void markStartLineNumber(@NotNull KtElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "markStartLineNumber"));
        }
        this.markLineNumber(element, false);
    }

    public void markLineNumber(@NotNull KtElement statement, boolean markEndOffset) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "markLineNumber"));
        }
        if (!this.shouldMarkLineNumbers) {
            return;
        }
        Integer lineNumber = CodegenUtil.getLineNumberForElement(statement, markEndOffset);
        if (lineNumber == null || lineNumber == this.myLastLineNumber) {
            return;
        }
        this.myLastLineNumber = lineNumber;
        Label label = new Label();
        this.v.visitLabel(label);
        this.v.visitLineNumber(lineNumber, label);
    }

    public void markLineNumberAfterInlineIfNeeded() {
        if (!this.shouldMarkLineNumbers) {
            if (this.myLastLineNumber > -1) {
                Label label = new Label();
                this.v.visitLabel(label);
                this.v.visitLineNumber(this.myLastLineNumber, label);
            }
        } else {
            this.myLastLineNumber = -1;
        }
    }

    private void doFinallyOnReturn(@NotNull Label afterReturnLabel) {
        if (afterReturnLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterReturnLabel", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "doFinallyOnReturn"));
        }
        if (!this.blockStackElements.isEmpty()) {
            BlockStackElement stackElement = this.blockStackElements.peek();
            if (stackElement instanceof FinallyBlockStackElement) {
                FinallyBlockStackElement finallyBlockStackElement = (FinallyBlockStackElement)stackElement;
                this.genFinallyBlockOrGoto(finallyBlockStackElement, null, afterReturnLabel);
            } else if (!(stackElement instanceof LoopBlockStackElement)) {
                throw new UnsupportedOperationException("Wrong BlockStackElement in processing stack");
            }
            this.blockStackElements.pop();
            this.doFinallyOnReturn(afterReturnLabel);
            this.blockStackElements.push(stackElement);
        }
    }

    public boolean hasFinallyBlocks() {
        for (BlockStackElement element : this.blockStackElements) {
            if (!(element instanceof FinallyBlockStackElement)) continue;
            return true;
        }
        return false;
    }

    private void genFinallyBlockOrGoto(@Nullable FinallyBlockStackElement finallyBlockStackElement, @Nullable Label tryCatchBlockEnd, @Nullable Label afterJumpLabel) {
        if (finallyBlockStackElement != null) {
            ++this.finallyDepth;
            assert (finallyBlockStackElement.gaps.size() % 2 == 0) : "Finally block gaps are inconsistent";
            BlockStackElement topOfStack = this.blockStackElements.pop();
            assert (topOfStack == finallyBlockStackElement) : "Top element of stack doesn't equals processing finally block";
            KtTryExpression jetTryExpression = finallyBlockStackElement.expression;
            Label finallyStart = new Label();
            this.v.mark(finallyStart);
            finallyBlockStackElement.addGapLabel(finallyStart);
            if (InlineCodegenUtil.isFinallyMarkerRequired(this.context)) {
                InlineCodegenUtil.generateFinallyMarker(this.v, this.finallyDepth, true);
            }
            this.gen(jetTryExpression.getFinallyBlock().getFinalExpression(), Type.VOID_TYPE);
            if (InlineCodegenUtil.isFinallyMarkerRequired(this.context)) {
                InlineCodegenUtil.generateFinallyMarker(this.v, this.finallyDepth, false);
            }
        }
        if (tryCatchBlockEnd != null) {
            this.v.goTo(tryCatchBlockEnd);
        }
        if (finallyBlockStackElement != null) {
            Label finallyEnd;
            --this.finallyDepth;
            Label label = finallyEnd = afterJumpLabel != null ? afterJumpLabel : new Label();
            if (afterJumpLabel == null) {
                this.v.mark(finallyEnd);
            }
            finallyBlockStackElement.addGapLabel(finallyEnd);
            this.blockStackElements.push(finallyBlockStackElement);
        }
    }

    @Override
    public StackValue visitReturnExpression(final @NotNull KtReturnExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitReturnExpression"));
        }
        return StackValue.operation(Type.VOID_TYPE, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter adapter) {
                Type returnType2;
                boolean isNonLocalReturn;
                KtExpression returnedExpression = expression.getReturnedExpression();
                CallableMemberDescriptor descriptor2 = (CallableMemberDescriptor)ExpressionCodegen.this.getContext().getContextDescriptor();
                NonLocalReturnInfo nonLocalReturn = ExpressionCodegen.this.getNonLocalReturnInfo(descriptor2, expression);
                boolean bl = isNonLocalReturn = nonLocalReturn != null;
                if (isNonLocalReturn && !ExpressionCodegen.this.state.isInlineEnabled()) {
                    ExpressionCodegen.this.state.getDiagnostics().report(Errors.NON_LOCAL_RETURN_IN_DISABLED_INLINE.on(expression));
                    AsmUtil.genThrow(ExpressionCodegen.this.v, "java/lang/UnsupportedOperationException", "Non-local returns are not allowed with inlining disabled");
                    return Unit.INSTANCE;
                }
                Type type2 = returnType2 = isNonLocalReturn ? nonLocalReturn.returnType : ExpressionCodegen.this.returnType;
                if (returnedExpression != null) {
                    ExpressionCodegen.this.gen(returnedExpression, returnType2);
                }
                Label afterReturnLabel = new Label();
                ExpressionCodegen.this.generateFinallyBlocksIfNeeded(returnType2, afterReturnLabel);
                if (isNonLocalReturn) {
                    InlineCodegenUtil.generateGlobalReturnFlag(ExpressionCodegen.this.v, nonLocalReturn.labelName);
                }
                ExpressionCodegen.this.v.visitInsn(returnType2.getOpcode(172));
                ExpressionCodegen.this.v.mark(afterReturnLabel);
                return Unit.INSTANCE;
            }
        });
    }

    public void generateFinallyBlocksIfNeeded(Type returnType2, @NotNull Label afterReturnLabel) {
        if (afterReturnLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterReturnLabel", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateFinallyBlocksIfNeeded"));
        }
        if (this.hasFinallyBlocks()) {
            if (!Type.VOID_TYPE.equals(returnType2)) {
                int returnValIndex = this.myFrameMap.enterTemp(returnType2);
                StackValue.Local localForReturnValue = StackValue.local(returnValIndex, returnType2);
                localForReturnValue.store(StackValue.onStack(returnType2), this.v);
                this.doFinallyOnReturn(afterReturnLabel);
                localForReturnValue.put(returnType2, this.v);
                this.myFrameMap.leaveTemp(returnType2);
            } else {
                this.doFinallyOnReturn(afterReturnLabel);
            }
        }
    }

    @Nullable
    private NonLocalReturnInfo getNonLocalReturnInfo(@NotNull CallableMemberDescriptor descriptor2, @NotNull KtReturnExpression expression) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getNonLocalReturnInfo"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getNonLocalReturnInfo"));
        }
        if (ExpressionTypingUtils.isFunctionLiteral(descriptor2) || ExpressionTypingUtils.isFunctionExpression(descriptor2)) {
            if (expression.getLabelName() == null) {
                if (ExpressionTypingUtils.isFunctionLiteral(descriptor2)) {
                    FunctionDescriptor containingFunction = BindingContextUtils.getContainingFunctionSkipFunctionLiterals(descriptor2, true).getFirst();
                    return new NonLocalReturnInfo(this.typeMapper.mapReturnType(containingFunction), "$$$$$ROOT$$$$$");
                }
                return null;
            }
            PsiElement element = this.bindingContext.get(BindingContext.LABEL_TARGET, expression.getTargetLabel());
            if (element != DescriptorToSourceUtils.getSourceFromDescriptor(this.context.getContextDescriptor())) {
                DeclarationDescriptor elementDescriptor = this.typeMapper.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
                assert (element != null) : "Expression should be not null " + expression.getText();
                assert (elementDescriptor != null) : "Descriptor should be not null: " + element.getText();
                return new NonLocalReturnInfo(this.typeMapper.mapReturnType((CallableDescriptor)elementDescriptor), expression.getLabelName());
            }
        }
        return null;
    }

    public void returnExpression(KtExpression expr) {
        boolean isBlockedNamedFunction = expr instanceof KtBlockExpression && expr.getParent() instanceof KtNamedFunction;
        this.gen(expr, isBlockedNamedFunction ? Type.VOID_TYPE : this.returnType);
        if (!ExpressionCodegen.endsWithReturn(expr)) {
            this.markLineNumber(expr, true);
            if (ExpressionCodegen.isLambdaVoidBody(expr, this.returnType)) {
                this.markLineNumber((KtFunctionLiteral)expr.getParent(), true);
            }
            if (isBlockedNamedFunction && !Type.VOID_TYPE.equals(this.expressionType(expr))) {
                StackValue.none().put(this.returnType, this.v);
            }
            this.v.areturn(this.returnType);
        }
    }

    private static boolean endsWithReturn(KtElement bodyExpression) {
        if (bodyExpression instanceof KtBlockExpression) {
            List<KtExpression> statements = ((KtBlockExpression)bodyExpression).getStatements();
            return statements.size() > 0 && statements.get(statements.size() - 1) instanceof KtReturnExpression;
        }
        return bodyExpression instanceof KtReturnExpression;
    }

    private static boolean isLambdaVoidBody(KtElement bodyExpression, Type returnType2) {
        PsiElement parent2;
        if (bodyExpression instanceof KtBlockExpression && (parent2 = bodyExpression.getParent()) instanceof KtFunctionLiteral) {
            return Type.VOID_TYPE.equals(returnType2);
        }
        return false;
    }

    @Override
    public StackValue visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression, @NotNull StackValue receiver) {
        DeclarationDescriptor descriptor2;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitSimpleNameExpression"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitSimpleNameExpression"));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(expression, this.bindingContext);
        if (resolvedCall == null) {
            descriptor2 = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression);
        } else {
            if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
                VariableAsFunctionResolvedCall call = (VariableAsFunctionResolvedCall)((Object)resolvedCall);
                resolvedCall = call.getVariableCall();
            }
            receiver = StackValue.receiver(resolvedCall, receiver, this, null);
            descriptor2 = resolvedCall.getResultingDescriptor();
            if (descriptor2 instanceof FakeCallableDescriptorForObject) {
                descriptor2 = ((FakeCallableDescriptorForObject)descriptor2).getReferencedDescriptor();
            }
        }
        assert (descriptor2 != null) : "Couldn't find descriptor for '" + expression.getText() + "'";
        boolean isSyntheticField = (descriptor2 = descriptor2.getOriginal()) instanceof SyntheticFieldDescriptor;
        if (isSyntheticField) {
            descriptor2 = ((SyntheticFieldDescriptor)descriptor2).getPropertyDescriptor();
        }
        if (descriptor2 instanceof CallableMemberDescriptor) {
            Type returnType2;
            StackValue intrinsicResult;
            CallableMemberDescriptor memberDescriptor = DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)descriptor2);
            IntrinsicMethod intrinsic = this.state.getIntrinsics().getIntrinsic(memberDescriptor);
            if (intrinsic instanceof IntrinsicPropertyGetter && (intrinsicResult = ((IntrinsicPropertyGetter)intrinsic).generate(resolvedCall, this, returnType2 = this.typeMapper.mapType(memberDescriptor), receiver)) != null) {
                return intrinsicResult;
            }
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            ClassDescriptor superCallTarget;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
            Collection codegenExtensions = ExpressionCodegenExtension.Companion.getInstances(this.state.getProject());
            if (!codegenExtensions.isEmpty() && resolvedCall != null) {
                ExpressionCodegenExtension.Context context = new ExpressionCodegenExtension.Context(this.typeMapper, this.v);
                KotlinType returnType3 = propertyDescriptor.getReturnType();
                for (ExpressionCodegenExtension extension : codegenExtensions) {
                    StackValue value;
                    if (returnType3 == null || (value = extension.applyProperty(receiver, resolvedCall, context)) == null) continue;
                    return value;
                }
            }
            boolean directToField = isSyntheticField && this.contextKind() != OwnerKind.DEFAULT_IMPLS;
            ClassDescriptor classDescriptor = superCallTarget = resolvedCall == null ? null : this.getSuperCallTarget(resolvedCall.getCall());
            if (directToField) {
                receiver = StackValue.receiverWithoutReceiverArgument(receiver);
            }
            return this.intermediateValueForProperty(propertyDescriptor, directToField, directToField, superCallTarget, false, receiver);
        }
        if (descriptor2 instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)descriptor2;
            if (DescriptorUtils.isObject(classDescriptor)) {
                return StackValue.singleton(classDescriptor, this.typeMapper);
            }
            if (DescriptorUtils.isEnumEntry(classDescriptor)) {
                return StackValue.enumEntry(classDescriptor, this.typeMapper);
            }
            ClassDescriptor companionObjectDescriptor2 = classDescriptor.getCompanionObjectDescriptor();
            if (companionObjectDescriptor2 != null) {
                return StackValue.singleton(companionObjectDescriptor2, this.typeMapper);
            }
            return StackValue.none();
        }
        StackValue localOrCaptured = this.findLocalOrCapturedValue(descriptor2);
        if (localOrCaptured != null) {
            return localOrCaptured;
        }
        throw new UnsupportedOperationException("don't know how to generate reference " + descriptor2);
    }

    @Nullable
    private ClassDescriptor getSuperCallTarget(@NotNull Call call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getSuperCallTarget"));
        }
        KtSuperExpression superExpression = CallResolverUtilKt.getSuperCallExpression(call);
        return superExpression == null ? null : ExpressionCodegen.getSuperCallLabelTarget(this.context, superExpression);
    }

    @Nullable
    public StackValue findLocalOrCapturedValue(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "findLocalOrCapturedValue"));
        }
        int index2 = this.lookupLocalIndex(descriptor2);
        if (index2 >= 0) {
            return this.stackValueForLocal(descriptor2, index2);
        }
        return this.findCapturedValue(descriptor2);
    }

    @Nullable
    public StackValue findCapturedValue(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "findCapturedValue"));
        }
        if (this.context instanceof ConstructorContext) {
            return this.lookupCapturedValueInConstructorParameters(descriptor2);
        }
        return this.context.lookupInContext(descriptor2, StackValue.LOCAL_0, this.state, false);
    }

    @Nullable
    private StackValue lookupCapturedValueInConstructorParameters(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lookupCapturedValueInConstructorParameters"));
        }
        StackValue parentResult = this.context.lookupInContext(descriptor2, StackValue.LOCAL_0, this.state, false);
        if (this.context.closure == null || parentResult == null) {
            return parentResult;
        }
        int parameterOffsetInConstructor = this.context.closure.getCapturedParameterOffsetInConstructor(descriptor2);
        if (parameterOffsetInConstructor == -1) {
            return parentResult;
        }
        assert (parentResult instanceof StackValue.Field || parentResult instanceof StackValue.FieldForSharedVar) : "Part of closure should be either Field or FieldForSharedVar";
        if (parentResult instanceof StackValue.FieldForSharedVar) {
            return StackValue.shared(parameterOffsetInConstructor, parentResult.type);
        }
        return StackValue.local(parameterOffsetInConstructor, parentResult.type);
    }

    private StackValue stackValueForLocal(DeclarationDescriptor descriptor2, int index2) {
        if (descriptor2 instanceof VariableDescriptor) {
            Type sharedVarType = this.typeMapper.getSharedVarType(descriptor2);
            KotlinType outType = ((VariableDescriptor)descriptor2).getType();
            if (sharedVarType != null) {
                return StackValue.shared(index2, this.asmType(outType));
            }
            return StackValue.local(index2, this.asmType(outType));
        }
        return StackValue.local(index2, AsmTypes.OBJECT_TYPE);
    }

    @Override
    public boolean lookupLocal(DeclarationDescriptor descriptor2) {
        return this.lookupLocalIndex(descriptor2) != -1;
    }

    public int lookupLocalIndex(DeclarationDescriptor descriptor2) {
        return this.myFrameMap.getIndex(descriptor2);
    }

    @Nullable
    private static KotlinType getPropertyDelegateType(@NotNull PropertyDescriptor descriptor2, @NotNull BindingContext bindingContext) {
        Call call;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getPropertyDelegateType"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getPropertyDelegateType"));
        }
        PropertyGetterDescriptor getter = descriptor2.getGetter();
        if (getter != null && (call = bindingContext.get(BindingContext.DELEGATED_PROPERTY_CALL, getter)) != null) {
            assert (call.getExplicitReceiver() != null) : "No explicit receiver for call:" + call;
            return ((ReceiverValue)call.getExplicitReceiver()).getType();
        }
        return null;
    }

    @NotNull
    public StackValue.Property intermediateValueForProperty(@NotNull PropertyDescriptor propertyDescriptor, boolean forceField, @Nullable ClassDescriptor superCallTarget, @NotNull StackValue receiver) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "intermediateValueForProperty"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "intermediateValueForProperty"));
        }
        StackValue.Property property = this.intermediateValueForProperty(propertyDescriptor, forceField, false, superCallTarget, false, receiver);
        if (property == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "intermediateValueForProperty"));
        }
        return property;
    }

    private CodegenContext getBackingFieldContext(@NotNull FieldAccessorKind accessorKind, @NotNull DeclarationDescriptor containingDeclaration) {
        if (accessorKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessorKind", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getBackingFieldContext"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getBackingFieldContext"));
        }
        switch (accessorKind) {
            case NORMAL: {
                return this.context.getParentContext();
            }
            case IN_CLASS_COMPANION: {
                return this.context.findParentContextWithDescriptor(containingDeclaration.getContainingDeclaration());
            }
            case FIELD_FROM_LOCAL: {
                return this.context.findParentContextWithDescriptor(containingDeclaration);
            }
        }
        throw new IllegalStateException();
    }

    public StackValue.Property intermediateValueForProperty(@NotNull PropertyDescriptor propertyDescriptor, boolean forceField, boolean syntheticBackingField, @Nullable ClassDescriptor superCallTarget, boolean skipAccessorsForPrivateFieldInOuterClass, StackValue receiver) {
        String fieldName;
        boolean skipPropertyAccessors;
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "intermediateValueForProperty"));
        }
        if (propertyDescriptor instanceof SyntheticJavaPropertyDescriptor) {
            return this.intermediateValueForSyntheticExtensionProperty((SyntheticJavaPropertyDescriptor)propertyDescriptor, receiver);
        }
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        FieldAccessorKind fieldAccessorKind = FieldAccessorKind.NORMAL;
        boolean isBackingFieldInClassCompanion = JvmAbi.isPropertyWithBackingFieldInOuterClass(propertyDescriptor);
        if (isBackingFieldInClassCompanion && (forceField || propertyDescriptor.isConst() && Visibilities.isPrivate(propertyDescriptor.getVisibility()))) {
            fieldAccessorKind = FieldAccessorKind.IN_CLASS_COMPANION;
        } else if (syntheticBackingField && this.context.getFirstCrossInlineOrNonInlineContext().getParentContext().getContextDescriptor() != containingDeclaration) {
            fieldAccessorKind = FieldAccessorKind.FIELD_FROM_LOCAL;
        }
        boolean isStaticBackingField = DescriptorUtils.isStaticDeclaration(propertyDescriptor) || AsmUtil.isInstancePropertyWithStaticBackingField(propertyDescriptor);
        boolean isSuper = superCallTarget != null;
        boolean isExtensionProperty = propertyDescriptor.getExtensionReceiverParameter() != null;
        KotlinType delegateType = ExpressionCodegen.getPropertyDelegateType(propertyDescriptor, this.bindingContext);
        boolean isDelegatedProperty = delegateType != null;
        CallableMethod callableGetter = null;
        CallableMethod callableSetter = null;
        CodegenContext backingFieldContext = this.getBackingFieldContext(fieldAccessorKind, containingDeclaration);
        DeclarationDescriptor ownerDescriptor = containingDeclaration;
        PropertyDescriptor originalPropertyDescriptor = DescriptorUtils.unwrapFakeOverride(propertyDescriptor);
        if (fieldAccessorKind != FieldAccessorKind.NORMAL) {
            int flags = AsmUtil.getVisibilityForBackingField(propertyDescriptor, isDelegatedProperty);
            boolean bl = skipPropertyAccessors = (flags & 2) == 0 || skipAccessorsForPrivateFieldInOuterClass;
            if (!skipPropertyAccessors) {
                propertyDescriptor = backingFieldContext.getAccessor(propertyDescriptor, fieldAccessorKind, delegateType, superCallTarget);
                assert (propertyDescriptor instanceof AccessorForPropertyBackingField) : "Unexpected accessor descriptor: " + propertyDescriptor;
                ownerDescriptor = propertyDescriptor;
            }
        } else {
            if (!isBackingFieldInClassCompanion) {
                ownerDescriptor = propertyDescriptor;
            }
            skipPropertyAccessors = forceField;
        }
        if (!skipPropertyAccessors) {
            PropertySetterDescriptor setter;
            if (!JvmCodegenUtil.couldUseDirectAccessToProperty(propertyDescriptor, true, isDelegatedProperty, this.context)) {
                propertyDescriptor = this.context.getAccessorForSuperCallIfNeeded(propertyDescriptor, superCallTarget);
                PropertyGetterDescriptor getter = (propertyDescriptor = this.context.accessibleDescriptor(propertyDescriptor, superCallTarget)).getGetter();
                if (getter != null && !JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(propertyDescriptor)) {
                    callableGetter = this.typeMapper.mapToCallableMethod(getter, isSuper);
                }
            }
            if (propertyDescriptor.isVar() && (setter = propertyDescriptor.getSetter()) != null && !JvmCodegenUtil.couldUseDirectAccessToProperty(propertyDescriptor, false, isDelegatedProperty, this.context) && !JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(propertyDescriptor)) {
                callableSetter = this.typeMapper.mapToCallableMethod(setter, isSuper);
            }
        }
        if (!isStaticBackingField) {
            propertyDescriptor = DescriptorUtils.unwrapFakeOverride(propertyDescriptor);
        }
        Type backingFieldOwner = this.typeMapper.mapOwner(ownerDescriptor);
        if (isExtensionProperty && !isDelegatedProperty) {
            fieldName = null;
        } else if (originalPropertyDescriptor.getContainingDeclaration() == backingFieldContext.getContextDescriptor()) {
            assert (backingFieldContext instanceof FieldOwnerContext) : "Actual context is " + backingFieldContext + " but should be instance of FieldOwnerContext";
            fieldName = ((FieldOwnerContext)backingFieldContext).getFieldName(propertyDescriptor, isDelegatedProperty);
        } else {
            fieldName = JetTypeMapper.mapDefaultFieldName(propertyDescriptor, isDelegatedProperty);
        }
        return StackValue.property(propertyDescriptor, backingFieldOwner, this.typeMapper.mapType(isDelegatedProperty && forceField ? delegateType : propertyDescriptor.getOriginal().getType()), isStaticBackingField, fieldName, callableGetter, callableSetter, this.state, receiver);
    }

    @NotNull
    private StackValue.Property intermediateValueForSyntheticExtensionProperty(@NotNull SyntheticJavaPropertyDescriptor propertyDescriptor, StackValue receiver) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "intermediateValueForSyntheticExtensionProperty"));
        }
        Type type2 = this.typeMapper.mapType(propertyDescriptor.getOriginal().getType());
        CallableMethod callableGetter = this.typeMapper.mapToCallableMethod(this.context.accessibleDescriptor(propertyDescriptor.getGetMethod(), null), false);
        FunctionDescriptor setMethod = propertyDescriptor.getSetMethod();
        CallableMethod callableSetter = setMethod != null ? this.typeMapper.mapToCallableMethod(this.context.accessibleDescriptor(setMethod, null), false) : null;
        StackValue.Property property = StackValue.property(propertyDescriptor, null, type2, false, null, callableGetter, callableSetter, this.state, receiver);
        if (property == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "intermediateValueForSyntheticExtensionProperty"));
        }
        return property;
    }

    @Override
    public StackValue visitCallExpression(@NotNull KtCallExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitCallExpression"));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCallWithAssert(expression, this.bindingContext);
        FunctionDescriptor descriptor2 = this.accessibleFunctionDescriptor(resolvedCall);
        if (descriptor2 instanceof ConstructorDescriptor) {
            return this.generateNewCall(expression, resolvedCall);
        }
        if (descriptor2.getOriginal() instanceof SamConstructorDescriptor) {
            KtExpression argumentExpression = this.bindingContext.get(CodegenBinding.SAM_CONSTRUCTOR_TO_ARGUMENT, expression);
            assert (argumentExpression != null) : "Argument expression is not saved for a SAM constructor: " + descriptor2;
            return this.genSamInterfaceValue(argumentExpression, this);
        }
        return this.invokeFunction(resolvedCall, receiver);
    }

    @Nullable
    private StackValue genSamInterfaceValue(@NotNull KtExpression probablyParenthesizedExpression, final @NotNull KtVisitor<StackValue, StackValue> visitor2) {
        if (probablyParenthesizedExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "probablyParenthesizedExpression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genSamInterfaceValue"));
        }
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genSamInterfaceValue"));
        }
        final KtExpression expression = KtPsiUtil.deparenthesize(probablyParenthesizedExpression);
        final SamType samType = this.bindingContext.get(CodegenBinding.SAM_VALUE, probablyParenthesizedExpression);
        if (samType == null || expression == null) {
            return null;
        }
        if (expression instanceof KtLambdaExpression) {
            return this.genClosure(((KtLambdaExpression)expression).getFunctionLiteral(), samType);
        }
        if (expression instanceof KtNamedFunction) {
            return this.genClosure((KtNamedFunction)expression, samType);
        }
        final Type asmType = this.state.getSamWrapperClasses().getSamWrapperClass(samType, expression.getContainingKtFile(), this.getParentCodegen());
        return StackValue.operation(asmType, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                v.anew(asmType);
                v.dup();
                Type functionType = ExpressionCodegen.this.typeMapper.mapType(samType.getKotlinFunctionType());
                ((StackValue)expression.accept(visitor2, StackValue.none())).put(functionType, v);
                Label ifNonNull = new Label();
                Label afterAll = new Label();
                v.dup();
                v.ifnonnull(ifNonNull);
                v.pop();
                v.pop2();
                v.aconst(null);
                v.goTo(afterAll);
                v.mark(ifNonNull);
                v.invokespecial(asmType.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, functionType), false);
                v.mark(afterAll);
                return null;
            }
        });
    }

    @NotNull
    protected FunctionDescriptor accessibleFunctionDescriptor(@NotNull ResolvedCall<?> resolvedCall) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "accessibleFunctionDescriptor"));
        }
        FunctionDescriptor descriptor2 = (FunctionDescriptor)resolvedCall.getResultingDescriptor();
        FunctionDescriptor originalIfSamAdapter = SamCodegenUtil.getOriginalIfSamAdapter(descriptor2);
        if (originalIfSamAdapter != null) {
            descriptor2 = originalIfSamAdapter;
        }
        FunctionDescriptor functionDescriptor = CallUtilKt.usesDefaultArguments(resolvedCall) ? descriptor2 : this.context.accessibleDescriptor(descriptor2, this.getSuperCallTarget(resolvedCall.getCall()));
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "accessibleFunctionDescriptor"));
        }
        return functionDescriptor;
    }

    @NotNull
    public StackValue invokeFunction(@NotNull ResolvedCall<?> resolvedCall, @NotNull StackValue receiver) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeFunction"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeFunction"));
        }
        StackValue stackValue = this.invokeFunction(resolvedCall.getCall(), resolvedCall, receiver);
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeFunction"));
        }
        return stackValue;
    }

    @NotNull
    public StackValue invokeFunction(@NotNull Call call, @NotNull ResolvedCall<?> resolvedCall, @NotNull StackValue receiver) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeFunction"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeFunction"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeFunction"));
        }
        FunctionDescriptor fd = this.accessibleFunctionDescriptor(resolvedCall);
        ClassDescriptor superCallTarget = this.getSuperCallTarget(call);
        fd = this.context.getAccessorForSuperCallIfNeeded(fd, superCallTarget);
        Collection codegenExtensions = ExpressionCodegenExtension.Companion.getInstances(this.state.getProject());
        if (!codegenExtensions.isEmpty()) {
            ExpressionCodegenExtension.Context context = new ExpressionCodegenExtension.Context(this.typeMapper, this.v);
            for (ExpressionCodegenExtension extension : codegenExtensions) {
                StackValue stackValue = extension.applyFunction(receiver, resolvedCall, context);
                if (stackValue == null) continue;
                StackValue stackValue2 = stackValue;
                if (stackValue2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeFunction"));
                }
                return stackValue2;
            }
        }
        Callable callable = this.resolveToCallable(fd, superCallTarget != null, resolvedCall);
        StackValue stackValue = callable.invokeMethodWithArguments(resolvedCall, receiver, this);
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeFunction"));
        }
        return stackValue;
    }

    @Nullable
    public static CodegenContext getParentContextSubclassOf(ClassDescriptor descriptor2, CodegenContext context) {
        for (CodegenContext c = context; c != null; c = c.getParentContext()) {
            if (!(c instanceof ClassContext) || !DescriptorUtils.isSubclass(c.getThisDescriptor(), descriptor2)) continue;
            return c;
        }
        return null;
    }

    @NotNull
    Callable resolveToCallable(@NotNull FunctionDescriptor fd, boolean superCall, @NotNull ResolvedCall resolvedCall) {
        if (fd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fd", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "resolveToCallable"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "resolveToCallable"));
        }
        IntrinsicMethod intrinsic = this.state.getIntrinsics().getIntrinsic(fd);
        if (intrinsic != null) {
            Callable callable = intrinsic.toCallable(fd, superCall, resolvedCall, this);
            if (callable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "resolveToCallable"));
            }
            return callable;
        }
        CallableMethod callableMethod = this.resolveToCallableMethod(fd, superCall);
        if (callableMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "resolveToCallable"));
        }
        return callableMethod;
    }

    @NotNull
    private CallableMethod resolveToCallableMethod(@NotNull FunctionDescriptor fd, boolean superCall) {
        if (fd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fd", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "resolveToCallableMethod"));
        }
        CallableMethod callableMethod = this.typeMapper.mapToCallableMethod(SamCodegenUtil.resolveSamAdapter(fd), superCall);
        if (callableMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "resolveToCallableMethod"));
        }
        return callableMethod;
    }

    public void invokeMethodWithArguments(@NotNull Callable callableMethod, @NotNull ResolvedCall<?> resolvedCall, @NotNull StackValue receiver) {
        if (callableMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableMethod", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeMethodWithArguments"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeMethodWithArguments"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeMethodWithArguments"));
        }
        CallGenerator callGenerator = this.getOrCreateCallGenerator(resolvedCall);
        Object descriptor2 = resolvedCall.getResultingDescriptor();
        assert (callGenerator == this.defaultCallGenerator || !this.tailRecursionCodegen.isTailRecursion(resolvedCall)) : "Tail recursive method can't be inlined: " + descriptor2;
        CallBasedArgumentGenerator argumentGenerator = new CallBasedArgumentGenerator(this, callGenerator, descriptor2.getValueParameters(), callableMethod.getValueParameterTypes());
        this.invokeMethodWithArguments(callableMethod, resolvedCall, receiver, callGenerator, argumentGenerator);
    }

    public void invokeMethodWithArguments(@NotNull Callable callableMethod, @NotNull ResolvedCall<?> resolvedCall, @NotNull StackValue receiver, @NotNull CallGenerator callGenerator, @NotNull ArgumentGenerator argumentGenerator) {
        if (callableMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableMethod", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeMethodWithArguments"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeMethodWithArguments"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeMethodWithArguments"));
        }
        if (callGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callGenerator", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeMethodWithArguments"));
        }
        if (argumentGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentGenerator", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeMethodWithArguments"));
        }
        boolean isConstructor = resolvedCall.getResultingDescriptor() instanceof ConstructorDescriptor;
        if (!isConstructor) {
            receiver = StackValue.receiver(resolvedCall, receiver, this, callableMethod);
            receiver.put(receiver.type, this.v);
            callableMethod.afterReceiverGeneration(this.v);
        }
        callGenerator.putHiddenParams();
        List<ResolvedValueArgument> valueArguments2 = resolvedCall.getValueArgumentsByIndex();
        assert (valueArguments2 != null) : "Failed to arrange value arguments by index: " + resolvedCall.getResultingDescriptor();
        DefaultCallArgs defaultArgs = argumentGenerator.generate(valueArguments2, new ArrayList<ResolvedValueArgument>(resolvedCall.getValueArguments().values()));
        if (this.tailRecursionCodegen.isTailRecursion(resolvedCall)) {
            this.tailRecursionCodegen.generateTailRecursion(resolvedCall);
            return;
        }
        boolean defaultMaskWasGenerated = defaultArgs.generateOnStackIfNeeded(callGenerator, isConstructor);
        if (callableMethod instanceof CallableMethod) {
            List<JvmMethodParameterSignature> callableParameters = ((CallableMethod)callableMethod).getValueParameters();
            for (JvmMethodParameterSignature parameter : callableParameters) {
                if (parameter.getKind() != JvmMethodParameterKind.CONSTRUCTOR_MARKER) continue;
                callGenerator.putValueIfNeeded(parameter.getAsmType(), StackValue.constant(null, parameter.getAsmType()));
            }
        }
        callGenerator.genCall(callableMethod, resolvedCall, defaultMaskWasGenerated, this);
        KotlinType returnType2 = resolvedCall.getResultingDescriptor().getReturnType();
        if (returnType2 != null && KotlinBuiltIns.isNothing(returnType2)) {
            this.v.aconst(null);
            this.v.athrow();
        }
    }

    @NotNull
    private CallGenerator getOrCreateCallGenerator(@NotNull CallableDescriptor descriptor2, @Nullable KtElement callElement, @Nullable TypeParameterMappings typeParameterMappings, boolean isDefaultCompilation) {
        boolean isInline;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getOrCreateCallGenerator"));
        }
        if (callElement == null) {
            CallGenerator callGenerator = this.defaultCallGenerator;
            if (callGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getOrCreateCallGenerator"));
            }
            return callGenerator;
        }
        boolean bl = isInline = !(!this.state.isInlineEnabled() && !InlineUtil.containsReifiedTypeParameters(descriptor2) || !InlineUtil.isInline(descriptor2) && !InlineUtil.isArrayConstructorWithLambda(descriptor2));
        if (!isInline) {
            CallGenerator callGenerator = this.defaultCallGenerator;
            if (callGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getOrCreateCallGenerator"));
            }
            return callGenerator;
        }
        FunctionDescriptor original = DescriptorUtils.unwrapFakeOverride((FunctionDescriptor)descriptor2.getOriginal());
        InlineCodegen inlineCodegen = new InlineCodegen(this, this.state, original, callElement, typeParameterMappings, isDefaultCompilation);
        if (inlineCodegen == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getOrCreateCallGenerator"));
        }
        return inlineCodegen;
    }

    @NotNull
    protected CallGenerator getOrCreateCallGeneratorForDefaultImplBody(@NotNull FunctionDescriptor descriptor2, @Nullable KtNamedFunction function) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getOrCreateCallGeneratorForDefaultImplBody"));
        }
        CallGenerator callGenerator = this.getOrCreateCallGenerator(descriptor2, function, null, true);
        if (callGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getOrCreateCallGeneratorForDefaultImplBody"));
        }
        return callGenerator;
    }

    @NotNull
    CallGenerator getOrCreateCallGenerator(@NotNull ResolvedCall<?> resolvedCall) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getOrCreateCallGenerator"));
        }
        Map<TypeParameterDescriptor, KotlinType> typeArguments = resolvedCall.getTypeArguments();
        TypeParameterMappings mappings = new TypeParameterMappings();
        for (Map.Entry<TypeParameterDescriptor, KotlinType> entry : typeArguments.entrySet()) {
            TypeParameterDescriptor key = entry.getKey();
            KotlinType type2 = TypeUtils.uncaptureTypeForInlineMapping(entry.getValue());
            boolean isReified = key.isReified() || InlineUtil.isArrayConstructorWithLambda(resolvedCall.getResultingDescriptor());
            Pair<TypeParameterDescriptor, ReificationArgument> typeParameterAndReificationArgument = ExpressionCodegen.extractReificationArgument(type2);
            if (typeParameterAndReificationArgument == null) {
                BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.TYPE);
                Type asmType = this.typeMapper.mapTypeParameter(type2, signatureWriter);
                mappings.addParameterMappingToType(key.getName().getIdentifier(), type2, asmType, signatureWriter.toString(), isReified);
                continue;
            }
            mappings.addParameterMappingForFurtherReification(key.getName().getIdentifier(), type2, typeParameterAndReificationArgument.getSecond(), isReified);
        }
        CallGenerator callGenerator = this.getOrCreateCallGenerator((CallableDescriptor)resolvedCall.getResultingDescriptor(), resolvedCall.getCall().getCallElement(), mappings, false);
        if (callGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getOrCreateCallGenerator"));
        }
        return callGenerator;
    }

    @Nullable
    private static Pair<TypeParameterDescriptor, ReificationArgument> extractReificationArgument(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "extractReificationArgument"));
        }
        int arrayDepth = 0;
        boolean isNullable = type2.isMarkedNullable();
        while (KotlinBuiltIns.isArray(type2)) {
            ++arrayDepth;
            type2 = type2.getArguments().get(0).getType();
        }
        TypeParameterDescriptor parameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(type2);
        if (parameterDescriptor == null) {
            return null;
        }
        return new Pair<TypeParameterDescriptor, ReificationArgument>(parameterDescriptor, new ReificationArgument(parameterDescriptor.getName().asString(), isNullable, arrayDepth));
    }

    @NotNull
    public StackValue generateReceiverValue(@Nullable ReceiverValue receiverValue, boolean isSuper) {
        if (receiverValue instanceof ImplicitClassReceiver) {
            ClassDescriptor receiverDescriptor = ((ImplicitClassReceiver)receiverValue).getDeclarationDescriptor();
            if (DescriptorUtils.isCompanionObject(receiverDescriptor)) {
                CallableMemberDescriptor contextDescriptor = (CallableMemberDescriptor)this.context.getContextDescriptor();
                if (contextDescriptor instanceof FunctionDescriptor && receiverDescriptor == contextDescriptor.getContainingDeclaration()) {
                    StackValue.Local local = StackValue.LOCAL_0;
                    if (local == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateReceiverValue"));
                    }
                    return local;
                }
                StackValue.Field field = StackValue.singleton(receiverDescriptor, this.typeMapper);
                if (field == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateReceiverValue"));
                }
                return field;
            }
            if (receiverDescriptor instanceof ScriptDescriptor) {
                StackValue stackValue = this.generateScriptReceiver((ScriptDescriptor)receiverDescriptor);
                if (stackValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateReceiverValue"));
                }
                return stackValue;
            }
            StackValue stackValue = StackValue.thisOrOuter(this, receiverDescriptor, isSuper, receiverValue instanceof CastImplicitClassReceiver || DescriptorUtils.isEnumEntry(receiverDescriptor));
            if (stackValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateReceiverValue"));
            }
            return stackValue;
        }
        if (receiverValue instanceof ExtensionReceiver) {
            StackValue stackValue = this.generateReceiver(((ExtensionReceiver)receiverValue).getDeclarationDescriptor());
            if (stackValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateReceiverValue"));
            }
            return stackValue;
        }
        if (receiverValue instanceof ExpressionReceiver) {
            StackValue stackValue = this.gen(((ExpressionReceiver)receiverValue).getExpression());
            if (stackValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateReceiverValue"));
            }
            return stackValue;
        }
        throw new UnsupportedOperationException("Unsupported receiver value: " + receiverValue);
    }

    @NotNull
    private StackValue generateReceiver(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateReceiver"));
        }
        StackValue stackValue = this.context.generateReceiver(descriptor2, this.state, false);
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateReceiver"));
        }
        return stackValue;
    }

    @NotNull
    private StackValue generateScriptReceiver(@NotNull ScriptDescriptor receiver) {
        CodegenContext cur;
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateScriptReceiver"));
        }
        StackValue result2 = StackValue.LOCAL_0;
        boolean inStartConstructorContext = cur instanceof ConstructorContext;
        for (cur = this.context; cur != null; cur = cur.getParentContext()) {
            if (!inStartConstructorContext) {
                cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
            }
            if (cur instanceof ScriptContext) {
                ScriptContext scriptContext = (ScriptContext)cur;
                if (scriptContext.getScriptDescriptor() == receiver) {
                    StackValue stackValue = result2;
                    if (stackValue == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateScriptReceiver"));
                    }
                    return stackValue;
                }
                Type currentScriptType = this.typeMapper.mapType(scriptContext.getScriptDescriptor());
                Type classType = this.typeMapper.mapType(receiver);
                String fieldName = scriptContext.getScriptFieldName(receiver);
                StackValue.Field field = StackValue.field(classType, currentScriptType, fieldName, false, result2, receiver);
                if (field == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateScriptReceiver"));
                }
                return field;
            }
            result2 = cur.getOuterExpression(result2, false);
            if (!inStartConstructorContext) continue;
            cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
            inStartConstructorContext = false;
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public StackValue generateThisOrOuter(@NotNull ClassDescriptor calleeContainingClass, boolean isSuper) {
        if (calleeContainingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeContainingClass", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateThisOrOuter"));
        }
        StackValue stackValue = this.generateThisOrOuter(calleeContainingClass, isSuper, false);
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateThisOrOuter"));
        }
        return stackValue;
    }

    @NotNull
    public StackValue generateThisOrOuter(@NotNull ClassDescriptor calleeContainingClass, boolean isSuper, boolean forceOuter) {
        CodegenContext cur;
        if (calleeContainingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeContainingClass", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateThisOrOuter"));
        }
        boolean isSingleton = calleeContainingClass.getKind().isSingleton();
        if (isSingleton) {
            if (calleeContainingClass.equals(this.context.getThisDescriptor()) && !AnnotationUtilKt.isPlatformStaticInObjectOrClass((CallableDescriptor)this.context.getContextDescriptor())) {
                StackValue.Local local = StackValue.local(0, this.typeMapper.mapType(calleeContainingClass));
                if (local == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateThisOrOuter"));
                }
                return local;
            }
            if (DescriptorUtils.isEnumEntry(calleeContainingClass)) {
                StackValue.Field field = StackValue.enumEntry(calleeContainingClass, this.typeMapper);
                if (field == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateThisOrOuter"));
                }
                return field;
            }
            StackValue.Field field = StackValue.singleton(calleeContainingClass, this.typeMapper);
            if (field == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateThisOrOuter"));
            }
            return field;
        }
        Type type2 = this.asmType(calleeContainingClass.getDefaultType());
        StackValue result2 = StackValue.local(0, type2);
        boolean inStartConstructorContext = cur instanceof ConstructorContext;
        for (cur = this.context; cur != null; cur = cur.getParentContext()) {
            ClassDescriptor thisDescriptor = cur.getThisDescriptor();
            if (!isSuper && thisDescriptor == calleeContainingClass) {
                StackValue.Local local = result2;
                if (local == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateThisOrOuter"));
                }
                return local;
            }
            if (!forceOuter && isSuper && DescriptorUtils.isSubclass(thisDescriptor, calleeContainingClass)) {
                StackValue stackValue = this.castToRequiredTypeOfInterfaceIfNeeded(result2, thisDescriptor, calleeContainingClass);
                if (stackValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateThisOrOuter"));
                }
                return stackValue;
            }
            forceOuter = false;
            if (inStartConstructorContext) {
                result2 = cur.getOuterExpression(result2, false);
                cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
                inStartConstructorContext = false;
                continue;
            }
            cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
            result2 = cur.getOuterExpression(result2, false);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    private static CodegenContext getNotNullParentContextForMethod(CodegenContext cur) {
        if (cur instanceof MethodContext) {
            cur = cur.getParentContext();
        }
        assert (cur != null);
        CodegenContext codegenContext = cur;
        if (codegenContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getNotNullParentContextForMethod"));
        }
        return codegenContext;
    }

    public void genVarargs(@NotNull VarargValueArgument valueArgument, @NotNull KotlinType outType) {
        int i;
        if (valueArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArgument", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genVarargs"));
        }
        if (outType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outType", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genVarargs"));
        }
        Type type2 = this.asmType(outType);
        assert (type2.getSort() == 9);
        Type elementType = AsmUtil.correctElementType(type2);
        List<ValueArgument> arguments2 = valueArgument.getArguments();
        int size = arguments2.size();
        boolean hasSpread = false;
        for (i = 0; i != size; ++i) {
            if (arguments2.get(i).getSpreadElement() == null) continue;
            hasSpread = true;
            break;
        }
        if (hasSpread) {
            boolean arrayOfReferences = KotlinBuiltIns.isArray(outType);
            if (size == 1) {
                ValueArgument argument = arguments2.get(0);
                Type arrayType = arrayOfReferences ? Type.getType("[Ljava/lang/Object;") : Type.getType("[" + elementType.getDescriptor());
                this.gen(argument.getArgumentExpression(), type2);
                this.v.dup();
                this.v.arraylength();
                this.v.invokestatic("java/util/Arrays", "copyOf", Type.getMethodDescriptor(arrayType, arrayType, Type.INT_TYPE), false);
                if (arrayOfReferences) {
                    this.v.checkcast(type2);
                }
            } else {
                String toArrayDescriptor;
                String addDescriptor;
                String owner;
                if (arrayOfReferences) {
                    owner = "kotlin/jvm/internal/SpreadBuilder";
                    addDescriptor = "(Ljava/lang/Object;)V";
                    toArrayDescriptor = "([Ljava/lang/Object;)[Ljava/lang/Object;";
                } else {
                    String spreadBuilderClassName = AsmUtil.asmPrimitiveTypeToLangPrimitiveType(elementType).getTypeName().getIdentifier() + "SpreadBuilder";
                    owner = "kotlin/jvm/internal/" + spreadBuilderClassName;
                    addDescriptor = "(" + elementType.getDescriptor() + ")V";
                    toArrayDescriptor = "()" + type2.getDescriptor();
                }
                this.v.anew(Type.getObjectType(owner));
                this.v.dup();
                this.v.iconst(size);
                this.v.invokespecial(owner, "<init>", "(I)V", false);
                for (int i2 = 0; i2 != size; ++i2) {
                    this.v.dup();
                    ValueArgument argument = arguments2.get(i2);
                    if (argument.getSpreadElement() != null) {
                        this.gen(argument.getArgumentExpression(), AsmTypes.OBJECT_TYPE);
                        this.v.invokevirtual(owner, "addSpread", "(Ljava/lang/Object;)V", false);
                        continue;
                    }
                    this.gen(argument.getArgumentExpression(), elementType);
                    this.v.invokevirtual(owner, "add", addDescriptor, false);
                }
                if (arrayOfReferences) {
                    this.v.dup();
                    this.v.invokevirtual(owner, "size", "()I", false);
                    this.newArrayInstruction(outType);
                    this.v.invokevirtual(owner, "toArray", toArrayDescriptor, false);
                    this.v.checkcast(type2);
                } else {
                    this.v.invokevirtual(owner, "toArray", toArrayDescriptor, false);
                }
            }
        } else {
            this.v.iconst(arguments2.size());
            this.newArrayInstruction(outType);
            for (i = 0; i != size; ++i) {
                this.v.dup();
                StackValue rightSide = this.gen(arguments2.get(i).getArgumentExpression());
                StackValue.arrayElement(elementType, StackValue.onStack(type2), StackValue.constant(i, Type.INT_TYPE)).store(rightSide, this.v);
            }
        }
    }

    public int indexOfLocal(KtReferenceExpression lhs) {
        DeclarationDescriptor declarationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, lhs);
        if (BindingContextUtils.isVarCapturedInClosure(this.bindingContext, declarationDescriptor)) {
            return -1;
        }
        return this.lookupLocalIndex(declarationDescriptor);
    }

    @Override
    public StackValue visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression, StackValue data) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitClassLiteralExpression"));
        }
        KotlinType type2 = this.bindingContext.getType(expression);
        assert (type2 != null);
        assert (this.state.getReflectionTypes().getKClass().getTypeConstructor().equals(type2.getConstructor())) : "::class expression should be type checked to a KClass: " + type2;
        return ExpressionCodegen.generateClassLiteralReference(this.typeMapper, CollectionsKt.single(type2.getArguments()).getType(), this);
    }

    @Override
    public StackValue visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression, StackValue data) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitCallableReferenceExpression"));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCallWithAssert(expression.getCallableReference(), this.bindingContext);
        FunctionDescriptor functionDescriptor = this.bindingContext.get(BindingContext.FUNCTION, expression);
        if (functionDescriptor != null) {
            FunctionReferenceGenerationStrategy strategy = new FunctionReferenceGenerationStrategy(this.state, functionDescriptor, resolvedCall);
            return this.genClosure(expression, functionDescriptor, strategy, null, (FunctionDescriptor)resolvedCall.getResultingDescriptor());
        }
        VariableDescriptor variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, expression);
        if (variableDescriptor != null) {
            return this.generatePropertyReference(expression, variableDescriptor, resolvedCall);
        }
        throw new UnsupportedOperationException("Unsupported callable reference expression: " + expression.getText());
    }

    @NotNull
    private StackValue generatePropertyReference(@NotNull KtElement element, @NotNull VariableDescriptor variableDescriptor, @NotNull ResolvedCall<?> resolvedCall) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generatePropertyReference"));
        }
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generatePropertyReference"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generatePropertyReference"));
        }
        ClassDescriptor classDescriptor = CodegenBinding.anonymousClassForCallable(this.bindingContext, variableDescriptor);
        ClassBuilder classBuilder2 = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(element), this.typeMapper.mapClass(classDescriptor), element.getContainingFile());
        PropertyReferenceCodegen codegen = new PropertyReferenceCodegen(this.state, this.parentCodegen, this.context.intoAnonymousClass(classDescriptor, this, OwnerKind.IMPLEMENTATION), element, classBuilder2, resolvedCall);
        codegen.generate();
        StackValue stackValue = codegen.putInstanceOnStack();
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generatePropertyReference"));
        }
        return stackValue;
    }

    @NotNull
    public static StackValue generateClassLiteralReference(@NotNull JetTypeMapper typeMapper, @NotNull KotlinType type2) {
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateClassLiteralReference"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateClassLiteralReference"));
        }
        StackValue stackValue = ExpressionCodegen.generateClassLiteralReference(typeMapper, type2, null);
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateClassLiteralReference"));
        }
        return stackValue;
    }

    @NotNull
    private static StackValue generateClassLiteralReference(final @NotNull JetTypeMapper typeMapper, final @NotNull KotlinType type2, final @Nullable ExpressionCodegen codegen) {
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateClassLiteralReference"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateClassLiteralReference"));
        }
        StackValue stackValue = StackValue.operation(AsmTypes.K_CLASS_TYPE, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                Type classAsmType = typeMapper.mapType(type2);
                ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
                if (descriptor2 instanceof TypeParameterDescriptor) {
                    TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)descriptor2;
                    assert (typeParameterDescriptor.isReified()) : "Non-reified type parameter under ::class should be rejected by type checker: " + typeParameterDescriptor;
                    assert (codegen != null) : "Reference to member of reified type should be rejected by type checker " + typeParameterDescriptor;
                    codegen.putReifiedOperationMarkerIfTypeIsReifiedParameter(type2, ReifiedTypeInliner.OperationKind.JAVA_CLASS);
                }
                AsmUtil.putJavaLangClassInstance(v, classAsmType);
                AsmUtil.wrapJavaClassIntoKClass(v);
                return Unit.INSTANCE;
            }
        });
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateClassLiteralReference"));
        }
        return stackValue;
    }

    @Override
    public StackValue visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitDotQualifiedExpression"));
        }
        StackValue receiverValue = StackValue.none();
        return this.genQualified(receiverValue, expression.getSelectorExpression());
    }

    private StackValue generateExpressionWithNullFallback(@NotNull KtExpression expression, @NotNull Label ifnull) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateExpressionWithNullFallback"));
        }
        if (ifnull == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifnull", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateExpressionWithNullFallback"));
        }
        KtExpression deparenthesized = KtPsiUtil.deparenthesize(expression);
        assert (deparenthesized != null) : "Unexpected empty expression";
        expression = deparenthesized;
        Type type2 = this.expressionType(expression);
        if (expression instanceof KtSafeQualifiedExpression && !AsmUtil.isPrimitive(type2)) {
            return StackValue.coercion(this.generateSafeQualifiedExpression((KtSafeQualifiedExpression)expression, ifnull), type2);
        }
        return this.genLazy(expression, type2);
    }

    private StackValue generateSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression, @NotNull Label ifNull) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateSafeQualifiedExpression"));
        }
        if (ifNull == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifNull", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateSafeQualifiedExpression"));
        }
        KtExpression receiver = expression.getReceiverExpression();
        KtExpression selector = expression.getSelectorExpression();
        Type receiverType = this.expressionType(receiver);
        StackValue receiverValue = this.generateExpressionWithNullFallback(receiver, ifNull);
        StackValue.SafeCall newReceiver = new StackValue.SafeCall(receiverType, receiverValue, AsmUtil.isPrimitive(receiverType) ? null : ifNull);
        return this.genQualified(newReceiver, selector);
    }

    @Override
    public StackValue visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression, StackValue unused) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitSafeQualifiedExpression"));
        }
        Label ifnull = new Label();
        Type type2 = AsmUtil.boxType(this.expressionType(expression));
        StackValue value = this.generateSafeQualifiedExpression(expression, ifnull);
        StackValue newReceiver = StackValue.coercion(value, type2);
        StackValue result2 = !AsmUtil.isPrimitive(this.expressionType(expression.getReceiverExpression())) ? new StackValue.SafeFallback(type2, ifnull, newReceiver) : newReceiver;
        return result2;
    }

    @Override
    public StackValue visitBinaryExpression(@NotNull KtBinaryExpression expression, @NotNull StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitBinaryExpression"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitBinaryExpression"));
        }
        KtSimpleNameExpression reference = expression.getOperationReference();
        IElementType opToken = reference.getReferencedNameElementType();
        if (opToken == KtTokens.EQ) {
            return this.generateAssignmentExpression(expression);
        }
        if (KtTokens.AUGMENTED_ASSIGNMENTS.contains(opToken)) {
            return this.generateAugmentedAssignment(expression);
        }
        if (opToken == KtTokens.ANDAND) {
            return this.generateBooleanAnd(expression);
        }
        if (opToken == KtTokens.OROR) {
            return this.generateBooleanOr(expression);
        }
        if (opToken == KtTokens.EQEQ || opToken == KtTokens.EXCLEQ || opToken == KtTokens.EQEQEQ || opToken == KtTokens.EXCLEQEQEQ) {
            return this.generateEquals(expression.getLeft(), expression.getRight(), opToken);
        }
        if (opToken == KtTokens.LT || opToken == KtTokens.LTEQ || opToken == KtTokens.GT || opToken == KtTokens.GTEQ) {
            return this.generateComparison(expression, receiver);
        }
        if (opToken == KtTokens.ELVIS) {
            return this.generateElvis(expression);
        }
        if (opToken == KtTokens.IN_KEYWORD || opToken == KtTokens.NOT_IN) {
            return this.generateIn(StackValue.expression(this.expressionType(expression.getLeft()), expression.getLeft(), this), expression.getRight(), reference);
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCallWithAssert(expression, this.bindingContext);
        FunctionDescriptor descriptor2 = (FunctionDescriptor)resolvedCall.getResultingDescriptor();
        if (descriptor2 instanceof ConstructorDescriptor) {
            return this.generateConstructorCall(resolvedCall, this.expressionType(expression));
        }
        return this.invokeFunction(resolvedCall, receiver);
    }

    private StackValue generateIn(final StackValue leftValue, KtExpression rangeExpression, final KtSimpleNameExpression operationReference) {
        final KtExpression deparenthesized = KtPsiUtil.deparenthesize(rangeExpression);
        assert (deparenthesized != null) : "For with empty range expression";
        return StackValue.operation(Type.BOOLEAN_TYPE, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                if (ExpressionCodegen.this.isIntRangeExpr(deparenthesized) && AsmUtil.isIntPrimitive(leftValue.type)) {
                    ExpressionCodegen.this.genInIntRange(leftValue, (KtBinaryExpression)deparenthesized);
                } else {
                    ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCallWithAssert(operationReference, ExpressionCodegen.this.bindingContext);
                    StackValue result2 = ExpressionCodegen.this.invokeFunction(resolvedCall.getCall(), resolvedCall, StackValue.none());
                    result2.put(result2.type, v);
                }
                if (operationReference.getReferencedNameElementType() == KtTokens.NOT_IN) {
                    AsmUtil.genInvertBoolean(v);
                }
                return null;
            }
        });
    }

    private void genInIntRange(StackValue leftValue, KtBinaryExpression rangeExpression) {
        this.v.iconst(1);
        leftValue.put(Type.INT_TYPE, this.v);
        this.v.dup2();
        this.gen(rangeExpression.getLeft(), Type.INT_TYPE);
        Label lok = new Label();
        this.v.ificmpge(lok);
        this.v.pop();
        this.v.iconst(0);
        this.v.mark(lok);
        this.v.dupX2();
        this.v.pop();
        this.gen(rangeExpression.getRight(), Type.INT_TYPE);
        Label rok = new Label();
        this.v.ificmple(rok);
        this.v.pop();
        this.v.iconst(0);
        this.v.mark(rok);
        this.v.and(Type.INT_TYPE);
    }

    private StackValue generateBooleanAnd(KtBinaryExpression expression) {
        return StackValue.and(this.gen(expression.getLeft()), this.gen(expression.getRight()));
    }

    private StackValue generateBooleanOr(KtBinaryExpression expression) {
        return StackValue.or(this.gen(expression.getLeft()), this.gen(expression.getRight()));
    }

    private StackValue generateEquals(KtExpression left, KtExpression right, IElementType opToken) {
        Type leftType = this.expressionType(left);
        Type rightType = this.expressionType(right);
        if (KtPsiUtil.isNullConstant(left)) {
            return this.genCmpWithNull(right, opToken);
        }
        if (KtPsiUtil.isNullConstant(right)) {
            return this.genCmpWithNull(left, opToken);
        }
        if (this.isIntZero(left, leftType) && AsmUtil.isIntPrimitive(rightType)) {
            return this.genCmpWithZero(right, opToken);
        }
        if (this.isIntZero(right, rightType) && AsmUtil.isIntPrimitive(leftType)) {
            return this.genCmpWithZero(left, opToken);
        }
        if (AsmUtil.isPrimitive(leftType) != AsmUtil.isPrimitive(rightType)) {
            leftType = AsmUtil.boxType(leftType);
            rightType = AsmUtil.boxType(rightType);
        }
        StackValue leftValue = this.genLazy(left, leftType);
        StackValue rightValue = this.genLazy(right, rightType);
        if (opToken == KtTokens.EQEQEQ || opToken == KtTokens.EXCLEQEQEQ) {
            Type operandType = AsmUtil.isPrimitive(leftType) ? leftType : AsmTypes.OBJECT_TYPE;
            return StackValue.cmp(opToken, operandType, leftValue, rightValue);
        }
        return AsmUtil.genEqualsForExpressionsOnStack(opToken, leftValue, rightValue);
    }

    private boolean isIntZero(KtExpression expr, Type exprType) {
        ConstantValue<?> exprValue = ExpressionCodegen.getCompileTimeConstant(expr, this.bindingContext);
        return AsmUtil.isIntPrimitive(exprType) && exprValue != null && Integer.valueOf(0).equals(exprValue.getValue());
    }

    private StackValue genCmpWithZero(KtExpression exp, IElementType opToken) {
        return StackValue.compareIntWithZero(this.gen(exp), KtTokens.EQEQ == opToken || KtTokens.EQEQEQ == opToken ? 154 : 153);
    }

    private StackValue genCmpWithNull(KtExpression exp, IElementType opToken) {
        return StackValue.compareWithNull(this.gen(exp), KtTokens.EQEQ == opToken || KtTokens.EQEQEQ == opToken ? 199 : 198);
    }

    private StackValue generateElvis(final @NotNull KtBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateElvis"));
        }
        KtExpression left = expression.getLeft();
        final Type exprType = this.expressionType(expression);
        final Type leftType = this.expressionType(left);
        final Label ifNull = new Label();
        assert (left != null) : "left expression in elvis should be not null: " + expression.getText();
        final StackValue value = this.generateExpressionWithNullFallback(left, ifNull);
        if (AsmUtil.isPrimitive(leftType)) {
            return value;
        }
        return StackValue.operation(exprType, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                value.put(value.type, v);
                v.dup();
                v.ifnull(ifNull);
                StackValue.onStack(leftType).put(exprType, v);
                Label end = new Label();
                v.goTo(end);
                v.mark(ifNull);
                v.pop();
                ExpressionCodegen.this.gen(expression.getRight(), exprType);
                v.mark(end);
                return null;
            }
        });
    }

    private StackValue generateComparison(KtBinaryExpression expression, StackValue receiver) {
        StackValue rightValue;
        StackValue leftValue;
        Type type2;
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCallWithAssert(expression, this.bindingContext);
        KtExpression left = expression.getLeft();
        KtExpression right = expression.getRight();
        Type leftType = this.expressionType(left);
        Type rightType = this.expressionType(right);
        if (AsmUtil.isPrimitive(leftType) && AsmUtil.isPrimitive(rightType)) {
            type2 = AsmUtil.comparisonOperandType(leftType, rightType);
            leftValue = this.gen(left);
            rightValue = this.gen(right);
        } else {
            type2 = Type.INT_TYPE;
            leftValue = this.invokeFunction(resolvedCall, receiver);
            rightValue = StackValue.constant(0, type2);
        }
        return StackValue.cmp(expression.getOperationToken(), type2, leftValue, rightValue);
    }

    private StackValue generateAssignmentExpression(KtBinaryExpression expression) {
        StackValue stackValue = this.gen(expression.getLeft());
        KtExpression right = expression.getRight();
        assert (right != null) : expression.getText();
        stackValue.store(this.gen(right), this.v);
        return StackValue.none();
    }

    private StackValue generateAugmentedAssignment(KtBinaryExpression expression) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCallWithAssert(expression, this.bindingContext);
        FunctionDescriptor descriptor2 = this.accessibleFunctionDescriptor(resolvedCall);
        Callable callable = this.resolveToCallable(descriptor2, false, resolvedCall);
        KtExpression lhs = expression.getLeft();
        Type lhsType = this.expressionType(lhs);
        boolean keepReturnValue = Boolean.TRUE.equals(this.bindingContext.get(BindingContext.VARIABLE_REASSIGNMENT, expression)) || !KotlinBuiltIns.isUnit(descriptor2.getReturnType());
        this.callAugAssignMethod(expression, resolvedCall, callable, lhsType, keepReturnValue);
        return StackValue.none();
    }

    private void callAugAssignMethod(@NotNull KtBinaryExpression expression, @NotNull ResolvedCall<?> resolvedCall, @NotNull Callable callable, @NotNull Type lhsType, boolean keepReturnValue) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "callAugAssignMethod"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "callAugAssignMethod"));
        }
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "callAugAssignMethod"));
        }
        if (lhsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lhsType", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "callAugAssignMethod"));
        }
        StackValue value = this.gen(expression.getLeft());
        if (keepReturnValue) {
            value = StackValue.complexWriteReadReceiver(value);
        }
        value.put(lhsType, this.v);
        StackValue receiver = StackValue.onStack(lhsType);
        callable.invokeMethodWithArguments(resolvedCall, receiver, this).put(callable.getReturnType(), this.v);
        if (keepReturnValue) {
            value.store(StackValue.onStack(callable.getReturnType()), this.v, true);
        }
    }

    public void invokeAppend(KtExpression expr) {
        KtBinaryExpression binaryExpression;
        if (expr instanceof KtBinaryExpression && (binaryExpression = (KtBinaryExpression)expr).getOperationToken() == KtTokens.PLUS) {
            KtExpression left = binaryExpression.getLeft();
            KtExpression right = binaryExpression.getRight();
            Type leftType = this.expressionType(left);
            if (leftType.equals(AsmTypes.JAVA_STRING_TYPE)) {
                this.invokeAppend(left);
                this.invokeAppend(right);
                return;
            }
        }
        Type exprType = this.expressionType(expr);
        this.gen(expr, exprType);
        AsmUtil.genInvokeAppendMethod(this.v, exprType.getSort() == 9 ? AsmTypes.OBJECT_TYPE : exprType);
    }

    @Nullable
    private static KtSimpleNameExpression targetLabel(KtExpression expression) {
        if (expression.getParent() instanceof KtLabeledExpression) {
            return ((KtLabeledExpression)expression.getParent()).getTargetLabel();
        }
        return null;
    }

    @Override
    public StackValue visitLabeledExpression(@NotNull KtLabeledExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitLabeledExpression"));
        }
        return this.genQualified(receiver, expression.getBaseExpression());
    }

    @Override
    public StackValue visitPrefixExpression(@NotNull KtPrefixExpression expression, @NotNull StackValue receiver) {
        String operationName;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitPrefixExpression"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitPrefixExpression"));
        }
        DeclarationDescriptor originalOperation = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getOperationReference());
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCallWithAssert(expression, this.bindingContext);
        CallableDescriptor op = resolvedCall.getResultingDescriptor();
        assert (op instanceof FunctionDescriptor || originalOperation == null) : String.valueOf(op);
        String string = operationName = originalOperation == null ? "" : originalOperation.getName().asString();
        if (!operationName.equals("inc") && !operationName.equals("dec")) {
            return this.invokeFunction(resolvedCall, receiver);
        }
        int increment = operationName.equals("inc") ? 1 : -1;
        Type type2 = this.expressionType(expression.getBaseExpression());
        StackValue value = this.gen(expression.getBaseExpression());
        return StackValue.preIncrement(type2, value, increment, resolvedCall, this);
    }

    @Override
    public StackValue visitPostfixExpression(final @NotNull KtPostfixExpression expression, StackValue receiver) {
        int index2;
        KtExpression operand;
        int increment;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitPostfixExpression"));
        }
        if (expression.getOperationReference().getReferencedNameElementType() == KtTokens.EXCLEXCL) {
            final StackValue base = this.genQualified(receiver, expression.getBaseExpression());
            if (AsmUtil.isPrimitive(base.type)) {
                return base;
            }
            return StackValue.operation(base.type, new Function1<InstructionAdapter, Unit>(){

                @Override
                public Unit invoke(InstructionAdapter v) {
                    base.put(base.type, v);
                    v.dup();
                    Label ok = new Label();
                    v.ifnonnull(ok);
                    v.invokestatic("kotlin/jvm/internal/Intrinsics", "throwNpe", "()V", false);
                    v.mark(ok);
                    return null;
                }
            });
        }
        DeclarationDescriptor originalOperation = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getOperationReference());
        String originalOperationName = originalOperation != null ? originalOperation.getName().asString() : null;
        final ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCallWithAssert(expression, this.bindingContext);
        CallableDescriptor op = resolvedCall.getResultingDescriptor();
        if (!(op instanceof FunctionDescriptor) || originalOperation == null) {
            throw new UnsupportedOperationException("Don't know how to generate this postfix expression: " + originalOperationName + " " + op);
        }
        final Type asmResultType = this.expressionType(expression);
        final Type asmBaseType = this.expressionType(expression.getBaseExpression());
        DeclarationDescriptor cls = op.getContainingDeclaration();
        if (originalOperationName.equals("inc")) {
            increment = 1;
        } else if (originalOperationName.equals("dec")) {
            increment = -1;
        } else {
            throw new UnsupportedOperationException("Unsupported postfix operation: " + originalOperationName + " " + op);
        }
        final boolean isPrimitiveNumberClassDescriptor = AsmUtil.isPrimitiveNumberClassDescriptor(cls);
        if (isPrimitiveNumberClassDescriptor && AsmUtil.isPrimitive(asmBaseType) && (operand = expression.getBaseExpression()) instanceof KtReferenceExpression && asmResultType == Type.INT_TYPE && this.bindingContext.get(BindingContext.SMARTCAST, operand) == null && (index2 = this.indexOfLocal((KtReferenceExpression)operand)) >= 0) {
            return StackValue.postIncrement(index2, increment);
        }
        return StackValue.operation(asmBaseType, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                Type storeType;
                StackValue value = ExpressionCodegen.this.gen(expression.getBaseExpression());
                value = StackValue.complexWriteReadReceiver(value);
                Type type2 = ExpressionCodegen.this.expressionType(expression.getBaseExpression());
                value.put(type2, v);
                value.dup(v, true);
                if (isPrimitiveNumberClassDescriptor && AsmUtil.isPrimitive(asmBaseType)) {
                    AsmUtil.genIncrement(asmResultType, increment, v);
                    storeType = type2;
                } else {
                    StackValue result2 = ExpressionCodegen.this.invokeFunction(resolvedCall, StackValue.onStack(type2));
                    result2.put(result2.type, v);
                    storeType = result2.type;
                }
                value.store(StackValue.onStack(storeType), v, true);
                return Unit.INSTANCE;
            }
        });
    }

    @Override
    public StackValue visitProperty(@NotNull KtProperty property, StackValue receiver) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitProperty"));
        }
        KtExpression initializer2 = property.getInitializer();
        if (initializer2 == null) {
            return StackValue.none();
        }
        this.initializeLocalVariable(property, this.gen(initializer2));
        return StackValue.none();
    }

    @Override
    public StackValue visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, StackValue receiver) {
        if (multiDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitDestructuringDeclaration"));
        }
        KtExpression initializer2 = multiDeclaration.getInitializer();
        if (initializer2 == null) {
            return StackValue.none();
        }
        KotlinType initializerType = this.bindingContext.getType(initializer2);
        assert (initializerType != null);
        Type initializerAsmType = this.asmType(initializerType);
        TransientReceiver initializerAsReceiver = new TransientReceiver(initializerType);
        int tempVarIndex = this.myFrameMap.enterTemp(initializerAsmType);
        this.gen(initializer2, initializerAsmType);
        this.v.store(tempVarIndex, initializerAsmType);
        StackValue.Local local = StackValue.local(tempVarIndex, initializerAsmType);
        for (KtDestructuringDeclarationEntry variableDeclaration : multiDeclaration.getEntries()) {
            ResolvedCall<FunctionDescriptor> resolvedCall = this.bindingContext.get(BindingContext.COMPONENT_RESOLVED_CALL, variableDeclaration);
            assert (resolvedCall != null) : "Resolved call is null for " + variableDeclaration.getText();
            Call call = this.makeFakeCall(initializerAsReceiver);
            this.initializeLocalVariable(variableDeclaration, this.invokeFunction(call, resolvedCall, local));
        }
        if (initializerAsmType.getSort() == 10 || initializerAsmType.getSort() == 9) {
            this.v.aconst(null);
            this.v.store(tempVarIndex, initializerAsmType);
        }
        this.myFrameMap.leaveTemp(initializerAsmType);
        return StackValue.none();
    }

    private void initializeLocalVariable(@NotNull KtVariableDeclaration variableDeclaration, @NotNull StackValue initializer2) {
        if (variableDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDeclaration", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "initializeLocalVariable"));
        }
        if (initializer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "initializeLocalVariable"));
        }
        VariableDescriptor variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, variableDeclaration);
        if (KtPsiUtil.isScriptDeclaration(variableDeclaration)) {
            return;
        }
        int index2 = this.lookupLocalIndex(variableDescriptor);
        if (index2 < 0) {
            throw new IllegalStateException("Local variable not found for " + variableDescriptor);
        }
        Type sharedVarType = this.typeMapper.getSharedVarType(variableDescriptor);
        assert (variableDescriptor != null);
        Type varType = this.asmType(variableDescriptor.getType());
        StackValue storeTo = sharedVarType == null ? StackValue.local(index2, varType) : StackValue.shared(index2, varType);
        storeTo.putReceiver(this.v, false);
        initializer2.put(initializer2.type, this.v);
        this.markLineNumber(variableDeclaration, false);
        storeTo.storeSelector(initializer2.type, this.v);
    }

    @NotNull
    private StackValue generateNewCall(@NotNull KtCallExpression expression, @NotNull ResolvedCall<?> resolvedCall) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateNewCall"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateNewCall"));
        }
        Type type2 = this.expressionType(expression);
        if (type2.getSort() == 9) {
            StackValue stackValue = this.generateNewArray(expression, this.bindingContext.getType(expression), resolvedCall);
            if (stackValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateNewCall"));
            }
            return stackValue;
        }
        StackValue stackValue = this.generateConstructorCall(resolvedCall, type2);
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateNewCall"));
        }
        return stackValue;
    }

    @NotNull
    public ConstructorDescriptor getConstructorDescriptor(@NotNull ResolvedCall<?> resolvedCall) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getConstructorDescriptor"));
        }
        FunctionDescriptor accessibleDescriptor = this.accessibleFunctionDescriptor(resolvedCall);
        assert (accessibleDescriptor instanceof ConstructorDescriptor) : "getConstructorDescriptor must be called only for constructors: " + accessibleDescriptor;
        ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)accessibleDescriptor;
        if (constructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getConstructorDescriptor"));
        }
        return constructorDescriptor;
    }

    @NotNull
    public StackValue generateConstructorCall(final @NotNull ResolvedCall<?> resolvedCall, final @NotNull Type objectType) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateConstructorCall"));
        }
        if (objectType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectType", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateConstructorCall"));
        }
        StackValue stackValue = StackValue.functionCall(objectType, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                v.anew(objectType);
                v.dup();
                ConstructorDescriptor constructor = ExpressionCodegen.this.getConstructorDescriptor(resolvedCall);
                ReceiverParameterDescriptor dispatchReceiver = constructor.getDispatchReceiverParameter();
                ClassDescriptor containingDeclaration = constructor.getContainingDeclaration();
                if (dispatchReceiver != null) {
                    Type receiverType = ExpressionCodegen.this.typeMapper.mapType(dispatchReceiver.getType());
                    ReceiverValue receiver = resolvedCall.getDispatchReceiver();
                    boolean callSuper = containingDeclaration.isInner() && receiver instanceof ImplicitClassReceiver;
                    ExpressionCodegen.this.generateReceiverValue(receiver, callSuper).put(receiverType, v);
                }
                ExpressionCodegen.this.pushClosureOnStack(containingDeclaration, dispatchReceiver == null, ExpressionCodegen.this.defaultCallGenerator);
                constructor = SamCodegenUtil.resolveSamAdapter(constructor);
                CallableMethod method = ExpressionCodegen.this.typeMapper.mapToCallableMethod(constructor, false);
                ExpressionCodegen.this.invokeMethodWithArguments(method, resolvedCall, StackValue.none());
                return Unit.INSTANCE;
            }
        });
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateConstructorCall"));
        }
        return stackValue;
    }

    public StackValue generateNewArray(@NotNull KtCallExpression expression, final @NotNull KotlinType arrayType, @NotNull ResolvedCall<?> resolvedCall) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateNewArray"));
        }
        if (arrayType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayType", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateNewArray"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateNewArray"));
        }
        List<KtValueArgument> args = expression.getValueArguments();
        assert (args.size() == 1 || args.size() == 2) : "Unknown constructor called: " + args.size() + " arguments";
        if (args.size() == 1) {
            final KtExpression sizeExpression = args.get(0).getArgumentExpression();
            return StackValue.operation(this.typeMapper.mapType(arrayType), new Function1<InstructionAdapter, Unit>(){

                @Override
                public Unit invoke(InstructionAdapter v) {
                    ExpressionCodegen.this.gen(sizeExpression, Type.INT_TYPE);
                    ExpressionCodegen.this.newArrayInstruction(arrayType);
                    return Unit.INSTANCE;
                }
            });
        }
        return this.invokeFunction(resolvedCall, StackValue.none());
    }

    public void newArrayInstruction(@NotNull KotlinType arrayType) {
        if (arrayType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayType", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "newArrayInstruction"));
        }
        if (KotlinBuiltIns.isArray(arrayType)) {
            KotlinType elementJetType = arrayType.getArguments().get(0).getType();
            this.putReifiedOperationMarkerIfTypeIsReifiedParameter(elementJetType, ReifiedTypeInliner.OperationKind.NEW_ARRAY);
            this.v.newarray(AsmUtil.boxType(this.asmType(elementJetType)));
        } else {
            Type type2 = this.typeMapper.mapType(arrayType);
            this.v.newarray(AsmUtil.correctElementType(type2));
        }
    }

    @Override
    public StackValue visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitArrayAccessExpression"));
        }
        KtExpression array = expression.getArrayExpression();
        KotlinType type2 = array != null ? this.bindingContext.getType(array) : null;
        Type arrayType = this.expressionType(array);
        List<KtExpression> indices = expression.getIndexExpressions();
        FunctionDescriptor operationDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression);
        assert (operationDescriptor != null);
        if (arrayType.getSort() == 9 && indices.size() == 1 && KotlinBuiltIns.isInt(operationDescriptor.getValueParameters().get(0).getType())) {
            Type elementType;
            assert (type2 != null);
            if (KotlinBuiltIns.isArray(type2)) {
                KotlinType jetElementType = type2.getArguments().get(0).getType();
                elementType = AsmUtil.boxType(this.asmType(jetElementType));
            } else {
                elementType = AsmUtil.correctElementType(arrayType);
            }
            StackValue arrayValue = this.genLazy(array, arrayType);
            StackValue index2 = this.genLazy(indices.get(0), Type.INT_TYPE);
            return StackValue.arrayElement(elementType, arrayValue, index2);
        }
        ResolvedCall<FunctionDescriptor> resolvedSetCall = this.bindingContext.get(BindingContext.INDEXED_LVALUE_SET, expression);
        ResolvedCall<FunctionDescriptor> resolvedGetCall = this.bindingContext.get(BindingContext.INDEXED_LVALUE_GET, expression);
        boolean isGetter = "get".equals(operationDescriptor.getName().asString());
        Callable callable = this.resolveToCallable(operationDescriptor, false, isGetter ? resolvedGetCall : resolvedSetCall);
        CallableMethod callableMethod = this.resolveToCallableMethod(operationDescriptor, false);
        Type[] argumentTypes = callableMethod.getParameterTypes();
        StackValue.CollectionElementReceiver collectionElementReceiver = this.createCollectionElementReceiver(expression, receiver, operationDescriptor, isGetter, resolvedGetCall, resolvedSetCall, callable);
        Type elementType = isGetter ? callableMethod.getReturnType() : ArrayUtil.getLastElement(argumentTypes);
        return StackValue.collectionElement(collectionElementReceiver, elementType, resolvedGetCall, resolvedSetCall, this);
    }

    @NotNull
    private StackValue.CollectionElementReceiver createCollectionElementReceiver(@NotNull KtArrayAccessExpression expression, @NotNull StackValue receiver, @NotNull FunctionDescriptor operationDescriptor, boolean isGetter, ResolvedCall<FunctionDescriptor> resolvedGetCall, ResolvedCall<FunctionDescriptor> resolvedSetCall, @NotNull Callable callable) {
        ResolvedCall<FunctionDescriptor> resolvedCall;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "createCollectionElementReceiver"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "createCollectionElementReceiver"));
        }
        if (operationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "createCollectionElementReceiver"));
        }
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "createCollectionElementReceiver"));
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = resolvedCall = isGetter ? resolvedGetCall : resolvedSetCall;
        assert (resolvedCall != null) : "couldn't find resolved call: " + expression.getText();
        List<ResolvedValueArgument> valueArguments2 = resolvedCall.getValueArgumentsByIndex();
        assert (valueArguments2 != null) : "Failed to arrange value arguments by index: " + operationDescriptor;
        if (!isGetter) {
            assert (valueArguments2.size() >= 2) : "Setter call should have at least 2 arguments: " + operationDescriptor;
            valueArguments2.remove(valueArguments2.size() - 1);
        }
        StackValue.CollectionElementReceiver collectionElementReceiver = new StackValue.CollectionElementReceiver(callable, receiver, resolvedGetCall, resolvedSetCall, isGetter, this, valueArguments2);
        if (collectionElementReceiver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "createCollectionElementReceiver"));
        }
        return collectionElementReceiver;
    }

    @Override
    public StackValue visitThrowExpression(final @NotNull KtThrowExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitThrowExpression"));
        }
        return StackValue.operation(Type.VOID_TYPE, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter adapter) {
                ExpressionCodegen.this.gen(expression.getThrownExpression(), AsmTypes.JAVA_THROWABLE_TYPE);
                ExpressionCodegen.this.v.athrow();
                return Unit.INSTANCE;
            }
        });
    }

    @Override
    public StackValue visitThisExpression(@NotNull KtThisExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitThisExpression"));
        }
        DeclarationDescriptor descriptor2 = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getInstanceReference());
        if (descriptor2 instanceof ClassDescriptor) {
            return StackValue.thisOrOuter(this, (ClassDescriptor)descriptor2, false, true);
        }
        if (descriptor2 instanceof CallableDescriptor) {
            return this.generateReceiver((CallableDescriptor)descriptor2);
        }
        throw new UnsupportedOperationException("Neither this nor receiver: " + descriptor2);
    }

    @Override
    public StackValue visitTryExpression(@NotNull KtTryExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitTryExpression"));
        }
        return this.generateTryExpression(expression, false);
    }

    public StackValue generateTryExpression(final KtTryExpression expression, final boolean isStatement) {
        KotlinType jetType = this.bindingContext.getType(expression);
        assert (jetType != null);
        final Type expectedAsmType = isStatement ? Type.VOID_TYPE : this.asmType(jetType);
        return StackValue.operation(expectedAsmType, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                KtFinallySection finallyBlock = expression.getFinallyBlock();
                FinallyBlockStackElement finallyBlockStackElement = null;
                if (finallyBlock != null) {
                    finallyBlockStackElement = new FinallyBlockStackElement(expression);
                    ExpressionCodegen.this.blockStackElements.push(finallyBlockStackElement);
                }
                Label tryStart = new Label();
                v.mark(tryStart);
                v.nop();
                ExpressionCodegen.this.gen(expression.getTryBlock(), expectedAsmType);
                int savedValue = -1;
                if (!isStatement) {
                    savedValue = ExpressionCodegen.this.myFrameMap.enterTemp(expectedAsmType);
                    v.store(savedValue, expectedAsmType);
                }
                Label tryEnd = new Label();
                v.mark(tryEnd);
                List tryBlockRegions = ExpressionCodegen.getCurrentCatchIntervals(finallyBlockStackElement, tryStart, tryEnd);
                Label end = new Label();
                ExpressionCodegen.this.genFinallyBlockOrGoto(finallyBlockStackElement, end, null);
                List<KtCatchClause> clauses = expression.getCatchClauses();
                int size = clauses.size();
                for (int i = 0; i < size; ++i) {
                    KtCatchClause clause = clauses.get(i);
                    Label clauseStart = new Label();
                    v.mark(clauseStart);
                    VariableDescriptor descriptor2 = ExpressionCodegen.this.bindingContext.get(BindingContext.VALUE_PARAMETER, clause.getCatchParameter());
                    assert (descriptor2 != null);
                    Type descriptorType = ExpressionCodegen.this.asmType(descriptor2.getType());
                    ExpressionCodegen.this.myFrameMap.enter(descriptor2, descriptorType);
                    int index2 = ExpressionCodegen.this.lookupLocalIndex(descriptor2);
                    v.store(index2, descriptorType);
                    ExpressionCodegen.this.gen(clause.getCatchBody(), expectedAsmType);
                    if (!isStatement) {
                        v.store(savedValue, expectedAsmType);
                    }
                    ExpressionCodegen.this.myFrameMap.leave(descriptor2);
                    Label clauseEnd = new Label();
                    v.mark(clauseEnd);
                    v.visitLocalVariable(descriptor2.getName().asString(), descriptorType.getDescriptor(), null, clauseStart, clauseEnd, index2);
                    ExpressionCodegen.this.genFinallyBlockOrGoto(finallyBlockStackElement, i != size - 1 || finallyBlock != null ? end : null, null);
                    ExpressionCodegen.this.generateExceptionTable(clauseStart, tryBlockRegions, descriptorType.getInternalName());
                }
                if (finallyBlock != null) {
                    Label defaultCatchStart = new Label();
                    v.mark(defaultCatchStart);
                    int savedException = ExpressionCodegen.this.myFrameMap.enterTemp(AsmTypes.JAVA_THROWABLE_TYPE);
                    v.store(savedException, AsmTypes.JAVA_THROWABLE_TYPE);
                    Label defaultCatchEnd = new Label();
                    v.mark(defaultCatchEnd);
                    List defaultCatchRegions = ExpressionCodegen.getCurrentCatchIntervals(finallyBlockStackElement, tryStart, defaultCatchEnd);
                    ExpressionCodegen.this.genFinallyBlockOrGoto(finallyBlockStackElement, null, null);
                    v.load(savedException, AsmTypes.JAVA_THROWABLE_TYPE);
                    ExpressionCodegen.this.myFrameMap.leaveTemp(AsmTypes.JAVA_THROWABLE_TYPE);
                    v.athrow();
                    ExpressionCodegen.this.generateExceptionTable(defaultCatchStart, defaultCatchRegions, null);
                }
                ExpressionCodegen.this.markLineNumber(expression, isStatement);
                v.mark(end);
                if (!isStatement) {
                    v.load(savedValue, expectedAsmType);
                    ExpressionCodegen.this.myFrameMap.leaveTemp(expectedAsmType);
                }
                if (finallyBlock != null) {
                    ExpressionCodegen.this.blockStackElements.pop();
                }
                return Unit.INSTANCE;
            }
        });
    }

    private void generateExceptionTable(@NotNull Label catchStart, @NotNull List<Label> catchedRegions, @Nullable String exception) {
        if (catchStart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "catchStart", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateExceptionTable"));
        }
        if (catchedRegions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "catchedRegions", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateExceptionTable"));
        }
        for (int i = 0; i < catchedRegions.size(); i += 2) {
            Label startRegion = catchedRegions.get(i);
            Label endRegion = catchedRegions.get(i + 1);
            this.v.visitTryCatchBlock(startRegion, endRegion, catchStart, exception);
        }
    }

    @NotNull
    private static List<Label> getCurrentCatchIntervals(@Nullable FinallyBlockStackElement finallyBlockStackElement, @NotNull Label blockStart, @NotNull Label blockEnd) {
        ArrayList<Label> gapsInBlock;
        if (blockStart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockStart", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getCurrentCatchIntervals"));
        }
        if (blockEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockEnd", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getCurrentCatchIntervals"));
        }
        ArrayList<Label> arrayList = gapsInBlock = finallyBlockStackElement != null ? new ArrayList<Label>(finallyBlockStackElement.gaps) : Collections.emptyList();
        assert (gapsInBlock.size() % 2 == 0);
        ArrayList<Label> blockRegions = new ArrayList<Label>(gapsInBlock.size() + 2);
        blockRegions.add(blockStart);
        blockRegions.addAll(gapsInBlock);
        blockRegions.add(blockEnd);
        ArrayList<Label> arrayList2 = blockRegions;
        if (arrayList2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getCurrentCatchIntervals"));
        }
        return arrayList2;
    }

    @Override
    public StackValue visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitBinaryWithTypeRHSExpression"));
        }
        KtExpression left = expression.getLeft();
        final IElementType opToken = expression.getOperationReference().getReferencedNameElementType();
        final KotlinType rightType = this.bindingContext.get(BindingContext.TYPE, expression.getRight());
        assert (rightType != null);
        final StackValue value = this.genQualified(receiver, left);
        return StackValue.operation(AsmUtil.boxType(this.asmType(rightType)), new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                value.put(AsmUtil.boxType(value.type), v);
                if (value.type == Type.VOID_TYPE) {
                    StackValue.putUnitInstance(v);
                }
                boolean safeAs = opToken == KtTokens.AS_SAFE;
                Type type2 = AsmUtil.boxType(ExpressionCodegen.this.asmType(rightType));
                if (TypeUtils.isReifiedTypeParameter(rightType)) {
                    ExpressionCodegen.this.putReifiedOperationMarkerIfTypeIsReifiedParameter(rightType, safeAs ? ReifiedTypeInliner.OperationKind.SAFE_AS : ReifiedTypeInliner.OperationKind.AS);
                    v.checkcast(type2);
                    return Unit.INSTANCE;
                }
                CodegenUtilKt.generateAsCast(v, rightType, type2, safeAs);
                return Unit.INSTANCE;
            }
        });
    }

    @Override
    public StackValue visitIsExpression(@NotNull KtIsExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitIsExpression"));
        }
        StackValue match2 = StackValue.expression(AsmTypes.OBJECT_TYPE, expression.getLeftHandSide(), this);
        return this.generateIsCheck(match2, expression.getTypeReference(), expression.isNegated());
    }

    private StackValue generateExpressionMatch(StackValue expressionToMatch, KtExpression patternExpression) {
        if (expressionToMatch != null) {
            Type condType;
            Type subjectType = expressionToMatch.type;
            this.markStartLineNumber(patternExpression);
            KotlinType condJetType = this.bindingContext.getType(patternExpression);
            if (AsmUtil.isNumberPrimitive(subjectType) || subjectType.getSort() == 1) {
                assert (condJetType != null);
                condType = this.asmType(condJetType);
                if (!AsmUtil.isNumberPrimitive(condType) && condType.getSort() != 1) {
                    subjectType = AsmUtil.boxType(subjectType);
                }
            } else {
                condType = AsmTypes.OBJECT_TYPE;
            }
            StackValue condition = this.genLazy(patternExpression, condType);
            return AsmUtil.genEqualsForExpressionsOnStack(KtTokens.EQEQ, StackValue.coercion(expressionToMatch, subjectType), condition);
        }
        return this.gen(patternExpression);
    }

    private StackValue generateIsCheck(StackValue expressionToMatch, KtTypeReference typeReference, boolean negated) {
        KotlinType jetType = this.bindingContext.get(BindingContext.TYPE, typeReference);
        this.markStartLineNumber(typeReference);
        StackValue value = this.generateIsCheck(expressionToMatch, jetType, false);
        return negated ? StackValue.not(value) : value;
    }

    private StackValue generateIsCheck(final StackValue expressionToGen, final KotlinType kotlinType, final boolean leaveExpressionOnStack) {
        return StackValue.operation(Type.BOOLEAN_TYPE, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                expressionToGen.put(AsmTypes.OBJECT_TYPE, v);
                if (leaveExpressionOnStack) {
                    v.dup();
                }
                Type type2 = AsmUtil.boxType(ExpressionCodegen.this.asmType(kotlinType));
                if (TypeUtils.isReifiedTypeParameter(kotlinType)) {
                    ExpressionCodegen.this.putReifiedOperationMarkerIfTypeIsReifiedParameter(kotlinType, ReifiedTypeInliner.OperationKind.IS);
                    v.instanceOf(type2);
                    return null;
                }
                CodegenUtilKt.generateIsCheck(v, kotlinType, type2);
                return null;
            }
        });
    }

    public void putReifiedOperationMarkerIfTypeIsReifiedParameter(@NotNull KotlinType type2, @NotNull ReifiedTypeInliner.OperationKind operationKind) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putReifiedOperationMarkerIfTypeIsReifiedParameter"));
        }
        if (operationKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationKind", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putReifiedOperationMarkerIfTypeIsReifiedParameter"));
        }
        Pair<TypeParameterDescriptor, ReificationArgument> typeParameterAndReificationArgument = ExpressionCodegen.extractReificationArgument(type2);
        if (typeParameterAndReificationArgument != null && typeParameterAndReificationArgument.getFirst().isReified()) {
            TypeParameterDescriptor typeParameterDescriptor = typeParameterAndReificationArgument.getFirst();
            if (typeParameterDescriptor.getContainingDeclaration() != this.context.getContextDescriptor()) {
                this.parentCodegen.getReifiedTypeParametersUsages().addUsedReifiedParameter(typeParameterDescriptor.getName().asString());
            }
            this.v.iconst(operationKind.getId());
            this.v.visitLdcInsn(typeParameterAndReificationArgument.getSecond().asString());
            this.v.invokestatic("kotlin/jvm/internal/Intrinsics", "reifiedOperationMarker", Type.getMethodDescriptor(Type.VOID_TYPE, Type.INT_TYPE, Type.getType(String.class)), false);
        }
    }

    public void propagateChildReifiedTypeParametersUsages(@NotNull ReifiedTypeParametersUsages usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "propagateChildReifiedTypeParametersUsages"));
        }
        this.parentCodegen.getReifiedTypeParametersUsages().propagateChildUsagesWithinContext(usages, this.context);
    }

    @Override
    public StackValue visitWhenExpression(@NotNull KtWhenExpression expression, StackValue receiver) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitWhenExpression"));
        }
        return this.generateWhenExpression(expression, false);
    }

    public StackValue generateWhenExpression(final KtWhenExpression expression, final boolean isStatement) {
        final KtExpression expr = expression.getSubjectExpression();
        final Type subjectType = this.expressionType(expr);
        final Type resultType = isStatement ? Type.VOID_TYPE : this.expressionType(expression);
        return StackValue.operation(resultType, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                int subjectLocal;
                SwitchCodegen switchCodegen = SwitchCodegenUtil.buildAppropriateSwitchCodegenIfPossible(expression, isStatement, ExpressionCodegen.this.isExhaustive(expression, isStatement), ExpressionCodegen.this);
                if (switchCodegen != null) {
                    switchCodegen.generate();
                    return Unit.INSTANCE;
                }
                int n = subjectLocal = expr != null ? ExpressionCodegen.this.myFrameMap.enterTemp(subjectType) : -1;
                if (subjectLocal != -1) {
                    ExpressionCodegen.this.gen(expr, subjectType);
                    ExpressionCodegen.this.tempVariables.put(expr, StackValue.local(subjectLocal, subjectType));
                    v.store(subjectLocal, subjectType);
                }
                Label end = new Label();
                boolean hasElse = KtPsiUtil.checkWhenExpressionHasSingleElse(expression);
                Label nextCondition = null;
                for (KtWhenEntry whenEntry : expression.getEntries()) {
                    if (nextCondition != null) {
                        v.mark(nextCondition);
                    }
                    nextCondition = new Label();
                    FrameMap.Mark mark = ExpressionCodegen.this.myFrameMap.mark();
                    Label thisEntry = new Label();
                    if (!whenEntry.isElse()) {
                        KtWhenCondition[] conditions = whenEntry.getConditions();
                        for (int i = 0; i < conditions.length; ++i) {
                            StackValue conditionValue = ExpressionCodegen.this.generateWhenCondition(subjectType, subjectLocal, conditions[i]);
                            BranchedValue.Companion.condJump(conditionValue, nextCondition, true, v);
                            if (i >= conditions.length - 1) continue;
                            v.goTo(thisEntry);
                            v.mark(nextCondition);
                            nextCondition = new Label();
                        }
                    }
                    v.visitLabel(thisEntry);
                    ExpressionCodegen.this.gen(whenEntry.getExpression(), resultType);
                    mark.dropTo();
                    if (whenEntry.isElse()) continue;
                    v.goTo(end);
                }
                if (!hasElse && nextCondition != null) {
                    v.mark(nextCondition);
                    ExpressionCodegen.this.putUnitInstanceOntoStackForNonExhaustiveWhen(expression, isStatement);
                }
                ExpressionCodegen.this.markLineNumber(expression, isStatement);
                v.mark(end);
                ExpressionCodegen.this.myFrameMap.leaveTemp(subjectType);
                ExpressionCodegen.this.tempVariables.remove(expr);
                return null;
            }
        });
    }

    private boolean isExhaustive(@NotNull KtWhenExpression whenExpression, boolean isStatement) {
        if (whenExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whenExpression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "isExhaustive"));
        }
        if (isStatement) {
            return Boolean.TRUE.equals(this.bindingContext.get(BindingContext.IMPLICIT_EXHAUSTIVE_WHEN, whenExpression));
        }
        return Boolean.TRUE.equals(this.bindingContext.get(BindingContext.EXHAUSTIVE_WHEN, whenExpression));
    }

    public void putUnitInstanceOntoStackForNonExhaustiveWhen(@NotNull KtWhenExpression whenExpression, boolean isStatement) {
        if (whenExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whenExpression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putUnitInstanceOntoStackForNonExhaustiveWhen"));
        }
        if (this.isExhaustive(whenExpression, isStatement)) {
            AsmUtil.genThrow(this.v, "kotlin/NoWhenBranchMatchedException", null);
        } else if (!isStatement) {
            StackValue.putUnitInstance(this.v);
        }
    }

    private StackValue generateWhenCondition(Type subjectType, int subjectLocal, KtWhenCondition condition) {
        StackValue.Local match2;
        if (condition instanceof KtWhenConditionInRange) {
            KtWhenConditionInRange conditionInRange = (KtWhenConditionInRange)condition;
            return this.generateIn(StackValue.local(subjectLocal, subjectType), conditionInRange.getRangeExpression(), conditionInRange.getOperationReference());
        }
        StackValue.Local local = match2 = subjectLocal == -1 ? null : StackValue.local(subjectLocal, subjectType);
        if (condition instanceof KtWhenConditionIsPattern) {
            KtWhenConditionIsPattern patternCondition = (KtWhenConditionIsPattern)condition;
            return this.generateIsCheck((StackValue)match2, patternCondition.getTypeReference(), patternCondition.isNegated());
        }
        if (condition instanceof KtWhenConditionWithExpression) {
            KtExpression patternExpression = ((KtWhenConditionWithExpression)condition).getExpression();
            return this.generateExpressionMatch(match2, patternExpression);
        }
        throw new UnsupportedOperationException("unsupported kind of when condition");
    }

    private boolean isIntRangeExpr(KtExpression rangeExpression) {
        KtBinaryExpression binaryExpression;
        if (rangeExpression instanceof KtBinaryExpression && (binaryExpression = (KtBinaryExpression)rangeExpression).getOperationReference().getReferencedNameElementType() == KtTokens.RANGE) {
            KotlinType jetType = this.bindingContext.getType(rangeExpression);
            assert (jetType != null);
            ClassifierDescriptor descriptor2 = jetType.getConstructor().getDeclarationDescriptor();
            return DescriptorUtilsKt.getBuiltIns(descriptor2).getIntegralRanges().contains(descriptor2);
        }
        return false;
    }

    private Call makeFakeCall(ReceiverValue initializerAsReceiver) {
        KtSimpleNameExpression fake = KtPsiFactoryKt.KtPsiFactory(this.state.getProject()).createSimpleName("fake");
        return CallMaker.makeCall(fake, initializerAsReceiver);
    }

    public String toString() {
        return ((CallableMemberDescriptor)this.context.getContextDescriptor()).toString();
    }

    @NotNull
    public FrameMap getFrameMap() {
        FrameMap frameMap = this.myFrameMap;
        if (frameMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getFrameMap"));
        }
        return frameMap;
    }

    @NotNull
    public MethodContext getContext() {
        MethodContext methodContext = this.context;
        if (methodContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getContext"));
        }
        return methodContext;
    }

    @NotNull
    public NameGenerator getInlineNameGenerator() {
        NameGenerator nameGenerator = this.getParentCodegen().getInlineNameGenerator();
        Name name = ((CallableMemberDescriptor)this.context.getContextDescriptor()).getName();
        NameGenerator nameGenerator2 = nameGenerator.subGenerator((name.isSpecial() ? "$special" : name.asString()) + "$$inlined");
        if (nameGenerator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getInlineNameGenerator"));
        }
        return nameGenerator2;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public Stack<BlockStackElement> getBlockStackElements() {
        return new Stack<BlockStackElement>((Collection<BlockStackElement>)this.blockStackElements);
    }

    public void addBlockStackElementsForNonLocalReturns(@NotNull Stack<BlockStackElement> elements, int finallyDepth) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "addBlockStackElementsForNonLocalReturns"));
        }
        this.blockStackElements.addAll(elements);
        this.finallyDepth = finallyDepth;
    }

    private static class NonLocalReturnInfo {
        final Type returnType;
        final String labelName;

        private NonLocalReturnInfo(Type type2, String name) {
            this.returnType = type2;
            this.labelName = name;
        }
    }

    private class ForInProgressionExpressionLoopGenerator
    extends AbstractForInProgressionOrRangeLoopGenerator {
        private int incrementVar;
        private Type incrementType;

        private ForInProgressionExpressionLoopGenerator(@NotNull KtForExpression forExpression) {
            if (forExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forExpression", "org/jetbrains/kotlin/codegen/ExpressionCodegen$ForInProgressionExpressionLoopGenerator", "<init>"));
            }
            super(forExpression);
        }

        @Override
        public void beforeLoop() {
            super.beforeLoop();
            this.incrementVar = this.createLoopTempVariable(this.asmElementType);
            KotlinType loopRangeType = ExpressionCodegen.this.bindingContext.getType(this.forExpression.getLoopRange());
            assert (loopRangeType != null);
            Type asmLoopRangeType = ExpressionCodegen.this.asmType(loopRangeType);
            Collection<PropertyDescriptor> incrementProp = loopRangeType.getMemberScope().getContributedVariables(Name.identifier("step"), NoLookupLocation.FROM_BACKEND);
            assert (incrementProp.size() == 1) : loopRangeType + " " + incrementProp.size();
            this.incrementType = ExpressionCodegen.this.asmType(incrementProp.iterator().next().getType());
            ExpressionCodegen.this.gen(this.forExpression.getLoopRange(), asmLoopRangeType);
            ExpressionCodegen.this.v.dup();
            ExpressionCodegen.this.v.dup();
            this.generateRangeOrProgressionProperty(asmLoopRangeType, "getFirst", this.asmElementType, this.loopParameterVar);
            this.generateRangeOrProgressionProperty(asmLoopRangeType, "getLast", this.asmElementType, this.endVar);
            this.generateRangeOrProgressionProperty(asmLoopRangeType, "getStep", this.incrementType, this.incrementVar);
        }

        @Override
        public void checkEmptyLoop(@NotNull Label loopExit) {
            if (loopExit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopExit", "org/jetbrains/kotlin/codegen/ExpressionCodegen$ForInProgressionExpressionLoopGenerator", "checkEmptyLoop"));
            }
            ExpressionCodegen.this.v.load(this.loopParameterVar, this.asmElementType);
            ExpressionCodegen.this.v.load(this.endVar, this.asmElementType);
            ExpressionCodegen.this.v.load(this.incrementVar, this.incrementType);
            Label negativeIncrement = new Label();
            Label afterIf = new Label();
            if (this.asmElementType.getSort() == 7) {
                ExpressionCodegen.this.v.lconst(0L);
                ExpressionCodegen.this.v.lcmp();
                ExpressionCodegen.this.v.ifle(negativeIncrement);
                ExpressionCodegen.this.v.lcmp();
                ExpressionCodegen.this.v.ifgt(loopExit);
                ExpressionCodegen.this.v.goTo(afterIf);
                ExpressionCodegen.this.v.mark(negativeIncrement);
                ExpressionCodegen.this.v.lcmp();
                ExpressionCodegen.this.v.iflt(loopExit);
                ExpressionCodegen.this.v.mark(afterIf);
            } else {
                ExpressionCodegen.this.v.ifle(negativeIncrement);
                ExpressionCodegen.this.v.ificmpgt(loopExit);
                ExpressionCodegen.this.v.goTo(afterIf);
                ExpressionCodegen.this.v.mark(negativeIncrement);
                ExpressionCodegen.this.v.ificmplt(loopExit);
                ExpressionCodegen.this.v.mark(afterIf);
            }
        }

        @Override
        protected void assignToLoopParameter() {
        }

        @Override
        protected void increment(@NotNull Label loopExit) {
            if (loopExit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopExit", "org/jetbrains/kotlin/codegen/ExpressionCodegen$ForInProgressionExpressionLoopGenerator", "increment"));
            }
            this.checkPostCondition(loopExit);
            ExpressionCodegen.this.v.load(this.loopParameterVar, this.asmElementType);
            ExpressionCodegen.this.v.load(this.incrementVar, this.asmElementType);
            ExpressionCodegen.this.v.add(this.asmElementType);
            if (this.asmElementType == Type.BYTE_TYPE || this.asmElementType == Type.SHORT_TYPE || this.asmElementType == Type.CHAR_TYPE) {
                StackValue.coerce(Type.INT_TYPE, this.asmElementType, ExpressionCodegen.this.v);
            }
            ExpressionCodegen.this.v.store(this.loopParameterVar, this.asmElementType);
        }
    }

    private class ForInRangeInstanceLoopGenerator
    extends AbstractForInRangeLoopGenerator {
        private ForInRangeInstanceLoopGenerator(@NotNull KtForExpression forExpression) {
            if (forExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forExpression", "org/jetbrains/kotlin/codegen/ExpressionCodegen$ForInRangeInstanceLoopGenerator", "<init>"));
            }
            super(forExpression);
        }

        @Override
        protected void storeRangeStartAndEnd() {
            KotlinType loopRangeType = ExpressionCodegen.this.bindingContext.getType(this.forExpression.getLoopRange());
            assert (loopRangeType != null);
            Type asmLoopRangeType = ExpressionCodegen.this.asmType(loopRangeType);
            ExpressionCodegen.this.gen(this.forExpression.getLoopRange(), asmLoopRangeType);
            ExpressionCodegen.this.v.dup();
            this.generateRangeOrProgressionProperty(asmLoopRangeType, "getFirst", this.asmElementType, this.loopParameterVar);
            this.generateRangeOrProgressionProperty(asmLoopRangeType, "getLast", this.asmElementType, this.endVar);
        }
    }

    private class ForInRangeLiteralLoopGenerator
    extends AbstractForInRangeLoopGenerator {
        private final RangeCodegenUtil.BinaryCall rangeCall;

        private ForInRangeLiteralLoopGenerator(@NotNull KtForExpression forExpression, @NotNull RangeCodegenUtil.BinaryCall rangeCall) {
            if (forExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forExpression", "org/jetbrains/kotlin/codegen/ExpressionCodegen$ForInRangeLiteralLoopGenerator", "<init>"));
            }
            if (rangeCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen$ForInRangeLiteralLoopGenerator", "<init>"));
            }
            super(forExpression);
            this.rangeCall = rangeCall;
        }

        @Override
        protected void storeRangeStartAndEnd() {
            ExpressionCodegen.this.gen(this.rangeCall.left, this.asmElementType);
            ExpressionCodegen.this.v.store(this.loopParameterVar, this.asmElementType);
            ExpressionCodegen.this.gen(this.rangeCall.right, this.asmElementType);
            ExpressionCodegen.this.v.store(this.endVar, this.asmElementType);
        }
    }

    private abstract class AbstractForInRangeLoopGenerator
    extends AbstractForInProgressionOrRangeLoopGenerator {
        private AbstractForInRangeLoopGenerator(@NotNull KtForExpression forExpression) {
            if (forExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forExpression", "org/jetbrains/kotlin/codegen/ExpressionCodegen$AbstractForInRangeLoopGenerator", "<init>"));
            }
            super(forExpression);
        }

        @Override
        public void beforeLoop() {
            super.beforeLoop();
            this.storeRangeStartAndEnd();
        }

        protected abstract void storeRangeStartAndEnd();

        @Override
        public void checkEmptyLoop(@NotNull Label loopExit) {
            if (loopExit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopExit", "org/jetbrains/kotlin/codegen/ExpressionCodegen$AbstractForInRangeLoopGenerator", "checkEmptyLoop"));
            }
            ExpressionCodegen.this.v.load(this.loopParameterVar, this.asmElementType);
            ExpressionCodegen.this.v.load(this.endVar, this.asmElementType);
            if (this.asmElementType.getSort() == 7) {
                ExpressionCodegen.this.v.lcmp();
                ExpressionCodegen.this.v.ifgt(loopExit);
            } else {
                ExpressionCodegen.this.v.ificmpgt(loopExit);
            }
        }

        @Override
        protected void assignToLoopParameter() {
        }

        @Override
        protected void increment(@NotNull Label loopExit) {
            if (loopExit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopExit", "org/jetbrains/kotlin/codegen/ExpressionCodegen$AbstractForInRangeLoopGenerator", "increment"));
            }
            this.checkPostCondition(loopExit);
            if (this.asmElementType == Type.INT_TYPE) {
                ExpressionCodegen.this.v.iinc(this.loopParameterVar, 1);
            } else {
                ExpressionCodegen.this.v.load(this.loopParameterVar, this.asmElementType);
                AsmUtil.genIncrement(this.asmElementType, 1, ExpressionCodegen.this.v);
                ExpressionCodegen.this.v.store(this.loopParameterVar, this.asmElementType);
            }
        }
    }

    private abstract class AbstractForInProgressionOrRangeLoopGenerator
    extends AbstractForLoopGenerator {
        protected int endVar;

        private AbstractForInProgressionOrRangeLoopGenerator(@NotNull KtForExpression forExpression) {
            if (forExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forExpression", "org/jetbrains/kotlin/codegen/ExpressionCodegen$AbstractForInProgressionOrRangeLoopGenerator", "<init>"));
            }
            super(forExpression);
            switch (this.asmElementType.getSort()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected range element type: " + this.asmElementType);
                }
            }
        }

        @Override
        public void beforeLoop() {
            super.beforeLoop();
            this.endVar = this.createLoopTempVariable(this.asmElementType);
        }

        protected void checkPostCondition(@NotNull Label loopExit) {
            if (loopExit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopExit", "org/jetbrains/kotlin/codegen/ExpressionCodegen$AbstractForInProgressionOrRangeLoopGenerator", "checkPostCondition"));
            }
            assert (this.endVar != -1) : "endVar must be allocated, endVar = " + this.endVar;
            ExpressionCodegen.this.v.load(this.loopParameterVar, this.asmElementType);
            ExpressionCodegen.this.v.load(this.endVar, this.asmElementType);
            if (this.asmElementType.getSort() == 7) {
                ExpressionCodegen.this.v.lcmp();
                ExpressionCodegen.this.v.ifeq(loopExit);
            } else {
                ExpressionCodegen.this.v.ificmpeq(loopExit);
            }
        }

        @Override
        public void checkPreCondition(@NotNull Label loopExit) {
            if (loopExit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopExit", "org/jetbrains/kotlin/codegen/ExpressionCodegen$AbstractForInProgressionOrRangeLoopGenerator", "checkPreCondition"));
            }
        }
    }

    private class ForInArrayLoopGenerator
    extends AbstractForLoopGenerator {
        private int indexVar;
        private int arrayVar;
        private final KotlinType loopRangeType;

        private ForInArrayLoopGenerator(@NotNull KtForExpression forExpression) {
            if (forExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forExpression", "org/jetbrains/kotlin/codegen/ExpressionCodegen$ForInArrayLoopGenerator", "<init>"));
            }
            super(forExpression);
            this.loopRangeType = ExpressionCodegen.this.bindingContext.getType(forExpression.getLoopRange());
        }

        @Override
        public void beforeLoop() {
            super.beforeLoop();
            this.indexVar = this.createLoopTempVariable(Type.INT_TYPE);
            KtExpression loopRange = this.forExpression.getLoopRange();
            StackValue value = ExpressionCodegen.this.gen(loopRange);
            Type asmLoopRangeType = ExpressionCodegen.this.asmType(this.loopRangeType);
            if (value instanceof StackValue.Local && value.type.equals(asmLoopRangeType)) {
                this.arrayVar = ((StackValue.Local)value).index;
            } else {
                this.arrayVar = this.createLoopTempVariable(AsmTypes.OBJECT_TYPE);
                value.put(asmLoopRangeType, ExpressionCodegen.this.v);
                ExpressionCodegen.this.v.store(this.arrayVar, AsmTypes.OBJECT_TYPE);
            }
            ExpressionCodegen.this.v.iconst(0);
            ExpressionCodegen.this.v.store(this.indexVar, Type.INT_TYPE);
        }

        @Override
        public void checkEmptyLoop(@NotNull Label loopExit) {
            if (loopExit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopExit", "org/jetbrains/kotlin/codegen/ExpressionCodegen$ForInArrayLoopGenerator", "checkEmptyLoop"));
            }
        }

        @Override
        public void checkPreCondition(@NotNull Label loopExit) {
            if (loopExit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopExit", "org/jetbrains/kotlin/codegen/ExpressionCodegen$ForInArrayLoopGenerator", "checkPreCondition"));
            }
            ExpressionCodegen.this.v.load(this.indexVar, Type.INT_TYPE);
            ExpressionCodegen.this.v.load(this.arrayVar, AsmTypes.OBJECT_TYPE);
            ExpressionCodegen.this.v.arraylength();
            ExpressionCodegen.this.v.ificmpge(loopExit);
        }

        @Override
        protected void assignToLoopParameter() {
            Type arrayElParamType = KotlinBuiltIns.isArray(this.loopRangeType) ? AsmUtil.boxType(this.asmElementType) : this.asmElementType;
            ExpressionCodegen.this.v.load(this.arrayVar, AsmTypes.OBJECT_TYPE);
            ExpressionCodegen.this.v.load(this.indexVar, Type.INT_TYPE);
            ExpressionCodegen.this.v.aload(arrayElParamType);
            StackValue.onStack(arrayElParamType).put(this.asmElementType, ExpressionCodegen.this.v);
            ExpressionCodegen.this.v.store(this.loopParameterVar, this.asmElementType);
        }

        @Override
        protected void increment(@NotNull Label loopExit) {
            if (loopExit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopExit", "org/jetbrains/kotlin/codegen/ExpressionCodegen$ForInArrayLoopGenerator", "increment"));
            }
            ExpressionCodegen.this.v.iinc(this.indexVar, 1);
        }
    }

    private class IteratorForLoopGenerator
    extends AbstractForLoopGenerator {
        private int iteratorVarIndex;
        private final ResolvedCall<FunctionDescriptor> iteratorCall;
        private final ResolvedCall<FunctionDescriptor> nextCall;
        private final Type asmTypeForIterator;

        private IteratorForLoopGenerator(@NotNull KtForExpression forExpression) {
            if (forExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forExpression", "org/jetbrains/kotlin/codegen/ExpressionCodegen$IteratorForLoopGenerator", "<init>"));
            }
            super(forExpression);
            KtExpression loopRange = forExpression.getLoopRange();
            assert (loopRange != null);
            this.iteratorCall = BindingContextUtils.getNotNull(ExpressionCodegen.this.bindingContext, BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, loopRange, "No .iterator() function " + DiagnosticUtils.atLocation(loopRange));
            KotlinType iteratorType = this.iteratorCall.getResultingDescriptor().getReturnType();
            assert (iteratorType != null);
            this.asmTypeForIterator = ExpressionCodegen.this.asmType(iteratorType);
            this.nextCall = BindingContextUtils.getNotNull(ExpressionCodegen.this.bindingContext, BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, loopRange, "No next() function " + DiagnosticUtils.atLocation(loopRange));
        }

        @Override
        public void beforeLoop() {
            super.beforeLoop();
            this.iteratorVarIndex = this.createLoopTempVariable(this.asmTypeForIterator);
            StackValue.local(this.iteratorVarIndex, this.asmTypeForIterator).store(ExpressionCodegen.this.invokeFunction(this.iteratorCall, StackValue.none()), ExpressionCodegen.this.v);
        }

        @Override
        public void checkEmptyLoop(@NotNull Label loopExit) {
            if (loopExit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopExit", "org/jetbrains/kotlin/codegen/ExpressionCodegen$IteratorForLoopGenerator", "checkEmptyLoop"));
            }
        }

        @Override
        public void checkPreCondition(@NotNull Label loopExit) {
            if (loopExit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopExit", "org/jetbrains/kotlin/codegen/ExpressionCodegen$IteratorForLoopGenerator", "checkPreCondition"));
            }
            KtExpression loopRange = this.forExpression.getLoopRange();
            ResolvedCall<FunctionDescriptor> hasNextCall = BindingContextUtils.getNotNull(ExpressionCodegen.this.bindingContext, BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, loopRange, "No hasNext() function " + DiagnosticUtils.atLocation(loopRange));
            Call fakeCall = ExpressionCodegen.this.makeFakeCall(new TransientReceiver(this.iteratorCall.getResultingDescriptor().getReturnType()));
            StackValue result2 = ExpressionCodegen.this.invokeFunction(fakeCall, hasNextCall, StackValue.local(this.iteratorVarIndex, this.asmTypeForIterator));
            result2.put(result2.type, ExpressionCodegen.this.v);
            FunctionDescriptor hasNext = hasNextCall.getResultingDescriptor();
            KotlinType type2 = hasNext.getReturnType();
            assert (type2 != null && KotlinTypeChecker.DEFAULT.isSubtypeOf(type2, DescriptorUtilsKt.getBuiltIns(hasNext).getBooleanType()));
            Type asmType = ExpressionCodegen.this.asmType(type2);
            StackValue.coerce(asmType, Type.BOOLEAN_TYPE, ExpressionCodegen.this.v);
            ExpressionCodegen.this.v.ifeq(loopExit);
        }

        @Override
        protected void assignToLoopParameter() {
            Call fakeCall = ExpressionCodegen.this.makeFakeCall(new TransientReceiver(this.iteratorCall.getResultingDescriptor().getReturnType()));
            StackValue value = ExpressionCodegen.this.invokeFunction(fakeCall, this.nextCall, StackValue.local(this.iteratorVarIndex, this.asmTypeForIterator));
            StackValue.local(this.loopParameterVar, ExpressionCodegen.this.asmType(this.nextCall.getResultingDescriptor().getReturnType())).store(value, ExpressionCodegen.this.v);
        }

        @Override
        protected void increment(@NotNull Label loopExit) {
            if (loopExit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopExit", "org/jetbrains/kotlin/codegen/ExpressionCodegen$IteratorForLoopGenerator", "increment"));
            }
        }
    }

    private abstract class AbstractForLoopGenerator {
        protected final KtForExpression forExpression;
        private final Label bodyStart;
        private final Label bodyEnd;
        private final List<Runnable> leaveVariableTasks;
        protected final KotlinType elementType;
        protected final Type asmElementType;
        protected int loopParameterVar;

        private AbstractForLoopGenerator(@NotNull KtForExpression forExpression) {
            if (forExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forExpression", "org/jetbrains/kotlin/codegen/ExpressionCodegen$AbstractForLoopGenerator", "<init>"));
            }
            this.bodyStart = new Label();
            this.bodyEnd = new Label();
            this.leaveVariableTasks = Lists.newArrayList();
            this.forExpression = forExpression;
            this.elementType = this.getElementType(forExpression);
            this.asmElementType = ExpressionCodegen.this.asmType(this.elementType);
        }

        @NotNull
        private KotlinType getElementType(KtForExpression forExpression) {
            KtExpression loopRange = forExpression.getLoopRange();
            assert (loopRange != null);
            ResolvedCall<FunctionDescriptor> nextCall = BindingContextUtils.getNotNull(ExpressionCodegen.this.bindingContext, BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, loopRange, "No next() function " + DiagnosticUtils.atLocation(loopRange));
            KotlinType kotlinType = nextCall.getResultingDescriptor().getReturnType();
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen$AbstractForLoopGenerator", "getElementType"));
            }
            return kotlinType;
        }

        public void beforeLoop() {
            KtParameter loopParameter = this.forExpression.getLoopParameter();
            if (loopParameter != null) {
                final VariableDescriptor parameterDescriptor = ExpressionCodegen.this.bindingContext.get(BindingContext.VALUE_PARAMETER, loopParameter);
                final Type asmTypeForParameter = ExpressionCodegen.this.asmType(parameterDescriptor.getType());
                this.loopParameterVar = ExpressionCodegen.this.myFrameMap.enter(parameterDescriptor, asmTypeForParameter);
                this.scheduleLeaveVariable(new Runnable(){

                    @Override
                    public void run() {
                        ExpressionCodegen.this.myFrameMap.leave(parameterDescriptor);
                        ExpressionCodegen.this.v.visitLocalVariable(parameterDescriptor.getName().asString(), asmTypeForParameter.getDescriptor(), null, AbstractForLoopGenerator.this.bodyStart, AbstractForLoopGenerator.this.bodyEnd, AbstractForLoopGenerator.this.loopParameterVar);
                    }
                });
            } else {
                KtDestructuringDeclaration multiParameter = this.forExpression.getDestructuringParameter();
                assert (multiParameter != null);
                this.loopParameterVar = this.createLoopTempVariable(this.asmElementType);
            }
        }

        public abstract void checkEmptyLoop(@NotNull Label var1);

        public abstract void checkPreCondition(@NotNull Label var1);

        public void beforeBody() {
            ExpressionCodegen.this.v.mark(this.bodyStart);
            this.assignToLoopParameter();
            if (this.forExpression.getLoopParameter() == null) {
                KtDestructuringDeclaration multiParameter = this.forExpression.getDestructuringParameter();
                assert (multiParameter != null);
                this.generateMultiVariables(multiParameter.getEntries());
            }
        }

        private void generateMultiVariables(List<KtDestructuringDeclarationEntry> entries) {
            for (KtDestructuringDeclarationEntry variableDeclaration : entries) {
                final VariableDescriptor componentDescriptor = ExpressionCodegen.this.bindingContext.get(BindingContext.VARIABLE, variableDeclaration);
                final Type componentAsmType = ExpressionCodegen.this.asmType(componentDescriptor.getReturnType());
                final int componentVarIndex = ExpressionCodegen.this.myFrameMap.enter(componentDescriptor, componentAsmType);
                final Label variableStartLabel = new Label();
                this.scheduleLeaveVariable(new Runnable(){

                    @Override
                    public void run() {
                        ExpressionCodegen.this.myFrameMap.leave(componentDescriptor);
                        ExpressionCodegen.this.v.visitLocalVariable(componentDescriptor.getName().asString(), componentAsmType.getDescriptor(), null, variableStartLabel, AbstractForLoopGenerator.this.bodyEnd, componentVarIndex);
                    }
                });
                ResolvedCall<FunctionDescriptor> resolvedCall = ExpressionCodegen.this.bindingContext.get(BindingContext.COMPONENT_RESOLVED_CALL, variableDeclaration);
                assert (resolvedCall != null) : "Resolved call is null for " + variableDeclaration.getText();
                Call call = ExpressionCodegen.this.makeFakeCall(new TransientReceiver(this.elementType));
                StackValue value = ExpressionCodegen.this.invokeFunction(call, resolvedCall, StackValue.local(this.loopParameterVar, this.asmElementType));
                StackValue.local(componentVarIndex, componentAsmType).store(value, ExpressionCodegen.this.v);
                ExpressionCodegen.this.v.visitLabel(variableStartLabel);
            }
        }

        protected abstract void assignToLoopParameter();

        protected abstract void increment(@NotNull Label var1);

        public void body() {
            ExpressionCodegen.this.generateLoopBody(this.forExpression.getBody());
        }

        private void scheduleLeaveVariable(Runnable runnable) {
            this.leaveVariableTasks.add(runnable);
        }

        protected int createLoopTempVariable(final Type type2) {
            int varIndex = ExpressionCodegen.this.myFrameMap.enterTemp(type2);
            this.scheduleLeaveVariable(new Runnable(){

                @Override
                public void run() {
                    ExpressionCodegen.this.myFrameMap.leaveTemp(type2);
                }
            });
            return varIndex;
        }

        public void afterBody(@NotNull Label loopExit) {
            if (loopExit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopExit", "org/jetbrains/kotlin/codegen/ExpressionCodegen$AbstractForLoopGenerator", "afterBody"));
            }
            ExpressionCodegen.this.markStartLineNumber(this.forExpression);
            this.increment(loopExit);
            ExpressionCodegen.this.v.mark(this.bodyEnd);
        }

        public void afterLoop() {
            for (Runnable task : Lists.reverse(this.leaveVariableTasks)) {
                task.run();
            }
        }

        protected void generateRangeOrProgressionProperty(Type loopRangeType, String getterName, Type elementType, int varToStore) {
            ExpressionCodegen.this.v.invokevirtual(loopRangeType.getInternalName(), getterName, "()" + elementType.getDescriptor(), false);
            ExpressionCodegen.this.v.store(varToStore, elementType);
        }
    }

    private static class ObjectLiteralResult {
        private final boolean wereReifiedMarkers;
        private final ClassDescriptor classDescriptor;

        public ObjectLiteralResult(boolean wereReifiedMarkers, @NotNull ClassDescriptor classDescriptor) {
            if (classDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen$ObjectLiteralResult", "<init>"));
            }
            this.wereReifiedMarkers = wereReifiedMarkers;
            this.classDescriptor = classDescriptor;
        }
    }

    static class FinallyBlockStackElement
    extends BlockStackElement {
        List<Label> gaps = new ArrayList<Label>();
        final KtTryExpression expression;

        FinallyBlockStackElement(KtTryExpression expression) {
            this.expression = expression;
        }

        private void addGapLabel(Label label) {
            this.gaps.add(label);
        }
    }

    static class LoopBlockStackElement
    extends BlockStackElement {
        final Label continueLabel;
        final Label breakLabel;
        public final KtSimpleNameExpression targetLabel;

        LoopBlockStackElement(Label breakLabel, Label continueLabel, KtSimpleNameExpression targetLabel) {
            this.breakLabel = breakLabel;
            this.continueLabel = continueLabel;
            this.targetLabel = targetLabel;
        }
    }

    static class BlockStackElement {
        BlockStackElement() {
        }
    }
}

