/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.common.FileSystem$WhenMappings;
import org.jetbrains.kotlin.daemon.common.FileSystemUtilsKt;
import org.jetbrains.kotlin.daemon.common.OSKind;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\r\u001a\u00020\u00042\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000f\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/daemon/common/FileSystem;", "", "()V", "logFilesPath", "", "getLogFilesPath", "()Ljava/lang/String;", "runtimeStateFilesBasePath", "getRuntimeStateFilesBasePath", "tempPath", "getTempPath", "userHomePath", "getUserHomePath", "getRuntimeStateFilesPath", "names", "", "([Ljava/lang/String;)Ljava/lang/String;", "kotlin-compiler"})
@KotlinClass(version={1, 1, 0}, data={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\r\u001a\u00020\u00042\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000f\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0011"}, strings={"Lorg/jetbrains/kotlin/daemon/common/FileSystem;", "", "()V", "logFilesPath", "", "getLogFilesPath", "()Ljava/lang/String;", "runtimeStateFilesBasePath", "getRuntimeStateFilesBasePath", "tempPath", "getTempPath", "userHomePath", "getUserHomePath", "getRuntimeStateFilesPath", "names", "", "([Ljava/lang/String;)Ljava/lang/String;", "kotlin-compiler"})
public final class FileSystem {
    public static final FileSystem INSTANCE;

    @NotNull
    public final String getUserHomePath() {
        String string = System.getProperty("user.home");
        Intrinsics.checkExpressionValueIsNotNull(string, "System.getProperty(\"user.home\")");
        return string;
    }

    @NotNull
    public final String getTempPath() {
        String string = System.getProperty("java.io.tmpdir");
        Intrinsics.checkExpressionValueIsNotNull(string, "System.getProperty(\"java.io.tmpdir\")");
        return string;
    }

    @NotNull
    public final String getLogFilesPath() {
        return this.getTempPath();
    }

    @NotNull
    public final String getRuntimeStateFilesBasePath() {
        String string;
        switch (FileSystem$WhenMappings.$EnumSwitchMapping$0[OSKind.Companion.getCurrent().ordinal()]) {
            case 1: {
                string = FileSystemUtilsKt.access$orDefault(System.getenv("LOCALAPPDATA"), this.getTempPath());
                break;
            }
            case 2: {
                string = this.getUserHomePath() + "/Library/Application Support";
                break;
            }
            case 3: {
                string = FileSystemUtilsKt.access$orDefault(System.getenv("XDG_DATA_HOME"), this.getUserHomePath() + "/.local/share");
                break;
            }
            case 4: {
                string = this.getTempPath();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getRuntimeStateFilesPath(String ... names2) {
        String string;
        File dir;
        File file;
        Object r;
        Iterable $receiver$iv;
        Object accumulator$iv;
        Unit unit;
        Intrinsics.checkParameterIsNotNull(names2, "names");
        boolean value$iv = ArraysKt.any((Object[])names2);
        if (_Assertions.ENABLED) {
            void value$iv$iv;
            if (value$iv$iv == false) {
                String message$iv$iv = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)message$iv$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        File base = new File(this.getRuntimeStateFilesBasePath());
        if (base.exists() && base.isDirectory()) {
            void initial$iv;
            Object[] $i$f$assert = names2;
            accumulator$iv = initial$iv;
            for (int i = 0; i < ((Iterable)$receiver$iv).length; ++i) {
                void v;
                Iterable element$iv = $receiver$iv[i];
                String string2 = (String)((Object)element$iv);
                r = (File)accumulator$iv;
                accumulator$iv = new File((File)r, (String)v);
            }
            file = (File)accumulator$iv;
        } else {
            void initial$iv;
            File $receiver$iv2;
            File file2;
            $receiver$iv = ArraysKt.drop((Object[])names2, 1);
            accumulator$iv = ArraysKt.first((Object[])names2);
            String string3 = this.getUserHomePath();
            File file3 = file2;
            File file4 = file2;
            String it = (String)((Object)$receiver$iv2);
            String string4 = StringsKt.startsWith$default(it, ".", false, 2, null) ? it : "." + it;
            file3(string3, string4);
            $receiver$iv2 = file4;
            File accumulator$iv2 = initial$iv;
            for (Object element$iv : $receiver$iv) {
                void v;
                r = (String)element$iv;
                File r2 = accumulator$iv2;
                accumulator$iv2 = new File(r2, (String)v);
            }
            file = dir = (File)accumulator$iv2;
        }
        if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
            String string5 = dir.getAbsolutePath();
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull(string5, "dir.absolutePath");
        } else {
            string = this.getTempPath();
        }
        return string;
    }

    private FileSystem() {
        INSTANCE = this;
    }

    static {
        new FileSystem();
    }
}

