/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0013H\u0096\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/descriptors/annotations/FilteredAnnotations;", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "delegate", "fqNameFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/FqName;", "", "(Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;Lkotlin/jvm/functions/Function1;)V", "findAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "fqName", "findExternalAnnotation", "getAllAnnotations", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationWithTarget;", "getUseSiteTargetedAnnotations", "hasAnnotation", "isEmpty", "iterator", "", "shouldBeReturned", "annotation", "kotlin-compiler"})
@KotlinClass(version={1, 1, 0}, data={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0013H\u0096\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, strings={"Lorg/jetbrains/kotlin/descriptors/annotations/FilteredAnnotations;", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "delegate", "fqNameFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/FqName;", "", "(Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;Lkotlin/jvm/functions/Function1;)V", "findAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "fqName", "findExternalAnnotation", "getAllAnnotations", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationWithTarget;", "getUseSiteTargetedAnnotations", "hasAnnotation", "isEmpty", "iterator", "", "shouldBeReturned", "annotation", "kotlin-compiler"})
public final class FilteredAnnotations
implements Annotations {
    private final Annotations delegate;
    private final Function1<FqName, Boolean> fqNameFilter;

    @Override
    public boolean hasAnnotation(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return this.fqNameFilter.invoke(fqName2) != false ? this.delegate.hasAnnotation(fqName2) : false;
    }

    @Override
    @Nullable
    public AnnotationDescriptor findAnnotation(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return this.fqNameFilter.invoke(fqName2) != false ? this.delegate.findAnnotation(fqName2) : (AnnotationDescriptor)null;
    }

    @Override
    @Nullable
    public AnnotationDescriptor findExternalAnnotation(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return this.fqNameFilter.invoke(fqName2) != false ? this.delegate.findExternalAnnotation(fqName2) : (AnnotationDescriptor)null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationWithTarget> getUseSiteTargetedAnnotations() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.delegate.getUseSiteTargetedAnnotations();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            AnnotationWithTarget it = (AnnotationWithTarget)element$iv$iv;
            if (!this.shouldBeReturned(it.getAnnotation())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationWithTarget> getAllAnnotations() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.delegate.getAllAnnotations();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            AnnotationWithTarget it = (AnnotationWithTarget)element$iv$iv;
            if (!this.shouldBeReturned(it.getAnnotation())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterator<AnnotationDescriptor> iterator() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.delegate;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            AnnotationDescriptor it = (AnnotationDescriptor)element$iv$iv;
            if (!this.shouldBeReturned(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return ((List)var3_3).iterator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldBeReturned(AnnotationDescriptor annotation2) {
        ClassifierDescriptor descriptor2 = annotation2.getType().getConstructor().getDeclarationDescriptor();
        if (descriptor2 == null) return false;
        FqNameUnsafe $receiver$iv = DescriptorUtils.getFqName(descriptor2);
        FqNameUnsafe fqName2 = $receiver$iv;
        if (!fqName2.isSafe()) return false;
        FqName fqName3 = fqName2.toSafe();
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "fqName.toSafe()");
        if (this.fqNameFilter.invoke(fqName3) == false) return false;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public FilteredAnnotations(@NotNull Annotations delegate2, @NotNull Function1<? super FqName, Boolean> fqNameFilter) {
        Intrinsics.checkParameterIsNotNull(delegate2, "delegate");
        Intrinsics.checkParameterIsNotNull(fqNameFilter, "fqNameFilter");
        this.delegate = delegate2;
        this.fqNameFilter = fqNameFilter;
    }
}

