/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.inline.InlineableResult;
import org.jetbrains.kotlin.js.inline.clean.RemoveDefaultInitializersKt;
import org.jetbrains.kotlin.js.inline.context.FunctionContext;
import org.jetbrains.kotlin.js.inline.context.InliningContext;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;
import org.jetbrains.kotlin.js.inline.util.NamingUtilsKt;
import org.jetbrains.kotlin.js.inline.util.RewriteUtilsKt;
import org.jetbrains.kotlin.js.inline.util.SideEffectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.ReturnReplacingVisitor;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBreak;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsContinue;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsLabel;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsParameter;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsReturn;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsVars;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u001bJ\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0019H\u0002J\b\u0010\u001f\u001a\u00020\u001bH\u0002J\n\u0010 \u001a\u0004\u0018\u00010!H\u0002J\b\u0010\"\u001a\u00020\u001bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010#\u001a\u00020\u0017H\u0002J\b\u0010$\u001a\u00020\u0017H\u0002J\b\u0010%\u001a\u00020\u0017H\u0002J\b\u0010&\u001a\u00020\u0017H\u0002J\u000e\u0010 \u001a\u0004\u0018\u00010!*\u00020'H\u0002J\u000e\u0010 \u001a\u0004\u0018\u00010!*\u00020(H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000b\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/js/inline/FunctionInlineMutator;", "", "call", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsInvocation;", "inliningContext", "Lorg/jetbrains/kotlin/js/inline/context/InliningContext;", "(Lcom/google/dart/compiler/backend/js/ast/JsInvocation;Lorg/jetbrains/kotlin/js/inline/context/InliningContext;)V", "body", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsBlock;", "breakLabel", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsLabel;", "currentStatement", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsStatement;", "Lorg/jetbrains/annotations/Nullable;", "invokedFunction", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunction;", "isResultNeeded", "", "namingContext", "Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "resultExpr", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "doReplaceReturns", "", "getArguments", "", "getBreakLabel", "", "getLabelPrefix", "getParameters", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsParameter;", "getResultLabel", "getResultReference", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNameRef;", "getThisAlias", "process", "processReturns", "removeStatementsAfterTopReturn", "replaceThis", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsBinaryOperation;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsVars;", "Companion", "kotlin-compiler"})
@KotlinClass(version={1, 1, 0}, data={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u001bJ\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0019H\u0002J\b\u0010\u001f\u001a\u00020\u001bH\u0002J\n\u0010 \u001a\u0004\u0018\u00010!H\u0002J\b\u0010\"\u001a\u00020\u001bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010#\u001a\u00020\u0017H\u0002J\b\u0010$\u001a\u00020\u0017H\u0002J\b\u0010%\u001a\u00020\u0017H\u0002J\b\u0010&\u001a\u00020\u0017H\u0002J\u000e\u0010 \u001a\u0004\u0018\u00010!*\u00020'H\u0002J\u000e\u0010 \u001a\u0004\u0018\u00010!*\u00020(H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000b\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, strings={"Lorg/jetbrains/kotlin/js/inline/FunctionInlineMutator;", "", "call", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsInvocation;", "inliningContext", "Lorg/jetbrains/kotlin/js/inline/context/InliningContext;", "(Lcom/google/dart/compiler/backend/js/ast/JsInvocation;Lorg/jetbrains/kotlin/js/inline/context/InliningContext;)V", "body", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsBlock;", "breakLabel", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsLabel;", "currentStatement", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsStatement;", "Lorg/jetbrains/annotations/Nullable;", "invokedFunction", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunction;", "isResultNeeded", "", "namingContext", "Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "resultExpr", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "doReplaceReturns", "", "getArguments", "", "getBreakLabel", "", "getLabelPrefix", "getParameters", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsParameter;", "getResultLabel", "getResultReference", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNameRef;", "getThisAlias", "process", "processReturns", "removeStatementsAfterTopReturn", "replaceThis", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsBinaryOperation;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsVars;", "Companion", "kotlin-compiler"})
public final class FunctionInlineMutator {
    private final JsFunction invokedFunction;
    private final boolean isResultNeeded;
    private final NamingContext namingContext;
    private final JsBlock body;
    private JsExpression resultExpr;
    private JsLabel breakLabel;
    private final JsStatement currentStatement;
    private final JsInvocation call;
    private final InliningContext inliningContext;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    private final void process() {
        JsExpression jsExpression;
        List<JsExpression> arguments2 = this.getArguments();
        List<JsParameter> parameters2 = this.getParameters();
        this.replaceThis();
        RemoveDefaultInitializersKt.removeDefaultInitializers(arguments2, parameters2, this.body);
        NamingUtilsKt.aliasArgumentsIfNeeded(this.namingContext, arguments2, parameters2);
        NamingUtilsKt.renameLocalNames(this.namingContext, this.invokedFunction);
        this.removeStatementsAfterTopReturn();
        this.processReturns();
        this.namingContext.applyRenameTo(this.body);
        FunctionInlineMutator functionInlineMutator = this;
        JsExpression jsExpression2 = this.resultExpr;
        if (jsExpression2 != null) {
            void $receiver$iv;
            JsExpression jsExpression3 = jsExpression2;
            FunctionInlineMutator functionInlineMutator2 = functionInlineMutator;
            JsExpression it = (JsExpression)$receiver$iv;
            JsNode jsNode = this.namingContext.applyRenameTo(it);
            if (jsNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsExpression");
            }
            JsExpression jsExpression4 = (JsExpression)jsNode;
            functionInlineMutator = functionInlineMutator2;
            jsExpression = jsExpression4;
        } else {
            jsExpression = null;
        }
        functionInlineMutator.resultExpr = jsExpression;
    }

    private final void replaceThis() {
        if (!FunctionInlineMutator.Companion.hasThisReference(this.body)) {
            return;
        }
        JsExpression thisReplacement = FunctionInlineMutator.Companion.getThisReplacement(this.call);
        if (thisReplacement == null || thisReplacement instanceof JsLiteral.JsThisRef) {
            return;
        }
        if (SideEffectUtilsKt.needToAlias(thisReplacement)) {
            JsName thisName = this.namingContext.getFreshName(this.getThisAlias());
            this.namingContext.newVar(thisName, thisReplacement);
            thisReplacement = thisName.makeRef();
        }
        RewriteUtilsKt.replaceThisReference((JsNode)this.body, thisReplacement);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeStatementsAfterTopReturn() {
        int n = 0;
        List<JsStatement> statements = this.body.getStatements();
        int statementsSize = statements.size();
        int n2 = statementsSize - 1;
        if (n <= n2) {
            while (true) {
                void i;
                JsStatement statement;
                if ((statement = statements.get((int)i)) instanceof JsReturn) {
                    statements.subList((int)(i + true), statementsSize).clear();
                    break;
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    private final void processReturns() {
        List<JsStatement> statements;
        JsStatement lastTopLevelStatement;
        if (this.currentStatement instanceof JsReturn && ((JsReturn)this.currentStatement).getExpression() == this.call) {
            this.inliningContext.getStatementContext().removeMe();
            return;
        }
        int returnCount = CollectUtilsKt.collectInstances(JsReturn.class, this.body).size();
        if (returnCount == 0) {
            this.resultExpr = JsLiteral.UNDEFINED;
            return;
        }
        if (returnCount == 1 && (lastTopLevelStatement = (statements = this.body.getStatements()).get(CollectionsKt.getLastIndex(statements))) instanceof JsReturn) {
            this.resultExpr = ((JsReturn)lastTopLevelStatement).getExpression();
            statements.remove(CollectionsKt.getLastIndex(statements));
            return;
        }
        this.doReplaceReturns();
    }

    /*
     * WARNING - void declaration
     */
    private final void doReplaceReturns() {
        Unit unit;
        JsNameRef resultReference = this.getResultReference();
        if (resultReference != null) {
            this.resultExpr = resultReference;
        }
        boolean value$iv = this.resultExpr == null || this.resultExpr instanceof JsNameRef;
        if (_Assertions.ENABLED) {
            void value$iv$iv;
            if (value$iv$iv == false) {
                String message$iv$iv = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)message$iv$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        JsName breakName = this.namingContext.getFreshName(this.getBreakLabel());
        this.breakLabel = new JsLabel(breakName);
        JsExpression jsExpression = this.resultExpr;
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        ReturnReplacingVisitor visitor2 = new ReturnReplacingVisitor((JsNameRef)jsExpression, breakName.makeRef());
        visitor2.accept((JsNode)this.body);
        List<JsStatement> statements = this.body.getStatements();
        JsStatement jsStatement = CollectionsKt.lastOrNull(statements);
        if (!(jsStatement instanceof JsBreak)) {
            jsStatement = null;
        }
        JsLabel jsLabel = this.breakLabel;
        JsBreak last = (JsBreak)jsStatement;
        SourceInfoAwareJsNode sourceInfoAwareJsNode = last;
        if ((sourceInfoAwareJsNode != null && (sourceInfoAwareJsNode = ((JsContinue)sourceInfoAwareJsNode).getLabel()) != null ? ((JsNameRef)sourceInfoAwareJsNode).getName() : null) == (jsLabel != null ? jsLabel.getName() : null)) {
            statements.remove(CollectionsKt.getLastIndex(statements));
        }
    }

    private final JsNameRef getResultReference() {
        JsNameRef existingReference;
        JsNameRef jsNameRef;
        if (!this.isResultNeeded) {
            return null;
        }
        JsStatement jsStatement = this.currentStatement;
        if (jsStatement instanceof JsExpressionStatement) {
            JsBinaryOperation expression;
            JsExpression jsExpression = ((JsExpressionStatement)this.currentStatement).getExpression();
            if (!(jsExpression instanceof JsBinaryOperation)) {
                jsExpression = null;
            }
            JsBinaryOperation jsBinaryOperation = expression = (JsBinaryOperation)jsExpression;
            jsNameRef = jsBinaryOperation != null ? this.getResultReference(jsBinaryOperation) : null;
        } else {
            jsNameRef = existingReference = jsStatement instanceof JsVars ? this.getResultReference((JsVars)this.currentStatement) : (JsNameRef)null;
        }
        if (existingReference != null) {
            return existingReference;
        }
        JsName resultName = this.namingContext.getFreshName(this.getResultLabel());
        this.namingContext.newVar(resultName, null);
        return resultName.makeRef();
    }

    private final JsNameRef getResultReference(JsBinaryOperation $receiver) {
        if ($receiver.getOperator() != JsBinaryOperator.ASG || $receiver.getArg2() != this.call) {
            return null;
        }
        JsExpression jsExpression = $receiver.getArg1();
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        return (JsNameRef)jsExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final JsNameRef getResultReference(JsVars $receiver) {
        void receiver$iv;
        List<JsVars.JsVar> vars = $receiver.getVars();
        JsVars.JsVar variable = CollectionsKt.first(vars);
        if (variable.getInitExpression() != this.call || vars.size() > 1) {
            return null;
        }
        JsName varName = variable.getName();
        JsContext<JsStatement> jsContext = this.inliningContext.getStatementContext();
        JsContext $receiver2 = (JsContext)receiver$iv;
        $receiver2.removeMe();
        $receiver2.addPrevious((JsNode)JsAstUtils.newVar(varName, null));
        return varName.makeRef();
    }

    private final List<JsExpression> getArguments() {
        List<JsExpression> arguments2 = this.call.getArguments();
        if (InvocationUtilsKt.isCallInvocation(this.call)) {
            return arguments2.subList(1, arguments2.size());
        }
        List<JsExpression> list2 = arguments2;
        Intrinsics.checkExpressionValueIsNotNull(list2, "arguments");
        return list2;
    }

    private final boolean isResultNeeded(JsInvocation call) {
        return !(this.currentStatement instanceof JsExpressionStatement) || Intrinsics.areEqual(call, ((JsExpressionStatement)this.currentStatement).getExpression()) ^ true;
    }

    private final List<JsParameter> getParameters() {
        List<JsParameter> list2 = this.invokedFunction.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "invokedFunction.parameters");
        return list2;
    }

    private final String getResultLabel() {
        return this.getLabelPrefix() + "result";
    }

    private final String getBreakLabel() {
        return this.getLabelPrefix() + "break";
    }

    private final String getThisAlias() {
        return "$this";
    }

    @NotNull
    public final String getLabelPrefix() {
        String labelPrefix;
        String ident = InvocationUtilsKt.getSimpleIdent(this.call);
        String string = ident;
        if (string == null) {
            string = labelPrefix = "inline$";
        }
        if (StringsKt.endsWith$default(labelPrefix, "$", false, 2, null)) {
            return labelPrefix;
        }
        return labelPrefix + "$";
    }

    private FunctionInlineMutator(JsInvocation call, InliningContext inliningContext) {
        this.call = call;
        this.inliningContext = inliningContext;
        this.currentStatement = this.inliningContext.getStatementContext().getCurrentNode();
        FunctionContext functionContext = this.inliningContext.getFunctionContext();
        this.invokedFunction = functionContext.getFunctionDefinition(this.call);
        JsBlock jsBlock = this.invokedFunction.getBody().deepCopy();
        Intrinsics.checkExpressionValueIsNotNull(jsBlock, "invokedFunction.body.deepCopy()");
        this.body = jsBlock;
        this.isResultNeeded = this.isResultNeeded(this.call);
        this.namingContext = this.inliningContext.newNamingContext();
    }

    public /* synthetic */ FunctionInlineMutator(@NotNull JsInvocation call, @NotNull InliningContext inliningContext, DefaultConstructorMarker $constructor_marker) {
        this(call, inliningContext);
    }

    public static final /* synthetic */ void access$setBreakLabel$p(FunctionInlineMutator $this, @Nullable JsLabel jsLabel) {
        $this.breakLabel = jsLabel;
    }

    public static final /* synthetic */ void access$setResultExpr$p(FunctionInlineMutator $this, @Nullable JsExpression jsExpression) {
        $this.resultExpr = jsExpression;
    }

    @JvmStatic
    @NotNull
    public static final InlineableResult getInlineableCallReplacement(@NotNull JsInvocation call, @NotNull InliningContext inliningContext) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        Intrinsics.checkParameterIsNotNull(inliningContext, "inliningContext");
        return Companion.getInlineableCallReplacement(call, inliningContext);
    }

    @JvmStatic
    public static final boolean canBeExpression(@NotNull JsFunction function) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        return Companion.canBeExpression(function);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0003J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/js/inline/FunctionInlineMutator$Companion;", "", "()V", "canBeExpression", "", "body", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsBlock;", "function", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunction;", "getInlineableCallReplacement", "Lorg/jetbrains/kotlin/js/inline/InlineableResult;", "call", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsInvocation;", "inliningContext", "Lorg/jetbrains/kotlin/js/inline/context/InliningContext;", "getThisReplacement", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "hasThisReference", "kotlin-compiler"})
    @KotlinClass(version={1, 1, 0}, data={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0003J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0012"}, strings={"Lorg/jetbrains/kotlin/js/inline/FunctionInlineMutator$Companion;", "", "()V", "canBeExpression", "", "body", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsBlock;", "function", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunction;", "getInlineableCallReplacement", "Lorg/jetbrains/kotlin/js/inline/InlineableResult;", "call", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsInvocation;", "inliningContext", "Lorg/jetbrains/kotlin/js/inline/context/InliningContext;", "getThisReplacement", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "hasThisReference", "kotlin-compiler"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final InlineableResult getInlineableCallReplacement(@NotNull JsInvocation call, @NotNull InliningContext inliningContext) {
            Intrinsics.checkParameterIsNotNull(call, "call");
            Intrinsics.checkParameterIsNotNull(inliningContext, "inliningContext");
            FunctionInlineMutator mutator = new FunctionInlineMutator(call, inliningContext, null);
            mutator.process();
            JsStatement inlineableBody = mutator.body;
            JsLabel breakLabel = mutator.breakLabel;
            if (breakLabel != null) {
                breakLabel.setStatement(inlineableBody);
                inlineableBody = breakLabel;
            }
            return new InlineableResult(inlineableBody, mutator.resultExpr);
        }

        @JvmStatic
        private final JsExpression getThisReplacement(JsInvocation call) {
            if (InvocationUtilsKt.isCallInvocation(call)) {
                return call.getArguments().get(0);
            }
            if (InvocationUtilsKt.hasCallerQualifier(call)) {
                return InvocationUtilsKt.getCallerQualifier(call);
            }
            return null;
        }

        private final boolean hasThisReference(JsBlock body) {
            List<JsLiteral.JsThisRef> thisRefs = CollectUtilsKt.collectInstances(JsLiteral.JsThisRef.class, body);
            return !thisRefs.isEmpty();
        }

        @JvmStatic
        public final boolean canBeExpression(@NotNull JsFunction function) {
            Intrinsics.checkParameterIsNotNull(function, "function");
            JsBlock jsBlock = function.getBody();
            Intrinsics.checkExpressionValueIsNotNull(jsBlock, "function.body");
            return this.canBeExpression(jsBlock);
        }

        private final boolean canBeExpression(JsBlock body) {
            List<JsStatement> statements = body.getStatements();
            return statements.size() == 1 && statements.get(0) instanceof JsReturn;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

