/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.HasName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsVisitor;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.util.AstUtil;

public final class JsNameRef
extends JsExpressionImpl
implements HasName {
    private String ident;
    private JsName name;
    private JsExpression qualifier;

    public JsNameRef(@NotNull JsName name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNameRef", "<init>"));
        }
        this.name = name;
    }

    public JsNameRef(@NotNull String ident) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNameRef", "<init>"));
        }
        this.ident = ident;
    }

    public JsNameRef(@NotNull String ident, JsExpression qualifier2) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNameRef", "<init>"));
        }
        this.ident = ident;
        this.qualifier = qualifier2;
    }

    public JsNameRef(@NotNull String ident, @NotNull String qualifier2) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNameRef", "<init>"));
        }
        if (qualifier2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNameRef", "<init>"));
        }
        this(ident, (JsExpression)new JsNameRef(qualifier2));
    }

    public JsNameRef(@NotNull JsName name, JsExpression qualifier2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNameRef", "<init>"));
        }
        this.name = name;
        this.qualifier = qualifier2;
    }

    @NotNull
    public String getIdent() {
        String string = this.name == null ? this.ident : this.name.getIdent();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNameRef", "getIdent"));
        }
        return string;
    }

    @Override
    @Nullable
    public JsName getName() {
        return this.name;
    }

    @Nullable
    public JsExpression getQualifier() {
        return this.qualifier;
    }

    @Override
    public boolean isLeaf() {
        return this.qualifier == null;
    }

    public void setQualifier(JsExpression qualifier2) {
        this.qualifier = qualifier2;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitNameRef(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        if (this.qualifier != null) {
            visitor2.accept(this.qualifier);
        }
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx) && this.qualifier != null) {
            this.qualifier = v.accept(this.qualifier);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsNameRef deepCopy() {
        JsExpression qualifierCopy = AstUtil.deepCopy(this.qualifier);
        if (this.name != null) {
            JsNameRef jsNameRef = new JsNameRef(this.name, qualifierCopy);
            if (jsNameRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNameRef", "deepCopy"));
            }
            return jsNameRef;
        }
        JsNameRef jsNameRef = new JsNameRef(this.ident, qualifierCopy).withMetadataFrom(this);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNameRef", "deepCopy"));
        }
        return jsNameRef;
    }
}

