/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\u0007H\u0007J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\u0013H\u0007J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/DescriptorToSourceUtils;", "", "()V", "collectEffectiveReferencedDescriptors", "", "result", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "descriptorToDeclaration", "Lcom/intellij/psi/PsiElement;", "findTopLevelParent", "declarationDescriptor", "getContainingFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getEffectiveReferencedDescriptors", "", "getSourceFromAnnotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "getSourceFromDescriptor", "kotlin-compiler"})
@KotlinClass(version={1, 1, 0}, data={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\u0007H\u0007J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\u0013H\u0007J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a8\u0006\u0015"}, strings={"Lorg/jetbrains/kotlin/resolve/DescriptorToSourceUtils;", "", "()V", "collectEffectiveReferencedDescriptors", "", "result", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "descriptorToDeclaration", "Lcom/intellij/psi/PsiElement;", "findTopLevelParent", "declarationDescriptor", "getContainingFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getEffectiveReferencedDescriptors", "", "getSourceFromAnnotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "getSourceFromDescriptor", "kotlin-compiler"})
public final class DescriptorToSourceUtils {
    public static final DescriptorToSourceUtils INSTANCE;

    private final void collectEffectiveReferencedDescriptors(List<DeclarationDescriptor> result2, DeclarationDescriptor descriptor2) {
        CallableMemberDescriptor.Kind kind;
        if (descriptor2 instanceof CallableMemberDescriptor && Intrinsics.areEqual((Object)(kind = ((CallableMemberDescriptor)descriptor2).getKind()), (Object)CallableMemberDescriptor.Kind.DECLARATION) ^ true && Intrinsics.areEqual((Object)kind, (Object)CallableMemberDescriptor.Kind.SYNTHESIZED) ^ true) {
            for (CallableMemberDescriptor callableMemberDescriptor : ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors()) {
                DeclarationDescriptor declarationDescriptor = callableMemberDescriptor.getOriginal();
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "overridden.original");
                this.collectEffectiveReferencedDescriptors(result2, declarationDescriptor);
            }
            return;
        }
        result2.add(descriptor2);
    }

    @JvmStatic
    @NotNull
    public static final Collection<DeclarationDescriptor> getEffectiveReferencedDescriptors(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        ArrayList result2 = new ArrayList();
        List list2 = result2;
        DeclarationDescriptor declarationDescriptor = descriptor2.getOriginal();
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "descriptor.original");
        INSTANCE.collectEffectiveReferencedDescriptors(list2, declarationDescriptor);
        return result2;
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getSourceFromDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        Object object;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (!(declarationDescriptor instanceof DeclarationDescriptorWithSource)) {
            declarationDescriptor = null;
        }
        return (object = (DeclarationDescriptorWithSource)declarationDescriptor) != null && (object = object.getSource()) != null ? KotlinSourceElementKt.getPsi((SourceElement)object) : null;
    }

    @JvmStatic
    @Nullable
    public static final KtAnnotationEntry getSourceFromAnnotation(@NotNull AnnotationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        PsiElement psiElement = KotlinSourceElementKt.getPsi(descriptor2.getSource());
        if (!(psiElement instanceof KtAnnotationEntry)) {
            psiElement = null;
        }
        return (KtAnnotationEntry)psiElement;
    }

    @JvmStatic
    @Nullable
    public static final PsiElement descriptorToDeclaration(@NotNull DeclarationDescriptor descriptor2) {
        PsiElement psiElement;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Collection<DeclarationDescriptor> effectiveReferencedDescriptors = DescriptorToSourceUtils.getEffectiveReferencedDescriptors(descriptor2);
        if (effectiveReferencedDescriptors.size() == 1) {
            Object t = CollectionsKt.firstOrNull((Iterable)effectiveReferencedDescriptors);
            if (t == null) {
                Intrinsics.throwNpe();
            }
            psiElement = DescriptorToSourceUtils.getSourceFromDescriptor((DeclarationDescriptor)t);
        } else {
            psiElement = null;
        }
        return psiElement;
    }

    @JvmStatic
    @Nullable
    public static final KtFile getContainingFile(@NotNull DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkParameterIsNotNull(declarationDescriptor, "declarationDescriptor");
        DeclarationDescriptor declarationDescriptor2 = INSTANCE.findTopLevelParent(declarationDescriptor);
        if (declarationDescriptor2 == null) {
            return null;
        }
        DeclarationDescriptor descriptor2 = declarationDescriptor2;
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (psiElement == null) {
            return null;
        }
        PsiElement declaration = psiElement;
        PsiFile psiFile = declaration.getContainingFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        return (KtFile)psiFile;
    }

    private final DeclarationDescriptor findTopLevelParent(DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor descriptor2 = declarationDescriptor;
        if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = descriptor2;
            if (declarationDescriptor2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor");
            }
            descriptor2 = ((PropertyAccessorDescriptor)declarationDescriptor2).getCorrespondingProperty();
        }
        while (descriptor2 != null && !DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            descriptor2 = descriptor2.getContainingDeclaration();
        }
        return descriptor2;
    }

    private DescriptorToSourceUtils() {
        INSTANCE = this;
    }

    static {
        new DescriptorToSourceUtils();
    }
}

