/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/OverloadsAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "checkDeclaration", "kotlin-compiler"})
@KotlinClass(version={1, 1, 0}, data={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, strings={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/OverloadsAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "checkDeclaration", "kotlin-compiler"})
public final class OverloadsAnnotationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        if (AnnotationUtilKt.hasJvmOverloadsAnnotation(descriptor2)) {
            this.checkDeclaration(declaration, descriptor2, diagnosticHolder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDeclaration(KtDeclaration declaration, DeclarationDescriptor descriptor2, DiagnosticSink diagnosticHolder) {
        if (!(descriptor2 instanceof CallableDescriptor)) {
            return;
        }
        if (descriptor2 instanceof FunctionDescriptor && Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor2).getModality(), (Object)Modality.ABSTRACT)) {
            diagnosticHolder.report(ErrorsJvm.OVERLOADS_ABSTRACT.on((KtDeclaration)((PsiElement)declaration)));
        } else if (!((CallableDescriptor)descriptor2).getVisibility().isPublicAPI() && Intrinsics.areEqual(((CallableDescriptor)descriptor2).getVisibility(), Visibilities.INTERNAL) ^ true || DescriptorUtils.isLocal(descriptor2)) {
            diagnosticHolder.report(ErrorsJvm.OVERLOADS_PRIVATE.on((KtDeclaration)((PsiElement)declaration)));
        } else {
            boolean bl;
            block7: {
                void $receiver$iv;
                Iterable iterable = ((CallableDescriptor)descriptor2).getValueParameters();
                for (Object element$iv : $receiver$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    if (!it.declaresDefaultValue()) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
            if (bl) {
                diagnosticHolder.report(ErrorsJvm.OVERLOADS_WITHOUT_DEFAULT_ARGUMENTS.on((KtDeclaration)((PsiElement)declaration)));
            }
        }
    }
}

