/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.varianceChecker;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyAccessorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.resolve.typeBinding.TypeArgumentBinding;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBinding;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBindingKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/varianceChecker/VarianceChecker;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "check", "", "c", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "checkClasses", "checkMembers", "Companion", "VarianceConflictDiagnosticData", "kotlin-compiler"})
@KotlinClass(version={1, 1, 0}, data={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, strings={"Lorg/jetbrains/kotlin/resolve/varianceChecker/VarianceChecker;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "check", "", "c", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "checkClasses", "checkMembers", "Companion", "VarianceConflictDiagnosticData", "kotlin-compiler"})
public final class VarianceChecker {
    private final BindingTrace trace;
    public static final Companion Companion = new Companion(null);

    public final void check(@NotNull TopDownAnalysisContext c) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        this.checkClasses(c);
        this.checkMembers(c);
    }

    private final void checkClasses(TopDownAnalysisContext c) {
        Map<KtClassOrObject, ClassDescriptorWithResolutionScopes> map2 = c.getDeclaredClasses();
        if (map2 == null) {
            Intrinsics.throwNpe();
        }
        for (KtClassOrObject jetClassOrObject : map2.keySet()) {
            if (!(jetClassOrObject instanceof KtClass)) continue;
            for (KtSuperTypeListEntry specifier : jetClassOrObject.getSuperTypeListEntries()) {
                Boolean bl;
                KtTypeReference ktTypeReference = specifier.getTypeReference();
                if (ktTypeReference != null) {
                    BindingContext bindingContext = this.trace.getBindingContext();
                    Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
                    bl = VarianceChecker.Companion.checkTypePosition(ktTypeReference, bindingContext, Variance.OUT_VARIANCE, this.trace);
                    continue;
                }
                bl = null;
            }
            KtTypeParameterListOwner ktTypeParameterListOwner = jetClassOrObject;
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
            VarianceChecker.Companion.checkTypeParameters(ktTypeParameterListOwner, bindingContext, Variance.OUT_VARIANCE, this.trace);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkMembers(TopDownAnalysisContext c) {
        Map<KtCallableDeclaration, CallableMemberDescriptor> $receiver$iv = c.getMembers();
        Iterator<Map.Entry<KtCallableDeclaration, CallableMemberDescriptor>> iterator2 = $receiver$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $receiver$iv2;
            void $receiver$iv3;
            Map.Entry<KtCallableDeclaration, CallableMemberDescriptor> entry;
            Map.Entry<KtCallableDeclaration, CallableMemberDescriptor> $i$f$iterator = entry = iterator2.next();
            KtCallableDeclaration declaration = (KtCallableDeclaration)$receiver$iv3.getKey();
            Map.Entry<KtCallableDeclaration, CallableMemberDescriptor> $i$f$component1 = entry;
            CallableMemberDescriptor descriptor2 = (CallableMemberDescriptor)$receiver$iv2.getValue();
            if (Visibilities.isPrivate(descriptor2.getVisibility())) continue;
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
            KtCallableDeclaration ktCallableDeclaration = declaration;
            Intrinsics.checkExpressionValueIsNotNull(ktCallableDeclaration, "declaration");
            CallableDescriptor callableDescriptor = descriptor2;
            Intrinsics.checkExpressionValueIsNotNull(callableDescriptor, "descriptor");
            VarianceChecker.Companion.checkCallableDeclaration(bindingContext, ktCallableDeclaration, callableDescriptor, this.trace);
        }
    }

    public VarianceChecker(@NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.trace = trace;
    }

    @JvmStatic
    public static final void recordPrivateToThisIfNeeded(@NotNull BindingTrace trace, @NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Companion.recordPrivateToThisIfNeeded(trace, descriptor2);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/varianceChecker/VarianceChecker$VarianceConflictDiagnosticData;", "", "containingType", "Lorg/jetbrains/kotlin/types/KotlinType;", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "occurrencePosition", "Lorg/jetbrains/kotlin/types/Variance;", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;Lorg/jetbrains/kotlin/types/Variance;)V", "getContainingType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getOccurrencePosition", "()Lorg/jetbrains/kotlin/types/Variance;", "getTypeParameter", "()Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "kotlin-compiler"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, strings={"Lorg/jetbrains/kotlin/resolve/varianceChecker/VarianceChecker$VarianceConflictDiagnosticData;", "", "containingType", "Lorg/jetbrains/kotlin/types/KotlinType;", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "occurrencePosition", "Lorg/jetbrains/kotlin/types/Variance;", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;Lorg/jetbrains/kotlin/types/Variance;)V", "getContainingType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getOccurrencePosition", "()Lorg/jetbrains/kotlin/types/Variance;", "getTypeParameter", "()Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "kotlin-compiler"})
    public static final class VarianceConflictDiagnosticData {
        @NotNull
        private final KotlinType containingType;
        @NotNull
        private final TypeParameterDescriptor typeParameter;
        @NotNull
        private final Variance occurrencePosition;

        @NotNull
        public final KotlinType getContainingType() {
            return this.containingType;
        }

        @NotNull
        public final TypeParameterDescriptor getTypeParameter() {
            return this.typeParameter;
        }

        @NotNull
        public final Variance getOccurrencePosition() {
            return this.occurrencePosition;
        }

        public VarianceConflictDiagnosticData(@NotNull KotlinType containingType, @NotNull TypeParameterDescriptor typeParameter, @NotNull Variance occurrencePosition) {
            Intrinsics.checkParameterIsNotNull(containingType, "containingType");
            Intrinsics.checkParameterIsNotNull(typeParameter, "typeParameter");
            Intrinsics.checkParameterIsNotNull((Object)occurrencePosition, "occurrencePosition");
            this.containingType = containingType;
            this.typeParameter = typeParameter;
            this.occurrencePosition = occurrencePosition;
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0010H\u0007J\u001c\u0010\u0013\u001a\u00020\u0004*\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004H\u0082\u0004\u00a2\u0006\u0002\u0010\u0015J$\u0010\u0016\u001a\u00020\u0004*\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002J+\u0010\u001a\u001a\u0004\u0018\u00010\u0004*\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u001dJ*\u0010\u001a\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002J\"\u0010\u001a\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/resolve/varianceChecker/VarianceChecker$Companion;", "", "()V", "checkCallableDeclaration", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "declaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "diagnosticSink", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "isIrrelevant", "recordPrivateToThis", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "recordPrivateToThisIfNeeded", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "and", "other", "(ZLjava/lang/Boolean;)Z", "checkTypeParameters", "Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwner;", "typePosition", "Lorg/jetbrains/kotlin/types/Variance;", "checkTypePosition", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "position", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/types/Variance;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;)Ljava/lang/Boolean;", "Lorg/jetbrains/kotlin/resolve/typeBinding/TypeBinding;", "Lcom/intellij/psi/PsiElement;", "containingType", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin-compiler"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0010H\u0007J\u001c\u0010\u0013\u001a\u00020\u0004*\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004H\u0082\u0004\u00a2\u0006\u0002\u0010\u0015J$\u0010\u0016\u001a\u00020\u0004*\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002J+\u0010\u001a\u001a\u0004\u0018\u00010\u0004*\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u001dJ*\u0010\u001a\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002J\"\u0010\u001a\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\""}, strings={"Lorg/jetbrains/kotlin/resolve/varianceChecker/VarianceChecker$Companion;", "", "()V", "checkCallableDeclaration", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "declaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "diagnosticSink", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "isIrrelevant", "recordPrivateToThis", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "recordPrivateToThisIfNeeded", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "and", "other", "(ZLjava/lang/Boolean;)Z", "checkTypeParameters", "Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwner;", "typePosition", "Lorg/jetbrains/kotlin/types/Variance;", "checkTypePosition", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "position", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/types/Variance;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;)Ljava/lang/Boolean;", "Lorg/jetbrains/kotlin/resolve/typeBinding/TypeBinding;", "Lcom/intellij/psi/PsiElement;", "containingType", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin-compiler"})
    public static final class Companion {
        @JvmStatic
        public final void recordPrivateToThisIfNeeded(@NotNull BindingTrace trace, @NotNull CallableMemberDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull(trace, "trace");
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            if (this.isIrrelevant(descriptor2) || Intrinsics.areEqual(descriptor2.getVisibility(), Visibilities.PRIVATE) ^ true) {
                return;
            }
            PsiElement psiElement = KotlinSourceElementKt.getPsi(descriptor2.getSource());
            if (!(psiElement instanceof KtCallableDeclaration)) {
                return;
            }
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)psiElement;
            CallableDescriptor callableDescriptor = descriptor2;
            DiagnosticSink diagnosticSink = DiagnosticSink.DO_NOTHING;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticSink, "DiagnosticSink.DO_NOTHING");
            if (!this.checkCallableDeclaration(bindingContext, ktCallableDeclaration, callableDescriptor, diagnosticSink)) {
                this.recordPrivateToThis(descriptor2);
            }
        }

        private final boolean isIrrelevant(CallableDescriptor descriptor2) {
            boolean bl;
            block2: {
                DeclarationDescriptor containingClass = descriptor2.getContainingDeclaration();
                if (!(containingClass instanceof ClassDescriptor)) {
                    return true;
                }
                Iterable $receiver$iv = ((ClassDescriptor)containingClass).getTypeConstructor().getParameters();
                for (Object element$iv : $receiver$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                    if (Intrinsics.areEqual((Object)it.getVariance(), (Object)Variance.INVARIANT)) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            return bl;
        }

        private final void recordPrivateToThis(CallableMemberDescriptor descriptor2) {
            if (descriptor2 instanceof FunctionDescriptorImpl) {
                ((FunctionDescriptorImpl)descriptor2).setVisibility(Visibilities.PRIVATE_TO_THIS);
            } else if (descriptor2 instanceof PropertyDescriptorImpl) {
                ((PropertyDescriptorImpl)descriptor2).setVisibility(Visibilities.PRIVATE_TO_THIS);
                Iterator<PropertyAccessorDescriptor> iterator2 = ((PropertyDescriptorImpl)descriptor2).getAccessors().iterator();
                while (iterator2.hasNext()) {
                    PropertyAccessorDescriptor accessor;
                    PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = iterator2.next();
                    if (propertyAccessorDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.impl.PropertyAccessorDescriptorImpl");
                    }
                    ((PropertyAccessorDescriptorImpl)propertyAccessorDescriptor).setVisibility(Visibilities.PRIVATE_TO_THIS);
                }
            } else {
                throw (Throwable)new IllegalStateException("Unexpected descriptor type: " + descriptor2.getClass().getName());
            }
        }

        private final boolean checkCallableDeclaration(BindingContext trace, KtCallableDeclaration declaration, CallableDescriptor descriptor2, DiagnosticSink diagnosticSink) {
            if (this.isIrrelevant(descriptor2)) {
                return true;
            }
            boolean noError = true;
            noError &= this.checkTypeParameters(declaration, trace, Variance.IN_VARIANCE, diagnosticSink);
            KtTypeReference ktTypeReference = declaration.getReceiverTypeReference();
            noError = this.and(noError, ktTypeReference != null ? this.checkTypePosition(ktTypeReference, trace, Variance.IN_VARIANCE, diagnosticSink) : null);
            for (KtParameter parameter : declaration.getValueParameters()) {
                KtTypeReference ktTypeReference2 = parameter.getTypeReference();
                noError = this.and(noError, ktTypeReference2 != null ? this.checkTypePosition(ktTypeReference2, trace, Variance.IN_VARIANCE, diagnosticSink) : null);
            }
            Variance returnTypePosition = descriptor2 instanceof VariableDescriptor && ((VariableDescriptor)descriptor2).isVar() ? Variance.INVARIANT : Variance.OUT_VARIANCE;
            TypeBinding<PsiElement> typeBinding = TypeBindingKt.createTypeBindingForReturnType(declaration, trace);
            noError = this.and(noError, typeBinding != null ? Boolean.valueOf(this.checkTypePosition(typeBinding, returnTypePosition, diagnosticSink)) : null);
            return noError;
        }

        private final boolean checkTypeParameters(KtTypeParameterListOwner $receiver, BindingContext trace, Variance typePosition, DiagnosticSink diagnosticSink) {
            boolean noError = true;
            for (KtTypeParameter typeParameter : $receiver.getTypeParameters()) {
                KtTypeReference ktTypeReference = typeParameter.getExtendsBound();
                noError = this.and(noError, ktTypeReference != null ? this.checkTypePosition(ktTypeReference, trace, typePosition, diagnosticSink) : null);
            }
            for (KtTypeConstraint typeConstraint : $receiver.getTypeConstraints()) {
                KtTypeReference ktTypeReference = typeConstraint.getBoundTypeReference();
                noError = this.and(noError, ktTypeReference != null ? this.checkTypePosition(ktTypeReference, trace, typePosition, diagnosticSink) : null);
            }
            return noError;
        }

        private final Boolean checkTypePosition(KtTypeReference $receiver, BindingContext trace, Variance position, DiagnosticSink diagnosticSink) {
            TypeBinding<KtTypeElement> typeBinding = TypeBindingKt.createTypeBinding($receiver, trace);
            return typeBinding != null ? Boolean.valueOf(this.checkTypePosition(typeBinding, position, diagnosticSink)) : null;
        }

        private final boolean checkTypePosition(TypeBinding<? extends PsiElement> $receiver, Variance position, DiagnosticSink diagnosticSink) {
            return this.checkTypePosition($receiver, $receiver.getKotlinType(), position, diagnosticSink);
        }

        private final boolean checkTypePosition(TypeBinding<? extends PsiElement> $receiver, KotlinType containingType, Variance position, DiagnosticSink diagnosticSink) {
            ClassifierDescriptor classifierDescriptor = $receiver.getKotlinType().getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor instanceof TypeParameterDescriptor) {
                Variance declarationVariance = ((TypeParameterDescriptor)classifierDescriptor).getVariance();
                if (!declarationVariance.allowsPosition(position)) {
                    Annotations annotations2 = $receiver.getKotlinType().getAnnotations();
                    FqName fqName2 = KotlinBuiltIns.FQ_NAMES.unsafeVariance;
                    Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.unsafeVariance");
                    if (!annotations2.hasAnnotation(fqName2)) {
                        diagnosticSink.report(Errors.TYPE_VARIANCE_CONFLICT.on($receiver.getPsiElement(), new VarianceConflictDiagnosticData(containingType, (TypeParameterDescriptor)classifierDescriptor, position)));
                    }
                }
                return declarationVariance.allowsPosition(position);
            }
            boolean noError = true;
            for (TypeArgumentBinding<? extends PsiElement> argumentBinding : $receiver.getArgumentBindings()) {
                Variance newPosition;
                Variance variance;
                TypeCheckingProcedure.EnrichedProjectionKind projectionKind;
                TypeCheckingProcedure.EnrichedProjectionKind enrichedProjectionKind;
                if (argumentBinding == null || argumentBinding.getTypeParameterDescriptor() == null) continue;
                TypeParameterDescriptor typeParameterDescriptor = argumentBinding.getTypeParameterDescriptor();
                if (typeParameterDescriptor == null) {
                    Intrinsics.throwNpe();
                }
                if (TypeCheckingProcedure.getEffectiveProjectionKind(typeParameterDescriptor, argumentBinding.getTypeProjection()) == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)(enrichedProjectionKind = projectionKind), (Object)TypeCheckingProcedure.EnrichedProjectionKind.OUT)) {
                    variance = position;
                } else if (Intrinsics.areEqual((Object)enrichedProjectionKind, (Object)TypeCheckingProcedure.EnrichedProjectionKind.IN)) {
                    variance = position.opposite();
                } else if (Intrinsics.areEqual((Object)enrichedProjectionKind, (Object)TypeCheckingProcedure.EnrichedProjectionKind.INV)) {
                    variance = Variance.INVARIANT;
                } else if (Intrinsics.areEqual((Object)enrichedProjectionKind, (Object)TypeCheckingProcedure.EnrichedProjectionKind.STAR)) {
                    variance = null;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                if ((newPosition = variance) == null) continue;
                noError &= this.checkTypePosition(argumentBinding.getTypeBinding(), containingType, newPosition, diagnosticSink);
            }
            return noError;
        }

        private final boolean and(boolean $receiver, Boolean other) {
            return other == null ? $receiver : $receiver & other;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

