/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.gnu.trove.THashMap;

public class ClassInnerStuffCache {
    private final PsiExtensibleClass myClass;
    private final SimpleModificationTracker myTracker;

    public ClassInnerStuffCache(@NotNull PsiExtensibleClass aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/source/ClassInnerStuffCache", "<init>"));
        }
        this.myClass = aClass2;
        this.myTracker = new SimpleModificationTracker();
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] psiMethodArray = CachedValuesManager.getCachedValue(this.myClass, new CachedValueProvider<PsiMethod[]>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<PsiMethod[]> compute() {
                return CachedValueProvider.Result.create(PsiImplUtil.getConstructors(ClassInnerStuffCache.this.myClass), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, ClassInnerStuffCache.this.myTracker);
            }
        });
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "getConstructors"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = CachedValuesManager.getCachedValue(this.myClass, new CachedValueProvider<PsiField[]>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<PsiField[]> compute() {
                return CachedValueProvider.Result.create(ClassInnerStuffCache.this.getAllFields(), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, ClassInnerStuffCache.this.myTracker);
            }
        });
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "getFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = CachedValuesManager.getCachedValue(this.myClass, new CachedValueProvider<PsiMethod[]>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<PsiMethod[]> compute() {
                return CachedValueProvider.Result.create(ClassInnerStuffCache.this.getAllMethods(), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, ClassInnerStuffCache.this.myTracker);
            }
        });
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "getMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] psiClassArray = CachedValuesManager.getCachedValue(this.myClass, new CachedValueProvider<PsiClass[]>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<PsiClass[]> compute() {
                return CachedValueProvider.Result.create(ClassInnerStuffCache.this.getAllInnerClasses(), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, ClassInnerStuffCache.this.myTracker);
            }
        });
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "getInnerClasses"));
        }
        return psiClassArray;
    }

    @Nullable
    public PsiField findFieldByName(String name, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findFieldByName(this.myClass, name, true);
        }
        return CachedValuesManager.getCachedValue(this.myClass, new CachedValueProvider<Map<String, PsiField>>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<Map<String, PsiField>> compute() {
                return CachedValueProvider.Result.create(ClassInnerStuffCache.this.getFieldsMap(), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, ClassInnerStuffCache.this.myTracker);
            }
        }).get(name);
    }

    @NotNull
    public PsiMethod[] findMethodsByName(String name, boolean checkBases) {
        if (checkBases) {
            PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsByName(this.myClass, name, true);
            if (psiMethodArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "findMethodsByName"));
            }
            return psiMethodArray;
        }
        PsiMethod[] methods = CachedValuesManager.getCachedValue(this.myClass, new CachedValueProvider<Map<String, PsiMethod[]>>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<Map<String, PsiMethod[]>> compute() {
                return CachedValueProvider.Result.create(ClassInnerStuffCache.this.getMethodsMap(), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, ClassInnerStuffCache.this.myTracker);
            }
        }).get(name);
        PsiMethod[] psiMethodArray = methods == null ? PsiMethod.EMPTY_ARRAY : methods;
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "findMethodsByName"));
        }
        return psiMethodArray;
    }

    @Nullable
    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findInnerByName(this.myClass, name, true);
        }
        return CachedValuesManager.getCachedValue(this.myClass, new CachedValueProvider<Map<String, PsiClass>>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<Map<String, PsiClass>> compute() {
                return CachedValueProvider.Result.create(ClassInnerStuffCache.this.getInnerClassesMap(), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, ClassInnerStuffCache.this.myTracker);
            }
        }).get(name);
    }

    @Nullable
    public PsiMethod getValuesMethod() {
        return !this.myClass.isEnum() || this.myClass.getName() == null ? null : CachedValuesManager.getCachedValue(this.myClass, new CachedValueProvider<PsiMethod>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<PsiMethod> compute() {
                String text = "public static " + ClassInnerStuffCache.this.myClass.getName() + "[] values() { }";
                return new CachedValueProvider.Result<PsiMethod>(ClassInnerStuffCache.this.getSyntheticMethod(text), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, ClassInnerStuffCache.this.myTracker);
            }
        });
    }

    @Nullable
    public PsiMethod getValueOfMethod() {
        return !this.myClass.isEnum() || this.myClass.getName() == null ? null : CachedValuesManager.getCachedValue(this.myClass, new CachedValueProvider<PsiMethod>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<PsiMethod> compute() {
                String text = "public static " + ClassInnerStuffCache.this.myClass.getName() + " valueOf(java.lang.String name) throws java.lang.IllegalArgumentException { }";
                return new CachedValueProvider.Result<PsiMethod>(ClassInnerStuffCache.this.getSyntheticMethod(text), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, ClassInnerStuffCache.this.myTracker);
            }
        });
    }

    @NotNull
    private PsiField[] getAllFields() {
        List<PsiField> own = this.myClass.getOwnFields();
        List<PsiField> ext = PsiAugmentProvider.collectAugments(this.myClass, PsiField.class);
        PsiField[] psiFieldArray = ArrayUtil.mergeCollections(own, ext, PsiField.ARRAY_FACTORY);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "getAllFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    private PsiMethod[] getAllMethods() {
        List<PsiMethod> own = this.myClass.getOwnMethods();
        List<PsiMethod> ext = PsiAugmentProvider.collectAugments(this.myClass, PsiMethod.class);
        PsiMethod[] psiMethodArray = ArrayUtil.mergeCollections(own, ext, PsiMethod.ARRAY_FACTORY);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "getAllMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    private PsiClass[] getAllInnerClasses() {
        List<PsiClass> own = this.myClass.getOwnInnerClasses();
        List<PsiClass> ext = PsiAugmentProvider.collectAugments(this.myClass, PsiClass.class);
        PsiClass[] psiClassArray = ArrayUtil.mergeCollections(own, ext, PsiClass.ARRAY_FACTORY);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "getAllInnerClasses"));
        }
        return psiClassArray;
    }

    @NotNull
    private Map<String, PsiField> getFieldsMap() {
        PsiField[] fields = this.getFields();
        if (fields.length == 0) {
            Map<String, PsiField> map2 = Collections.emptyMap();
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "getFieldsMap"));
            }
            return map2;
        }
        THashMap<String, PsiField> cachedFields = new THashMap<String, PsiField>();
        for (PsiField field : fields) {
            String name = field.getName();
            if (field instanceof ExternallyDefinedPsiElement && cachedFields.containsKey(name)) continue;
            cachedFields.put(name, field);
        }
        THashMap<String, PsiField> tHashMap = cachedFields;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "getFieldsMap"));
        }
        return tHashMap;
    }

    @NotNull
    private Map<String, PsiMethod[]> getMethodsMap() {
        PsiMethod[] methods = this.getMethods();
        if (methods.length == 0) {
            Map<String, PsiMethod[]> map2 = Collections.emptyMap();
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "getMethodsMap"));
            }
            return map2;
        }
        HashMap collectedMethods = ContainerUtil.newHashMap();
        for (PsiMethod method : methods) {
            List list2 = (List)collectedMethods.get(method.getName());
            if (list2 == null) {
                list2 = ContainerUtil.newSmartList();
                collectedMethods.put(method.getName(), list2);
            }
            list2.add(method);
        }
        THashMap<String, PsiMethod[]> cachedMethods = ContainerUtil.newTroveMap();
        for (Map.Entry entry : collectedMethods.entrySet()) {
            List list3 = (List)entry.getValue();
            cachedMethods.put((String)entry.getKey(), list3.toArray(new PsiMethod[list3.size()]));
        }
        THashMap<String, PsiMethod[]> tHashMap = cachedMethods;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "getMethodsMap"));
        }
        return tHashMap;
    }

    @NotNull
    private Map<String, PsiClass> getInnerClassesMap() {
        PsiClass[] classes2 = this.getInnerClasses();
        if (classes2.length == 0) {
            Map<String, PsiClass> map2 = Collections.emptyMap();
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "getInnerClassesMap"));
            }
            return map2;
        }
        THashMap<String, PsiClass> cachedInners = new THashMap<String, PsiClass>();
        for (PsiClass psiClass : classes2) {
            String name = psiClass.getName();
            if (psiClass instanceof ExternallyDefinedPsiElement && cachedInners.containsKey(name)) continue;
            cachedInners.put(name, psiClass);
        }
        THashMap<String, PsiClass> tHashMap = cachedInners;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/ClassInnerStuffCache", "getInnerClassesMap"));
        }
        return tHashMap;
    }

    private PsiMethod getSyntheticMethod(String text) {
        PsiElementFactory factory = JavaPsiFacade.getInstance(this.myClass.getProject()).getElementFactory();
        PsiMethod method = factory.createMethodFromText(text, this.myClass);
        return new LightMethod(this.myClass.getManager(), method, this.myClass);
    }

    public void dropCaches() {
        this.myTracker.incModificationCount();
    }
}

