/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KotlinReflectionInternalError;
import kotlin.reflect.jvm.internal.JvmFunctionSignature;
import kotlin.reflect.jvm.internal.JvmPropertySignature;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.com.google.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaMethodDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaPropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.sources.JavaSourceElement;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaElement;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaConstructor;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaField;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaMethod;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.platform.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedPropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmProtoBufUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000bR\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lkotlin/reflect/jvm/internal/RuntimeTypeMapper;", "", "()V", "primitiveType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "Ljava/lang/Class;", "getPrimitiveType", "(Ljava/lang/Class;)Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "mapIntrinsicFunctionSignature", "Lkotlin/reflect/jvm/internal/JvmFunctionSignature;", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "mapJvmClassToKotlinClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "klass", "mapPropertySignature", "Lkotlin/reflect/jvm/internal/JvmPropertySignature;", "possiblyOverriddenProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "mapSignature", "possiblySubstitutedFunction", "kotlin-reflection"})
public final class RuntimeTypeMapper {
    public static final RuntimeTypeMapper INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JvmFunctionSignature mapSignature(@NotNull FunctionDescriptor possiblySubstitutedFunction) {
        FunctionDescriptor function;
        Intrinsics.checkParameterIsNotNull(possiblySubstitutedFunction, "possiblySubstitutedFunction");
        FunctionDescriptor functionDescriptor = function = ((FunctionDescriptor)DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)possiblySubstitutedFunction)).getOriginal();
        if (functionDescriptor instanceof DeserializedCallableMemberDescriptor) {
            FunctionDescriptor functionDescriptor2 = function;
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor2, "function");
            JvmFunctionSignature jvmFunctionSignature = this.mapIntrinsicFunctionSignature(functionDescriptor2);
            if (jvmFunctionSignature != null) {
                void $receiver$iv;
                JvmFunctionSignature jvmFunctionSignature2 = jvmFunctionSignature;
                JvmFunctionSignature it = (JvmFunctionSignature)$receiver$iv;
                return it;
            }
            MessageLite proto = ((DeserializedCallableMemberDescriptor)((Object)function)).getProto();
            if (proto instanceof ProtoBuf.Function) {
                String string = JvmProtoBufUtil.INSTANCE.getJvmMethodSignature((ProtoBuf.Function)proto, ((DeserializedCallableMemberDescriptor)((Object)function)).getNameResolver(), ((DeserializedCallableMemberDescriptor)((Object)function)).getTypeTable());
                if (string != null) {
                    void $receiver$iv;
                    String it = string;
                    String signature = (String)$receiver$iv;
                    return new JvmFunctionSignature.KotlinFunction(signature);
                }
            }
            if (proto instanceof ProtoBuf.Constructor) {
                String string = JvmProtoBufUtil.INSTANCE.getJvmConstructorSignature((ProtoBuf.Constructor)proto, ((DeserializedCallableMemberDescriptor)((Object)function)).getNameResolver(), ((DeserializedCallableMemberDescriptor)((Object)function)).getTypeTable());
                if (string != null) {
                    String $receiver$iv = string;
                    String signature = $receiver$iv;
                    return new JvmFunctionSignature.KotlinConstructor(signature);
                }
            }
            throw (Throwable)new KotlinReflectionInternalError("Reflection on built-in Kotlin types is not yet fully supported. " + ("No metadata found for " + function));
        }
        if (functionDescriptor instanceof JavaMethodDescriptor) {
            Object object;
            SourceElement sourceElement = ((JavaMethodDescriptor)function).getSource();
            if (!(sourceElement instanceof JavaSourceElement)) {
                sourceElement = null;
            }
            JavaSourceElement javaSourceElement = (JavaSourceElement)sourceElement;
            JavaElement javaElement = javaSourceElement != null ? javaSourceElement.getJavaElement() : null;
            if (!(javaElement instanceof ReflectJavaMethod)) {
                javaElement = null;
            }
            if ((object = (ReflectJavaMethod)javaElement) == null || (object = ((ReflectJavaMethod)object).getMember()) == null) {
                throw (Throwable)new KotlinReflectionInternalError("Incorrect resolution sequence for Java method " + function);
            }
            Object method = object;
            return new JvmFunctionSignature.JavaMethod((Method)method);
        }
        if (functionDescriptor instanceof JavaConstructorDescriptor) {
            Object object;
            SourceElement sourceElement = ((JavaConstructorDescriptor)function).getSource();
            if (!(sourceElement instanceof JavaSourceElement)) {
                sourceElement = null;
            }
            JavaSourceElement javaSourceElement = (JavaSourceElement)sourceElement;
            JavaElement javaElement = javaSourceElement != null ? javaSourceElement.getJavaElement() : null;
            if (!(javaElement instanceof ReflectJavaConstructor)) {
                javaElement = null;
            }
            if ((object = (ReflectJavaConstructor)javaElement) == null || (object = ((ReflectJavaConstructor)object).getMember()) == null) {
                throw (Throwable)new KotlinReflectionInternalError("Incorrect resolution sequence for Java constructor " + function);
            }
            Object constructor = object;
            return new JvmFunctionSignature.JavaConstructor((Constructor<?>)constructor);
        }
        throw (Throwable)new KotlinReflectionInternalError("Unknown origin of " + function + " (" + function.getClass() + ")");
    }

    @NotNull
    public final JvmPropertySignature mapPropertySignature(@NotNull PropertyDescriptor possiblyOverriddenProperty) {
        Intrinsics.checkParameterIsNotNull(possiblyOverriddenProperty, "possiblyOverriddenProperty");
        PropertyDescriptor property = (PropertyDescriptor)DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)possiblyOverriddenProperty);
        if (property instanceof DeserializedPropertyDescriptor) {
            ProtoBuf.Property proto = ((DeserializedPropertyDescriptor)property).getProto();
            if (!proto.hasExtension(JvmProtoBuf.propertySignature)) {
                throw (Throwable)new KotlinReflectionInternalError("No metadata found for " + property);
            }
            PropertyDescriptor propertyDescriptor = property;
            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "property");
            JvmProtoBuf.JvmPropertySignature jvmPropertySignature = proto.getExtension(JvmProtoBuf.propertySignature);
            Intrinsics.checkExpressionValueIsNotNull(jvmPropertySignature, "proto.getExtension(JvmProtoBuf.propertySignature)");
            return new JvmPropertySignature.KotlinProperty(propertyDescriptor, proto, jvmPropertySignature, ((DeserializedPropertyDescriptor)property).getNameResolver(), ((DeserializedPropertyDescriptor)property).getTypeTable());
        }
        if (property instanceof JavaPropertyDescriptor) {
            Object object;
            SourceElement sourceElement = ((JavaPropertyDescriptor)property).getSource();
            if (!(sourceElement instanceof JavaSourceElement)) {
                sourceElement = null;
            }
            JavaSourceElement javaSourceElement = (JavaSourceElement)sourceElement;
            JavaElement javaElement = javaSourceElement != null ? javaSourceElement.getJavaElement() : null;
            if (!(javaElement instanceof ReflectJavaField)) {
                javaElement = null;
            }
            if ((object = (ReflectJavaField)javaElement) == null || (object = ((ReflectJavaField)object).getMember()) == null) {
                throw (Throwable)new KotlinReflectionInternalError("Incorrect resolution sequence for Java field " + property);
            }
            Object field = object;
            return new JvmPropertySignature.JavaField((Field)field);
        }
        throw (Throwable)new KotlinReflectionInternalError("Unknown origin of " + property + " (" + property.getClass() + ")");
    }

    private final JvmFunctionSignature mapIntrinsicFunctionSignature(FunctionDescriptor function) {
        List<ValueParameterDescriptor> parameters2 = function.getValueParameters();
        switch (function.getName().asString()) {
            case "equals": {
                if (parameters2.size() != 1 || !KotlinBuiltIns.isNullableAny(CollectionsKt.single(parameters2).getType())) break;
                Member member = Object.class.getDeclaredMethod("equals", Object.class);
                Intrinsics.checkExpressionValueIsNotNull(member, "Any::class.java.getDecla\u2026equals\", Any::class.java)");
                return new JvmFunctionSignature.BuiltInFunction.Predefined("equals(Ljava/lang/Object;)Z", member);
            }
            case "hashCode": {
                if (!parameters2.isEmpty()) break;
                Member member = Object.class.getDeclaredMethod("hashCode", new Class[0]);
                Intrinsics.checkExpressionValueIsNotNull(member, "Any::class.java.getDeclaredMethod(\"hashCode\")");
                return new JvmFunctionSignature.BuiltInFunction.Predefined("hashCode()I", member);
            }
            case "toString": {
                if (!parameters2.isEmpty()) break;
                Member member = Object.class.getDeclaredMethod("toString", new Class[0]);
                Intrinsics.checkExpressionValueIsNotNull(member, "Any::class.java.getDeclaredMethod(\"toString\")");
                return new JvmFunctionSignature.BuiltInFunction.Predefined("toString()Ljava/lang/String;", member);
            }
        }
        return null;
    }

    @NotNull
    public final ClassId mapJvmClassToKotlinClassId(@NotNull Class<?> klass) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        if (klass.isArray()) {
            PrimitiveType primitiveType = this.getPrimitiveType(klass.getComponentType());
            if (primitiveType != null) {
                PrimitiveType $receiver$iv = primitiveType;
                PrimitiveType it = $receiver$iv;
                return new ClassId(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, it.getArrayTypeName());
            }
            ClassId classId = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.array.toSafe());
            Intrinsics.checkExpressionValueIsNotNull(classId, "ClassId.topLevel(KotlinB\u2026.FQ_NAMES.array.toSafe())");
            return classId;
        }
        PrimitiveType primitiveType = this.getPrimitiveType(klass);
        if (primitiveType != null) {
            PrimitiveType $receiver$iv = primitiveType;
            PrimitiveType it = $receiver$iv;
            return new ClassId(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, it.getTypeName());
        }
        ClassId classId = ReflectClassUtilKt.getClassId(klass);
        if (!classId.isLocal()) {
            ClassDescriptor classDescriptor = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(classId.asSingleFqName());
            if (classDescriptor != null) {
                ClassDescriptor $receiver$iv = classDescriptor;
                ClassDescriptor it = $receiver$iv;
                return DescriptorUtilsKt.getClassId(it);
            }
        }
        return classId;
    }

    private final PrimitiveType getPrimitiveType(Class<?> $receiver) {
        return $receiver.isPrimitive() ? JvmPrimitiveType.get($receiver.getSimpleName()).getPrimitiveType() : (PrimitiveType)null;
    }

    private RuntimeTypeMapper() {
        INSTANCE = this;
    }

    static {
        new RuntimeTypeMapper();
    }
}

