/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.extensions.PluginId;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.gnu.trove.THashMap;
import org.jetbrains.kotlin.relocated.gnu.trove.TObjectIntHashMap;

class PluginClassCache {
    private static final Object ourLock = new Object();
    private final Map<String, PluginId> myMissingClasses = new THashMap<String, PluginId>();
    private final TObjectIntHashMap<PluginId> myClassCounts = new TObjectIntHashMap();

    PluginClassCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginClass(String className2, PluginId pluginId, boolean loaded) {
        Object object = ourLock;
        synchronized (object) {
            if (loaded) {
                this.myMissingClasses.remove(className2);
                this.myClassCounts.put(pluginId, this.myClassCounts.get(pluginId) + 1);
            } else {
                this.myMissingClasses.put(className2, pluginId);
            }
        }
    }

    @Nullable
    private static PluginId findLoadingPlugin(String className2) {
        for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
            ClassLoader loader = descriptor2.getPluginClassLoader();
            if (!(loader instanceof PluginClassLoader) || !((PluginClassLoader)loader).hasLoadedClass(className2)) continue;
            return descriptor2.getPluginId();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PluginId getPluginByClassName(String className2) {
        Object object = ourLock;
        synchronized (object) {
            PluginId id = this.myMissingClasses.get(className2);
            if (id != null) {
                return id;
            }
        }
        return PluginClassCache.findLoadingPlugin(className2);
    }
}

