/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.util.ReflectionUtil;
import java.util.ArrayList;
import org.jetbrains.kotlin.relocated.org.jdom.Element;
import org.jetbrains.kotlin.relocated.org.jdom.IllegalDataException;

@Deprecated
public class JDOMExternalizableStringList
extends ArrayList<String>
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.JDOMExternalizableStringList");

    @Override
    public void readExternal(Element element) {
        this.clear();
        Class callerClass = null;
        for (Element listElement : element.getChildren("list")) {
            if (callerClass == null) {
                callerClass = ReflectionUtil.findCallerClass(2);
                assert (callerClass != null);
            }
            ClassLoader classLoader = callerClass.getClassLoader();
            for (Element listItemElement : listElement.getChildren("item")) {
                Class<?> itemClass;
                if (!"item".equals(listItemElement.getName())) {
                    throw new IllegalDataException("Unable to read list item. Unknown element found: " + listItemElement.getName());
                }
                String itemClassString = listItemElement.getAttributeValue("class");
                try {
                    itemClass = Class.forName(itemClassString, true, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    throw new IllegalDataException("Unable to read list item: unable to load class: " + itemClassString + " \n" + ex.getMessage());
                }
                String listItem = listItemElement.getAttributeValue("itemvalue");
                LOG.assertTrue(String.class.equals(itemClass));
                this.add(listItem);
            }
        }
    }

    @Override
    public void writeExternal(Element element) {
        int listSize = this.size();
        Element listElement = new Element("list");
        listElement.setAttribute("size", Integer.toString(listSize));
        element.addContent(listElement);
        for (int i = 0; i < listSize; ++i) {
            String listItem = (String)this.get(i);
            if (listItem == null) continue;
            Element itemElement = new Element("item");
            itemElement.setAttribute("index", Integer.toString(i));
            itemElement.setAttribute("class", listItem.getClass().getName());
            itemElement.setAttribute("itemvalue", DefaultJDOMExternalizer.filterXMLCharacters(listItem));
            listElement.addContent(itemElement);
        }
    }
}

