/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiTypeParameterListStub;
import com.intellij.psi.impl.java.stubs.PsiTypeParameterStub;
import com.intellij.psi.impl.java.stubs.impl.PsiTypeParameterListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiTypeParameterStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.StringRef;
import java.text.CharacterIterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SignatureParsing {
    private SignatureParsing() {
    }

    public static PsiTypeParameterListStub parseTypeParametersDeclaration(CharacterIterator iterator2, StubElement parentStub) throws ClsFormatException {
        PsiTypeParameterListStubImpl list2 = new PsiTypeParameterListStubImpl(parentStub);
        if (iterator2.current() == '<') {
            iterator2.next();
            while (iterator2.current() != '>') {
                SignatureParsing.parseTypeParameter(iterator2, list2);
            }
            iterator2.next();
        }
        return list2;
    }

    private static PsiTypeParameterStub parseTypeParameter(CharacterIterator iterator2, PsiTypeParameterListStub parent2) throws ClsFormatException {
        StringBuilder name = new StringBuilder();
        while (iterator2.current() != ':' && iterator2.current() != '\uffff') {
            name.append(iterator2.current());
            iterator2.next();
        }
        if (iterator2.current() == '\uffff') {
            throw new ClsFormatException();
        }
        PsiTypeParameterStubImpl parameterStub = new PsiTypeParameterStubImpl((StubElement)parent2, StringRef.fromString(name.toString()));
        List bounds = null;
        boolean jlo = false;
        while (iterator2.current() == ':') {
            iterator2.next();
            String bound = SignatureParsing.parseTopLevelClassRefSignature(iterator2);
            if (bound == null) continue;
            if (bounds == null) {
                if ("java.lang.Object".equals(bound)) {
                    jlo = true;
                    continue;
                }
                bounds = ContainerUtil.newSmartList();
                if (jlo) {
                    bounds.add("java.lang.Object");
                }
            }
            bounds.add(bound);
        }
        StubBuildingVisitor.newReferenceList(JavaStubElementTypes.EXTENDS_BOUND_LIST, parameterStub, ArrayUtil.toStringArray(bounds));
        return parameterStub;
    }

    @Nullable
    public static String parseTopLevelClassRefSignature(CharacterIterator signature2) throws ClsFormatException {
        if (signature2.current() == 'L') {
            return SignatureParsing.parseParameterizedClassRefSignature(signature2);
        }
        if (signature2.current() == 'T') {
            return SignatureParsing.parseTypeVariableRefSignature(signature2);
        }
        return null;
    }

    private static String parseTypeVariableRefSignature(CharacterIterator signature2) {
        signature2.next();
        StringBuilder id = new StringBuilder();
        while (signature2.current() != ';' && signature2.current() != '>') {
            id.append(signature2.current());
            signature2.next();
        }
        if (signature2.current() == ';') {
            signature2.next();
        }
        return id.toString();
    }

    private static String parseParameterizedClassRefSignature(CharacterIterator signature2) throws ClsFormatException {
        assert (signature2.current() == 'L');
        StringBuilder canonicalText = new StringBuilder();
        signature2.next();
        while (signature2.current() != ';' && signature2.current() != '\uffff') {
            switch (signature2.current()) {
                case '$': {
                    if (signature2.getIndex() > 0) {
                        boolean standAlone$;
                        char previous = signature2.previous();
                        signature2.next();
                        boolean bl = standAlone$ = !StringUtil.isJavaIdentifierPart(previous);
                        if (standAlone$) {
                            canonicalText.append('$');
                            break;
                        }
                        if (signature2.getIndex() + 1 < signature2.getEndIndex()) {
                            char next = signature2.next();
                            signature2.previous();
                            boolean bl2 = standAlone$ = !StringUtil.isJavaIdentifierPart(next);
                            if (standAlone$) {
                                canonicalText.append('$');
                                break;
                            }
                        }
                    }
                }
                case '.': 
                case '/': {
                    canonicalText.append('.');
                    break;
                }
                case '<': {
                    canonicalText.append('<');
                    signature2.next();
                    do {
                        SignatureParsing.processTypeArgument(signature2, canonicalText);
                    } while (signature2.current() != '>');
                    canonicalText.append('>');
                    break;
                }
                case ' ': {
                    break;
                }
                default: {
                    canonicalText.append(signature2.current());
                }
            }
            signature2.next();
        }
        if (signature2.current() == '\uffff') {
            throw new ClsFormatException();
        }
        for (int index2 = 0; index2 < canonicalText.length(); ++index2) {
            char c = canonicalText.charAt(index2);
            if ('0' > c || c > '1' || index2 <= 0 || canonicalText.charAt(index2 - 1) != '.') continue;
            canonicalText.setCharAt(index2 - 1, '$');
        }
        signature2.next();
        return canonicalText.toString();
    }

    private static void processTypeArgument(CharacterIterator signature2, StringBuilder canonicalText) throws ClsFormatException {
        String typeArgument = SignatureParsing.parseClassOrTypeVariableElement(signature2);
        canonicalText.append(typeArgument);
        if (signature2.current() != '>') {
            canonicalText.append(',');
        }
    }

    public static String parseClassOrTypeVariableElement(CharacterIterator signature2) throws ClsFormatException {
        char variance = SignatureParsing.parseVariance(signature2);
        if (variance == '*') {
            return SignatureParsing.decorateTypeText("*", variance);
        }
        int arrayCount = 0;
        while (signature2.current() == '[') {
            ++arrayCount;
            signature2.next();
        }
        String type2 = SignatureParsing.parseTypeWithoutVariance(signature2);
        if (type2 != null) {
            String ref = type2;
            while (arrayCount > 0) {
                ref = ref + "[]";
                --arrayCount;
            }
            return SignatureParsing.decorateTypeText(ref, variance);
        }
        throw new ClsFormatException();
    }

    private static String decorateTypeText(String canonical, char variance) {
        switch (variance) {
            case '\u0000': {
                return canonical;
            }
            case '+': {
                return "? extends " + canonical;
            }
            case '-': {
                return "? super " + canonical;
            }
            case '*': {
                return "?";
            }
        }
        assert (false) : "unknown variance";
        return null;
    }

    private static char parseVariance(CharacterIterator signature2) {
        char variance;
        switch (signature2.current()) {
            case '*': 
            case '+': 
            case '-': {
                variance = signature2.current();
                signature2.next();
                break;
            }
            case '.': 
            case '=': {
                signature2.next();
            }
            default: {
                variance = '\u0000';
            }
        }
        return variance;
    }

    @NotNull
    public static String parseTypeString(@NotNull CharacterIterator signature2) throws ClsFormatException {
        if (signature2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/psi/impl/compiled/SignatureParsing", "parseTypeString"));
        }
        int arrayDimensions = 0;
        while (signature2.current() == '[') {
            ++arrayDimensions;
            signature2.next();
        }
        char variance = SignatureParsing.parseVariance(signature2);
        String text = SignatureParsing.parseTypeWithoutVariance(signature2);
        if (text == null) {
            throw new ClsFormatException();
        }
        for (int i = 0; i < arrayDimensions; ++i) {
            text = text + "[]";
        }
        if (variance != '\u0000') {
            text = variance + text;
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/SignatureParsing", "parseTypeString"));
        }
        return string;
    }

    @Nullable
    private static String parseTypeWithoutVariance(CharacterIterator signature2) throws ClsFormatException {
        String text;
        switch (signature2.current()) {
            case 'L': {
                text = SignatureParsing.parseParameterizedClassRefSignature(signature2);
                break;
            }
            case 'T': {
                text = SignatureParsing.parseTypeVariableRefSignature(signature2);
                break;
            }
            case 'B': {
                text = "byte";
                signature2.next();
                break;
            }
            case 'C': {
                text = "char";
                signature2.next();
                break;
            }
            case 'D': {
                text = "double";
                signature2.next();
                break;
            }
            case 'F': {
                text = "float";
                signature2.next();
                break;
            }
            case 'I': {
                text = "int";
                signature2.next();
                break;
            }
            case 'J': {
                text = "long";
                signature2.next();
                break;
            }
            case 'S': {
                text = "short";
                signature2.next();
                break;
            }
            case 'Z': {
                text = "boolean";
                signature2.next();
                break;
            }
            case 'V': {
                text = "void";
                signature2.next();
                break;
            }
            default: {
                return null;
            }
        }
        return text;
    }
}

